/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.hr.hbp.business.service.complexobj.datatype.LongArrayType;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;

public class AlgoDataTypeTransUtil {
    private static Map<DataTypeEnum, DataType> baseDataTypeMap = new HashMap<DataTypeEnum, DataType>(16);
    private static Map<String, DataType> stringBaseDataTypeMap;
    private static Map<Integer, DataType> dbTypeDataTypeMap;

    public static DataType getDataType(DataTypeEnum dataTypeEnum) {
        return baseDataTypeMap.get(dataTypeEnum);
    }

    public static DataType getDataType(String dataType) {
        return stringBaseDataTypeMap.get(dataType);
    }

    public static DataTypeEnum getDataTypeEnum(DataType dataType) {
        return AlgoDataTypeTransUtil.getOrDefaultDataTypeEnum(dataType, DataTypeEnum.STRING);
    }

    public static DataType getDataTypeByDbType(int dbType) {
        DataType dataType = dbTypeDataTypeMap.get(dbType);
        if (dataType == null) {
            dataType = DataType.fromSqlType((int)dbType);
        }
        return dataType;
    }

    public static DataTypeEnum getOrDefaultDataTypeEnum(DataType dataType, DataTypeEnum defaultDataTypeEnum) {
        for (Map.Entry<DataTypeEnum, DataType> entry : baseDataTypeMap.entrySet()) {
            if (!entry.getValue().equals((Object)dataType)) continue;
            return entry.getKey();
        }
        return defaultDataTypeEnum;
    }

    public static DataType getDataTypeByInstance(Object instance) {
        String dataType = "";
        if (instance instanceof Date) {
            dataType = DataTypeEnum.DATETIME.getDataTypeKey();
        } else if (instance instanceof CharSequence) {
            dataType = DataTypeEnum.STRING.getDataTypeKey();
        } else if (instance instanceof Boolean) {
            dataType = DataTypeEnum.BOOLEAN.getDataTypeKey();
        } else if (instance instanceof Integer) {
            dataType = DataTypeEnum.INTEGER.getDataTypeKey();
        } else if (instance instanceof Long) {
            dataType = DataTypeEnum.LONG.getDataTypeKey();
        } else if (instance instanceof Double || instance instanceof Float) {
            dataType = DataTypeEnum.BIGDECIMAL.getDataTypeKey();
        }
        return AlgoDataTypeTransUtil.getDataType(dataType);
    }

    static {
        baseDataTypeMap.put(DataTypeEnum.INTEGER, (DataType)DataType.IntegerType);
        baseDataTypeMap.put(DataTypeEnum.STRING, (DataType)DataType.StringType);
        baseDataTypeMap.put(DataTypeEnum.LONG, (DataType)DataType.LongType);
        baseDataTypeMap.put(DataTypeEnum.BOOLEAN, (DataType)DataType.BooleanType);
        baseDataTypeMap.put(DataTypeEnum.BIGDECIMAL, (DataType)DataType.BigDecimalType);
        baseDataTypeMap.put(DataTypeEnum.DATETIME, (DataType)DataType.TimestampType);
        baseDataTypeMap.put(DataTypeEnum.LONG_ARRAY, LongArrayType.getInstance());
        stringBaseDataTypeMap = new HashMap<String, DataType>(16);
        stringBaseDataTypeMap.put("integer", (DataType)DataType.IntegerType);
        stringBaseDataTypeMap.put("string", (DataType)DataType.StringType);
        stringBaseDataTypeMap.put("long", (DataType)DataType.LongType);
        stringBaseDataTypeMap.put("boolean", (DataType)DataType.BooleanType);
        stringBaseDataTypeMap.put("bigdecimal", (DataType)DataType.BigDecimalType);
        stringBaseDataTypeMap.put("datetime", (DataType)DataType.TimestampType);
        stringBaseDataTypeMap.put("longArray", LongArrayType.getInstance());
        dbTypeDataTypeMap = new HashMap<Integer, DataType>(16);
        dbTypeDataTypeMap.put(5, (DataType)DataType.IntegerType);
        dbTypeDataTypeMap.put(4, (DataType)DataType.IntegerType);
        dbTypeDataTypeMap.put(-5, (DataType)DataType.LongType);
        dbTypeDataTypeMap.put(1, (DataType)DataType.StringType);
        dbTypeDataTypeMap.put(-15, (DataType)DataType.StringType);
        dbTypeDataTypeMap.put(12, (DataType)DataType.StringType);
        dbTypeDataTypeMap.put(-9, (DataType)DataType.StringType);
        dbTypeDataTypeMap.put(2011, (DataType)DataType.StringType);
        dbTypeDataTypeMap.put(2004, (DataType)DataType.StringType);
        dbTypeDataTypeMap.put(3, (DataType)DataType.BigDecimalType);
        dbTypeDataTypeMap.put(93, (DataType)DataType.TimestampType);
        dbTypeDataTypeMap.put(8, (DataType)DataType.DoubleType);
    }
}

