/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.service.complexobj.model.DimensionData;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.util.EntityPropParseUtil;
import kd.hr.hbp.business.service.complexobj.util.FieldFullPathParseUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryEntityUtil;
import kd.hr.hbp.common.util.ReportTimeZoneUtil;
import org.apache.commons.lang3.StringUtils;

public class BaseDataLoadUtil {
    private static final Log LOGGER = LogFactory.getLog(BaseDataLoadUtil.class);

    private static Map<String, DynamicProperty> fillTransferField(List<EntityFieldInfo> fieldInfoList, List<HRComplexObjFieldInfo> allFields) {
        HashMap enumFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        Set notTransferFields = allFields.stream().filter(field -> !field.isTransfer()).map(HRComplexObjFieldInfo::getAlias).collect(Collectors.toSet());
        EntityPropParseUtil propParseUtil = new EntityPropParseUtil();
        for (EntityFieldInfo entityFieldInfo : fieldInfoList) {
            String fullFieldName;
            String entityNumber;
            DynamicProperty property;
            if (notTransferFields.contains(entityFieldInfo.getAlias()) || !QueryEntityUtil.checkEntityEnumProp((Object)(property = propParseUtil.convertFullFieldName(entityNumber = entityFieldInfo.getFieldEntityNumber(), fullFieldName = FieldFullPathParseUtil.getFullFieldName(entityFieldInfo.getFieldEntityAlias(), entityFieldInfo.getAlias()))))) continue;
            enumFieldMap.put(entityFieldInfo.getAlias(), property);
        }
        for (HRComplexObjFieldInfo fieldInfo : allFields) {
            if (!fieldInfo.isTransfer() || HRStringUtils.equals((String)fieldInfo.getFieldType(), (String)"1") || fieldInfo.getDataType() != DataTypeEnum.DATETIME) continue;
            enumFieldMap.put(fieldInfo.getAlias(), new DateProp());
        }
        return enumFieldMap;
    }

    public static void dataTransfer(List<Map<String, Object>> list, List<EntityFieldInfo> fieldInfoList, List<HRComplexObjFieldInfo> allFields, HRComplexObjContext context) {
        Map<String, DynamicProperty> fillTransferFieldMap = BaseDataLoadUtil.fillTransferField(fieldInfoList, allFields);
        for (Map<String, Object> dataMap : list) {
            for (Map.Entry<String, DynamicProperty> entry : fillTransferFieldMap.entrySet()) {
                Object originalValue = dataMap.get(entry.getKey());
                TimeZone dateTimeFieldTimeZone = ReportTimeZoneUtil.transferDateTimeFieldTimeZone(allFields, (String)entry.getKey());
                Object value = QueryEntityUtil.getEntityProp((Object)entry.getValue(), (Object)originalValue, (TimeZone)dateTimeFieldTimeZone, (HRComplexObjContext)context);
                dataMap.put(entry.getKey(), value);
            }
        }
    }

    public static void dimensionDataTransfer(List<Map<String, DimensionData>> list, List<EntityFieldInfo> fieldInfoList, List<HRComplexObjFieldInfo> allFields, HRComplexObjContext context) {
        Map<String, DynamicProperty> fillTransferFieldMap = BaseDataLoadUtil.fillTransferField(fieldInfoList, allFields);
        for (Map<String, DimensionData> dataMap : list) {
            for (Map.Entry<String, DynamicProperty> entry : fillTransferFieldMap.entrySet()) {
                DimensionData dimensionData = dataMap.get(entry.getKey());
                if (dimensionData == null) continue;
                Object value = QueryEntityUtil.getEntityProp((Object)entry.getValue(), (Object)dimensionData.getValue(), null, (HRComplexObjContext)context);
                dimensionData.setValue(value);
            }
        }
    }

    public static void reloadBdProp(List<Map<String, Object>> list, List<EntityFieldInfo> fieldInfoList) {
        Map<String, String> idTypeMap = BaseDataLoadUtil.getIdTypeMap(fieldInfoList);
        HashMap<String, Set<Object>> baseDataIdMap = new HashMap<String, Set<Object>>();
        for (Map<String, Object> resultMap : list) {
            BaseDataLoadUtil.buildDaseDataId("", resultMap, baseDataIdMap, idTypeMap);
        }
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        Map<String, Map<Object, DynamicObject>> entityMap = BaseDataLoadUtil.loadBaseDataProp(fieldInfoList, baseDataIdMap, mainEntityTypeUtil);
        Map<String, List<EntityFieldInfo>> cvtFieldOriginFieldInfoMap = fieldInfoList.stream().filter(fi -> baseDataIdMap.containsKey(fi.getConvertField())).collect(Collectors.groupingBy(EntityFieldInfo::getConvertField));
        LOGGER.info("complexobj load basedataprop:{}", cvtFieldOriginFieldInfoMap.keySet());
        for (Map<String, Object> dataMap : list) {
            for (Map.Entry<String, Map<Object, DynamicObject>> mapEntry : entityMap.entrySet()) {
                String convertField = mapEntry.getKey();
                Object convertFieldVal = dataMap.get(convertField);
                if (convertFieldVal == null) {
                    convertFieldVal = "0";
                }
                if (BaseDataLoadUtil.isNumber(convertFieldVal)) {
                    convertFieldVal = Long.parseLong(convertFieldVal.toString());
                }
                DynamicObject bdDyo = mapEntry.getValue().get(convertFieldVal);
                List<EntityFieldInfo> fieldInfos = cvtFieldOriginFieldInfoMap.get(convertField);
                for (EntityFieldInfo fieldInfo : fieldInfos) {
                    String fieldEntityAlias;
                    if (fieldInfo.getAlias().equals(convertField)) {
                        dataMap.put(fieldInfo.getAlias(), convertFieldVal);
                        continue;
                    }
                    String originField = fieldInfo.getOriginField();
                    String bdField = BaseDataLoadUtil.removeIdSuffix(convertField);
                    if (bdField.startsWith((fieldEntityAlias = fieldInfo.getFieldEntityAlias()) + ".")) {
                        bdField = bdField.replaceFirst(fieldEntityAlias + "\\.", "");
                    }
                    if (fieldInfo.isEntryField()) {
                        String[] split = bdField.split("\\.");
                        MainEntityType entityType = mainEntityTypeUtil.getMainEntityType(fieldInfo.getFieldEntityNumber());
                        DynamicProperty property = entityType.getProperty(split[0]);
                        if (property instanceof EntryProp) {
                            bdField = bdField.replaceFirst(split[0] + "\\.", "");
                        }
                    }
                    String bdProp = originField.replaceFirst(bdField + "\\.", "");
                    Object value = null;
                    if (bdDyo != null) {
                        value = bdDyo.get(bdProp);
                    }
                    if (value instanceof OrmLocaleValue) {
                        value = ((OrmLocaleValue)value).getLocaleValue();
                    }
                    if (value == null) {
                        value = BaseDataLoadUtil.setDefVal(mainEntityTypeUtil, fieldInfo, bdProp, value);
                    }
                    dataMap.put(fieldInfo.getAlias(), value);
                }
            }
        }
    }

    private static Object setDefVal(MainEntityTypeUtil mainEntityTypeUtil, EntityFieldInfo fieldInfo, String bdProp, Object value) {
        block4: {
            try {
                MainEntityType entityType = mainEntityTypeUtil.getMainEntityType(fieldInfo.getFieldEntityNumber());
                DynamicProperty property = entityType.getProperty(bdProp);
                value = property.getDefaultValue();
            }
            catch (Exception e) {
                if (fieldInfo == null) break block4;
                DataTypeEnum dataType = fieldInfo.getDataType();
                if (dataType == DataTypeEnum.STRING) {
                    value = "";
                }
                if (dataType == DataTypeEnum.LONG || dataType == DataTypeEnum.INTEGER || dataType == DataTypeEnum.BIGDECIMAL) {
                    value = 0;
                }
                if (dataType != DataTypeEnum.BOOLEAN) break block4;
                value = false;
            }
        }
        return value;
    }

    private static String removeIdSuffix(String input) {
        if (input.endsWith(".id")) {
            return input.substring(0, input.length() - 3);
        }
        return input;
    }

    public static void resetBasedataField(List<Map<String, Object>> list, List<EntityFieldInfo> fieldInfoList) {
        Map<String, String> idTypeMap = BaseDataLoadUtil.getIdTypeMap(fieldInfoList);
        HashMap<String, Set<Object>> baseDataIdMap = new HashMap<String, Set<Object>>();
        for (Map<String, Object> resultMap : list) {
            BaseDataLoadUtil.buildDaseDataId("", resultMap, baseDataIdMap, idTypeMap);
        }
        Map<String, List<EntityFieldInfo>> cvtFieldOriginFieldInfoMap = fieldInfoList.stream().filter(fi -> baseDataIdMap.containsKey(fi.getConvertField())).collect(Collectors.groupingBy(EntityFieldInfo::getConvertField));
        LOGGER.info("complexobj load basedataprop:{}", cvtFieldOriginFieldInfoMap.keySet());
        for (Map<String, Object> dataMap : list) {
            for (String idFiled : idTypeMap.keySet()) {
                String convertField = idFiled;
                Object convertFieldVal = dataMap.get(convertField);
                if (convertFieldVal == null) {
                    convertFieldVal = "0";
                }
                if (BaseDataLoadUtil.isNumber(convertFieldVal)) {
                    convertFieldVal = Long.parseLong(convertFieldVal.toString());
                }
                List<EntityFieldInfo> fieldInfos = cvtFieldOriginFieldInfoMap.get(convertField);
                for (EntityFieldInfo fieldInfo : fieldInfos) {
                    dataMap.put(fieldInfo.getAlias(), convertFieldVal);
                }
            }
        }
    }

    public static Map<String, String> getIdTypeMap(List<EntityFieldInfo> fieldInfoList) {
        HashMap<String, String> idTypeMap = new HashMap<String, String>();
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        for (EntityFieldInfo entityFieldInfo : fieldInfoList) {
            String convertField = entityFieldInfo.getConvertField();
            if (convertField == null || !convertField.endsWith(".id")) continue;
            String fieldEntityNumber = entityFieldInfo.getFieldEntityNumber();
            String fieldNumber = convertField = convertField.replaceFirst(fieldEntityNumber + "\\.", "");
            if (convertField.contains(".")) {
                fieldNumber = convertField.substring(0, convertField.indexOf(46));
            }
            IDataEntityProperty property = (IDataEntityProperty)mainEntityTypeUtil.getMainEntityType(fieldEntityNumber).getAllFields().get(fieldNumber);
            String baseEntityId = null;
            if (property instanceof BasedataProp) {
                baseEntityId = ((BasedataProp)property).getBaseEntityId();
            } else if (property instanceof MulBasedataProp) {
                baseEntityId = ((MulBasedataProp)property).getBaseEntityId();
            }
            if (baseEntityId == null) continue;
            Class propertyType = mainEntityTypeUtil.getMainEntityType(baseEntityId).getPrimaryKey().getPropertyType();
            String pkType = propertyType == String.class ? "string" : "bigint";
            idTypeMap.put(entityFieldInfo.getConvertField(), pkType);
        }
        return idTypeMap;
    }

    private static Map<String, Map<Object, DynamicObject>> loadBaseDataProp(List<EntityFieldInfo> fieldInfoList, Map<String, Set<Object>> baseDataIdMap, MainEntityTypeUtil mainEntityTypeUtil) {
        HashMap entityMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, String> bdLoadPropMap = BaseDataLoadUtil.resolveBdprop(fieldInfoList, mainEntityTypeUtil);
        Map fieldInfoMap = fieldInfoList.stream().filter(fi -> baseDataIdMap.containsKey(fi.getConvertField())).collect(Collectors.toMap(EntityFieldInfo::getConvertField, Function.identity(), (k1, k2) -> k1));
        for (Map.Entry<String, Set<Object>> baseMap : baseDataIdMap.entrySet()) {
            DynamicProperty property;
            HashMap baseSelectMap = Maps.newHashMapWithExpectedSize((int)baseMap.getValue().size());
            String bdField = BaseDataLoadUtil.removeIdSuffix(baseMap.getKey());
            EntityFieldInfo handFieldInfo = (EntityFieldInfo)fieldInfoMap.get(baseMap.getKey());
            if (null == handFieldInfo) continue;
            String entityNumber = handFieldInfo.getFieldEntityNumber();
            String fieldEntityAlias = handFieldInfo.getFieldEntityAlias();
            if (bdField.startsWith(fieldEntityAlias + ".")) {
                bdField = bdField.replaceFirst(fieldEntityAlias + "\\.", "");
            }
            MainEntityType dataEntityTypeNest = mainEntityTypeUtil.getMainEntityType(entityNumber);
            String[] split = bdField.split("\\.");
            if (split.length > 1 && handFieldInfo.isEntryField()) {
                EntryProp entryProp = (EntryProp)dataEntityTypeNest.getProperty(split[0]);
                EntityType itemType = (EntityType)entryProp.getDynamicCollectionItemPropertyType();
                property = itemType.getProperty(split[1]);
            } else {
                property = dataEntityTypeNest.getProperty(bdField);
            }
            if (!(property instanceof BasedataProp)) continue;
            BasedataProp basedataProp = (BasedataProp)property;
            DynamicObject[] subjoinEntityArray = null;
            String selectProperties = bdLoadPropMap.get(basedataProp.getBaseEntityId());
            if (HRStringUtils.isEmpty((String)selectProperties) || selectProperties.equals("id")) continue;
            DynamicObjectType type = BaseDataLoadUtil.getSubEntityType(basedataProp.getBaseEntityId(), selectProperties);
            subjoinEntityArray = BusinessDataServiceHelper.load((Object[])baseMap.getValue().toArray(new Object[0]), (DynamicObjectType)type);
            BaseDataLoadUtil.convertArrayToMap(subjoinEntityArray, baseSelectMap);
            entityMap.put(baseMap.getKey(), baseSelectMap);
        }
        return entityMap;
    }

    private static void convertArrayToMap(DynamicObject[] objects, Map<Object, DynamicObject> map) {
        for (DynamicObject object : objects) {
            Object id = object.get("id");
            map.put(id, object);
        }
    }

    private static DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        return EntityMetadataCache.getSubDataEntityType((String)entityName, select);
    }

    private static Map<String, String> resolveBdprop(List<EntityFieldInfo> fieldInfoList, MainEntityTypeUtil mainEntityTypeUtil) {
        HashMap bdLoadFieldsMap = Maps.newHashMapWithExpectedSize((int)16);
        for (EntityFieldInfo fieldInfo : fieldInfoList) {
            MainEntityType dataEntityType = mainEntityTypeUtil.getMainEntityType(fieldInfo.getFieldEntityNumber());
            if (fieldInfo.isEntryField()) {
                String alias = fieldInfo.getAlias();
                String fieldAlias = alias;
                if (fieldAlias.startsWith(fieldInfo.getFieldEntityAlias())) {
                    fieldAlias = fieldAlias.replaceFirst(fieldInfo.getFieldEntityAlias() + "\\.", "");
                }
                String[] split = fieldAlias.split("\\.");
                EntryProp entryProp = (EntryProp)dataEntityType.getProperty(split[0]);
                EntityType itemType = (EntityType)entryProp.getDynamicCollectionItemPropertyType();
                BaseDataLoadUtil.recordBdField(itemType, fieldInfo.getOriginField(), bdLoadFieldsMap);
                continue;
            }
            BaseDataLoadUtil.recordBdField((EntityType)dataEntityType, fieldInfo.getOriginField(), bdLoadFieldsMap);
        }
        HashMap bdLoadPropMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry entry : bdLoadFieldsMap.entrySet()) {
            Set value = (Set)entry.getValue();
            bdLoadPropMap.put(entry.getKey(), StringUtils.join((Object[])value.toArray(new String[value.size()]), (char)','));
        }
        return bdLoadPropMap;
    }

    private static void recordBdField(EntityType dataEntityType, String fieldName, Map<String, Set<String>> bdLoadFieldsMap) {
        String[] nameKeys = fieldName.split("\\.");
        if (nameKeys.length < 2) {
            return;
        }
        DynamicProperty property = dataEntityType.getProperty(nameKeys[0]);
        if (property instanceof DynamicComplexProperty) {
            BasedataProp basedataProp = (BasedataProp)property;
            String bdEntityId = basedataProp.getBaseEntityId();
            String bdField = fieldName.replaceFirst(nameKeys[0] + "\\.", "");
            HashSet bdFieldSet = bdLoadFieldsMap.get(bdEntityId);
            if (bdFieldSet == null) {
                bdFieldSet = Sets.newHashSetWithExpectedSize((int)16);
                bdFieldSet.add("id");
            }
            bdFieldSet.add(bdField);
            bdLoadFieldsMap.put(bdEntityId, bdFieldSet);
        } else if (property instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)property;
            DynamicObjectType dynamicObjectType = entryProp.getDynamicCollectionItemPropertyType();
        }
    }

    private static void buildDaseDataId(String preName, Map<String, Object> resultMap, Map<String, Set<Object>> baseDataIdMap, Map<String, String> idTypeMap) {
        for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
            if (baseDataIdMap.containsKey(preName + entry.getKey())) {
                Set<Object> objectSet = baseDataIdMap.get(preName + entry.getKey());
                BaseDataLoadUtil.addId(objectSet, entry, idTypeMap);
                continue;
            }
            if (entry.getKey().endsWith(".id")) {
                HashSet<Object> idSet = new HashSet<Object>();
                BaseDataLoadUtil.addId(idSet, entry, idTypeMap);
                baseDataIdMap.put(preName + entry.getKey(), idSet);
                continue;
            }
            if (!(entry.getValue() instanceof Map)) continue;
            Map value = (Map)entry.getValue();
            BaseDataLoadUtil.buildDaseDataId(entry.getKey() + ".", value, baseDataIdMap, idTypeMap);
        }
    }

    private static boolean isNumber(Object value) {
        boolean isNumber = false;
        if (value != null) {
            isNumber = StringUtils.isNumeric((CharSequence)value.toString());
        }
        return isNumber;
    }

    private static void addId(Set<Object> idSet, Map.Entry<String, Object> entry, Map<String, String> idTypeMap) {
        Object value = entry.getValue();
        if (value == null) {
            return;
        }
        String idType = idTypeMap.get(entry.getKey());
        if (HRStringUtils.isNotEmpty((String)idType)) {
            if (HRStringUtils.equals((String)idType, (String)"bigint")) {
                idSet.add(Long.parseLong(value.toString()));
            } else {
                idSet.add(value);
            }
            return;
        }
        if (BaseDataLoadUtil.isNumber(value)) {
            idSet.add(Long.parseLong(value.toString()));
        } else {
            idSet.add(value);
        }
    }
}

