/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.service.complexobj.ExtendSortService;
import kd.hr.hbp.business.service.complexobj.enums.ReportSortTypeEnum;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlParser;
import kd.hr.hbp.business.service.complexobj.model.CustomSortInfo;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.model.FieldStoreInfo;
import kd.hr.hbp.business.service.complexobj.util.FieldFullPathParseUtil;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryKSqlUtil;

public class EntityFieldTransfer {
    private final HRComplexObjContext complexObjCont;
    private final KSqlParser kSqlParser;
    private final Map<String, SortFieldInfo> sortFieldInfoMap;
    private final Set<String> sortFieldAliasSet;
    private final Set<String> customSortFieldAliasSet;
    private final ExtendSortService extendSortService;
    private final Map<String, DataTypeEnum> pkDataTypeMap = new HashMap<String, DataTypeEnum>(16);
    private final Set<String> transCacheSet = new HashSet<String>(16);
    private String customSortTable;
    private String commonSortTable;

    public EntityFieldTransfer(KSqlParser kSqlParser, HRComplexObjContext complexObjCont) {
        this.kSqlParser = kSqlParser;
        List sortFieldInfoList = kSqlParser.getComplexObjCont().getSortFieldInfoList();
        this.sortFieldInfoMap = sortFieldInfoList.stream().collect(Collectors.toMap(SortFieldInfo::getFieldAlias, Function.identity(), (x, y) -> x));
        this.sortFieldAliasSet = sortFieldInfoList.stream().filter(SortFieldInfo::isSqlSort).map(SortFieldInfo::getFieldAlias).collect(Collectors.toSet());
        this.customSortFieldAliasSet = sortFieldInfoList.stream().filter(SortFieldInfo::isCustomSort).map(SortFieldInfo::getFieldAlias).collect(Collectors.toSet());
        this.extendSortService = new ExtendSortService();
        this.complexObjCont = complexObjCont;
    }

    public List<EntityFieldInfo> transfer(Map<String, String> tablePk, Set<String> extraFieldAliasSet, Set<String> filterFieldSet) {
        List fieldInfoList = this.complexObjCont.getComplexObjFieldInfoList().stream().filter(fi -> "1".equals(fi.getFieldType())).collect(Collectors.toList());
        Map<String, String> relEntityMap = this.complexObjCont.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        ArrayList<EntityFieldInfo> entityFieldInfoList = new ArrayList<EntityFieldInfo>(fieldInfoList.size());
        String entityNumber = this.complexObjCont.getEntityNumber();
        MainEntityType mainEntityType = this.kSqlParser.entityTypeUtil.getMainEntityType(entityNumber);
        this.preLoadCustomConf();
        for (HRComplexObjFieldInfo fieldInfo : fieldInfoList) {
            String fieldAlias = fieldInfo.getAlias();
            if (this.transCacheSet.contains(fieldAlias)) continue;
            this.transCacheSet.add(fieldAlias);
            EntityFieldInfo entityFieldInfo = this.getEntityFieldInfo(tablePk, relEntityMap, entityNumber, mainEntityType, fieldInfo);
            entityFieldInfoList.add(entityFieldInfo);
        }
        Iterator<String> iterator = filterFieldSet.iterator();
        while (iterator.hasNext()) {
            String fieldAlias = iterator.next();
            if (this.transCacheSet.contains(fieldAlias)) {
                iterator.remove();
                continue;
            }
            this.transCacheSet.add(fieldAlias);
            EntityFieldInfo entityFieldInfo = this.getEntityFieldInfo(tablePk, relEntityMap, entityNumber, mainEntityType, fieldAlias, DataTypeEnum.STRING, false);
            entityFieldInfoList.add(entityFieldInfo);
        }
        List sortFieldInfoList = this.kSqlParser.getComplexObjCont().getSortFieldInfoList();
        for (SortFieldInfo sortFieldInfo : sortFieldInfoList) {
            String fieldAlias = sortFieldInfo.getFieldAlias();
            if (this.transCacheSet.contains(fieldAlias)) continue;
            this.transCacheSet.add(fieldAlias);
            EntityFieldInfo entityFieldInfo = this.getEntityFieldInfo(tablePk, relEntityMap, entityNumber, mainEntityType, fieldAlias, sortFieldInfo.getDataType(), false);
            entityFieldInfoList.add(entityFieldInfo);
            extraFieldAliasSet.add(fieldAlias);
        }
        ISimpleProperty primaryKey = mainEntityType.getPrimaryKey();
        DataTypeEnum pkDataType = DataTypeEnum.LONG;
        if ("java.lang.String".equalsIgnoreCase(primaryKey.getPropertyType().getName())) {
            pkDataType = DataTypeEnum.STRING;
        }
        this.pkDataTypeMap.put(primaryKey.getName(), pkDataType);
        for (Map.Entry entry : relEntityMap.entrySet()) {
            String entityAlias = (String)entry.getKey();
            String relEntityNumber = (String)entry.getValue();
            MainEntityType relEntityType = this.kSqlParser.entityTypeUtil.getMainEntityType(relEntityNumber);
            ISimpleProperty relEntityTypePrimaryKey = relEntityType.getPrimaryKey();
            pkDataType = DataTypeEnum.LONG;
            if ("java.lang.String".equalsIgnoreCase(relEntityTypePrimaryKey.getPropertyType().getName())) {
                pkDataType = DataTypeEnum.STRING;
            }
            this.pkDataTypeMap.put(entityAlias + "." + relEntityTypePrimaryKey.getName(), pkDataType);
        }
        Set loadAliasSet = entityFieldInfoList.stream().map(EntityFieldInfo::getAlias).collect(Collectors.toSet());
        for (Map.Entry<String, DataTypeEnum> entry : this.pkDataTypeMap.entrySet()) {
            if (loadAliasSet.contains(entry.getKey())) continue;
            EntityFieldInfo entityFieldInfo = this.getEntityFieldInfo(tablePk, relEntityMap, entityNumber, mainEntityType, entry.getKey(), entry.getValue(), false);
            loadAliasSet.add(entry.getKey());
            entityFieldInfoList.add(entityFieldInfo);
            extraFieldAliasSet.add(entry.getKey());
        }
        return entityFieldInfoList;
    }

    private void preLoadCustomConf() {
        if (this.customSortFieldAliasSet.isEmpty()) {
            return;
        }
        HashSet<Long> rptPks = new HashSet<Long>(16);
        HashSet<Long> rptFieldPks = new HashSet<Long>(16);
        for (String customFieldAlias : this.customSortFieldAliasSet) {
            SortFieldInfo sortFieldInfo = this.sortFieldInfoMap.get(customFieldAlias);
            rptPks.add(sortFieldInfo.getReportId());
            rptFieldPks.add(sortFieldInfo.getFieldId());
        }
        this.extendSortService.initAllPK4Cache(rptPks, rptFieldPks);
    }

    private EntityFieldInfo getEntityFieldInfo(Map<String, String> tablePk, Map<String, String> relEntityMap, String entityNumber, MainEntityType mainEntityType, HRComplexObjFieldInfo fieldInfo) {
        return this.getEntityFieldInfo(tablePk, relEntityMap, entityNumber, mainEntityType, fieldInfo.getAlias(), fieldInfo.getDataType(), true);
    }

    private EntityFieldInfo getEntityFieldInfo(Map<String, String> tablePk, Map<String, String> relEntityMap, String entityNumber, MainEntityType mainEntityType, String fieldAlias, DataTypeEnum dataType, boolean parseSortField) {
        String relEntityNumber;
        String[] fieldAliasSplit;
        SplitDateTypeEnum splitDateTypeEnum;
        EntityFieldInfo entityFieldInfo = new EntityFieldInfo();
        entityFieldInfo.setAlias(fieldAlias);
        entityFieldInfo.setDataType(dataType);
        if (fieldAlias.contains("!") && (splitDateTypeEnum = SplitDateTypeEnum.getEnum((String)(fieldAliasSplit = fieldAlias.split("!"))[1])) != null) {
            fieldAlias = fieldAliasSplit[0];
            entityFieldInfo.setSplitDateType(splitDateTypeEnum);
        }
        if (HRStringUtils.isEmpty((String)(relEntityNumber = FieldFullPathParseUtil.getFieldEntityNumber(relEntityMap, fieldAlias)))) {
            if (fieldAlias.startsWith(entityNumber + ".")) {
                fieldAlias = fieldAlias.replaceFirst(entityNumber + "\\.", "");
            }
            entityFieldInfo.setFieldEntityNumber(entityNumber);
            entityFieldInfo.setFieldEntityAlias(entityNumber);
            this.parseProp((DynamicObjectType)mainEntityType, fieldAlias, fieldAlias, entityFieldInfo, "", tablePk, parseSortField);
        } else {
            entityFieldInfo.setFieldEntityNumber(relEntityNumber);
            MainEntityType joinEntityType = this.kSqlParser.entityTypeUtil.getMainEntityType(relEntityNumber);
            String[] fieldAliasArr = fieldAlias.split("\\.");
            String relEntityAlias = fieldAliasArr[0];
            entityFieldInfo.setFieldEntityAlias(relEntityAlias);
            String fieldPrex = relEntityAlias + ".";
            String realField = fieldAlias.replaceFirst(relEntityAlias + "\\.", "");
            this.parseProp((DynamicObjectType)joinEntityType, fieldAlias, realField, entityFieldInfo, fieldPrex, tablePk, parseSortField);
        }
        return entityFieldInfo;
    }

    private void parseProp(DynamicObjectType dynamicObjectType, String fieldAlias, String originField, EntityFieldInfo entityFieldInfo, String fieldPrex, Map<String, String> tablePk, boolean parseSortField) {
        String[] fieldAliasArr = originField.split("\\.");
        DynamicProperty property = dynamicObjectType.getProperty(originField);
        if (property == null) {
            property = dynamicObjectType.getProperty(fieldAliasArr[0]);
        }
        if (property == null) {
            return;
        }
        String mainTable = dynamicObjectType.getAlias();
        String mainTablePk = dynamicObjectType.getPrimaryKey().getAlias();
        String prefixNoDot = fieldPrex;
        if (fieldPrex.endsWith(".")) {
            prefixNoDot = fieldPrex.substring(0, fieldPrex.length() - 1);
        }
        String convertFieldAlias = QueryKSqlUtil.convertFieldAlias((DynamicObjectType)dynamicObjectType, (String)prefixNoDot, (String)originField);
        entityFieldInfo.setDbField(property.getAlias());
        entityFieldInfo.setConvertField(convertFieldAlias);
        entityFieldInfo.setOriginField(originField);
        entityFieldInfo.setTable(mainTable);
        entityFieldInfo.setPkDbField(mainTablePk);
        entityFieldInfo.setPkField(dynamicObjectType.getPrimaryKey().getName());
        tablePk.put(mainTable, mainTablePk);
        if (property instanceof ISimpleProperty && PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)property)) {
            entityFieldInfo.setPrivacyField(true);
        }
        if (parseSortField) {
            if (this.sortFieldAliasSet.contains(fieldAlias)) {
                this.genFieldStoreInfo(property, originField, fieldAlias, entityFieldInfo);
            } else if (this.customSortFieldAliasSet.contains(fieldAlias)) {
                entityFieldInfo.setCustomSortInfo(this.genFieldCustomSort(fieldAlias));
            }
        }
        this.setMulOrGroupProp(property, fieldAlias, entityFieldInfo, mainTable, fieldPrex, tablePk, parseSortField);
    }

    private CustomSortInfo genFieldCustomSort(String fieldAlias) {
        CustomSortInfo customSortInfo = new CustomSortInfo();
        SortFieldInfo sortFieldInfo = this.sortFieldInfoMap.get(fieldAlias);
        customSortInfo.setValueType(sortFieldInfo.getValueType());
        Long customSortPk = this.extendSortService.getCustomSortPk(sortFieldInfo.getReportId(), sortFieldInfo.getFieldId());
        customSortInfo.setCustomSortPk(customSortPk);
        customSortInfo.setSeq(sortFieldInfo.getSeq());
        customSortInfo.setDbRouteKey(this.kSqlParser.getDBRoute().getRouteKey());
        customSortInfo.setSortTable(this.getCustomSortTable());
        return customSortInfo;
    }

    private CustomSortInfo genFieldExtSort(String fieldAlias, String valueType, Long extSortPk) {
        SortFieldInfo sortFieldInfo = this.sortFieldInfoMap.get(fieldAlias);
        CustomSortInfo commonSortInfo = new CustomSortInfo();
        commonSortInfo.setValueType(valueType);
        commonSortInfo.setCustomSortPk(extSortPk);
        commonSortInfo.setSeq(sortFieldInfo.getSeq());
        commonSortInfo.setDbRouteKey(this.kSqlParser.getDBRoute().getRouteKey());
        commonSortInfo.setSortTable(this.getCommonSortTable());
        return commonSortInfo;
    }

    private FieldStoreInfo genFieldStoreInfo(DynamicProperty property, String originField, String fieldAlias, EntityFieldInfo entityFieldInfo) {
        FieldStoreInfo fieldStoreInfo = null;
        String[] fieldAliasArr = originField.split("\\.");
        if (property instanceof BasedataProp) {
            DynamicProperty ultimateProp;
            BasedataProp basedataProp = (BasedataProp)property;
            DynamicObjectType complexPropertyType = basedataProp.getDynamicComplexPropertyType();
            String dbRouteKey = complexPropertyType.getDBRouteKey();
            String routeKey = this.kSqlParser.getDBRoute().getRouteKey();
            if (routeKey.equals(dbRouteKey)) {
                String bdTable = complexPropertyType.getAlias();
                String bdTablePk = complexPropertyType.getPrimaryKey().getAlias();
                fieldStoreInfo = new FieldStoreInfo(bdTable, bdTablePk, basedataProp.getAlias());
                fieldStoreInfo.setFieldAlias(fieldAlias);
                if (fieldAliasArr.length == 3) {
                    DynamicProperty secondBdProp = complexPropertyType.getProperty(fieldAliasArr[1]);
                    fieldStoreInfo.setReference(this.genFieldStoreInfo(secondBdProp, originField.replaceFirst(fieldAliasArr[0] + "\\.", ""), fieldAlias, null));
                } else if (fieldAliasArr.length == 2) {
                    DynamicProperty ultimateProp2 = complexPropertyType.getProperty(fieldAliasArr[1]);
                    fieldStoreInfo.setRealDbField(ultimateProp2.getAlias());
                    if (ultimateProp2 instanceof MuliLangTextProp) {
                        FieldStoreInfo mulField = new FieldStoreInfo(fieldStoreInfo.getTable() + "_L", fieldStoreInfo.getTablePk(), fieldStoreInfo.getStoreField());
                        mulField.setMultilingual(true);
                        mulField.setFieldAlias(fieldStoreInfo.getFieldAlias());
                        mulField.setRealDbField(fieldStoreInfo.getRealDbField());
                        fieldStoreInfo.setReference(mulField);
                    }
                }
            } else if (entityFieldInfo != null && (ultimateProp = complexPropertyType.getProperty(fieldAliasArr[1])) != null && fieldAliasArr.length != 3 && fieldAliasArr.length == 2) {
                Long customSortPk = ultimateProp instanceof MuliLangTextProp ? this.extendSortService.getCommonSortPk(complexPropertyType.getName(), ultimateProp.getName(), RequestContext.get().getLang().toString()) : this.extendSortService.getCommonSortPk(complexPropertyType.getName(), ultimateProp.getName(), null);
                CustomSortInfo customSortInfo = this.genFieldExtSort(fieldAlias, this.getValueType(complexPropertyType.getPrimaryKey().getPropertyType().getTypeName()), customSortPk);
                entityFieldInfo.setCustomSortInfo(customSortInfo);
            }
        } else if (property instanceof ComboProp && entityFieldInfo != null) {
            Long customSortPk = this.extendSortService.getCommonSortPk(property.getParent().getName(), property.getName(), RequestContext.get().getLang().toString());
            CustomSortInfo customSortInfo = this.genFieldExtSort(fieldAlias, "string", customSortPk);
            entityFieldInfo.setCustomSortInfo(customSortInfo);
        }
        if (entityFieldInfo != null && fieldStoreInfo != null) {
            entityFieldInfo.setFieldStoreInfo(fieldStoreInfo);
        }
        return fieldStoreInfo;
    }

    private String getValueType(String type) {
        return "long".equals(type) ? "long" : "string";
    }

    private void setMulOrGroupProp(DynamicProperty property, String fieldAlias, EntityFieldInfo entityFieldInfo, String mainTable, String fieldPrex, Map<String, String> tablePk, boolean parseSortField) {
        if (Objects.isNull(entityFieldInfo)) {
            return;
        }
        if (property instanceof EntryProp) {
            DynamicProperty tempProp;
            entityFieldInfo.setEntryField(true);
            String originField = entityFieldInfo.getOriginField();
            String[] split = originField.split("\\.");
            String entityAlias = split[0] + ".";
            DynamicObjectType entryProp = ((EntryProp)property).getDynamicCollectionItemPropertyType();
            String entryTable = entryProp.getAlias();
            originField = originField.replaceFirst(split[0] + "\\.", "");
            entityFieldInfo.setTable(entryTable);
            this.kSqlParser.addUnIgnoreTable(entityFieldInfo.getFieldEntityAlias(), entryTable);
            tablePk.put(entryTable, entryProp.getPrimaryKey().getAlias());
            if (split.length >= 2 && (tempProp = entryProp.getProperty(split[1])) instanceof SubEntryProp) {
                String subEntryAlias = split[1] + ".";
                entryProp = ((SubEntryProp)tempProp).getDynamicCollectionItemPropertyType();
                this.kSqlParser.addUnIgnoreTable(entityFieldInfo.getFieldEntityAlias(), entryProp.getAlias());
                originField = originField.replaceFirst(split[1] + "\\.", "");
                entityFieldInfo.setEntryField(false);
                entityFieldInfo.setSubEntryField(true);
                entityFieldInfo.setSubEntryParentTb(entryProp.getParent().getAlias());
                entityFieldInfo.setSubEntryParentTbPk(entryProp.getParent().getPrimaryKey().getAlias());
                entityAlias = entityAlias + subEntryAlias;
            }
            fieldPrex = fieldPrex + entityAlias;
            String alias = fieldPrex + "id";
            this.pkDataTypeMap.put(alias, DataTypeEnum.LONG);
            this.parseProp(entryProp, fieldAlias, originField, entityFieldInfo, fieldPrex, tablePk, parseSortField);
            entityFieldInfo.setPkField(entityAlias + entityFieldInfo.getPkField());
        } else if (property instanceof MuliLangTextProp) {
            entityFieldInfo.setMultiLangField(true);
            entityFieldInfo.setTable(mainTable);
            entityFieldInfo.setMultiLanguageTb(mainTable + "_L");
        } else {
            String tableGroup = property.getTableGroup();
            if (HRStringUtils.isNotEmpty((String)tableGroup)) {
                entityFieldInfo.setSplitField(true);
                entityFieldInfo.setTable(mainTable + "_" + tableGroup);
            }
        }
    }

    private String getCustomSortTable() {
        if (HRStringUtils.isEmpty((String)this.customSortTable)) {
            this.customSortTable = this.extendSortService.getBizSortTableByDbRouteKey(this.kSqlParser.getMainEntityAppNumber(), this.kSqlParser.getDBRoute().getRouteKey(), ReportSortTypeEnum.SELF_SORT.getSortType());
            if (HRStringUtils.isEmpty((String)this.customSortTable)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49\u6392\u5e8f\u3002", (String)"EntityFieldTransfer_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
        }
        return this.customSortTable;
    }

    public String getCommonSortTable() {
        if (HRStringUtils.isEmpty((String)this.commonSortTable)) {
            this.commonSortTable = this.extendSortService.getBizSortTableByDbRouteKey(this.kSqlParser.getMainEntityAppNumber(), this.kSqlParser.getDBRoute().getRouteKey(), ReportSortTypeEnum.COMMON_SORT.getSortType());
            if (HRStringUtils.isEmpty((String)this.commonSortTable)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u4e0d\u652f\u6301\u901a\u7528\u6392\u5e8f\u3002", (String)"EntityFieldTransfer_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
        }
        return this.commonSortTable;
    }
}

