/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.model.JoinConditionRowItem;
import kd.hr.hbp.business.service.complexobj.util.ComplexObjRouteUtil;
import kd.hr.hbp.business.service.complexobj.util.DBConfigUtil;
import kd.hr.hbp.business.service.complexobj.util.FieldFullPathParseUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjConditionRow;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.util.HRStringUtils;

public class FilterTransJoinFunction
implements Function<QFilter, QFilter> {
    private final HRComplexObjContext context;
    private final Map<String, String> relEntityMap;
    private final List<HRComplexObjJoinRelation> addJoinRelationList;
    private final MainEntityTypeUtil mainEntityTypeUtil;
    private final DBConfigUtil dbConfigUtil;
    private int aliasIdx = 0;

    public FilterTransJoinFunction(HRComplexObjContext context) {
        this.context = context;
        this.relEntityMap = this.context.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        this.mainEntityTypeUtil = new MainEntityTypeUtil();
        this.dbConfigUtil = new DBConfigUtil();
        this.addJoinRelationList = new ArrayList<HRComplexObjJoinRelation>(10);
    }

    @Override
    public QFilter apply(QFilter qFilter) {
        String fieldAlias = qFilter.getProperty();
        boolean propIsBdFilter = FieldFullPathParseUtil.fieldIsMultiBdProp(fieldAlias, this.relEntityMap, this.context.getEntityNumber(), this.mainEntityTypeUtil);
        if (!propIsBdFilter) {
            return qFilter;
        }
        return this.transQFilter(qFilter, fieldAlias);
    }

    private QFilter transQFilter(QFilter qFilter, String fieldAlias) {
        String curEntityAlias;
        String curEntityNumber;
        String[] split = fieldAlias.split("\\.");
        String relEntityNumber = this.relEntityMap.get(split[0]);
        if (relEntityNumber == null) {
            curEntityNumber = this.context.getEntityNumber();
            curEntityAlias = "";
        } else {
            curEntityNumber = relEntityNumber;
            curEntityAlias = split[0];
            fieldAlias = fieldAlias.replaceFirst(curEntityAlias + "\\.", "");
        }
        qFilter = this.qFilterTransToJoinEntity(curEntityNumber, curEntityAlias, fieldAlias, qFilter, 0);
        return qFilter;
    }

    private QFilter qFilterTransToJoinEntity(String entityNumber, String entityAlias, String fieldName, QFilter qFilter, int deep) {
        if (deep > 2 || HRStringUtils.isEmpty((String)fieldName)) {
            return qFilter;
        }
        MainEntityType entityType = this.mainEntityTypeUtil.getMainEntityType(entityNumber);
        String[] fieldNameArr = fieldName.split("\\.");
        if (fieldNameArr.length == 1) {
            return qFilter;
        }
        DynamicProperty property = entityType.getProperty(fieldNameArr[0]);
        if (!(property instanceof DynamicComplexProperty)) {
            return qFilter;
        }
        if (fieldNameArr.length == 2 && fieldNameArr[1].equals("id")) {
            return qFilter;
        }
        MainEntityType firstEntityType = (MainEntityType)((DynamicComplexProperty)property).getComplexType();
        String pkName = firstEntityType.getPrimaryKey().getName();
        String bdEntityNumber = firstEntityType.getName();
        boolean inOneLDB = ComplexObjRouteUtil.inOneLDB(entityNumber, bdEntityNumber, this.mainEntityTypeUtil, this.dbConfigUtil);
        if (!inOneLDB) {
            return qFilter;
        }
        String joinBdAlias = this.findExistsRelEntityAlias(entityNumber, property.getName(), pkName, bdEntityNumber);
        if (HRStringUtils.isEmpty((String)joinBdAlias)) {
            joinBdAlias = "filterjoinbd_" + this.aliasIdx++;
            String leftJoinPropAlias = HRStringUtils.isEmpty((String)entityAlias) ? property.getName() + ".id" : entityAlias + '.' + property.getName() + ".id";
            String rightJoinPropAlias = joinBdAlias + '.' + pkName;
            this.relEntityMap.put(joinBdAlias, bdEntityNumber);
            JoinConditionRowItem rowItem = JoinConditionRowItem.getInstance(entityNumber, entityAlias, leftJoinPropAlias, bdEntityNumber, joinBdAlias, rightJoinPropAlias);
            String baseDataPrex = HRStringUtils.isEmpty((String)entityAlias) ? fieldNameArr[0] : entityAlias + '.' + fieldNameArr[0];
            rowItem.setBaseDataPrex(baseDataPrex);
            rowItem.setHostEntity(entityNumber);
            HRComplexObjJoinRelation joinRelation = rowItem.genJoinRelation();
            this.addJoinRelationList.add(joinRelation);
        }
        fieldName = fieldName.replaceFirst(fieldNameArr[0] + "\\.", joinBdAlias + ".");
        qFilter.__setProperty(fieldName);
        String secondPropStr = fieldNameArr[1];
        DynamicProperty secondProp = firstEntityType.getProperty(secondPropStr);
        if (secondProp instanceof DynamicComplexProperty) {
            fieldName = fieldName.replaceFirst(joinBdAlias + "\\.", "");
            return this.qFilterTransToJoinEntity(bdEntityNumber, joinBdAlias, fieldName, qFilter, ++deep);
        }
        return qFilter;
    }

    private String findExistsRelEntityAlias(String entityNumber, String propName, String pkName, String bdEntityNumber) {
        return this.addJoinRelationList.stream().filter(rel -> {
            boolean onlyEqCondition;
            boolean existsRelation;
            boolean bl = existsRelation = rel.getEntityNumber().equals(entityNumber) && rel.getRelEntityNumber().equals(bdEntityNumber);
            if (!existsRelation) {
                return false;
            }
            boolean bl2 = onlyEqCondition = rel.getCondition().size() == 1 && ((HRComplexObjConditionRow)rel.getCondition().get(0)).isRightFieldItem();
            if (!onlyEqCondition) {
                return false;
            }
            HRComplexObjConditionRow conditionRow = (HRComplexObjConditionRow)rel.getCondition().get(0);
            return conditionRow.getRightItem().endsWith('.' + pkName) && conditionRow.getLeftItem().endsWith(propName + ".id");
        }).map(HRComplexObjJoinRelation::getRelEntityAlias).findFirst().orElse(null);
    }

    public List<HRComplexObjJoinRelation> getAddJoinRelationList() {
        return this.addJoinRelationList;
    }
}

