/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.model.ComplexJoinBo;
import kd.hr.hbp.business.service.complexobj.model.JoinConditionRowItem;
import kd.hr.hbp.business.service.complexobj.model.Tuple2;
import kd.hr.hbp.business.service.complexobj.util.FieldFullPathParseUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.complexobj.util.MapCacheUtil;
import kd.hr.hbp.business.service.complexobj.util.QFilterUtil;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.business.servicehelper.HREntityHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjConditionRow;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.QUnknownValue;
import kd.hr.hbp.common.model.query.vo.NestedBasicDataPropertyVO;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class JoinConditionTrans {
    private static final Log LOGGER = LogFactory.getLog(JoinConditionTrans.class);
    private final MainEntityTypeUtil mainEntityTypeUtil;
    private final HRComplexObjContext complexObjCont;
    private int aliasIdx = 0;

    public JoinConditionTrans(HRComplexObjContext complexObjCont) {
        this.complexObjCont = complexObjCont;
        this.mainEntityTypeUtil = new MainEntityTypeUtil();
    }

    public void resetJoinCondition() {
        Map<String, String> relEntityMap = this.complexObjCont.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        JoinConditionTrans.adjustCondition(this.complexObjCont.getJoinRelationList(), relEntityMap);
        this.resetJoinCondition(relEntityMap, this.complexObjCont.getJoinRelationList());
        JoinConditionTrans.resetRelEntityFilter(relEntityMap, this.complexObjCont.getJoinRelationList());
        this.resetJoinFilter(relEntityMap, this.complexObjCont.getJoinRelationList());
    }

    @ExcludeFromJacocoGeneratedReport
    private static void resetRelEntityFilter(Map<String, String> relEntityMap, List<HRComplexObjJoinRelation> joinRelationList) {
        LOGGER.info("before resetRelEntityFilter : {}", joinRelationList);
        HashMap filterRowMap = new HashMap(16);
        for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
            List conditionRows = joinRelation.getCondition();
            Iterator iterator = conditionRows.iterator();
            while (iterator.hasNext()) {
                String leftItem;
                String[] split;
                HRComplexObjConditionRow conditionRow = (HRComplexObjConditionRow)iterator.next();
                if (conditionRow.isRightFieldItem() || !relEntityMap.containsKey((split = (leftItem = conditionRow.getLeftItem()).split("\\."))[0]) || split[0].equals(joinRelation.getRelEntityAlias())) continue;
                iterator.remove();
                MapCacheUtil.addMapListVal(filterRowMap, split[0], conditionRow);
            }
        }
        if (!filterRowMap.isEmpty()) {
            for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
                List filterRowList = (List)filterRowMap.get(joinRelation.getRelEntityAlias());
                if (filterRowList != null && filterRowList.size() > 0) {
                    joinRelation.getCondition().addAll(filterRowList);
                }
                filterRowMap.remove(joinRelation.getRelEntityAlias());
            }
        }
        LOGGER.info("after resetRelEntityFilter : {}", joinRelationList);
        if (filterRowMap.size() > 0) {
            LOGGER.info("after resetRelEntityFilter.filterRowMap : {}", filterRowMap);
            throw new KDBizException("resetRelEntityFilter fail!");
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static void adjustCondition(List<HRComplexObjJoinRelation> joinRelationList, Map<String, String> relEntityMap) {
        for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
            for (HRComplexObjConditionRow conditionRow : joinRelation.getCondition()) {
                if (!conditionRow.isRightFieldItem()) continue;
                String leftRelEntNum = FieldFullPathParseUtil.getFieldEntityNumber(relEntityMap, conditionRow.getLeftItem());
                String rightRelEntNum = FieldFullPathParseUtil.getFieldEntityNumber(relEntityMap, conditionRow.getRightItem());
                if (leftRelEntNum == null && rightRelEntNum == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5173\u8054\u5b57\u6bb5\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\u540c\u4e00\u4e2a\u5b9e\u4f53\u4e2d\u7684\u5b57\u6bb5\u3002", (String)"JoinConditionTrans_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                }
                if (rightRelEntNum != null) continue;
                String temp = conditionRow.getLeftItem();
                conditionRow.setLeftItem(conditionRow.getRightItem());
                conditionRow.setRightItem(temp);
            }
        }
    }

    private void resetJoinCondition(Map<String, String> relEntityMap, List<HRComplexObjJoinRelation> joinRelationList) {
        List<HRComplexObjJoinRelation> joinRelationListNew = new ArrayList<HRComplexObjJoinRelation>(joinRelationList.size());
        for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
            List<HRComplexObjJoinRelation> resolveRelationList = null;
            if (this.needResolveRelation(relEntityMap, joinRelation)) {
                resolveRelationList = this.resolveRelation(relEntityMap, joinRelation);
            }
            if (resolveRelationList == null) {
                joinRelationListNew.add(joinRelation);
                continue;
            }
            resolveRelationList = this.mergeByRelEntityAlias(resolveRelationList);
            joinRelationListNew.addAll(resolveRelationList);
        }
        joinRelationListNew = this.mergeByRelEntityAlias(joinRelationListNew);
        LOGGER.info("after resetJoinCondition : {}", joinRelationListNew);
        this.complexObjCont.setJoinRelationList(joinRelationListNew);
    }

    private List<HRComplexObjJoinRelation> mergeByRelEntityAlias(List<HRComplexObjJoinRelation> joinRelationList) {
        long disCount = joinRelationList.stream().map(HRComplexObjJoinRelation::getRelEntityAlias).distinct().count();
        if (disCount == (long)joinRelationList.size()) {
            return joinRelationList;
        }
        Map<String, Long> countMap = this.getDuplicateValues(joinRelationList);
        ArrayList<HRComplexObjJoinRelation> copyJoinRelationList = new ArrayList<HRComplexObjJoinRelation>(joinRelationList.size());
        HashMap<String, HRComplexObjJoinRelation> relationHashMap = new HashMap<String, HRComplexObjJoinRelation>(countMap.size());
        for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
            String relEntityAlias = joinRelation.getRelEntityAlias();
            if (countMap.containsKey(relEntityAlias)) {
                HRComplexObjJoinRelation dupRelation = (HRComplexObjJoinRelation)relationHashMap.get(relEntityAlias);
                if (dupRelation == null) {
                    dupRelation = joinRelation;
                } else {
                    List conditionRows = joinRelation.getCondition();
                    for (HRComplexObjConditionRow conditionRow : conditionRows) {
                        String leftItem = conditionRow.getLeftItem();
                        String prex = joinRelation.getEntityAlias() + ".";
                        if (joinRelation.getEntityAlias().equals(dupRelation.getEntityNumber()) || leftItem.startsWith(prex)) continue;
                        conditionRow.setLeftItem(prex + leftItem);
                    }
                    dupRelation.getCondition().addAll(conditionRows);
                }
                relationHashMap.put(relEntityAlias, dupRelation);
                Long count = countMap.get(relEntityAlias);
                count = count - 1L;
                countMap.put(relEntityAlias, count);
                if (count != 0L) continue;
                copyJoinRelationList.add(dupRelation);
                continue;
            }
            copyJoinRelationList.add(joinRelation);
        }
        return copyJoinRelationList;
    }

    private Map<String, Long> getDuplicateValues(List<HRComplexObjJoinRelation> list) {
        return list.stream().collect(Collectors.groupingBy(HRComplexObjJoinRelation::getRelEntityAlias, Collectors.counting())).entrySet().stream().filter(ct -> (Long)ct.getValue() > 1L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @ExcludeFromJacocoGeneratedReport
    private String getJoinOnFilterPrex(String fieldAlias, Map<String, String> relEntityMap) {
        String prex;
        String curEntityNumber;
        String relEntityNumber = FieldFullPathParseUtil.getFieldEntityNumber(relEntityMap, fieldAlias);
        if (HRStringUtils.isEmpty((String)relEntityNumber)) {
            curEntityNumber = this.complexObjCont.getEntityNumber();
            prex = "";
        } else {
            curEntityNumber = relEntityNumber;
            String[] fieldAliasArr = fieldAlias.split("\\.");
            String relEntityAlias = fieldAliasArr[0];
            prex = relEntityAlias + '.';
            fieldAlias = fieldAlias.replaceFirst(relEntityAlias + "\\.", "");
        }
        MainEntityType entityType = this.mainEntityTypeUtil.getMainEntityType(curEntityNumber);
        String[] fieldAliasArr = fieldAlias.split("\\.");
        DynamicProperty property = entityType.getProperty(fieldAliasArr[0]);
        if (property instanceof DynamicComplexProperty) {
            prex = prex + property.getName() + '.';
            if (fieldAliasArr.length > 2) {
                MainEntityType secondEntityType = (MainEntityType)((DynamicComplexProperty)property).getComplexType();
                DynamicProperty property2 = secondEntityType.getProperty(fieldAliasArr[1]);
                prex = prex + property2.getName() + '.';
            }
        }
        if (prex.endsWith(".")) {
            prex = prex.substring(0, prex.length() - 1);
        }
        return prex;
    }

    private void transSubJoinCondition(Map<String, String> relEntityMap, HRComplexObjJoinRelation joinRelation) {
        if (!this.needTransSub(joinRelation)) {
            return;
        }
        List conditionRows = joinRelation.getCondition();
        Map<String, List<HRComplexObjConditionRow>> filterRowMap = this.groupByJoinFilterByPrex(relEntityMap, conditionRows);
        String relEntityAlias = joinRelation.getRelEntityAlias();
        for (HRComplexObjConditionRow conditionRow : conditionRows) {
            if (!conditionRow.isRightFieldItem()) continue;
            String leftItem = conditionRow.getLeftItem();
            String rightItem = conditionRow.getRightItem();
            Tuple2<String, HRComplexObjContext> leftJoinContItem = this.transSingleItem(relEntityMap, leftItem, true, filterRowMap);
            Tuple2<String, HRComplexObjContext> tuple2 = this.transSingleItem(relEntityMap, rightItem, false, filterRowMap);
        }
    }

    private boolean needTransSub(HRComplexObjJoinRelation joinRelation) {
        List conditionRows = joinRelation.getCondition();
        for (HRComplexObjConditionRow conditionRow : conditionRows) {
            if (!conditionRow.isRightFieldItem()) continue;
            String leftItem = conditionRow.getLeftItem();
            String[] split = leftItem.split("\\.");
            if (split.length > 2 || split.length == 2 && !split[1].equals("id")) {
                return true;
            }
            String rightItem = conditionRow.getRightItem();
            split = rightItem.split("\\.");
            if (split.length <= 3 && (split.length != 3 || split[2].equals("id"))) continue;
            return true;
        }
        return false;
    }

    @ExcludeFromJacocoGeneratedReport
    private List<HRComplexObjJoinRelation> resolveRelation(Map<String, String> relEntityMap, HRComplexObjJoinRelation joinRelation) {
        List conditionRows = joinRelation.getCondition();
        String relEntityAlias = joinRelation.getRelEntityAlias();
        Map<String, List<HRComplexObjConditionRow>> filterRowMap = this.groupByJoinFilterByPrex(relEntityMap, conditionRows);
        ArrayList<HRComplexObjJoinRelation> conditionRowNewList = new ArrayList<HRComplexObjJoinRelation>(conditionRows.size());
        for (HRComplexObjConditionRow conditionRow : conditionRows) {
            if (!conditionRow.isRightFieldItem()) continue;
            String leftItem = conditionRow.getLeftItem();
            String rightItem = conditionRow.getRightItem();
            ComplexJoinBo leftJoinBo = this.parseSingleItem(relEntityMap, leftItem, filterRowMap, true);
            ComplexJoinBo rightJoinBo = this.parseSingleItem(relEntityMap, rightItem, filterRowMap, false);
            if (leftJoinBo == null && rightJoinBo == null) {
                HRComplexObjJoinRelation copyJoinRelation = new HRComplexObjJoinRelation();
                copyJoinRelation.setJoinType(joinRelation.getJoinType());
                copyJoinRelation.setEntityNumber(joinRelation.getEntityNumber());
                copyJoinRelation.setEntityAlias(joinRelation.getEntityAlias());
                copyJoinRelation.setRelEntityNumber(joinRelation.getRelEntityNumber());
                copyJoinRelation.setRelEntityAlias(joinRelation.getRelEntityAlias());
                copyJoinRelation.setRelEntityLongNumber(joinRelation.getRelEntityLongNumber());
                ArrayList<HRComplexObjConditionRow> copyRow = new ArrayList<HRComplexObjConditionRow>(1);
                copyRow.add(conditionRow);
                copyJoinRelation.setCondition(copyRow);
                conditionRowNewList.add(copyJoinRelation);
                continue;
            }
            if (leftJoinBo != null) {
                leftItem = leftJoinBo.getJoinProp();
                List<HRComplexObjJoinRelation> leftJoinRelationList = leftJoinBo.getExtJoinRelationList();
                conditionRowNewList.addAll(leftJoinRelationList);
            }
            List<HRComplexObjJoinRelation> rightJoinRelationList = null;
            if (rightJoinBo != null) {
                rightItem = rightJoinBo.getJoinProp();
                rightJoinRelationList = rightJoinBo.getExtJoinRelationList();
                Collections.reverse(rightJoinRelationList);
            }
            ArrayList<HRComplexObjJoinRelation> joinRelationAdd = new ArrayList<HRComplexObjJoinRelation>(1);
            String[] lsplit = leftItem.split("\\.");
            String[] rsplit = rightItem.split("\\.");
            ArrayList<HRComplexObjConditionRow> conditionRowsLR = new ArrayList<HRComplexObjConditionRow>(10);
            conditionRowsLR.add(new HRComplexObjConditionRow(leftItem, rightItem, true));
            String leftEntityAlias = lsplit[0];
            String leftEntityNumber = relEntityMap.get(leftEntityAlias);
            if (HRStringUtils.isEmpty((String)leftEntityNumber)) {
                leftEntityNumber = this.complexObjCont.getEntityNumber();
                leftEntityAlias = this.complexObjCont.getEntityNumber();
            }
            HRComplexObjJoinRelation joinRelationLR = new HRComplexObjJoinRelation(leftEntityNumber, leftEntityAlias, relEntityMap.get(rsplit[0]), rsplit[0], conditionRowsLR);
            joinRelationAdd.add(joinRelationLR);
            conditionRowNewList.addAll(joinRelationAdd);
            if (rightJoinRelationList != null) {
                conditionRowNewList.addAll(rightJoinRelationList);
            }
            HRComplexObjJoinRelation joinRelationFirst = (HRComplexObjJoinRelation)conditionRowNewList.get(0);
            HRComplexObjJoinRelation joinRelationlast = (HRComplexObjJoinRelation)conditionRowNewList.get(conditionRowNewList.size() - 1);
            for (Map.Entry<String, List<HRComplexObjConditionRow>> entry : filterRowMap.entrySet()) {
                if (entry.getKey().startsWith(relEntityAlias + '.')) {
                    joinRelationlast.getCondition().addAll((Collection)entry.getValue());
                    continue;
                }
                joinRelationFirst.getCondition().addAll((Collection)entry.getValue());
            }
        }
        if (conditionRowNewList.isEmpty()) {
            return null;
        }
        return conditionRowNewList;
    }

    private Tuple2<String, HRComplexObjContext> transSingleItem(Map<String, String> relEntityMap, String fieldAlias, boolean isMainEntityProp, Map<String, List<HRComplexObjConditionRow>> filterRowMap) {
        String secondPkAlias;
        String curEntityAlias;
        String curEntityNumber;
        if (isMainEntityProp) {
            curEntityNumber = this.complexObjCont.getEntityNumber();
            curEntityAlias = "";
        } else {
            curEntityNumber = FieldFullPathParseUtil.getFieldEntityNumber(relEntityMap, fieldAlias);
            String[] fieldAliasArr = fieldAlias.split("\\.");
            curEntityAlias = fieldAliasArr[0];
            fieldAlias = fieldAlias.replaceFirst(curEntityAlias + "\\.", "");
        }
        MainEntityType entityType = this.mainEntityTypeUtil.getMainEntityType(curEntityNumber);
        String[] fieldAliasArr = fieldAlias.split("\\.");
        DynamicProperty property = entityType.getProperty(fieldAliasArr[0]);
        if (!(property instanceof DynamicComplexProperty)) {
            return null;
        }
        if (fieldAliasArr.length == 2 && fieldAliasArr[1].equals("id")) {
            return null;
        }
        HRComplexObjContext context = new HRComplexObjContext();
        context.setEntityNumber(curEntityNumber);
        context.setEntityTable(HREntityHelper.getTableName(curEntityNumber));
        ArrayList<HRComplexObjFieldInfo> complexObjFieldInfoList = new ArrayList<HRComplexObjFieldInfo>(10);
        HRComplexObjFieldInfo pkField = new HRComplexObjFieldInfo("id", "id");
        complexObjFieldInfoList.add(pkField);
        context.setComplexObjFieldInfoList(complexObjFieldInfoList);
        ArrayList<HRComplexObjJoinRelation> joinRelationList = new ArrayList<HRComplexObjJoinRelation>(10);
        HRComplexObjJoinRelation joinRelation = new HRComplexObjJoinRelation();
        joinRelation.setJoinType("InnerJoin");
        joinRelation.setEntityAlias(curEntityAlias);
        joinRelation.setEntityNumber(curEntityNumber);
        MainEntityType firstEntityType = (MainEntityType)((DynamicComplexProperty)property).getComplexType();
        String pkName = firstEntityType.getPrimaryKey().getName();
        String entityNumber = firstEntityType.getName();
        String joinBdAlias = "joinbd_" + this.aliasIdx++;
        String leftJoinPropAlias = HRStringUtils.isEmpty((String)curEntityAlias) ? property.getName() + ".id" : curEntityAlias + '.' + property.getName() + ".id";
        String rightJoinPropAlias = joinBdAlias + '.' + pkName;
        joinRelation.setRelEntityNumber(entityNumber);
        joinRelation.setRelEntityAlias(joinBdAlias);
        JoinConditionRowItem rowItem = JoinConditionRowItem.getInstance(curEntityNumber, curEntityAlias, leftJoinPropAlias, entityNumber, joinBdAlias, rightJoinPropAlias);
        rowItem.setSwop(!isMainEntityProp);
        String baseDataPrex = HRStringUtils.isEmpty((String)curEntityAlias) ? fieldAliasArr[0] : curEntityAlias + '.' + fieldAliasArr[0];
        rowItem.setBaseDataPrex(baseDataPrex);
        rowItem.setHostEntity(curEntityNumber);
        ArrayList<HRComplexObjConditionRow> condition = new ArrayList<HRComplexObjConditionRow>();
        condition.add(rowItem.genJoinConditionRow());
        joinRelation.setCondition(condition);
        List<HRComplexObjConditionRow> filterRows = filterRowMap.get(rowItem.getBaseDataPrex());
        if (filterRows != null) {
            for (Object filterRow : filterRows) {
                String replace = filterRow.getLeftItem().replace(rowItem.getBaseDataPrex(), joinBdAlias);
                filterRow.setLeftItem(replace);
            }
            joinRelation.getCondition().addAll(filterRows);
            filterRowMap.remove(rowItem.getBaseDataPrex());
        }
        joinRelationList.add(joinRelation);
        String secondPropStr = fieldAliasArr.length == 1 ? "id" : fieldAliasArr[1];
        DynamicProperty secondProp = firstEntityType.getProperty(secondPropStr);
        if (secondProp instanceof DynamicComplexProperty) {
            MainEntityType secondEntityType = (MainEntityType)((DynamicComplexProperty)secondProp).getComplexType();
            String secondPkName = secondEntityType.getPrimaryKey().getName();
            String secondEntityNumber = secondEntityType.getName();
            String secondBdAlias = "joinbd_" + this.aliasIdx++;
            if (fieldAliasArr.length == 3 && fieldAliasArr[2].equals(secondPkName)) {
                Object filterRow;
                filterRow = joinBdAlias + '.' + secondProp.getName();
            }
            HRComplexObjJoinRelation rightJoinRelation = new HRComplexObjJoinRelation();
            rightJoinRelation.setJoinType("InnerJoin");
            rightJoinRelation.setEntityAlias(entityNumber);
            rightJoinRelation.setEntityNumber(joinBdAlias);
            rightJoinRelation.setRelEntityAlias(secondBdAlias);
            rightJoinRelation.setRelEntityNumber(secondEntityNumber);
            leftJoinPropAlias = joinBdAlias + '.' + secondProp.getName() + ".id";
            rightJoinPropAlias = secondBdAlias + '.' + secondPkName;
            relEntityMap.put(secondBdAlias, secondEntityNumber);
            rowItem = JoinConditionRowItem.getInstance(entityNumber, joinBdAlias, leftJoinPropAlias, secondEntityNumber, secondBdAlias, rightJoinPropAlias);
            rowItem.setSwop(!isMainEntityProp);
            if (HRStringUtils.isEmpty((String)curEntityAlias)) {
                rowItem.setBaseDataPrex(fieldAliasArr[0] + '.' + fieldAliasArr[1]);
            } else {
                rowItem.setBaseDataPrex(curEntityAlias + '.' + fieldAliasArr[0] + '.' + fieldAliasArr[1]);
            }
            rowItem.setHostEntity(curEntityNumber);
            ArrayList<HRComplexObjConditionRow> condition2 = new ArrayList<HRComplexObjConditionRow>();
            condition2.add(rowItem.genJoinConditionRow());
            rightJoinRelation.setCondition(condition2);
            filterRows = filterRowMap.get(rowItem.getBaseDataPrex());
            if (filterRows != null) {
                for (HRComplexObjConditionRow filterRow : filterRows) {
                    String replace = filterRow.getLeftItem().replace(rowItem.getBaseDataPrex(), secondBdAlias);
                    filterRow.setLeftItem(replace);
                }
                rightJoinRelation.getCondition().addAll(filterRows);
                filterRowMap.remove(rowItem.getBaseDataPrex());
            }
            joinRelationList.add(rightJoinRelation);
            DynamicProperty secondEntityProp = secondEntityType.getProperty(fieldAliasArr[2]);
            secondPkAlias = secondBdAlias + '.' + secondEntityProp.getName();
        } else {
            secondPkAlias = joinBdAlias + '.' + secondProp.getName();
        }
        context.setJoinRelationList(joinRelationList);
        return new Tuple2<String, HRComplexObjContext>(secondPkAlias, context);
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean needResolveRelation(Map<String, String> relEntityMap, HRComplexObjJoinRelation joinRelation) {
        List conditionRows = joinRelation.getCondition();
        for (HRComplexObjConditionRow conditionRow : conditionRows) {
            if (!conditionRow.isRightFieldItem()) continue;
            String leftItem = conditionRow.getLeftItem();
            String rightItem = conditionRow.getRightItem();
            if (!FieldFullPathParseUtil.fieldIsMultiBdProp(leftItem, relEntityMap, this.complexObjCont.getEntityNumber(), this.mainEntityTypeUtil) && !FieldFullPathParseUtil.fieldIsMultiBdProp(rightItem, relEntityMap, this.complexObjCont.getEntityNumber(), this.mainEntityTypeUtil)) continue;
            return true;
        }
        return false;
    }

    @ExcludeFromJacocoGeneratedReport
    private ComplexJoinBo parseSingleItem(Map<String, String> relEntityMap, String fieldAlias, Map<String, List<HRComplexObjConditionRow>> filterRowMap, boolean isLeft) {
        String curEntityAlias;
        String curEntityNumber;
        boolean isMainEntityProp = false;
        String[] split = fieldAlias.split("\\.");
        String relEntityNumber = relEntityMap.get(split[0]);
        if (relEntityNumber == null) {
            isMainEntityProp = true;
            curEntityNumber = this.complexObjCont.getEntityNumber();
            curEntityAlias = "";
        } else {
            curEntityNumber = FieldFullPathParseUtil.getFieldEntityNumber(relEntityMap, fieldAlias);
            String[] fieldAliasArr = fieldAlias.split("\\.");
            curEntityAlias = fieldAliasArr[0];
            fieldAlias = fieldAlias.replaceFirst(curEntityAlias + "\\.", "");
        }
        MainEntityType entityType = this.mainEntityTypeUtil.getMainEntityType(curEntityNumber);
        String[] fieldAliasArr = fieldAlias.split("\\.");
        DynamicProperty property = entityType.getProperty(fieldAliasArr[0]);
        if (!(property instanceof DynamicComplexProperty)) {
            return null;
        }
        if (fieldAliasArr.length == 2 && fieldAliasArr[1].equals("id")) {
            return null;
        }
        ArrayList<HRComplexObjJoinRelation> joinRelationList = new ArrayList<HRComplexObjJoinRelation>(10);
        MainEntityType firstEntityType = (MainEntityType)((DynamicComplexProperty)property).getComplexType();
        String pkName = firstEntityType.getPrimaryKey().getName();
        String entityNumber = firstEntityType.getName();
        String joinBdAlias = "joinbd_" + this.aliasIdx++;
        String leftJoinPropAlias = HRStringUtils.isEmpty((String)curEntityAlias) ? property.getName() + ".id" : curEntityAlias + '.' + property.getName() + ".id";
        String rightJoinPropAlias = joinBdAlias + '.' + pkName;
        relEntityMap.put(joinBdAlias, entityNumber);
        JoinConditionRowItem rowItem = JoinConditionRowItem.getInstance(curEntityNumber, curEntityAlias, leftJoinPropAlias, entityNumber, joinBdAlias, rightJoinPropAlias);
        rowItem.setSwop(!isLeft);
        String baseDataPrex = HRStringUtils.isEmpty((String)curEntityAlias) ? fieldAliasArr[0] : curEntityAlias + '.' + fieldAliasArr[0];
        rowItem.setBaseDataPrex(baseDataPrex);
        rowItem.setHostEntity(curEntityNumber);
        HRComplexObjJoinRelation joinRelation = rowItem.genJoinRelation();
        List<HRComplexObjConditionRow> filterRows = filterRowMap.get(rowItem.getBaseDataPrex());
        if (filterRows != null) {
            for (HRComplexObjConditionRow filterRow : filterRows) {
                String replace = filterRow.getLeftItem().replace(rowItem.getBaseDataPrex(), joinBdAlias);
                filterRow.setLeftItem(replace);
            }
            joinRelation.getCondition().addAll(filterRows);
            filterRowMap.remove(rowItem.getBaseDataPrex());
        }
        joinRelationList.add(joinRelation);
        String secondPropStr = fieldAliasArr.length == 1 ? "id" : fieldAliasArr[1];
        DynamicProperty secondProp = firstEntityType.getProperty(secondPropStr);
        if (secondProp instanceof DynamicComplexProperty) {
            MainEntityType secondEntityType = (MainEntityType)((DynamicComplexProperty)secondProp).getComplexType();
            String secondPkName = secondEntityType.getPrimaryKey().getName();
            if (fieldAliasArr.length == 3 && fieldAliasArr[2].equals(secondPkName)) {
                String secondPkAlias = joinBdAlias + '.' + secondProp.getName();
                return new ComplexJoinBo(secondPkAlias, joinRelationList);
            }
            String secondEntityNumber = secondEntityType.getName();
            String secondBdAlias = "joinbd_" + this.aliasIdx++;
            leftJoinPropAlias = joinBdAlias + '.' + secondProp.getName() + ".id";
            rightJoinPropAlias = secondBdAlias + '.' + secondPkName;
            relEntityMap.put(secondBdAlias, secondEntityNumber);
            rowItem = JoinConditionRowItem.getInstance(entityNumber, joinBdAlias, leftJoinPropAlias, secondEntityNumber, secondBdAlias, rightJoinPropAlias);
            rowItem.setSwop(!isMainEntityProp);
            if (HRStringUtils.isEmpty((String)curEntityAlias)) {
                rowItem.setBaseDataPrex(fieldAliasArr[0] + '.' + fieldAliasArr[1]);
            } else {
                rowItem.setBaseDataPrex(curEntityAlias + '.' + fieldAliasArr[0] + '.' + fieldAliasArr[1]);
            }
            rowItem.setHostEntity(curEntityNumber);
            joinRelation = rowItem.genJoinRelation();
            filterRows = filterRowMap.get(rowItem.getBaseDataPrex());
            if (filterRows != null) {
                for (HRComplexObjConditionRow filterRow : filterRows) {
                    String replace = filterRow.getLeftItem().replace(rowItem.getBaseDataPrex(), secondBdAlias);
                    filterRow.setLeftItem(replace);
                }
                joinRelation.getCondition().addAll(filterRows);
                filterRowMap.remove(rowItem.getBaseDataPrex());
            }
            joinRelationList.add(joinRelation);
            DynamicProperty secondEntityProp = secondEntityType.getProperty(fieldAliasArr[2]);
            String secondPkAlias = secondBdAlias + '.' + secondEntityProp.getName();
            return new ComplexJoinBo(secondPkAlias, joinRelationList);
        }
        String secondPkAlias = joinBdAlias + '.' + secondProp.getName();
        return new ComplexJoinBo(secondPkAlias, joinRelationList);
    }

    private Map<String, List<HRComplexObjConditionRow>> groupByJoinFilterByPrex(Map<String, String> relEntityMap, List<HRComplexObjConditionRow> conditionRows) {
        List filterRow = conditionRows.stream().filter(row -> !row.isRightFieldItem()).collect(Collectors.toList());
        HashMap<String, List<HRComplexObjConditionRow>> filterRowMap = new HashMap<String, List<HRComplexObjConditionRow>>(16);
        for (HRComplexObjConditionRow conditionRow : filterRow) {
            String leftItem = conditionRow.getLeftItem();
            MapCacheUtil.addMapListVal(filterRowMap, this.getJoinOnFilterPrex(leftItem, relEntityMap), conditionRow);
        }
        return filterRowMap;
    }

    @ExcludeFromJacocoGeneratedReport
    private void resetJoinFilter(Map<String, String> relEntityMap, List<HRComplexObjJoinRelation> joinRelationList) {
        for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
            List conditionRows = joinRelation.getCondition();
            for (HRComplexObjConditionRow conditionRow : conditionRows) {
                if (conditionRow.isRightFieldItem()) continue;
                String leftItem = conditionRow.getLeftItem();
                String rightItem = conditionRow.getRightItem();
                boolean existsComplexProp = this.isComplexProperty(leftItem, relEntityMap);
                if (!existsComplexProp) continue;
                QFilter qFilter = new QFilter(leftItem, conditionRow.getCompareOp(), this.condExprTransObj(rightItem));
                qFilter = this.transformBDQFilter(qFilter, relEntityMap);
                conditionRow.setLeftItem(qFilter.getProperty());
                conditionRow.setCompareOp(qFilter.getCP());
                if (QUnknownValue.value.toString().equals(qFilter.getValue())) {
                    conditionRow.setRightItem(QUnknownValue.value.toString());
                    continue;
                }
                String itemVal = QFilterUtilHR.parametertoString(qFilter.getValue());
                conditionRow.setRightItem(itemVal);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private Object condExprTransObj(String expr) {
        if (!HRStringUtils.isEmpty((String)expr)) {
            if (expr.startsWith("'") && expr.endsWith("'")) {
                return expr.substring(1, expr.length() - 1);
            }
            if (expr.startsWith("{ts'") && expr.endsWith("'}")) {
                String dateStr = expr.substring(4, expr.length() - 2);
                try {
                    return HRDateTimeUtils.parseDate((String)dateStr);
                }
                catch (ParseException parseException) {
                }
            } else if (StringUtils.isNumeric((CharSequence)expr)) {
                try {
                    if (expr.indexOf(46) > 0) {
                        BigDecimal bigDecimal = new BigDecimal(expr);
                        return bigDecimal.doubleValue();
                    }
                    return Long.parseLong(expr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return expr;
    }

    @ExcludeFromJacocoGeneratedReport
    private QFilter transformBDQFilter(QFilter qFilter, Map<String, String> relEntityMap) {
        Collection cl;
        NestedBasicDataPropertyVO vo;
        boolean isMainEntity = false;
        String entityName = FieldFullPathParseUtil.getFieldEntityNumber(relEntityMap, qFilter.getProperty());
        if (entityName == null) {
            entityName = this.complexObjCont.getEntityNumber();
            isMainEntity = true;
        }
        if ((vo = QFilterUtil.changeSecondLvBDToFirstLvBDByFilterEx(qFilter.getProperty(), qFilter, this.complexObjCont, this.mainEntityTypeUtil)) == null) {
            vo = QFilterUtil.getNestedBasicDataPropertyVO(qFilter, entityName, isMainEntity, this.complexObjCont, this.mainEntityTypeUtil);
        }
        if (QFilterUtil.NOT_EXTID.equals(vo.getFilter().getValue())) {
            vo.getFilter().__setCP("=");
            vo.getFilter().__setValue((Object)QUnknownValue.value.toString());
        }
        if (vo.getFilter().getCP().equalsIgnoreCase("in") && vo.getFilter().getValue() == null) {
            vo.getFilter().__setCP("is null");
        }
        if (vo.getFilter().getValue() != null && vo.getFilter().getValue() instanceof Collection && (cl = (Collection)vo.getFilter().getValue()).isEmpty()) {
            vo.getFilter().__setCP("=");
            vo.getFilter().__setValue((Object)QUnknownValue.value.toString());
        }
        return vo.getFilter();
    }

    private boolean isComplexProperty(String fieldAlias, Map<String, String> relEntityMap) {
        String curEntityNumber;
        String relEntityNumber = FieldFullPathParseUtil.getFieldEntityNumber(relEntityMap, fieldAlias);
        if (HRStringUtils.isEmpty((String)relEntityNumber)) {
            curEntityNumber = this.complexObjCont.getEntityNumber();
        } else {
            curEntityNumber = relEntityNumber;
            String[] fieldAliasArr = fieldAlias.split("\\.");
            String relEntityAlias = fieldAliasArr[0];
            fieldAlias = fieldAlias.replaceFirst(relEntityAlias + "\\.", "");
        }
        MainEntityType entityType = this.mainEntityTypeUtil.getMainEntityType(curEntityNumber);
        String[] fieldAliasArr = fieldAlias.split("\\.");
        DynamicProperty property = entityType.getProperty(fieldAliasArr[0]);
        if (property instanceof DynamicComplexProperty) {
            DynamicComplexProperty dynamicComplexProperty = (DynamicComplexProperty)property;
            return fieldAliasArr.length != 2 || !fieldAliasArr[1].equals("id");
        }
        return false;
    }
}

