/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.model.JoinConditionRowDetail;
import kd.hr.hbp.business.service.complexobj.model.JoinEntityRelation;
import kd.hr.hbp.business.service.complexobj.model.JoinFieldDetail;
import kd.hr.hbp.business.service.complexobj.util.FieldFullPathParseUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjConditionRow;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class JoinExprUtil {
    public static boolean conditionContainEntrySplit(HRComplexObjJoinRelation anObjJoinRelation) {
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        for (HRComplexObjConditionRow row : anObjJoinRelation.getCondition()) {
            DynamicProperty rightProp;
            DynamicProperty property = JoinExprUtil.getDynamicProperty(anObjJoinRelation, row.getLeftItem(), mainEntityTypeUtil);
            if (property instanceof EntryProp) {
                return true;
            }
            if (!row.isRightFieldItem() || !((rightProp = JoinExprUtil.getDynamicProperty(anObjJoinRelation, row.getRightItem(), mainEntityTypeUtil)) instanceof EntryProp)) continue;
            return true;
        }
        return false;
    }

    private static DynamicProperty getDynamicProperty(HRComplexObjJoinRelation anObjJoinRelation, String leftItem, MainEntityTypeUtil mainEntityTypeUtil) {
        String originField = leftItem;
        String[] fieldAliasArr = leftItem.split("\\.");
        String firstField = fieldAliasArr[0];
        String entityNumber = anObjJoinRelation.getEntityNumber();
        if (anObjJoinRelation.getRelEntityAlias().equals(firstField)) {
            entityNumber = anObjJoinRelation.getRelEntityNumber();
            originField = originField.replaceFirst(firstField + "\\.", "");
        }
        MainEntityType entityType = mainEntityTypeUtil.getMainEntityType(entityNumber);
        String[] fieldAliasArr2 = originField.split("\\.");
        DynamicProperty property = entityType.getProperty(originField);
        if (property == null) {
            property = entityType.getProperty(fieldAliasArr2[0]);
        }
        return property;
    }

    public static JoinEntityRelation conditionTrans(String mainEntityNumber, HRComplexObjJoinRelation anObjJoinRelation, Map<String, String> relEntityMap, Map<String, EntityFieldInfo> entityFieldInfoMap) {
        JoinEntityRelation joinEntityRelation = new JoinEntityRelation(anObjJoinRelation);
        List conditions = joinEntityRelation.getJoinRelation().getCondition();
        ArrayList<JoinConditionRowDetail> joinRowList = new ArrayList<JoinConditionRowDetail>(conditions.size());
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        for (HRComplexObjConditionRow condition : conditions) {
            JoinConditionRowDetail joinConditionRowDetail = new JoinConditionRowDetail(condition);
            MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(anObjJoinRelation.getEntityNumber());
            String leftItem = condition.getLeftItem();
            if (leftItem.startsWith(mainEntityNumber + ".") && !mainEntityNumber.equals(anObjJoinRelation.getEntityNumber())) {
                mainEntityType = mainEntityTypeUtil.getMainEntityType(mainEntityNumber);
            }
            JoinFieldDetail leftJoinFieldDetail = JoinExprUtil.parseJoinItem(leftItem, relEntityMap, mainEntityType, entityFieldInfoMap, mainEntityTypeUtil);
            joinConditionRowDetail.setLeftField(leftJoinFieldDetail);
            if (condition.isRightFieldItem()) {
                JoinFieldDetail rightJoinFieldDetail = JoinExprUtil.parseJoinItem(condition.getRightItem(), relEntityMap, mainEntityType, entityFieldInfoMap, mainEntityTypeUtil);
                joinConditionRowDetail.setRightField(rightJoinFieldDetail);
                if (leftJoinFieldDetail.getFieldRealTable().equals(leftJoinFieldDetail.getMainTable()) && rightJoinFieldDetail.getFieldRealTable().equals(rightJoinFieldDetail.getMainTable())) {
                    joinConditionRowDetail.setCanJoin(true);
                }
                if (HRStringUtils.isNotEmpty((String)leftJoinFieldDetail.getSplitTable()) || HRStringUtils.isNotEmpty((String)rightJoinFieldDetail.getSplitTable())) {
                    joinConditionRowDetail.setJoinNum(4);
                } else if (HRStringUtils.isNotEmpty((String)leftJoinFieldDetail.getSubEntryTable()) || HRStringUtils.isNotEmpty((String)rightJoinFieldDetail.getSubEntryTable())) {
                    joinConditionRowDetail.setJoinNum(3);
                } else if (HRStringUtils.isNotEmpty((String)leftJoinFieldDetail.getEntryTable()) || HRStringUtils.isNotEmpty((String)rightJoinFieldDetail.getEntryTable())) {
                    joinConditionRowDetail.setJoinNum(2);
                } else if (HRStringUtils.isNotEmpty((String)leftJoinFieldDetail.getMainTable()) || HRStringUtils.isNotEmpty((String)rightJoinFieldDetail.getMainTable())) {
                    joinConditionRowDetail.setJoinNum(1);
                }
            } else {
                joinConditionRowDetail.setJoinNum(9);
            }
            joinRowList.add(joinConditionRowDetail);
        }
        joinEntityRelation.setJoinRowList(joinRowList);
        boolean canJoin = false;
        for (JoinConditionRowDetail row : joinEntityRelation.getJoinRowList()) {
            if (!row.isCanJoin()) continue;
            canJoin = true;
            break;
        }
        joinEntityRelation.setJoinAble(canJoin);
        return joinEntityRelation;
    }

    private static JoinFieldDetail parseJoinItem(String exprStr, Map<String, String> relEntityMap, MainEntityType mainEntityType, Map<String, EntityFieldInfo> entityFieldInfoMap, MainEntityTypeUtil mainEntityTypeUtil) {
        JoinFieldDetail joinFieldDetail;
        EntityFieldInfo fieldInfo = entityFieldInfoMap.get(exprStr);
        String relEntityNumber = FieldFullPathParseUtil.getFieldEntityNumber(relEntityMap, exprStr);
        if (HRStringUtils.isEmpty((String)relEntityNumber)) {
            if (exprStr.startsWith(mainEntityType.getName() + ".")) {
                exprStr = exprStr.replaceFirst(mainEntityType.getName() + "\\.", "");
            }
            joinFieldDetail = JoinExprUtil.genJoinFieldDetail(null, (DynamicObjectType)mainEntityType, exprStr, "");
            joinFieldDetail.setMainEntityField(true);
        } else {
            MainEntityType joinEntityType = mainEntityTypeUtil.getMainEntityType(relEntityNumber);
            String[] fieldAliasArr = exprStr.split("\\.");
            String relEntityAlias = fieldAliasArr[0];
            String fieldPrex = relEntityAlias + ".";
            String realField = exprStr.replaceFirst(relEntityAlias + "\\.", "");
            joinFieldDetail = JoinExprUtil.genJoinFieldDetail(null, (DynamicObjectType)joinEntityType, realField, fieldPrex);
            joinFieldDetail.setMainEntityField(false);
        }
        joinFieldDetail.setFieldInfo(fieldInfo);
        return joinFieldDetail;
    }

    @ExcludeFromJacocoGeneratedReport
    private static JoinFieldDetail genJoinFieldDetail(JoinFieldDetail joinFieldDetail, DynamicObjectType dynamicObjectType, String originField, String fieldPrex) {
        String[] fieldAliasArr = originField.split("\\.");
        DynamicProperty property = dynamicObjectType.getProperty(originField);
        if (property == null) {
            property = dynamicObjectType.getProperty(fieldAliasArr[0]);
        }
        if (property == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u65e0\u6cd5\u89e3\u6790\u3002", (String)"JoinExprUtil_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), originField));
        }
        String mainTable = dynamicObjectType.getAlias();
        String mainTablePk = dynamicObjectType.getPrimaryKey().getAlias();
        if (joinFieldDetail == null) {
            joinFieldDetail = new JoinFieldDetail();
            joinFieldDetail.setMainTable(mainTable);
            joinFieldDetail.setMainTablePk(mainTablePk);
        }
        joinFieldDetail.setFieldRealTable(mainTable);
        if (property instanceof ISimpleProperty && PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)property)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u5173\u8054\u4e0d\u53ef\u4f7f\u7528\u9690\u79c1\u4e2d\u5fc3\u5b57\u6bb5\uff1a%s\u3002", (String)"JoinExprUtil_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), originField));
        }
        return JoinExprUtil.setMulOrGroupProp(property, originField, joinFieldDetail, mainTable, fieldPrex);
    }

    @ExcludeFromJacocoGeneratedReport
    private static JoinFieldDetail setMulOrGroupProp(DynamicProperty property, String originField, JoinFieldDetail joinFieldDetail, String mainTable, String fieldPrex) {
        if (property instanceof EntryProp) {
            DynamicProperty tempProp;
            String[] split = originField.split("\\.");
            DynamicObjectType entryProp = ((EntryProp)property).getDynamicCollectionItemPropertyType();
            originField = originField.replaceFirst(split[0] + "\\.", "");
            joinFieldDetail.setEntryTable(entryProp.getAlias());
            joinFieldDetail.setEntryTablePk(entryProp.getPrimaryKey().getAlias());
            joinFieldDetail.setFieldRealTable(entryProp.getAlias());
            if (split.length >= 2 && (tempProp = entryProp.getProperty(split[1])) instanceof SubEntryProp) {
                entryProp = ((SubEntryProp)tempProp).getDynamicCollectionItemPropertyType();
                originField = originField.replaceFirst(split[1] + "\\.", "");
                joinFieldDetail.setSubEntryTable(entryProp.getAlias());
                joinFieldDetail.setSubEntryTablePk(entryProp.getPrimaryKey().getAlias());
                joinFieldDetail.setFieldRealTable(entryProp.getAlias());
            }
            return JoinExprUtil.genJoinFieldDetail(joinFieldDetail, entryProp, originField, fieldPrex);
        }
        if (property instanceof MuliLangTextProp) {
            joinFieldDetail.setMulangField(true);
            joinFieldDetail.setSplitTable(mainTable + "_L");
            joinFieldDetail.setFieldRealTable(mainTable + "_L");
        } else {
            String tableGroup = property.getTableGroup();
            if (HRStringUtils.isNotEmpty((String)tableGroup)) {
                String splitTable = mainTable + "_" + tableGroup;
                joinFieldDetail.setSplitTable(splitTable);
                joinFieldDetail.setFieldRealTable(splitTable);
            }
        }
        return joinFieldDetail;
    }

    public static boolean isDateExpr(String itemVal) {
        if (HRStringUtils.isEmpty((String)itemVal)) {
            return false;
        }
        return itemVal.startsWith("{ts'") && itemVal.endsWith("'}");
    }

    @ExcludeFromJacocoGeneratedReport
    public static Date exprToDate(String itemVal) throws ParseException {
        if (!JoinExprUtil.isDateExpr(itemVal)) {
            return null;
        }
        String dataStr = itemVal.substring(4, itemVal.indexOf("'}"));
        return HRDateTimeUtils.parseDate((String)dataStr);
    }
}

