/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import java.util.HashMap;
import java.util.Map;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public class KSqlFuncUtil {
    private static final String EXPRESSION = "expression";
    private static final String FUNC_MONTH = " MONTH ( expression ) ";
    private static final String FUNC_QUARTER = " QUARTER ( expression ) ";
    private static final String FUNC_DAYOFMONTH = " DAYOFMONTH ( expression ) ";
    private static final String FUNC_YEAR = " YEAR ( expression ) ";
    private static final String FUNC_YEAR_QUARTER = " CASE WHEN expression IS NULL THEN NULL ELSE CONCAT (YEAR(expression), CONCAT ('-', QUARTER(expression))) END ";
    private static final String FUNC_YEAR_MONTH = " SUBSTRING (TO_CHAR(expression) , 0 , 8) ";
    private static final String FUNC_YEAR_MONTH_DAY = " SUBSTRING (TO_CHAR(expression) , 0 , 11) ";
    private static final Map<SplitDateTypeEnum, String> splitDateFuncMap = new HashMap<SplitDateTypeEnum, String>(16);

    public static String substitutionFunc(String expression, SplitDateTypeEnum splitDateTypeEnum) {
        if (splitDateTypeEnum == null) {
            return expression;
        }
        String func = splitDateFuncMap.get(splitDateTypeEnum);
        if (HRStringUtils.isEmpty((String)func)) {
            return expression;
        }
        return func.replace(EXPRESSION, expression);
    }

    static {
        splitDateFuncMap.put(SplitDateTypeEnum.SN_MONTH, FUNC_MONTH);
        splitDateFuncMap.put(SplitDateTypeEnum.FN_MONTH, FUNC_MONTH);
        splitDateFuncMap.put(SplitDateTypeEnum.SN_QUARTER, FUNC_QUARTER);
        splitDateFuncMap.put(SplitDateTypeEnum.FN_QUARTER, FUNC_QUARTER);
        splitDateFuncMap.put(SplitDateTypeEnum.SN_DAY, FUNC_DAYOFMONTH);
        splitDateFuncMap.put(SplitDateTypeEnum.FN_DAY, FUNC_DAYOFMONTH);
        splitDateFuncMap.put(SplitDateTypeEnum.FN_YEAR, FUNC_YEAR);
        splitDateFuncMap.put(SplitDateTypeEnum.SN_YEAR, FUNC_YEAR);
        splitDateFuncMap.put(SplitDateTypeEnum.SN_YEAR_QUARTER, FUNC_YEAR_QUARTER);
        splitDateFuncMap.put(SplitDateTypeEnum.FN_YEAR_QUARTER, FUNC_YEAR_QUARTER);
        splitDateFuncMap.put(SplitDateTypeEnum.SN_YEAR_MONTH, FUNC_YEAR_MONTH);
        splitDateFuncMap.put(SplitDateTypeEnum.FN_YEAR_MONTH, FUNC_YEAR_MONTH);
        splitDateFuncMap.put(SplitDateTypeEnum.FN_YEAR_MONTH_DAY, FUNC_YEAR_MONTH_DAY);
    }
}

