/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.QFilterMrCollectionUtil;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import org.apache.commons.collections.CollectionUtils;

public class QFilterOptimizeUtil {
    private static final Log LOGGER = LogFactory.getLog(QFilterOptimizeUtil.class);

    public static QFilter[] optimize(QFilter[] filters) {
        List<QFilter> qFilterList = new ArrayList<QFilter>(10);
        for (QFilter filter : filters) {
            boolean canSpread = QFilterOptimizeUtil.canSpread(filter);
            if (!canSpread) {
                qFilterList.add(filter);
                continue;
            }
            QFilterOptimizeUtil.spread(qFilterList, filter);
        }
        LOGGER.info("===QFilter optimize before:{}", qFilterList);
        qFilterList = QFilterOptimizeUtil.merge(qFilterList);
        LOGGER.info("===QFilter optimize after:{}", qFilterList);
        return qFilterList.toArray(new QFilter[0]);
    }

    private static List<QFilter> merge(List<QFilter> qFilterList) {
        ArrayList<QFilter> qFilterListMerge = new ArrayList<QFilter>(10);
        ArrayList<QFilter> toBeMergeQFilterList = new ArrayList<QFilter>(10);
        for (QFilter filter : qFilterList) {
            if (CollectionUtils.isNotEmpty((Collection)filter.getNests(true))) {
                qFilterListMerge.add(filter);
                continue;
            }
            if (filter.toString().equals("1 = 1")) continue;
            if (filter.getValue() instanceof Date) {
                qFilterListMerge.add(filter);
                continue;
            }
            if (filter.getCP().equals("in") || filter.getCP().equals("=")) {
                toBeMergeQFilterList.add(filter);
                continue;
            }
            qFilterListMerge.add(filter);
        }
        Map<String, List<QFilter>> groupByQfilterList = toBeMergeQFilterList.stream().collect(Collectors.groupingBy(QFilter::getProperty));
        for (Map.Entry<String, List<QFilter>> entry : groupByQfilterList.entrySet()) {
            List<QFilter> tmpQFilterList = entry.getValue();
            if (tmpQFilterList.size() == 1) {
                qFilterListMerge.addAll(tmpQFilterList);
                continue;
            }
            Set<Object> allValue = null;
            for (QFilter qFilter : tmpQFilterList) {
                if (qFilter.getCP().equals("in")) {
                    Object[] params = QFilterUtilHR.getWithoutDuplicateInValues(qFilter.getValue());
                    Set<Object> valSet = QFilterOptimizeUtil.copyToSet(params);
                    allValue = allValue == null ? valSet : QFilterMrCollectionUtil.findIntersection(allValue, valSet);
                } else {
                    Object value = qFilter.getValue();
                    if (allValue == null) {
                        allValue = new HashSet<Object>(10);
                        allValue.add(value);
                    } else if (QFilterMrCollectionUtil.containsObject(allValue, value)) {
                        allValue.clear();
                        allValue.add(value);
                    } else {
                        allValue.clear();
                    }
                }
                if (!allValue.isEmpty()) continue;
                break;
            }
            if (allValue == null || allValue.isEmpty()) {
                LOGGER.info("not unite compare filter:{}", tmpQFilterList);
                qFilterListMerge.add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
                break;
            }
            QFilter qFilter = new QFilter(entry.getKey(), "in", (Object)allValue);
            qFilterListMerge.add(qFilter);
        }
        return qFilterListMerge;
    }

    private static Set<Object> copyToSet(Object[] params) {
        HashSet<Object> set = new HashSet<Object>(16);
        set.addAll(Arrays.asList(params));
        return set;
    }

    private static void spread(List<QFilter> qFilterList, QFilter qFilter) {
        List nests = qFilter.getNests(true);
        qFilter.clearNests();
        qFilterList.add(qFilter);
        for (QFilter.QFilterNest nest : nests) {
            QFilterOptimizeUtil.spread(qFilterList, nest.getFilter());
        }
    }

    private static boolean canSpread(QFilter filter) {
        List nests = filter.getNests(true);
        if (CollectionUtils.isEmpty((Collection)nests)) {
            return true;
        }
        for (QFilter.QFilterNest qFilterNest : nests) {
            if (!"OR".equals(qFilterNest.getOp()) && QFilterOptimizeUtil.canSpread(qFilterNest.getFilter())) continue;
            return false;
        }
        return true;
    }
}

