/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.formula.excel.Expr;
import kd.hr.hbp.business.function.service.ReportFunctionExecuteService;
import kd.hr.hbp.business.service.complexobj.RptLRUCache;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.TimeZoneInfo;
import kd.hr.hbp.common.util.ReportTimeZoneUtil;

public class ReportFunctionExecuteByCache
implements Serializable {
    private static final long serialVersionUID = 2520779306143183129L;
    private final Map<String, TimeZoneInfo> timeZoneInfoMap;
    private final HRComplexObjContext context;

    public ReportFunctionExecuteByCache(HRComplexObjContext context, List<HRComplexObjFieldInfo> allFields) {
        this.context = context;
        this.timeZoneInfoMap = allFields.stream().filter(field -> field.getTimeZoneInfo() != null).collect(Collectors.toMap(HRComplexObjFieldInfo::getAlias, HRComplexObjFieldInfo::getTimeZoneInfo, (k1, k2) -> k1));
    }

    public ReportFunctionExecuteByCache(HRComplexObjContext context, Map<String, TimeZoneInfo> timeZoneInfoMap) {
        this.context = context;
        this.timeZoneInfoMap = timeZoneInfoMap;
    }

    public Object getFormulaVal(RptLRUCache<String, Object> lruCache, String formula, Expr expr, Map<String, Object> paramMap) {
        this.transferTimeZone(paramMap);
        String cacheKey = formula + paramMap;
        Object val = lruCache.get(cacheKey);
        if (val == null) {
            this.handleBooleanParam(paramMap);
            val = ReportFunctionExecuteService.getInstance().execute(formula, expr, paramMap);
            lruCache.put(cacheKey, val);
        }
        return val;
    }

    public Object getFormulaVal(RptLRUCache<String, Object> lruCache, String formula, Map<String, Object> paramMap) {
        this.transferTimeZone(paramMap);
        String cacheKey = formula + paramMap;
        Object val = lruCache.get(cacheKey);
        if (val == null) {
            this.handleBooleanParam(paramMap);
            val = ReportFunctionExecuteService.getInstance().execute(formula, paramMap);
            lruCache.put(cacheKey, val);
        }
        return val;
    }

    private void handleBooleanParam(Map<String, Object> paramMap) {
        paramMap.forEach((fieldKey, param) -> {
            if (param instanceof Boolean) {
                paramMap.put((String)fieldKey, param == Boolean.TRUE ? "1" : "0");
            }
        });
    }

    private void transferTimeZone(Map<String, Object> paramMap) {
        paramMap.forEach((fieldAlias, value) -> {
            String timeZone;
            TimeZoneInfo timeZoneInfo = this.timeZoneInfoMap.get(fieldAlias);
            if (timeZoneInfo != null && value instanceof Date && (timeZone = timeZoneInfo.getTimeZone()) != null) {
                try {
                    Date date = ReportTimeZoneUtil.transferUserDateTimeFormat((TimeZone)TimeZone.getTimeZone(timeZone), (Date)((Date)value), (DateFormat)this.context.getCurrentUserDateTimeFormat());
                    paramMap.put((String)fieldAlias, date);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
    }
}

