/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.diff;

import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.yaml.snakeyaml.Yaml;

public class AOPContainer {
    private static final Logger logger = Logger.getLogger(AOPContainer.class);
    private static final AOPContainer instance = new AOPContainer();
    private final List<AOPItem> data = new ArrayList<AOPItem>();
    private final String DEFAULT_AOPCONFIG_PATH = "resources/apiaopconfig.json";
    private final String EXTEND_AOPCONFIG_PATH = "resources/apiaopconfig_temp.json";
    private static final String BEFORE = "kd.hr.hbp.business.service.diff.DiffProxy.before";
    private static final String AFTER = "kd.hr.hbp.business.service.diff.DiffProxy.after";
    private static final byte[] MC = "kingdee".getBytes(StandardCharsets.UTF_8);

    private AOPContainer() {
    }

    public static AOPContainer getInstance() {
        return instance;
    }

    public List<AOPItem> getData() {
        return this.data;
    }

    public AOPContainer init() {
        HashMap<String, AOPItem> map = new HashMap<String, AOPItem>();
        this.doInitNormal("resources/apiaopconfig.json", map);
        this.doInitExtend("resources/apiaopconfig_temp.json", map);
        this.data.addAll(map.values());
        return instance;
    }

    private void doInitNormal(String path, Map<String, AOPItem> container) {
        Yaml yaml = new Yaml();
        try {
            Enumeration<URL> resourceUrls = ClassLoader.getSystemResources(path);
            URL url = null;
            while (resourceUrls.hasMoreElements()) {
                url = resourceUrls.nextElement();
                String curFileName = this.parseCurrentAOPConfigFileName(url);
                logger.info((Object)String.format(Locale.ROOT, "AOPContainer.doInitExtend(), parse AOP config file : '%s'.", curFileName));
                InputStream in = url.openStream();
                Throwable throwable = null;
                try {
                    JSONArray array = this.translate((List)yaml.load(in));
                    this.doAddData(array, container, false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (Exception e) {
            String errorMsg = "AOPContainer.doInitNormal() error, read " + path + " error: " + e.getMessage();
            logger.error((Object)errorMsg, (Throwable)e);
            throw new KDException(new ErrorCode("kd.hr.hbp.business.service.diff.AOPContainer.doInitNormal", errorMsg), new Object[]{e});
        }
    }

    private void doInitExtend(String path, Map<String, AOPItem> container) {
        try {
            Enumeration<URL> resourceUrls = ClassLoader.getSystemResources(path);
            URL url = null;
            while (resourceUrls.hasMoreElements()) {
                url = resourceUrls.nextElement();
                String curFileName = this.parseCurrentAOPConfigFileName(url);
                logger.info((Object)String.format(Locale.ROOT, "AOPContainer.doInitExtend(), parse temp AOP config file : '%s'.", curFileName));
                InputStream in = url.openStream();
                Throwable throwable = null;
                try {
                    byte[] bytes = new byte[in.available()];
                    if (-1 == in.read(bytes)) continue;
                    String content = this.decrypt(bytes);
                    JSONArray array = new JSONArray(content);
                    this.doAddData(array, container, true);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (Exception e) {
            String errorMsg = "AOPContainer.doInitExtend() error, read " + path + " error: " + e.getMessage();
            logger.error((Object)errorMsg, (Throwable)e);
            throw new KDException(new ErrorCode("kd.hr.hbp.business.service.diff.AOPContainer.doInitExtend", errorMsg), new Object[]{e});
        }
    }

    private String parseCurrentAOPConfigFileName(URL url) {
        String curFileName = "";
        String[] fileStrs = null;
        if (url.getFile().indexOf("/") >= 0) {
            fileStrs = url.getFile().split("/");
        } else {
            String filePath = url.getFile();
            fileStrs = filePath.split("\\\\");
        }
        curFileName = fileStrs.length > 0 ? fileStrs[fileStrs.length - 3] + "/" + fileStrs[fileStrs.length - 2] + "/" + fileStrs[fileStrs.length - 1] : url.getFile();
        return curFileName;
    }

    private JSONArray translate(List<Map<String, String>> list) {
        JSONArray array = new JSONArray();
        for (Map<String, String> map : list) {
            JSONObject item = new JSONObject();
            item.put("className", (Object)map.get("className"));
            item.put("methodName", (Object)map.get("methodName"));
            item.put("aopType", (Object)map.get("aopType"));
            array.put((Object)item);
        }
        return array;
    }

    private void doAddData(JSONArray array, Map<String, AOPItem> map, boolean extend) {
        for (Object o : array) {
            JSONObject jsonObject = (JSONObject)o;
            String className = jsonObject.getString("className");
            String methodName = jsonObject.getString("methodName");
            String location = jsonObject.getString("aopType");
            final AOPItemScope scope = AOPItemScope.valueOf(location);
            String key = this.getKey(className, methodName);
            if (map.containsKey(key)) {
                if (0 == scope.compareTo(AOPItemScope.BEFORE) && !map.get(key).getTargets().stream().anyMatch(it -> BEFORE.equals(it.getKey()))) {
                    map.get(key).getTargets().add((Pair<String, AOPItemScope>)Pair.of((Object)BEFORE, (Object)((Object)scope)));
                    continue;
                }
                if (0 != scope.compareTo(AOPItemScope.AFTER) || map.get(key).getTargets().stream().anyMatch(it -> AFTER.equals(it.getKey()))) continue;
                map.get(key).getTargets().add((Pair<String, AOPItemScope>)Pair.of((Object)AFTER, (Object)((Object)scope)));
                continue;
            }
            ArrayList<Pair<String, AOPItemScope>> aopTargetItems = new ArrayList<Pair<String, AOPItemScope>>(){
                private static final long serialVersionUID = 1L;
                {
                    if (0 == scope.compareTo(AOPItemScope.BEFORE)) {
                        this.add(Pair.of((Object)AOPContainer.BEFORE, (Object)((Object)scope)));
                    } else {
                        this.add(Pair.of((Object)AOPContainer.AFTER, (Object)((Object)scope)));
                    }
                }
            };
            AOPItem item = new AOPItem(className, methodName, (List<Pair<String, AOPItemScope>>)aopTargetItems, extend);
            map.put(key, item);
        }
    }

    public String decrypt(byte[] bytes) {
        for (int index = 0; index < bytes.length; ++index) {
            int n = index;
            bytes[n] = (byte)(bytes[n] ^ MC[index % MC.length]);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private String getKey(String className, String methodName) {
        return className + "#" + methodName;
    }

    static enum AOPItemScope {
        BEFORE,
        AFTER;

    }

    static class AOPItem {
        private final String sourceClassName;
        private final String sourceMethodName;
        private final List<Pair<String, AOPItemScope>> targets;
        private boolean extend;

        public AOPItem(String sourceClassName, String sourceMethodName, List<Pair<String, AOPItemScope>> targets, boolean extend) {
            this.sourceClassName = sourceClassName;
            this.sourceMethodName = sourceMethodName;
            this.targets = targets;
            this.extend = extend;
        }

        public String getSourceClassName() {
            return this.sourceClassName;
        }

        public String getSourceMethodName() {
            return this.sourceMethodName;
        }

        public List<Pair<String, AOPItemScope>> getTargets() {
            return this.targets;
        }

        public boolean isExtend() {
            return this.extend;
        }
    }
}

