/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.entity.operate.imp;

import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.Donothing;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.service.operation.EntityOperateTypes;
import kd.bos.service.operation.OperationService;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.hr.hbp.business.service.entity.operate.imp.HRMPDonothingService;
import kd.hr.hbp.business.service.entity.operate.imp.HRMPSaveService;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRMPOperationServiceImpl
implements OperationService {
    private static final Log LOGGER = LogFactory.getLog(HRMPOperationServiceImpl.class);
    private String entityNumber;

    public HRMPOperationServiceImpl(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public String invokeOperation(String operationKey, DynamicObject[] dataEntities, OperateOption option) {
        OperationResult operationResult = this.localInvokeOperation(operationKey, dataEntities, option);
        return this.serializeOperationResult(operationResult);
    }

    public String invokeOperation(String arg0, String arg1, Object[] arg2, OperateOption arg3) {
        return null;
    }

    public OperationResult localInvokeOperation(String operationKey, DynamicObject[] dataEntities, OperateOption option) {
        try (TraceSpan span = Tracer.create((String)"OperationService", (String)operationKey);){
            OperationResult operationResult = new OperationResult();
            if (dataEntities.length == 0) {
                operationResult.setSuccess(true);
            } else {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.entityNumber);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("--------------------localInvokeOperation-------------------entityNumber=" + this.entityNumber + ",mainEntityType=" + mainEntityType.getName());
                }
                EntityOperateService operate = this.initializeOperate(operationKey, mainEntityType, dataEntities, option);
                try {
                    operationResult = operate.excute(dataEntities);
                }
                catch (KDBizException e) {
                    if (HRStringUtils.equalsIgnoreCase((String)option.getVariableValue("WF", ""), (String)"TRUE")) {
                        throw e;
                    }
                    operationResult.setSuccess(false);
                    operationResult.setMessage(e.getMessage());
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, BosErrorCode.operationFailed, new Object[]{e.getMessage()});
                }
            }
            OperationResult operationResult2 = operationResult;
            return operationResult2;
        }
    }

    protected void setDataEntities(DynamicObject[] dataEntities) {
    }

    private String serializeOperationResult(OperationResult operationResult) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        return serialResult;
    }

    private EntityOperateService initializeOperate(String operationKey, MainEntityType mainEntityType, DynamicObject[] dataEntities, OperateOption option) {
        EntityOperateService operate = this.createOperation(operationKey, mainEntityType.getName());
        operate.setOption(option != null ? option : OperateOption.create());
        operate.initialize(mainEntityType, operationKey, dataEntities);
        return operate;
    }

    private EntityOperateService createOperation(String operationKey, String entityNumber) {
        switch (operationKey) {
            case "save": {
                HRMPSaveService service = new HRMPSaveService();
                return service;
            }
        }
        Map op = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)operationKey);
        String type = (String)op.get("type");
        EntityOperateService entityOperateService = (EntityOperateService)EntityOperateTypes.createEntityOperate((String)type);
        if (entityOperateService instanceof Donothing) {
            return new HRMPDonothingService();
        }
        return entityOperateService;
    }
}

