/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.FormulaFormatService;
import kd.hr.hbp.business.service.formula.entity.FormulaInfo;
import kd.hr.hbp.business.service.formula.entity.expression.ArrayIndexExpression;
import kd.hr.hbp.business.service.formula.entity.expression.AssExpression;
import kd.hr.hbp.business.service.formula.entity.expression.BooleanExpression;
import kd.hr.hbp.business.service.formula.entity.expression.CalExpression;
import kd.hr.hbp.business.service.formula.entity.expression.ConditionExpression;
import kd.hr.hbp.business.service.formula.entity.expression.DataGradeExpression;
import kd.hr.hbp.business.service.formula.entity.expression.DataGradeResultExpression;
import kd.hr.hbp.business.service.formula.entity.expression.DateExpression;
import kd.hr.hbp.business.service.formula.entity.expression.DateTimeExpression;
import kd.hr.hbp.business.service.formula.entity.expression.ExitExpression;
import kd.hr.hbp.business.service.formula.entity.expression.ExportExpression;
import kd.hr.hbp.business.service.formula.entity.expression.Expression;
import kd.hr.hbp.business.service.formula.entity.expression.FunExpression;
import kd.hr.hbp.business.service.formula.entity.expression.IntExpression;
import kd.hr.hbp.business.service.formula.entity.expression.InvokeMethodExpression;
import kd.hr.hbp.business.service.formula.entity.expression.ItemExpression;
import kd.hr.hbp.business.service.formula.entity.expression.NullExpression;
import kd.hr.hbp.business.service.formula.entity.expression.NumExpression;
import kd.hr.hbp.business.service.formula.entity.expression.OperatorExpression;
import kd.hr.hbp.business.service.formula.entity.expression.ResultExpression;
import kd.hr.hbp.business.service.formula.entity.expression.SelectItemExpression;
import kd.hr.hbp.business.service.formula.entity.expression.StrExpression;
import kd.hr.hbp.business.service.formula.entity.floatcontrol.SelectItem;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.entity.item.DataGradeItem;
import kd.hr.hbp.business.service.formula.entity.item.FunctionItem;
import kd.hr.hbp.business.service.formula.entity.item.ParamItem;
import kd.hr.hbp.business.service.formula.entity.item.ResultItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.entity.node.OriginalNode;
import kd.hr.hbp.business.service.formula.enums.CalItemParamsEnum;
import kd.hr.hbp.business.service.formula.enums.CalItemTypeEnum;
import kd.hr.hbp.business.service.formula.enums.ConditionEnum;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.service.formula.enums.ExpressionNodeTypeEnum;
import kd.hr.hbp.business.service.formula.enums.FormulaKeyEnum;
import kd.hr.hbp.business.service.formula.enums.InvokeMethodEnum;
import kd.hr.hbp.business.service.formula.enums.OperatorEnum;
import kd.hr.hbp.business.service.formula.helper.ExpressionParseHelper;
import kd.hr.hbp.business.service.formula.helper.FormulaDataServiceHelper;
import kd.hr.hbp.business.service.formula.helper.FormulaReplaceHelper;
import kd.hr.hbp.business.service.formula.helper.FormulaSplitHelper;
import kd.hr.hbp.business.service.formula.utils.FormulaCacheUtils;
import kd.hr.hbp.business.service.formula.utils.FormulaListUtils;
import kd.hr.hbp.business.service.formula.utils.FormulaUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkPublic;
import org.jetbrains.annotations.NotNull;

@SdkPublic
public class FormulaParseService {
    private static final char NEWLINE = '\n';
    private static final String ENDINDEX = "endIndex";
    private static final String EXPRESSIONFLAG = "expression";
    private static final String DATA_GRADE_RESULT_FLAG = "dataGradeResult";
    private static final String CONDITION_EXP_PLACEHOLDER = "CONDITION_EXP_PLACEHOLDER_";
    private static final String JAVA_VARIABLE_REGULAR = "^[\\u4e00-\\u9fa5_a-zA-Z0-9]+$";

    public final FormulaInfo parseFormula(DynamicObject formula, long formulaId, IFormView view) {
        FormulaInfo formulaInfo = this.getFormulaInfo();
        this.setFormulaInfo(formula, formulaId, formulaInfo, view);
        this.parse(formulaInfo);
        FormulaReplaceHelper.replaceToUniqueKey(formulaInfo);
        return formulaInfo;
    }

    public final DynamicObject parseFormulaDy(DynamicObject formula, long formulaId, String bizAppNumber, List<TreeNodeItem> treeNodeItems, List<ResultItem> resultItems, List<TreeNodeItem> dataGradeItems, boolean isParseByUniqueCodeExp) {
        FormulaInfo formulaInfo = this.getFormulaInfo();
        this.setFormulaInfo(formula, formulaId, formulaInfo, bizAppNumber, treeNodeItems, resultItems, dataGradeItems, isParseByUniqueCodeExp);
        this.parse(formulaInfo);
        FormulaReplaceHelper.replaceToUniqueKey(formulaInfo);
        this.setFormulaParseValue(formulaInfo, formula);
        return formula;
    }

    private void setFormulaInfo(DynamicObject formula, long formulaId, FormulaInfo formulaInfo, String bizAppNumber, List<TreeNodeItem> treeNodeItems, List<ResultItem> resultItems, List<TreeNodeItem> dataGradeItems, boolean isParseByUniqueCodeExp) throws KDBizException {
        formulaInfo.setId(String.valueOf(formulaId));
        IDataEntityProperty property = (IDataEntityProperty)formula.getDataEntityType().getProperties().get((Object)"resultitem");
        String resultItemPropertyName = property.getDisplayName().getLocaleValue();
        formulaInfo.setResultItemPropertyName(resultItemPropertyName);
        this.setFormulaMapData(formulaInfo, bizAppNumber, treeNodeItems, resultItems, dataGradeItems);
        DynamicObject resultItemObj = formula.getDynamicObject("resultitem");
        if (Objects.isNull(resultItemObj)) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u6307\u5b9a\u7684%1$s\u3002", (String)"FormulaParseService_50", (String)"hrmp-hbp-business", (Object[])new Object[0]), resultItemPropertyName));
        }
        if (isParseByUniqueCodeExp) {
            formulaInfo.setOriginalCode(this.getOriginalExpByUniqueCodeExp(formula, formulaInfo, formulaInfo.getFcMap().values(), treeNodeItems, dataGradeItems));
        } else {
            formulaInfo.setOriginalCode(formula.getString("originalexp"));
        }
        String resultItemName = resultItemObj.getString("name");
        ResultItem item = new ResultItem();
        item.setName(resultItemName);
        item.setItemCategory(resultItemObj.getString("itemcategory"));
        item.setUniqueCode(resultItemObj.getString("uniquecode"));
        item.setDataType(DataTypeEnum.getDataType(resultItemObj.getString("datatype")));
        item.setCalProportionItem("1".equals(resultItemObj.getString("issubsectionitem")));
        item.setDataLength(resultItemObj.getInt("datalength"));
        item.setScale(resultItemObj.getInt("scale"));
        formulaInfo.setResultItem(item);
        formulaInfo.setProrateItemFormula(item.isCalProportionItem());
        Map<String, ResultItem> resultItemMap = formulaInfo.getResultItemMap();
        ResultItem findResultItem = resultItemMap.get(FormulaUtils.getItemMapKey(item.getItemCategory(), resultItemName));
        if (Objects.isNull(findResultItem) && !formulaInfo.isProrateItemFormula()) {
            String msg = ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u65e0\u6cd5\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5\u5ba1\u6838\u72b6\u6001\uff0c\u6216\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"FormulaParseService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(Locale.ROOT, msg, resultItemPropertyName, resultItemName));
        }
    }

    private void setFormulaMapData(FormulaInfo formulaInfo, String bizAppNumber, List<TreeNodeItem> treeNodeItems, List<ResultItem> resultItems, List<TreeNodeItem> dataGradeItems) {
        HashSet itemCategorySet = Sets.newHashSetWithExpectedSize((int)16);
        FormulaDataServiceHelper.getFuncList(bizAppNumber, null, null).ifPresent(funcList -> {
            formulaInfo.setFcMap(funcList.stream().filter(func -> func instanceof FunctionItem).map(func -> (FunctionItem)func).collect(Collectors.toMap(func -> FormulaUtils.getItemMapKey(func.getItemCategory(), func.getName()), func -> func, (v1, v2) -> v2)));
            itemCategorySet.addAll(FormulaUtils.getItemCategorySet(funcList));
        });
        if (treeNodeItems != null && treeNodeItems.size() > 0) {
            Map<String, CalItem> calItemMap = treeNodeItems.stream().filter(item -> item instanceof CalItem).map(item -> (CalItem)item).collect(Collectors.toMap(item -> FormulaUtils.getItemMapKey(item.getItemCategory(), item.getName()), item -> item, (v1, v2) -> v2));
            formulaInfo.setCalItemMap(calItemMap);
            formulaInfo.setEntityNumberBaseDataCalItemMap(calItemMap.values().stream().filter(item -> HRStringUtils.isNotEmpty((String)item.getEntityNumber())).filter(item -> CalItemTypeEnum.BASE_DATA == item.getItemType()).collect(Collectors.toMap(CalItem::getEntityNumber, item -> item, (item1, item2) -> item2)));
            formulaInfo.setEnumValueToCalItemMap(this.getEnumShowValueToCalItemMap(calItemMap.values()));
            itemCategorySet.addAll(FormulaUtils.getItemCategorySet(treeNodeItems));
        }
        if (dataGradeItems != null && dataGradeItems.size() > 0) {
            formulaInfo.setDataGradeMap(dataGradeItems.stream().filter(dataGrade -> dataGrade instanceof DataGradeItem).map(dataGrade -> (DataGradeItem)dataGrade).collect(Collectors.toMap(dataGrade -> FormulaUtils.getItemMapKey(dataGrade.getItemCategory(), dataGrade.getName()), dataGrade -> dataGrade, (v1, v2) -> v2)));
            itemCategorySet.addAll(FormulaUtils.getItemCategorySet(dataGradeItems));
        }
        if (resultItems != null && resultItems.size() > 0) {
            formulaInfo.setResultItemMap(resultItems.stream().collect(Collectors.toMap(resultItem -> FormulaUtils.getItemMapKey(resultItem.getItemCategory(), resultItem.getName()), resultItem -> resultItem, (v1, v2) -> v2)));
            itemCategorySet.addAll(FormulaUtils.getItemCategorySet(resultItems));
        }
        formulaInfo.setItemCategorySet(itemCategorySet);
    }

    private String getOriginalExpByUniqueCodeExp(DynamicObject formula, FormulaInfo formulaInfo, Collection<FunctionItem> functionItems, List<TreeNodeItem> treeNodeItems, List<TreeNodeItem> dataGradeItems) {
        String uniqueCodeExp = formula.getString("uniquecodeexp");
        FormulaSplitHelper splitHelper = new FormulaSplitHelper();
        List<OriginalNode> splitNodes = splitHelper.getOriginalNodes(uniqueCodeExp, null);
        Map<String, String> uniqueCodeDisplayNameMap = FormulaReplaceHelper.getUniqueCodeToDisplayNameMap(formula, functionItems, dataGradeItems, treeNodeItems);
        return FormulaFormatService.formatFormulaExp(FormulaReplaceHelper.transfer(splitNodes, uniqueCodeDisplayNameMap), formulaInfo);
    }

    private void setFormulaParseValue(FormulaInfo formulaInfo, DynamicObject formula) {
        formula.set("executeexp", (Object)formulaInfo.getExecuteCode());
        formula.set("uniquecodeexp", (Object)formulaInfo.getUniqueKeyCode());
        formula.set("originalexp", (Object)formulaInfo.getOriginalCode());
        formula.set("isdraft", (Object)Boolean.FALSE);
        formula.set("dependentfunc", (Object)FormulaListUtils.join(formulaInfo.getFcUniqueCodeSet(), ","));
        formula.set("dependentcalitem", (Object)FormulaListUtils.join(formulaInfo.getCalUniqueCodeKeyMap().keySet(), ","));
        formula.set("dependentcustitem", (Object)FormulaListUtils.join(formulaInfo.getCalCustomUniqueCodeSet(), ","));
        formula.set("dependentcalitemforfunc", (Object)FormulaListUtils.join(formulaInfo.getCalForFuncUniqueCodeKeyMap().keySet(), ","));
        formula.set("dependentcalitemfordg", (Object)FormulaListUtils.join(formulaInfo.getCalForDataGradeUniqueCodeKeyMap().keySet(), ","));
        formula.set("dependentdatagrade", (Object)FormulaListUtils.join(formulaInfo.getDataGradeUniqueCodeSet(), ","));
        formula.set("dependentbasedata", (Object)FormulaListUtils.join(formulaInfo.getBaseDataUniqueCodeSet(), ","));
        formula.set("dependentenum", (Object)FormulaListUtils.join(formulaInfo.getEnumUniqueCodeSet(), ","));
        formula.set("resultitemcategory", (Object)formulaInfo.getResultItem().getItemCategory());
        formula.set("resultitemuniquecode", (Object)formulaInfo.getResultItem().getUniqueCode());
        formula.set("resultitemdatatype", (Object)formulaInfo.getResultItem().getDataType().name());
        formula.set("resultitemdatalength", (Object)formulaInfo.getResultItem().getDataLength());
        formula.set("resultitemscale", (Object)formulaInfo.getResultItem().getScale());
    }

    private void setFormulaInfo(DynamicObject formula, long formulaId, FormulaInfo formulaInfo, IFormView view) throws KDBizException {
        formulaInfo.setId(String.valueOf(formulaId));
        formulaInfo.setName(formula.getString("name"));
        BasedataEdit control = (BasedataEdit)view.getControl("resultitem");
        String resultItemPropertyName = control.getProperty().getDisplayName().getLocaleValue();
        formulaInfo.setResultItemPropertyName(resultItemPropertyName);
        formulaInfo.setOriginalCode(formula.getString("originalexp"));
        formulaInfo.setFcMap(FormulaCacheUtils.getMapCustValueFromFormulaPageCache(view, "formula_fuc_map_cache_key", FunctionItem.class));
        formulaInfo.setDataGradeMap(FormulaCacheUtils.getMapCustValueFromFormulaPageCache(view, "formula_data_grade_map_cache_key", DataGradeItem.class));
        Map<String, CalItem> calItemMap = FormulaCacheUtils.getMapCustValueFromFormulaPageCache(view, "formula_cal_item_map_cache_key", CalItem.class);
        formulaInfo.setCalItemMap(calItemMap);
        formulaInfo.setEntityNumberBaseDataCalItemMap(calItemMap.values().stream().filter(item -> HRStringUtils.isNotEmpty((String)item.getEntityNumber())).filter(item -> CalItemTypeEnum.BASE_DATA == item.getItemType()).collect(Collectors.toMap(CalItem::getEntityNumber, item -> item, (item1, item2) -> item2)));
        formulaInfo.setEnumValueToCalItemMap(this.getEnumShowValueToCalItemMap(calItemMap.values()));
        formulaInfo.setResultItemMap(FormulaCacheUtils.getMapCustValueFromFormulaPageCache(view, "formula_result_item_map_cache_key", ResultItem.class));
        formulaInfo.setItemCategorySet(new HashSet<String>(FormulaCacheUtils.getListBaseValueFromFormulaPageCache(view, "formula_item_category_set_cache_key", String.class)));
        DynamicObject resultItemObj = formula.getDynamicObject("resultitem");
        if (Objects.isNull(resultItemObj)) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u6307\u5b9a\u7684%1$s\u3002", (String)"FormulaParseService_50", (String)"hrmp-hbp-business", (Object[])new Object[0]), resultItemPropertyName));
        }
        String resultItemName = resultItemObj.getString("name");
        ResultItem item3 = new ResultItem();
        item3.setName(resultItemName);
        item3.setItemCategory(resultItemObj.getString("itemcategory"));
        item3.setUniqueCode(resultItemObj.getString("uniquecode"));
        item3.setDataType(DataTypeEnum.getDataType(resultItemObj.getString("datatype")));
        item3.setCalProportionItem("1".equals(resultItemObj.getString("issubsectionitem")));
        item3.setDataLength(resultItemObj.getInt("datalength"));
        item3.setScale(resultItemObj.getInt("scale"));
        formulaInfo.setResultItem(item3);
        formulaInfo.setProrateItemFormula(item3.isCalProportionItem());
        Map<String, ResultItem> resultItemMap = formulaInfo.getResultItemMap();
        ResultItem findResultItem = resultItemMap.get(FormulaUtils.getItemMapKey(item3.getItemCategory(), resultItemName));
        if (Objects.isNull(findResultItem) && !formulaInfo.isProrateItemFormula()) {
            String msg = ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u65e0\u6cd5\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5\u5ba1\u6838\u72b6\u6001\uff0c\u6216\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"FormulaParseService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(Locale.ROOT, msg, resultItemPropertyName, resultItemName));
        }
        this.childSetFormulaInfo(formula, formulaInfo, view);
    }

    private Map<String, List<CalItem>> getEnumShowValueToCalItemMap(Collection<CalItem> calItems) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        if (calItems == null) {
            return map;
        }
        List enumItems = calItems.stream().filter(item -> CalItemTypeEnum.ENUM == item.getItemType()).filter(item -> HRStringUtils.isNotEmpty((String)item.getEntityNumber())).filter(item -> HRStringUtils.isNotEmpty((String)item.getPropertyField())).collect(Collectors.toList());
        for (CalItem item2 : enumItems) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)item2.getEntityNumber());
            DynamicProperty property = entityType.getProperty(item2.getPropertyField());
            if (property instanceof ComboProp) {
                ComboProp prop = (ComboProp)property;
                List comboItems = prop.getComboItems();
                for (ValueMapItem valueMapItem : comboItems) {
                    String showKey = SelectItem.getShowKey(valueMapItem.getName().getLocaleValue());
                    map.putIfAbsent(showKey, new ArrayList(10));
                    map.computeIfPresent(showKey, (value1, value2) -> {
                        value2.add(item2);
                        return value2;
                    });
                }
                continue;
            }
            throw new KDBizException(MessageFormat.format("{} is not a enum field in metadata {}", item2.getPropertyField(), item2.getEntityNumber()));
        }
        return map;
    }

    private List<ConditionExpression> getConditionExpressionList(List<OriginalNode> nodes, boolean isOutermost) {
        boolean isOutermostAndExpIsNotEmpty;
        int complex = 0;
        ArrayList<ConditionExpression> expressionList = new ArrayList<ConditionExpression>(10);
        Map<String, ConditionEnum> conditionKeyMap = FormulaUtils.getConditionMap();
        ConditionExpression conditionExpression = new ConditionExpression(null);
        int index = 0;
        while (index < nodes.size()) {
            OriginalNode node = nodes.get(index);
            ConditionEnum conditionEnum = conditionKeyMap.get(node.getNodeText());
            if (null != conditionEnum) {
                boolean conditionIsComplexStart;
                boolean conditionIsEndIFOrEndWhileOrElseIF;
                boolean bl = conditionIsEndIFOrEndWhileOrElseIF = ConditionEnum.ENDIF == conditionEnum || ConditionEnum.END_WHILE == conditionEnum || ConditionEnum.ELSEIF == conditionEnum;
                if (conditionIsEndIFOrEndWhileOrElseIF) {
                    boolean conditionIsComplexEnd;
                    if (!CollectionUtils.isEmpty(conditionExpression.getExpressions()) && Objects.isNull(conditionExpression.getNode())) {
                        expressionList.add(conditionExpression);
                    }
                    if (complex == 0 && !isOutermost) break;
                    conditionExpression = new ConditionExpression(node);
                    conditionExpression.setConditionEnum(conditionEnum);
                    expressionList.add(conditionExpression);
                    boolean bl2 = conditionIsComplexEnd = ConditionEnum.ENDIF == conditionEnum || ConditionEnum.END_WHILE == conditionEnum;
                    if (conditionIsComplexEnd) {
                        conditionExpression = new ConditionExpression(null);
                        --complex;
                    }
                    ++index;
                    continue;
                }
                if (ConditionEnum.THEN == conditionEnum || ConditionEnum.ELSE == conditionEnum) {
                    if (!CollectionUtils.isEmpty(conditionExpression.getExpressions()) && Objects.isNull(conditionExpression.getNode())) {
                        expressionList.add(conditionExpression);
                    }
                    if (complex == 0 && !isOutermost) break;
                    List<OriginalNode> childNodes = nodes.stream().skip(index + 1).collect(Collectors.toList());
                    conditionExpression = new ConditionExpression(node);
                    conditionExpression.setConditionEnum(conditionEnum);
                    List<ConditionExpression> childConditions = this.getConditionExpressionList(childNodes, false);
                    index = index + this.getExpressionNodesCount(childConditions) + this.getCurrentConditionExpressionNodesCount(childConditions) + 1;
                    conditionExpression.setChildConditionExpressions(this.getActualChildAndSetExpressions(conditionExpression, childConditions));
                    expressionList.add(conditionExpression);
                    continue;
                }
                if (!CollectionUtils.isEmpty(conditionExpression.getExpressions()) && Objects.isNull(conditionExpression.getNode())) {
                    expressionList.add(conditionExpression);
                }
                boolean bl3 = conditionIsComplexStart = ConditionEnum.IF == conditionEnum || ConditionEnum.WHILE == conditionEnum;
                if (conditionIsComplexStart) {
                    ++complex;
                }
                conditionExpression = new ConditionExpression(node);
                conditionExpression.setConditionEnum(conditionEnum);
                expressionList.add(conditionExpression);
            } else {
                conditionExpression.addExpression(node);
            }
            if (this.isResultKey(node.getNodeText())) {
                conditionExpression.setIsResult(Boolean.TRUE);
            }
            ++index;
        }
        boolean bl = isOutermostAndExpIsNotEmpty = isOutermost && !CollectionUtils.isEmpty(conditionExpression.getExpressions()) && Objects.isNull(conditionExpression.getNode());
        if (isOutermostAndExpIsNotEmpty) {
            expressionList.add(conditionExpression);
        }
        return expressionList;
    }

    private int getExpressionNodesCount(List<ConditionExpression> conditionExpressions) {
        if (CollectionUtils.isEmpty(conditionExpressions)) {
            return 0;
        }
        int count = conditionExpressions.stream().filter(exp -> !CollectionUtils.isEmpty(exp.getChildConditionExpressions())).mapToInt(exp -> this.getExpressionNodesCount(exp.getChildConditionExpressions())).sum();
        return count + conditionExpressions.stream().mapToInt(exp -> exp.getExpressions().size()).sum();
    }

    private int getCurrentConditionExpressionNodesCount(List<ConditionExpression> conditionExpressions) {
        if (CollectionUtils.isEmpty(conditionExpressions)) {
            return 0;
        }
        return (int)conditionExpressions.stream().filter(exp -> Objects.nonNull(exp.getNode())).count();
    }

    private List<ConditionExpression> getActualChildAndSetExpressions(ConditionExpression parentConditionExp, List<ConditionExpression> childConditionExpressions) {
        if (!CollectionUtils.isEmpty(childConditionExpressions)) {
            int index = 0;
            for (ConditionExpression childExp2 : childConditionExpressions) {
                if (Objects.isNull(childExp2.getNode())) {
                    childExp2.getExpressions().forEach(parentConditionExp::addExpression);
                    continue;
                }
                OriginalNode node = new OriginalNode();
                node.setNodeText(CONDITION_EXP_PLACEHOLDER + index);
                parentConditionExp.addExpression(node);
                ++index;
            }
            return childConditionExpressions.stream().filter(childExp -> Objects.nonNull(childExp.getNode())).collect(Collectors.toList());
        }
        return childConditionExpressions;
    }

    public List<Expression> getExpression(ConditionExpression conditionExpression, List<OriginalNode> nodes, FormulaInfo formula) {
        ArrayList<List<Expression>> expressionLists = new ArrayList<List<Expression>>(10);
        LoopIndex loopIndex = new LoopIndex(nodes, 0);
        while (loopIndex.getCurrIndex() < loopIndex.getLen()) {
            OriginalNode node = loopIndex.getOriginalNode();
            this.checkDetailNode(node, nodes, loopIndex.getSubExpList(), formula);
            if (FormulaUtils.isFunction(formula, node.getNodeText())) {
                this.addFunctionExpression(nodes, formula, null, loopIndex);
            } else if (FormulaUtils.isDataGrade(formula, node.getNodeText())) {
                this.addDataGradeExpression(nodes, formula, null, loopIndex);
            } else if (FormulaUtils.isCalCustomItem(formula, node.getNodeText())) {
                this.addCalCustomExpression(formula, null, CalItemParamsEnum.COMMON, loopIndex);
            } else if (FormulaUtils.isCalItem(formula, node.getNodeText())) {
                this.addCalExpression(formula, null, CalItemParamsEnum.COMMON, loopIndex);
            } else if (FormulaUtils.isTempVariable(formula, node.getNodeText())) {
                this.addTempVariableExpression(formula, null, loopIndex, node);
            } else if (FormulaUtils.isInvokeMethod(node.getNodeText())) {
                this.addInvokeMethodExpression(null, loopIndex, node);
            } else if (FormulaUtils.isString(node.getNodeText())) {
                boolean isResult = Objects.nonNull(conditionExpression) && conditionExpression.getIsResult();
                Expression selectOrDateOrStrExpression = this.getSelectOrDateOrStrExpression(nodes, formula, loopIndex.currIndex, loopIndex.getSubExpList(), null, null, isResult);
                this.addSimpleNotOperatorExpression(null, loopIndex, node, selectOrDateOrStrExpression);
            } else if (FormulaUtils.isOperation(node.getNodeText()) && !this.isAssignmentKey(node.getNodeText())) {
                this.addSimpleOperatorExpression(formula, conditionExpression, null, loopIndex, node);
            } else if (FormulaUtils.isInteger(node.getNodeText())) {
                this.checkIntegerValue(loopIndex.getCurrIndex(), nodes, node);
                this.addSimpleNotOperatorExpression(null, loopIndex, node, new IntExpression(node));
            } else if (FormulaUtils.isNumber(node.getNodeText())) {
                this.addSimpleNotOperatorExpression(null, loopIndex, node, new NumExpression(node));
            } else if (FormulaUtils.isBoolean(node.getNodeText())) {
                this.addSimpleNotOperatorExpression(null, loopIndex, node, new BooleanExpression(node));
            } else if (this.isChildConditionKey(node.getNodeText())) {
                this.addChildConditionExpression(conditionExpression, expressionLists, loopIndex, node);
            } else if (FormulaUtils.isExit(node.getNodeText())) {
                this.addSimpleNotOperatorExpression(null, loopIndex, node, new ExitExpression(node));
            } else if (FormulaUtils.isNullType(node.getNodeText())) {
                this.addSimpleNotOperatorExpression(null, loopIndex, node, new NullExpression(node));
            } else if (this.isExportKey(node.getNodeText())) {
                this.addExportExpression(nodes, formula, loopIndex);
            } else if (FormulaUtils.isDataType(node.getNodeText())) {
                this.addDataTypeExpression(nodes, formula, loopIndex, node);
            } else if (FormulaUtils.isArrayIndex(node, formula)) {
                this.addArrayExpression(loopIndex, node);
            } else {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u672a\u5b9a\u4e49\u7684\u5173\u952e\u5b57[{2}]\u3002", (String)"FormulaParseService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
            }
            if (loopIndex.getCurrIndex() != loopIndex.getLen() || loopIndex.getSubExpList().size() <= 0) continue;
            expressionLists.add(loopIndex.getSubExpList());
        }
        return this.addCalExpressionAndReturnCommonList(expressionLists);
    }

    private Expression getSelectOrStrExpression(List<OriginalNode> nodes, FormulaInfo formula, int currentIndex, OriginalNode entityNode, OriginalNode complexNode, boolean isResult) {
        OriginalNode node = nodes.get(currentIndex);
        if (Objects.nonNull(complexNode)) {
            return new StrExpression(node);
        }
        if (Objects.isNull(entityNode) && !isResult) {
            int lineSize;
            for (int nodeIndex = currentIndex; nodeIndex >= 1; --nodeIndex) {
                OriginalNode preNode = nodes.get(nodeIndex - 1);
                if (!FormulaUtils.isItem(formula, preNode.getNodeText())) continue;
                entityNode = preNode;
                break;
            }
            if (entityNode == null && currentIndex + 2 < (lineSize = nodes.size())) {
                int nodeIndex = currentIndex;
                for (int time = 0; time < 2; ++time) {
                    OriginalNode afterNode = nodes.get(nodeIndex + 1);
                    if (FormulaUtils.isItem(formula, afterNode.getNodeText())) {
                        entityNode = afterNode;
                        break;
                    }
                    ++nodeIndex;
                }
            }
        }
        if (Objects.isNull(entityNode) && !isResult) {
            return new StrExpression(node);
        }
        CalItem calItem = isResult ? formula.getResultItem() : formula.getCalItemMap().get(entityNode.getNodeText());
        if (calItem == null) {
            return new StrExpression(node);
        }
        if (CalItemTypeEnum.BASE_DATA == calItem.getItemType() && HRStringUtils.isNotEmpty((String)calItem.getEntityNumber()) && HRStringUtils.isNotEmpty((String)calItem.getPropertyField())) {
            return FormulaParseService.getBaseDataOrStrExpression(node, calItem);
        }
        if (CalItemTypeEnum.ENUM == calItem.getItemType() && HRStringUtils.isNotEmpty((String)calItem.getEntityNumber()) && HRStringUtils.isNotEmpty((String)calItem.getPropertyField())) {
            return FormulaParseService.getEnumOrStrExpression(node, calItem);
        }
        return new StrExpression(node);
    }

    private Expression getSelectOrDateOrStrExpression(List<OriginalNode> nodes, FormulaInfo formula, int currentIndex, List<Expression> expressionList, OriginalNode entityNode, OriginalNode complexNode, boolean isResult) {
        OriginalNode node = nodes.get(currentIndex);
        if (Objects.nonNull(complexNode)) {
            if (FormulaUtils.isDate(node.getNodeText())) {
                if (node.getNodeText().contains(":")) {
                    node.setDataType(DataTypeEnum.DATETIME);
                    return new DateTimeExpression(node);
                }
                node.setDataType(DataTypeEnum.DATE);
                return new DateExpression(node);
            }
            return new StrExpression(node);
        }
        if (Objects.isNull(entityNode) && !isResult) {
            int lineSize;
            for (int nodeIndex = currentIndex; nodeIndex >= 1; --nodeIndex) {
                OriginalNode preNode = nodes.get(nodeIndex - 1);
                if (!FormulaUtils.isItem(formula, preNode.getNodeText())) continue;
                entityNode = preNode;
                break;
            }
            if (entityNode == null && currentIndex + 2 < (lineSize = nodes.size())) {
                int nodeIndex = currentIndex;
                for (int time = 0; time < 2; ++time) {
                    OriginalNode afterNode = nodes.get(nodeIndex + 1);
                    if (FormulaUtils.isItem(formula, afterNode.getNodeText())) {
                        entityNode = afterNode;
                        break;
                    }
                    ++nodeIndex;
                }
            }
        }
        if (Objects.isNull(entityNode) && !isResult) {
            if (FormulaUtils.isDate(node.getNodeText())) {
                return this.getDateOrStrExpression(nodes, formula, currentIndex, expressionList, null, false);
            }
            return new StrExpression(node);
        }
        CalItem calItem = isResult ? formula.getResultItem() : formula.getCalItemMap().get(entityNode.getNodeText());
        if (calItem == null) {
            if (FormulaUtils.isDate(node.getNodeText())) {
                return this.getDateOrStrExpression(nodes, formula, currentIndex, expressionList, null, false);
            }
            return new StrExpression(node);
        }
        if (CalItemTypeEnum.BASE_DATA == calItem.getItemType() && HRStringUtils.isNotEmpty((String)calItem.getEntityNumber()) && HRStringUtils.isNotEmpty((String)calItem.getPropertyField())) {
            return FormulaParseService.getBaseDataOrStrExpression(node, calItem);
        }
        if (CalItemTypeEnum.ENUM == calItem.getItemType() && HRStringUtils.isNotEmpty((String)calItem.getEntityNumber()) && HRStringUtils.isNotEmpty((String)calItem.getPropertyField())) {
            return FormulaParseService.getEnumOrStrExpression(node, calItem);
        }
        if (FormulaUtils.isDate(node.getNodeText())) {
            return this.getDateOrStrExpression(nodes, formula, currentIndex, expressionList, null, isResult);
        }
        return new StrExpression(node);
    }

    private Expression getDateOrStrExpression(List<OriginalNode> nodes, FormulaInfo formula, int currentIndex, List<Expression> expressionList, OriginalNode complexNode, boolean isResult) {
        OriginalNode itemNode;
        Expression expression;
        OriginalNode node = nodes.get(currentIndex);
        if (Objects.nonNull(complexNode)) {
            if (node.getNodeText().contains(":")) {
                node.setDataType(DataTypeEnum.DATETIME);
                return new DateTimeExpression(node);
            }
            node.setDataType(DataTypeEnum.DATE);
            return new DateExpression(node);
        }
        if (isResult) {
            ResultItem resultItem = formula.getResultItem();
            DataTypeEnum dataType = resultItem.getDataType();
            if (DataTypeEnum.TEXT == dataType) {
                return new StrExpression(node);
            }
            if (DataTypeEnum.DATETIME == dataType) {
                node.setDataType(DataTypeEnum.DATETIME);
                return new DateTimeExpression(node);
            }
            node.setDataType(DataTypeEnum.DATE);
            return new DateExpression(node);
        }
        int expressionSize = expressionList.size();
        if (expressionSize - 2 >= 0 && (expression = expressionList.get(expressionSize - 2)) instanceof AssExpression) {
            CalItem calItem = ((AssExpression)expression).getCalItem();
            DataTypeEnum dataTypeEnum = calItem != null ? calItem.getDataType() : ((AssExpression)expression).getDataType();
            if (DataTypeEnum.TEXT == dataTypeEnum) {
                return new StrExpression(node);
            }
            if (DataTypeEnum.DATETIME == dataTypeEnum) {
                node.setDataType(DataTypeEnum.DATETIME);
                return new DateTimeExpression(node);
            }
            node.setDataType(DataTypeEnum.DATE);
            return new DateExpression(node);
        }
        if (currentIndex + 2 < nodes.size() && FormulaUtils.isItem(formula, (itemNode = nodes.get(currentIndex + 2)).getNodeText())) {
            CalItem calItem = formula.getCalItemMap().get(itemNode.getNodeText());
            DataTypeEnum dataTypeEnum = calItem.getDataType();
            if (DataTypeEnum.TEXT == dataTypeEnum) {
                return new StrExpression(node);
            }
            if (DataTypeEnum.DATETIME == dataTypeEnum) {
                node.setDataType(DataTypeEnum.DATETIME);
                return new DateTimeExpression(node);
            }
            node.setDataType(DataTypeEnum.DATE);
            return new DateExpression(node);
        }
        if (node.getNodeText().contains(":")) {
            node.setDataType(DataTypeEnum.DATETIME);
            return new DateTimeExpression(node);
        }
        node.setDataType(DataTypeEnum.DATE);
        return new DateExpression(node);
    }

    public static Expression getBaseDataOrStrExpression(OriginalNode node, CalItem calItem) {
        HRBaseServiceHelper helper;
        DynamicObject baseData;
        String entityNumber = calItem.getEntityNumber();
        String propertyField = calItem.getPropertyField();
        String[] fields = propertyField.split(",");
        String[] splitStr = fields.length == 1 ? new String[]{node.getNodeText().substring(1, node.getNodeText().length() - 1)} : node.getNodeText().substring(1, node.getNodeText().length() - 1).split("_");
        if (splitStr.length != fields.length) {
            return new StrExpression(node);
        }
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)splitStr.length);
        for (int index = 0; index < splitStr.length; ++index) {
            qFilterList.add(new QFilter(fields[index], "=", (Object)splitStr[index]));
        }
        QFilter[] qFilters = calItem.getqFilters();
        if (qFilters != null && qFilters.length > 0) {
            qFilterList.addAll(Arrays.asList(qFilters));
        }
        if (Objects.nonNull(baseData = (helper = new HRBaseServiceHelper(entityNumber)).queryOriginalOne("id," + calItem.getPropertyField(), qFilterList.toArray(new QFilter[0]), calItem.getOrders()))) {
            return new SelectItemExpression(node, SelectItem.getSelectItemByBaseData(calItem, baseData));
        }
        return new StrExpression(node);
    }

    public static Expression getEnumOrStrExpression(OriginalNode node, CalItem calItem) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)calItem.getEntityNumber());
        DynamicProperty property = mainEntityType.getProperty(calItem.getPropertyField());
        if (property instanceof ComboProp) {
            ComboProp prop = (ComboProp)property;
            List comboItems = prop.getComboItems();
            if (comboItems == null) {
                throw new KDBizException(MessageFormat.format("{} is empty enum select in metadata {}", calItem.getPropertyField(), calItem.getEntityNumber()));
            }
            ValueMapItem item = null;
            for (ValueMapItem valueMapItem : comboItems) {
                String name = valueMapItem.getName().getLocaleValue();
                String value = valueMapItem.getValue();
                if (!node.getNodeText().equals(SelectItem.getShowKey(name)) && !node.getNodeText().equals(SelectItem.getShowKey(value))) continue;
                item = valueMapItem;
                break;
            }
            if (item == null) {
                throw new KDBizException(ResManager.loadKDString((String)MessageFormat.format("\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u5728\u8ba1\u7b97\u9879\u76ee\u201c{3}\u201d\u7684\u679a\u4e3e\u9009\u9879\u4e2d\u4e0d\u5b58\u5728\u3002", node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText(), calItem.getName()), (String)"FormulaParseService_57", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            return new SelectItemExpression(node, SelectItem.getSelectItemByValueMapItem(calItem, item));
        }
        throw new KDBizException(MessageFormat.format("{} is not a enum field in metadata {}", calItem.getPropertyField(), calItem.getEntityNumber()));
    }

    private List<Expression> addCalExpressionAndReturnCommonList(List<List<Expression>> expressionLists) {
        ArrayList<Expression> expresses = new ArrayList<Expression>(expressionLists.size());
        for (List<Expression> expList : expressionLists) {
            Expression expression;
            if (expList.size() == 1) {
                expression = expList.get(0);
            } else {
                CalExpression calExp = new CalExpression();
                calExp.setParameter(expList);
                expression = calExp;
            }
            expresses.add(expression);
        }
        return expresses;
    }

    private void addArrayExpression(LoopIndex loopIndex, OriginalNode node) {
        if (loopIndex.getCurrIndex() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u4e0d\u80fd\u4ee5\u6570\u7ec4\u7d22\u5f15\u201c{2}\u201d\u4f5c\u4e3a\u4e00\u884c\u516c\u5f0f\u5b9a\u4e49\u7684\u5f00\u5934\u3002", (String)"FormulaParseService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
        this.checkArrayIndexPreviousExpression(loopIndex.getSubExpList().get(loopIndex.getSubExpList().size() - 1), node);
        loopIndex.addExpressionInSubList(new ArrayIndexExpression(node));
        loopIndex.addCurrentIndex();
    }

    private void addDataTypeExpression(List<OriginalNode> nodes, FormulaInfo formula, LoopIndex loopIndex, OriginalNode node) {
        loopIndex.setPreviousType(this.checkIsSameExpressType(loopIndex.getPreviousType(), "assType", node));
        loopIndex.addCurrentIndex();
        loopIndex.setTempNode(node);
    }

    private void addChildConditionExpression(ConditionExpression conditionExpression, List<List<Expression>> expressionLists, LoopIndex loopIndex, OriginalNode node) {
        List<ConditionExpression> childConditionExpressions = conditionExpression.getChildConditionExpressions();
        int index = Integer.parseInt(node.getNodeText().replace(CONDITION_EXP_PLACEHOLDER, ""));
        if (childConditionExpressions.size() <= index) {
            String errorMsg = ResManager.loadKDString((String)"\u590d\u6742\u6761\u4ef6\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25\u3002", (String)"FormulaParseService_4", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ArrayList<ConditionExpression> childConditionKey = new ArrayList<ConditionExpression>(1);
        childConditionKey.add(childConditionExpressions.get(index));
        expressionLists.add(childConditionKey);
        loopIndex.addCurrentIndex();
    }

    private void addExportExpression(List<OriginalNode> nodes, FormulaInfo formula, LoopIndex loopIndex) {
        int nextIndex;
        OriginalNode exportNode = loopIndex.getOriginalNode();
        loopIndex.setPreviousType(this.checkIsSameExpressType(loopIndex.getPreviousType(), "otherType", exportNode));
        int currIndex = loopIndex.getCurrIndex();
        if (nextIndex >= nodes.size()) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8f93\u51fa\u8bed\u53e5\u5fc5\u987b\u6ee1\u8db3\u683c\u5f0f\uff1a\u201c{2} \u8ba1\u7b97\u9879\u76ee\u201d\uff0c\u8f93\u51fa\u591a\u4e2a\u8ba1\u7b97\u9879\u76ee\u5219\u901a\u8fc7\u9017\u53f7\u5bf9\u8ba1\u7b97\u9879\u76ee\u8fdb\u884c\u5206\u5272\u3002", (String)"FormulaParseService_64", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, exportNode.getLineIndex() + 1, exportNode.getStartColumnIndex() + 1, exportNode.getNodeText()));
        }
        exportNode.setKeyType(ExpressionNodeTypeEnum.EXPORT);
        exportNode.setUniqueKey(FormulaKeyEnum.EXPORT.getAlias());
        ExportExpression exportExpression = new ExportExpression(exportNode);
        boolean checkItem = true;
        for (nextIndex = currIndex + 1; nextIndex < nodes.size(); ++nextIndex) {
            OriginalNode nextNode = nodes.get(nextIndex);
            if (checkItem) {
                try {
                    this.checkItemAndAddItemExpression(nextNode, formula, exportExpression.getExportItems(), CalItemParamsEnum.COMMON);
                    checkItem = false;
                    continue;
                }
                catch (KDBizException exception) {
                    String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8f93\u51fa\u8bed\u53e5\u5fc5\u987b\u6ee1\u8db3\u683c\u5f0f\uff1a\u201c{2} \u8ba1\u7b97\u9879\u76ee\u201d\uff0c\u8f93\u51fa\u591a\u4e2a\u8ba1\u7b97\u9879\u76ee\u5219\u901a\u8fc7\u9017\u53f7\u5bf9\u8ba1\u7b97\u9879\u76ee\u8fdb\u884c\u5206\u5272\u3002", (String)"FormulaParseService_64", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, exportNode.getLineIndex() + 1, exportNode.getStartColumnIndex() + 1, exportNode.getNodeText()));
                }
            }
            if (!",".equals(nextNode.getNodeText())) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u540e\u9762\u591a\u4e2a\u8ba1\u7b97\u5143\u7d20\u4f7f\u7528\u82f1\u6587\u9017\u53f7\u8fdb\u884c\u5206\u5272\u3002", (String)"FormulaParseService_63", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, exportNode.getLineIndex() + 1, exportNode.getStartColumnIndex() + 1, exportNode.getNodeText()));
            }
            checkItem = true;
        }
        loopIndex.addExpressionInSubList(exportExpression);
        loopIndex.setCurrIndex(nextIndex);
    }

    private void checkAssItemAndAddAssExpression(OriginalNode node, FormulaInfo formula, List<Expression> expressionList, CalItemParamsEnum paramType) throws KDBizException {
        AssExpression assExpression;
        String nodeText = node.getNodeText();
        CalItem calItem = this.getCalItem(formula, nodeText);
        if (null == calItem) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8ba1\u7b97\u9879\u76ee\u201c{2}\u201d\u4e0d\u5b58\u5728\u3002", (String)"FormulaParseService_6", (String)"hrmp-hbp-business", (Object[])new Object[0]), node.getLineIndex() + 1, node.getStartColumnIndex() + 1, nodeText));
        }
        List<OriginalNode> originalKeys = formula.getOriginalKeys();
        if (originalKeys != null) {
            OriginalNode node2 = originalKeys.get(originalKeys.size() - 1);
            assExpression = FormulaKeyEnum.RESULT.getCode().equals(node2.getUniqueKey()) ? new AssExpression(ExpressionNodeTypeEnum.RESULT, node) : new AssExpression(node);
        } else {
            assExpression = new AssExpression(node);
        }
        assExpression.setCalItem(calItem);
        assExpression.setItemType(calItem.getItemCategory());
        expressionList.add(assExpression);
        this.addUniqueCodeByItemType(calItem, formula, paramType);
    }

    private void checkAssTempVariableDefineAndAddAssExpression(OriginalNode node, OriginalNode afterNode, FormulaInfo formula) throws KDBizException {
        Pattern pattern = Pattern.compile(JAVA_VARIABLE_REGULAR);
        String afterNodeText = afterNode.getNodeText();
        if (FormulaUtils.isCalItem(formula, afterNodeText) || FormulaUtils.isCalCustomItem(formula, afterNodeText) || FormulaUtils.isFunction(formula, afterNodeText) || FormulaUtils.isDataGrade(formula, afterNodeText)) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u201c\u53d8\u91cf\u540d\u6d89\u53ca\u8ba1\u7b97\u5143\u7d20\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FormulaParseService_62", (String)"hrmp-hbp-business", (Object[])new Object[0]), afterNode.getLineIndex() + 1, afterNode.getStartColumnIndex() + 1, afterNodeText));
        }
        if (!pattern.matcher(afterNodeText).matches()) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u53d8\u91cf\u540d\u547d\u540d\u4e0d\u89c4\u8303\uff0c\u53ea\u652f\u6301\u82f1\u6587\u3001\u4e2d\u6587\u4ee5\u53ca\u4e0b\u5212\u7ebf\u3002", (String)"FormulaParseService_7", (String)"hrmp-hbp-business", (Object[])new Object[0]), afterNode.getLineIndex() + 1, afterNode.getStartColumnIndex() + 1, afterNodeText));
        }
        if (FormulaUtils.isOperation(afterNodeText) || this.isChildConditionKey(afterNodeText) || FormulaUtils.isDataType(afterNodeText) || FormulaUtils.isFormulaKey(afterNodeText)) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u53d8\u91cf\u540d\u6d89\u53ca\u90e8\u5206\u5173\u952e\u5b57\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FormulaParseService_8", (String)"hrmp-hbp-business", (Object[])new Object[0]), afterNode.getLineIndex() + 1, afterNode.getStartColumnIndex() + 1, afterNodeText));
        }
        String nodeText = node.getNodeText();
        DataTypeEnum typeEnum = FormulaUtils.getDataTypeMap().get(nodeText);
        OriginalNode tempVariableNode = formula.getTempVariableMap().get(FormulaUtils.getTempVariableCode(afterNodeText));
        if (Objects.nonNull(tempVariableNode) && tempVariableNode.getDataType() != typeEnum) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c[{2}]\u53d8\u91cf\u91cd\u590d\u58f0\u660e\uff0c\u5e76\u4e14\u8d4b\u503c\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FormulaParseService_9", (String)"hrmp-hbp-business", (Object[])new Object[0]), afterNode.getLineIndex() + 1, afterNode.getStartColumnIndex() + 1, afterNodeText));
        }
        afterNode.setUniqueKey(FormulaUtils.getTempVariableCode(afterNodeText));
        afterNode.setDataType(typeEnum);
        formula.addTempVariable(FormulaUtils.getTempVariableCode(afterNodeText), afterNode);
    }

    private void checkAssTempVariableAndAddAssExpression(OriginalNode node, FormulaInfo formula, List<Expression> expressionList) throws KDBizException {
        AssExpression assExpression;
        String nodeText = node.getNodeText();
        OriginalNode tempVariableNode = formula.getTempVariableMap().get(FormulaUtils.getTempVariableCode(nodeText));
        node.setUniqueKey(FormulaUtils.getTempVariableCode(nodeText));
        node.setDataType(tempVariableNode.getDataType());
        List<OriginalNode> originalKeys = formula.getOriginalKeys();
        if (originalKeys != null) {
            OriginalNode node2 = originalKeys.get(originalKeys.size() - 1);
            assExpression = FormulaKeyEnum.RESULT.getCode().equals(node2.getUniqueKey()) ? new AssExpression(ExpressionNodeTypeEnum.RESULT, node, tempVariableNode.getDataType()) : new AssExpression(node, tempVariableNode.getDataType());
        } else {
            assExpression = new AssExpression(node, tempVariableNode.getDataType());
        }
        expressionList.add(assExpression);
    }

    private void checkItemAndAddItemExpression(OriginalNode node, FormulaInfo formula, List<Expression> expressionList, CalItemParamsEnum paramType) throws KDBizException {
        String nodeText = node.getNodeText();
        CalItem calItem = this.getCalItem(formula, nodeText);
        if (null == calItem) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8ba1\u7b97\u9879\u76ee\u201c{2}\u201d\u4e0d\u5b58\u5728\u3002", (String)"FormulaParseService_6", (String)"hrmp-hbp-business", (Object[])new Object[0]), node.getLineIndex() + 1, node.getStartColumnIndex() + 1, nodeText));
        }
        node.setUniqueKey(calItem.getUniqueCode());
        ItemExpression itemExpression = new ItemExpression(node);
        itemExpression.setCalItem(calItem);
        itemExpression.setItemType(calItem.getItemCategory());
        expressionList.add(itemExpression);
        this.addUniqueCodeByItemType(calItem, formula, paramType);
    }

    private void addUniqueCodeByItemType(CalItem calItem, FormulaInfo formula, CalItemParamsEnum paramType) {
        if (calItem.isCustomItem()) {
            formula.addCalCustomUniqueCode(calItem.getUniqueCode());
            formula.addCalCustomItemInfoToMap(calItem);
            return;
        }
        switch (paramType) {
            case FUNCTION: {
                formula.addCalDependForFunc(calItem);
                break;
            }
            case DATA_GRADE: {
                formula.addCalDependForDataGrade(calItem);
                break;
            }
            default: {
                formula.addDependCalItem(calItem);
            }
        }
    }

    private CalItem getCalItem(FormulaInfo formula, String nodeText) {
        return formula.getCalItemMap().get(nodeText);
    }

    private void checkIntegerValue(int index, List<OriginalNode> nodeList, OriginalNode node) throws KDBizException {
        OriginalNode tempNode;
        String value = node.getNodeText();
        if (index == 1 && "-".equals(nodeList.get(0).getNodeText())) {
            value = "-" + value;
        } else if (index > 1 && "-".equals(nodeList.get(index - 1).getNodeText()) && this.isSpecialOperator(tempNode = nodeList.get(index - 2))) {
            value = "-" + value;
        }
        if (FormulaUtils.isGtMaxInteger(value)) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6574\u6570\u201c{2}\u201d\u6570\u636e\u8fc7\u5927\uff0c\u6574\u6570\u6570\u636e\u4e0d\u80fd\u8d85\u51fa\u6574\u6570\u7684\u6700\u5927\u503c2147483647\u3002", (String)"FormulaParseService_11", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
        if (FormulaUtils.isLtMinInteger(value)) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6574\u6570\u201c-{2}\u201d\u6570\u636e\u8fc7\u5c0f\uff0c\u6574\u6570\u6570\u636e\u4e0d\u80fd\u5c0f\u4e8e\u6574\u6570\u7684\u6700\u5c0f\u503c-2147483648\u3002", (String)"FormulaParseService_12", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
    }

    private boolean isSpecialOperator(OriginalNode node) {
        return HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.EQUAL.getAlias()) || HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.UNEQUAL.getAlias()) || HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.GT.getAlias()) || HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.LT.getAlias()) || HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.GTOREQUAL.getAlias()) || HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.LTOREQUAL.getAlias()) || HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.LPARENTHESES.getAlias());
    }

    private String checkIsSameExpressType(String previousType, String currentType, OriginalNode node) throws KDBizException {
        if (previousType == null) {
            return currentType;
        }
        if (HRStringUtils.equals((String)previousType, (String)currentType) && !HRStringUtils.equals((String)"operatorType", (String)previousType)) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5173\u952e\u5b57\u201c{2}\u201d\u7ef4\u62a4\u4e0d\u6b63\u786e\uff0c\u9879\u76ee\u3001\u51fd\u6570\u3001\u5b57\u7b26\u4e32\u3001\u6570\u5b57\u7b49\u5173\u952e\u5b57\u4e0d\u80fd\u8fde\u7eed\u51fa\u73b0\uff0c\u4e2d\u95f4\u5fc5\u987b\u6709\u8fd0\u7b97\u7b26\u53f7\u3001\u6761\u4ef6\u5173\u952e\u5b57\u3002", (String)"FormulaParseService_13", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
        return currentType;
    }

    private void checkArrayIndexPreviousExpression(Expression expression, OriginalNode node) throws KDBizException {
        if (expression instanceof AssExpression) {
            DataTypeEnum typeEnum = ((AssExpression)expression).getDataType();
            if (!DataTypeEnum.isArrayType(typeEnum)) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u7ec4\u7d22\u5f15\u201c{2}\u201d\u7ef4\u62a4\u4e0d\u6b63\u786e\uff0c\u6570\u7ec4\u7d22\u5f15\u524d\u4e00\u4e2a\u8282\u70b9\u5fc5\u987b\u662f\u6570\u7ec4\u7c7b\u578b\u7684\u8282\u70b9\u3002", (String)"FormulaParseService_14", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
            }
        } else {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u7ec4\u7d22\u5f15\u201c{2}\u201d\u7ef4\u62a4\u4e0d\u6b63\u786e\uff0c\u6570\u7ec4\u7d22\u5f15\u524d\u4e00\u4e2a\u8282\u70b9\u5fc5\u987b\u662f\u6570\u7ec4\u7c7b\u578b\u7684\u8282\u70b9\u3002", (String)"FormulaParseService_14", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
    }

    private void checkInvokeMethodPreviousExpression(Expression expression, OriginalNode node, InvokeMethodEnum invokeMethodEnum) throws KDBizException {
        if (expression instanceof AssExpression) {
            DataTypeEnum typeEnum = ((AssExpression)expression).getDataType();
            if (!invokeMethodEnum.getInvokeDataType().contains((Object)typeEnum)) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8c03\u7528\u65b9\u6cd5\u201c{2}\u201d\u7ef4\u62a4\u4e0d\u6b63\u786e\uff0c\u8be5\u65b9\u6cd5\u524d\u4e00\u4e2a\u8282\u70b9\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u7684\u53d8\u91cf\u6216\u8282\u70b9\u3002", (String)"FormulaParseService_15", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
            }
        } else {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8c03\u7528\u65b9\u6cd5\u201c{2}\u201d\u7ef4\u62a4\u4e0d\u6b63\u786e\uff0c\u8be5\u65b9\u6cd5\u524d\u4e00\u4e2a\u8282\u70b9\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u7684\u53d8\u91cf\u6216\u8282\u70b9\u3002", (String)"FormulaParseService_15", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getFunctionExpression(FunExpression expression, List<OriginalNode> nodes, int index, FormulaInfo formula) throws KDBizException {
        int endIndex;
        OriginalNode node;
        OriginalNode function = nodes.get(index);
        if (++index >= nodes.size()) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570\u201c{2}\u201d\u7f3a\u5c11\u62ec\u53f7\u3002", (String)"FormulaParseService_18", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, function.getLineIndex() + 1, function.getStartColumnIndex() + 1, function.getNodeText()));
        }
        OriginalNode firstNode = nodes.get(index);
        if (!firstNode.getNodeText().equals(OperatorEnum.LPARENTHESES.getAlias())) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570\u201c{2}\u201d\u7f3a\u5c11\u62ec\u53f7\u3002", (String)"FormulaParseService_18", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, firstNode.getLineIndex() + 1, firstNode.getStartColumnIndex() + 1, function.getNodeText()));
        }
        int loopIndex = index + 1;
        int len = nodes.size();
        while (loopIndex < len && !(node = nodes.get(loopIndex)).getNodeText().equals(OperatorEnum.RPARENTHESES.getAlias())) {
            Map<String, Object> temResultMap;
            if (node.getNodeText().equals(OperatorEnum.COMMA.getAlias())) {
                temResultMap = this.getParamExp(nodes, loopIndex + 1, formula, function, CalItemParamsEnum.FUNCTION);
                expression.addParameter((Expression)temResultMap.get(EXPRESSIONFLAG));
                endIndex = (Integer)temResultMap.get(ENDINDEX);
                loopIndex = endIndex + 1;
                continue;
            }
            if (loopIndex != index + 1) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570\u201c{2}\u201d\u5b58\u5728\u9519\u8bef\u7684\u53c2\u6570\u201c{3}\u201d\u3002", (String)"FormulaParseService_16", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, function.getLineIndex() + 1, function.getStartColumnIndex() + 1, function.getNodeText(), node.getNodeText()));
            }
            temResultMap = this.getParamExp(nodes, loopIndex, formula, function, CalItemParamsEnum.FUNCTION);
            expression.addParameter((Expression)temResultMap.get(EXPRESSIONFLAG));
            endIndex = (Integer)temResultMap.get(ENDINDEX);
            loopIndex = endIndex + 1;
        }
        if (loopIndex >= len) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570\u201c{2}\u201d\u7f3a\u5931\u53f3\u62ec\u53f7\u3002", (String)"FormulaParseService_17", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, function.getLineIndex() + 1, function.getStartColumnIndex() + 1, function.getNodeText()));
        }
        OriginalNode lastNode = nodes.get(loopIndex);
        if (!lastNode.getNodeText().equals(OperatorEnum.RPARENTHESES.getAlias())) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570\u201c{2}\u201d\u7f3a\u5931\u53f3\u62ec\u53f7\u3002", (String)"FormulaParseService_17", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, function.getLineIndex() + 1, function.getStartColumnIndex() + 1, function.getNodeText()));
        }
        endIndex = loopIndex;
        this.checkFuncParams(expression, formula);
        return endIndex;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getDataGradeExpression(DataGradeExpression expression, List<OriginalNode> nodes, int index, FormulaInfo formula) throws KDBizException {
        int endIndex;
        OriginalNode node;
        OriginalNode function = nodes.get(index);
        if (++index >= nodes.size()) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u636e\u5206\u7ea7\u201c{2}\u201d\u7f3a\u5c11\u62ec\u53f7\u3002", (String)"FormulaParseService_21", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, function.getLineIndex() + 1, function.getStartColumnIndex() + 1, function.getNodeText()));
        }
        OriginalNode firstNode = nodes.get(index);
        if (!firstNode.getNodeText().equals(OperatorEnum.LPARENTHESES.getAlias())) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u636e\u5206\u7ea7\u201c{2}\u201d\u7f3a\u5c11\u62ec\u53f7\u3002", (String)"FormulaParseService_21", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, firstNode.getLineIndex() + 1, firstNode.getStartColumnIndex() + 1, function.getNodeText()));
        }
        int nowIndex = index + 1;
        int len = nodes.size();
        while (nowIndex < len && !(node = nodes.get(nowIndex)).getNodeText().equals(OperatorEnum.RPARENTHESES.getAlias())) {
            if (node.getNodeText().equals(OperatorEnum.COMMA.getAlias())) {
                endIndex = this.addParamsExpAndGetEndIndex(expression, nodes, formula, function, nowIndex + 1);
                nowIndex = endIndex + 1;
                continue;
            }
            if (nowIndex != index + 1) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u636e\u5206\u7ea7\u201c{2}\u201d\u5b58\u5728\u9519\u8bef\u7684\u53c2\u6570\u201c{3}\u201d\u3002", (String)"FormulaParseService_19", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, function.getLineIndex() + 1, function.getStartColumnIndex() + 1, function.getNodeText(), node.getNodeText()));
            }
            endIndex = this.addParamsExpAndGetEndIndex(expression, nodes, formula, function, nowIndex);
            nowIndex = endIndex + 1;
        }
        if (nowIndex >= len) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u636e\u5206\u7ea7\u201c{2}\u201d\u7f3a\u5931\u53f3\u62ec\u53f7\u3002", (String)"FormulaParseService_20", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, function.getLineIndex() + 1, function.getStartColumnIndex() + 1, function.getNodeText()));
        }
        OriginalNode lastNode = nodes.get(nowIndex);
        if (!lastNode.getNodeText().equals(OperatorEnum.RPARENTHESES.getAlias())) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u636e\u5206\u7ea7\u201c{2}\u201d\u7f3a\u5931\u53f3\u62ec\u53f7\u3002", (String)"FormulaParseService_20", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, function.getLineIndex() + 1, function.getStartColumnIndex() + 1, function.getNodeText()));
        }
        endIndex = nowIndex;
        this.checkDataGradeParams(expression, formula);
        return endIndex;
    }

    private int addParamsExpAndGetEndIndex(DataGradeExpression expression, List<OriginalNode> nodes, FormulaInfo formula, OriginalNode node, int index) {
        Map<String, Object> temResultMap = this.getParamExp(nodes, index, formula, node, CalItemParamsEnum.DATA_GRADE);
        if (Boolean.TRUE.equals(temResultMap.get(DATA_GRADE_RESULT_FLAG))) {
            expression.setResultExpression((DataGradeResultExpression)temResultMap.get(EXPRESSIONFLAG));
        } else {
            expression.addParameter((Expression)temResultMap.get(EXPRESSIONFLAG));
        }
        return (Integer)temResultMap.get(ENDINDEX);
    }

    private void checkFuncParams(FunExpression expression, FormulaInfo formula) throws KDBizException {
        OriginalNode funcNode = expression.getNode();
        List<Expression> parameters = expression.getParameter();
        Map<String, FunctionItem> fcMap = formula.getFcMap();
        FunctionItem functionItem = fcMap.get(funcNode.getNodeText());
        List<ParamItem> paramItems = functionItem.getParams();
        if (parameters.size() != paramItems.size()) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570\u201c{2}\u201d\u7684\u53c2\u6570\u6709{3}\u4e2a\uff0c\u7ef4\u62a4\u4e86{4}\u4e2a\uff0c\u4e0d\u6b63\u786e\u3002", (String)"FormulaParseService_22", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, funcNode.getLineIndex() + 1, funcNode.getStartColumnIndex() + 1, funcNode.getNodeText(), paramItems.size(), parameters.size()));
        }
    }

    private void checkDataGradeParams(DataGradeExpression expression, FormulaInfo formula) throws KDBizException {
        OriginalNode dataGradeNode = expression.getNode();
        List<Expression> parameters = expression.getParameter();
        DataGradeItem dataGradeItem = formula.getDataGradeMap().get(dataGradeNode.getNodeText());
        List<ParamItem> paramItems = dataGradeItem.getDataGradeParams();
        if (parameters.size() != paramItems.size()) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u636e\u5206\u7ea7\u201c{2}\u201d\u7684\u53c2\u6570\u6709{3}\u4e2a\uff0c\u7ef4\u62a4\u4e86{4}\u4e2a\uff0c\u4e0d\u6b63\u786e\u3002", (String)"FormulaParseService_23", (String)"hrmp-hbp-business", (Object[])new Object[0]), dataGradeNode.getLineIndex() + 1, dataGradeNode.getStartColumnIndex() + 1, dataGradeNode.getNodeText(), paramItems.size(), parameters.size()));
        }
    }

    private Map<String, Object> getParamExp(List<OriginalNode> nodes, int index, FormulaInfo formula, OriginalNode complexNode, CalItemParamsEnum paramType) throws KDBizException {
        LoopIndex loopIndex = new LoopIndex(nodes, index);
        while (loopIndex.getCurrIndex() < loopIndex.getLen()) {
            boolean nodeTextEquals;
            OriginalNode node = loopIndex.getOriginalNode();
            boolean bl = nodeTextEquals = node.getNodeText().equals(OperatorEnum.RPARENTHESES.getAlias()) || node.getNodeText().equals(OperatorEnum.COMMA.getAlias());
            if (loopIndex.getlPress() == loopIndex.getrPress() && nodeTextEquals) break;
            if (this.checkIsParentheses(loopIndex, node)) continue;
            if (FormulaUtils.isFunction(formula, node.getNodeText())) {
                this.addFunctionExpression(nodes, formula, complexNode, loopIndex);
                continue;
            }
            if (FormulaUtils.isDataGrade(formula, node.getNodeText())) {
                this.addDataGradeExpression(nodes, formula, complexNode, loopIndex);
                continue;
            }
            if (FormulaUtils.isDataGradeResult(formula, complexNode.getNodeText(), node.getNodeText(), loopIndex.getCurrIndex(), nodes)) {
                DataGradeResultExpression dataGradeResultExpression = new DataGradeResultExpression(node, formula.getDataGradeMap().get(complexNode.getNodeText()).getReturnDataMap().get(node.getNodeText()));
                this.addSimpleNotOperatorExpression(complexNode, loopIndex, node, dataGradeResultExpression);
                loopIndex.setDataGradeResult(true);
                continue;
            }
            if (FormulaUtils.isCalCustomItem(formula, node.getNodeText())) {
                this.addCalCustomExpression(formula, complexNode, paramType, loopIndex);
                continue;
            }
            if (FormulaUtils.isCalItem(formula, node.getNodeText())) {
                this.addCalExpression(formula, complexNode, paramType, loopIndex);
                continue;
            }
            if (FormulaUtils.isTempVariable(formula, node.getNodeText())) {
                this.addTempVariableExpression(formula, complexNode, loopIndex, node);
                continue;
            }
            if (FormulaUtils.isInvokeMethod(node.getNodeText())) {
                this.addInvokeMethodExpression(complexNode, loopIndex, node);
                continue;
            }
            if (FormulaUtils.isString(node.getNodeText())) {
                Expression selectOrDateOrStrExpression = this.getSelectOrDateOrStrExpression(nodes, formula, loopIndex.currIndex, loopIndex.getSubExpList(), null, complexNode, false);
                this.addSimpleNotOperatorExpression(complexNode, loopIndex, node, selectOrDateOrStrExpression);
                continue;
            }
            if (FormulaUtils.isOperation(node.getNodeText())) {
                this.addSimpleOperatorExpression(formula, null, complexNode, loopIndex, node);
                continue;
            }
            if (FormulaUtils.isInteger(node.getNodeText())) {
                this.checkIntegerValue(loopIndex.getCurrIndex(), nodes, node);
                this.addSimpleNotOperatorExpression(complexNode, loopIndex, node, new IntExpression(node));
                continue;
            }
            if (FormulaUtils.isNumber(node.getNodeText())) {
                this.addSimpleNotOperatorExpression(complexNode, loopIndex, node, new NumExpression(node));
                continue;
            }
            if (FormulaUtils.isNullType(node.getNodeText())) {
                this.addSimpleNotOperatorExpression(null, loopIndex, node, new NullExpression(node));
                continue;
            }
            if (FormulaUtils.isBoolean(node.getNodeText())) {
                this.addSimpleNotOperatorExpression(complexNode, loopIndex, node, new BooleanExpression(node));
                continue;
            }
            loopIndex.setErrorMsg(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u5206\u7ea7/\u51fd\u6570\u4e2d\u672a\u5b9a\u4e49\u7684\u5173\u952e\u5b57[{2}]\u3002", (String)"FormulaParseService_55", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            throw new KDBizException(MessageFormat.format(loopIndex.getErrorMsg(), node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
        this.checkParentheses(loopIndex);
        return this.getParamExpressionResultMap(complexNode, loopIndex);
    }

    private void addInvokeMethodExpression(OriginalNode complexNode, LoopIndex loopIndex, OriginalNode node) {
        InvokeMethodEnum methodEnum = InvokeMethodEnum.getInvokeMethodEnum(node.getNodeText());
        if (Objects.isNull(complexNode)) {
            loopIndex.setPreviousType(this.checkIsSameExpressType(loopIndex.getPreviousType(), "assType", node));
        } else {
            loopIndex.setPreviousType(this.checkParamsExpressionType(loopIndex.getPreviousType(), "otherType", node, complexNode));
        }
        this.checkInvokeMethodPreviousExpression(loopIndex.getSubExpList().get(loopIndex.getSubExpList().size() - 1), node, methodEnum);
        loopIndex.addExpressionInSubList(new InvokeMethodExpression(node, methodEnum));
        loopIndex.addCurrentIndex();
    }

    private void addTempVariableExpression(FormulaInfo formula, OriginalNode complexNode, LoopIndex loopIndex, OriginalNode node) {
        this.checkAssTempVariableAndAddAssExpression(node, formula, loopIndex.getSubExpList());
        if (Objects.isNull(complexNode)) {
            loopIndex.setPreviousType(this.checkIsSameExpressType(loopIndex.getPreviousType(), "otherType", node));
        } else {
            loopIndex.setPreviousType(this.checkParamsExpressionType(loopIndex.getPreviousType(), "otherType", node, complexNode));
        }
        loopIndex.addCurrentIndex();
    }

    private void addCalExpression(FormulaInfo formula, OriginalNode complexNode, CalItemParamsEnum paramType, LoopIndex loopIndex) {
        OriginalNode node = loopIndex.getOriginalNode();
        this.checkItemAndAddItemExpression(node, formula, loopIndex.getSubExpList(), paramType);
        if (CalItemParamsEnum.COMMON == paramType || Objects.isNull(complexNode)) {
            loopIndex.setPreviousType(this.checkIsSameExpressType(loopIndex.getPreviousType(), "otherType", node));
        } else {
            loopIndex.setPreviousType(this.checkParamsExpressionType(loopIndex.getPreviousType(), "otherType", node, complexNode));
        }
        loopIndex.addCurrentIndex();
        this.replaceFrontStrExpression(formula, complexNode, loopIndex, node);
    }

    private void addCalCustomExpression(FormulaInfo formula, OriginalNode complexNode, CalItemParamsEnum paramType, LoopIndex loopIndex) {
        OriginalNode node = loopIndex.getOriginalNode();
        this.checkAssItemAndAddAssExpression(node, formula, loopIndex.getSubExpList(), paramType);
        if (CalItemParamsEnum.COMMON == paramType || Objects.isNull(complexNode)) {
            loopIndex.setPreviousType(this.checkIsSameExpressType(loopIndex.getPreviousType(), "otherType", node));
        } else {
            loopIndex.setPreviousType(this.checkParamsExpressionType(loopIndex.getPreviousType(), "otherType", node, complexNode));
        }
        loopIndex.addCurrentIndex();
        this.replaceFrontStrExpression(formula, complexNode, loopIndex, node);
    }

    private void replaceFrontStrExpression(FormulaInfo formula, OriginalNode complexNode, LoopIndex loopIndex, OriginalNode node) {
        List<OriginalNode> nodes;
        Expression selectOrDateOrStrExpression;
        Expression expression;
        CalItem calItem = this.getCalItem(formula, node.getNodeText());
        if (HRStringUtils.isNotEmpty((String)calItem.getEntityNumber()) && loopIndex.getSubExpList().size() > 2 && (expression = loopIndex.getSubExpList().get(loopIndex.getSubExpList().size() - 3)) instanceof StrExpression && ((selectOrDateOrStrExpression = this.getSelectOrDateOrStrExpression(nodes = loopIndex.getNodes(), formula, loopIndex.getCurrIndex() - 3, loopIndex.getSubExpList(), node, complexNode, false)) instanceof SelectItemExpression || selectOrDateOrStrExpression instanceof DateTimeExpression)) {
            loopIndex.getSubExpList().set(loopIndex.getSubExpList().size() - 3, selectOrDateOrStrExpression);
        }
    }

    private void addDataGradeExpression(List<OriginalNode> nodes, FormulaInfo formula, OriginalNode complexNode, LoopIndex loopIndex) {
        OriginalNode node = loopIndex.getOriginalNode();
        DataGradeItem dataGradeItem = formula.getDataGradeMap().get(node.getNodeText());
        if (Objects.isNull(dataGradeItem)) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u636e\u5206\u7ea7\u201c{2}\u201d\u4e0d\u5b58\u5728\u3002", (String)"FormulaParseService_24", (String)"hrmp-hbp-business", (Object[])new Object[0]), node.getLineIndex() + 1, node.getStartColumnIndex() + 1, FormulaUtils.subStringNodeText(node.getNodeText())));
        }
        if (Objects.isNull(complexNode)) {
            loopIndex.setPreviousType(this.checkIsSameExpressType(loopIndex.getPreviousType(), "otherType", node));
        } else {
            loopIndex.setPreviousType(this.checkParamsExpressionType(loopIndex.getPreviousType(), "otherType", node, complexNode));
        }
        DataGradeExpression expression = new DataGradeExpression(node);
        expression.setDataGradeItem(dataGradeItem);
        int tmpEndIndex = this.getDataGradeExpression(expression, nodes, loopIndex.getCurrIndex(), formula);
        loopIndex.addExpressionInSubList(expression);
        formula.addDataGradeUniqueCode(dataGradeItem.getUniqueCode());
        loopIndex.setCurrIndex(tmpEndIndex + 1);
    }

    private void addFunctionExpression(List<OriginalNode> nodes, FormulaInfo formula, OriginalNode complexNode, LoopIndex loopIndex) {
        OriginalNode node = loopIndex.getOriginalNode();
        FunctionItem functionItem = formula.getFcMap().get(node.getNodeText());
        if (Objects.isNull(functionItem)) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570\u201c{2}\u201d\u4e0d\u5b58\u5728\u3002", (String)"FormulaParseService_25", (String)"hrmp-hbp-business", (Object[])new Object[0]), node.getLineIndex() + 1, node.getStartColumnIndex() + 1, FormulaUtils.subStringNodeText(node.getNodeText())));
        }
        if (Objects.isNull(complexNode)) {
            loopIndex.setPreviousType(this.checkIsSameExpressType(loopIndex.getPreviousType(), "otherType", node));
        } else {
            loopIndex.setPreviousType(this.checkParamsExpressionType(loopIndex.getPreviousType(), "otherType", node, complexNode));
        }
        FunExpression expression = new FunExpression(node);
        expression.setFunctionItem(functionItem);
        int tmpEndIndex = this.getFunctionExpression(expression, nodes, loopIndex.getCurrIndex(), formula);
        loopIndex.addExpressionInSubList(expression);
        formula.addFcUniqueCode(functionItem.getUniqueCode());
        loopIndex.setCurrIndex(tmpEndIndex + 1);
    }

    private boolean checkIsParentheses(LoopIndex loopIndex, OriginalNode node) {
        if (node.getNodeText().equals(OperatorEnum.LPARENTHESES.getAlias())) {
            loopIndex.addIntoLeftParenthesesList(node);
            loopIndex.addExpressionInSubList(new OperatorExpression(node));
            loopIndex.addLeftParenthesesIndex();
            loopIndex.addCurrentIndex();
            return true;
        }
        if (node.getNodeText().equals(OperatorEnum.RPARENTHESES.getAlias())) {
            loopIndex.addExpressionInSubList(new OperatorExpression(node));
            loopIndex.addRightParenthesesIndex();
            loopIndex.addCurrentIndex();
            return true;
        }
        return false;
    }

    @NotNull
    private Map<String, Object> getParamExpressionResultMap(OriginalNode complexNode, LoopIndex loopIndex) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        loopIndex.setEndIndex(loopIndex.getCurrIndex() - 1);
        if (loopIndex.getSubExpList().size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u7684\u53c2\u6570\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"FormulaParseService_26", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, complexNode.getLineIndex() + 1, complexNode.getStartColumnIndex() + 1, complexNode.getNodeText()));
        }
        if (loopIndex.getSubExpList().size() == 1) {
            resultMap.put(EXPRESSIONFLAG, loopIndex.getSubExpList().get(0));
            if (loopIndex.isDataGradeResult()) {
                resultMap.put(DATA_GRADE_RESULT_FLAG, Boolean.TRUE);
            }
        } else {
            CalExpression calExp = new CalExpression();
            calExp.setParameter(loopIndex.getSubExpList());
            resultMap.put(EXPRESSIONFLAG, calExp);
        }
        resultMap.put(ENDINDEX, loopIndex.getEndIndex());
        return resultMap;
    }

    private void checkParentheses(LoopIndex loopIndex) {
        if (loopIndex.getlPress() > loopIndex.getrPress()) {
            OriginalNode node = loopIndex.getlParenthesesList().get(0);
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\u5b58\u5728\u4e0d\u5339\u914d\u7684\u7b26\u53f7\u201c{2}\u201d\u3002", (String)"FormulaParseService_27", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
        if (loopIndex.getlPress() < loopIndex.getrPress()) {
            OriginalNode node = loopIndex.getlParenthesesList().get(loopIndex.getlParenthesesList().size() - 1);
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\u5b58\u5728\u4e0d\u5339\u914d\u7684\u7b26\u53f7\u201c{2}\u201d\u3002", (String)"FormulaParseService_27", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addSimpleOperatorExpression(FormulaInfo formula, ConditionExpression conditionExpression, OriginalNode complexNode, LoopIndex loopIndex, OriginalNode node) {
        boolean conditionEnumNotEqualsIfOrWhileOrElseIf;
        if (Objects.isNull(complexNode)) {
            loopIndex.setPreviousType(this.checkIsSameExpressType(loopIndex.getPreviousType(), "operatorType", node));
        } else {
            loopIndex.setPreviousType(this.checkParamsExpressionType(loopIndex.getPreviousType(), "operatorType", node, complexNode));
        }
        OriginalNode tempNode = loopIndex.getTempNode();
        boolean bl = conditionEnumNotEqualsIfOrWhileOrElseIf = Objects.isNull(conditionExpression) || conditionExpression.getConditionEnum() != ConditionEnum.IF && conditionExpression.getConditionEnum() != ConditionEnum.ELSEIF && conditionExpression.getConditionEnum() != ConditionEnum.WHILE;
        if (HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.EQUAL.getAlias()) && Objects.isNull(complexNode) && conditionEnumNotEqualsIfOrWhileOrElseIf) {
            List<OriginalNode> nodes = loopIndex.getNodes();
            if (Objects.nonNull(tempNode) && this.isDataTypeKey(tempNode.getNodeText())) {
                int startColumnIndex = node.getStartColumnIndex();
                tempNode.setStartColumnIndex(startColumnIndex);
                tempNode.setNodeText(FormulaKeyEnum.ASSIGN.getAlias());
                node = tempNode;
                loopIndex.setTempNode(null);
            } else if (FormulaUtils.isAssignmentMeaning(formula, nodes, loopIndex.getCurrIndex() - 1)) {
                if (!FormulaUtils.checkIsCanAssignment(formula, nodes, loopIndex.getCurrIndex() - 1)) {
                    String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8ba1\u7b97\u9879\u76ee\u201c{2}\u201d\u4e0d\u80fd\u8fdb\u884c\u8d4b\u503c\u3002", (String)"FormulaParseService_5", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, nodes.get(loopIndex.getCurrIndex() - 1).getNodeText()));
                }
                node.setNodeText(FormulaKeyEnum.ASSIGN.getAlias());
            } else if (!loopIndex.getSubExpList().isEmpty() && loopIndex.getSubExpList().get(loopIndex.getSubExpList().size() - 1) instanceof ArrayIndexExpression) {
                node.setNodeText(FormulaKeyEnum.ASSIGN.getAlias());
            }
        }
        loopIndex.addExpressionInSubList(new OperatorExpression(node));
        loopIndex.addCurrentIndex();
    }

    private void addSimpleNotOperatorExpression(OriginalNode complexNode, LoopIndex loopIndex, OriginalNode node, Expression expression) {
        if (Objects.isNull(complexNode)) {
            loopIndex.setPreviousType(this.checkIsSameExpressType(loopIndex.getPreviousType(), "otherType", node));
        } else {
            loopIndex.setPreviousType(this.checkParamsExpressionType(loopIndex.getPreviousType(), "otherType", node, complexNode));
        }
        loopIndex.addExpressionInSubList(expression);
        loopIndex.addCurrentIndex();
    }

    private String checkParamsExpressionType(String previousType, String currentType, OriginalNode node, OriginalNode complexNode) throws KDBizException {
        if (HRStringUtils.isEmpty((String)previousType)) {
            return currentType;
        }
        if (HRStringUtils.equals((String)previousType, (String)currentType)) {
            String errorMsg = HRStringUtils.equals((String)currentType, (String)"otherType") ? ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u7684\u53c2\u6570\u201c{3}\u201d\u7ef4\u62a4\u4e0d\u6b63\u786e\uff0c\u9879\u76ee\u3001\u51fd\u6570\u3001\u5b57\u7b26\u4e32\u3001\u6570\u5b57\u7b49\u5173\u952e\u5b57\u4e0d\u80fd\u8fde\u7eed\u51fa\u73b0\u3002", (String)"FormulaParseService_28", (String)"hrmp-hbp-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u7684\u8fd0\u7b97\u7b26\u53f7\u201c{3}\u201d\u7ef4\u62a4\u4e0d\u6b63\u786e\uff0c\u8fd0\u7b97\u7b26\u53f7\u5173\u952e\u5b57\u4e0d\u80fd\u8fde\u7eed\u51fa\u73b0\u3002", (String)"FormulaParseService_29", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, complexNode.getLineIndex() + 1, complexNode.getStartColumnIndex() + 1, complexNode.getNodeText(), node.getNodeText()));
        }
        return currentType;
    }

    private void parse(FormulaInfo formula) throws KDBizException {
        if (Objects.isNull(formula)) {
            return;
        }
        FormulaSplitHelper splitHelper = new FormulaSplitHelper();
        List<OriginalNode> nodes = splitHelper.getOriginalNodes(formula.getOriginalCode(), formula.getItemCategorySet());
        if (nodes == null || nodes.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u6709\u6548\u7684\u516c\u5f0f\u5185\u5bb9\u3002", (String)"FormulaParseService_30", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        formula.setOriginalNodes(nodes);
        List<OriginalNode> codeNodes = nodes.stream().filter(node -> !node.isAnnotation()).collect(Collectors.toList());
        List<ConditionExpression> conditionExpList = this.getConditionExpressionList(codeNodes, true);
        this.checkCondition(formula, conditionExpList);
        this.parseAndBuildExecuteExp(formula, conditionExpList);
    }

    private void parseAndBuildExecuteExp(FormulaInfo formula, List<ConditionExpression> expList) throws KDBizException {
        ResultItem item = formula.getResultItem();
        StringBuilder startCode = new StringBuilder();
        StringBuilder resultCode = new StringBuilder();
        HashMap<String, CalItem> customCalItemMap = new HashMap<String, CalItem>(16);
        DataTypeEnum type = item.getDataType();
        String typeStr = this.getDefineType(type);
        String itemUniqueCode = item.getUniqueCode();
        String resultItemName = itemUniqueCode.replace('.', '_').replace('-', '_');
        if (formula.isProrateItemFormula()) {
            itemUniqueCode = formula.getId();
        }
        startCode.append(String.format(Locale.ROOT, "String formulaName = \"%s\";", formula.getName())).append('\n');
        startCode.append("String params = null;").append('\n');
        startCode.append("if (isOpenLog()) {").append('\n');
        startCode.append("    params = SerializationUtils.toJsonString(this.params);").append('\n');
        startCode.append("}").append('\n');
        startCode.append("try {").append('\n');
        startCode.append(String.format(Locale.ROOT, typeStr, resultItemName)).append('\n');
        startCode.append("    int while_index = 0;").append('\n');
        resultCode.append(String.format(Locale.ROOT, "    List itemSectionList =  getItemSectionList(\"%s\");", itemUniqueCode)).append('\n');
        resultCode.append("    String sectionKey = null;").append('\n');
        resultCode.append("    for(int for_index = 0; for_index < itemSectionList.size(); for_index++) {").append('\n');
        resultCode.append("        sectionKey = (String)itemSectionList.get(for_index);").append('\n');
        resultCode.append("        setCurrentSectionKey(sectionKey);").append('\n');
        resultCode.append("        boolean isExit = false;").append('\n');
        StringBuilder formulaCode = new StringBuilder();
        ConditionEnum preConditionEnum = null;
        for (ConditionExpression conditionExpression : expList) {
            this.getResultExpression(formula, item, formulaCode, customCalItemMap, resultItemName, conditionExpression, false, preConditionEnum);
            preConditionEnum = conditionExpression.getConditionEnum();
        }
        this.getCalItemCodeStr(formula, startCode, resultCode);
        resultCode.append((CharSequence)formulaCode);
        this.validatorResultExp(formula.getResultCount());
        resultCode.append('\n');
        this.getCustomItemCodeStr(formula, startCode);
        this.getTempVariableCodeStr(formula, startCode);
        resultCode.append("        if(while_index > getLoopLimit()) {").append('\n');
        resultCode.append("            throwLoopException();").append('\n');
        resultCode.append("        }").append('\n');
        this.setCalCustomValueGlobalEffect(resultCode, customCalItemMap);
        this.setCalItemValueChangeEffect(formula, resultCode);
        this.setOutputAddResultCalItem(formula, resultCode);
        resultCode.append(String.format(Locale.ROOT, "        addResultValue(\"%s\",%s,sectionKey);\n", itemUniqueCode, resultItemName));
        resultCode.append("    }\n");
        this.setOutputSumResultCalItem(formula, resultCode);
        resultCode.append(String.format(Locale.ROOT, "    sumItemResultValue(\"%s\");", itemUniqueCode)).append('\n');
        this.setOutputCustomCalItem(formula, resultCode);
        resultCode.append("            if (isOpenLog()) {").append('\n');
        resultCode.append(String.format(Locale.ROOT, "             logResult(new FormulaLog(\"%s\", \"%s\", params, SerializationUtils.toJsonString(this.resultMap), null));}", formula.getId(), formula.getName())).append('\n');
        resultCode.append("} catch (Exception e) {").append('\n');
        resultCode.append("            if (isOpenLog()) {").append('\n');
        resultCode.append(String.format(Locale.ROOT, "             logResult(new FormulaLog(\"%s\", \"%s\", params,null, e.getMessage(), e));}", formula.getId(), formula.getName())).append('\n');
        resultCode.append(String.format(Locale.ROOT, "throw new KDBizException(e, new ErrorCode(\"%s\", \"%s\"), null);", formula.getId(), formula.getName())).append('\n');
        resultCode.append("}\n");
        startCode.append((CharSequence)resultCode);
        formula.setExecuteCode(startCode.toString());
    }

    private void getResultExpression(FormulaInfo formula, ResultItem item, StringBuilder resultCode, Map<String, CalItem> customCalItemMap, String resultItemName, ConditionExpression conditionExpression, boolean isRecursion, ConditionEnum preConditionEnum) {
        boolean conditionEnumEquals;
        OriginalNode conditionNode = conditionExpression.getNode();
        ConditionEnum conditionEnum = conditionExpression.getConditionEnum();
        if (conditionNode != null) {
            conditionNode.setKeyType(ExpressionNodeTypeEnum.CONDITION);
            formula.addOriginalKey(conditionNode);
            if (conditionEnum == ConditionEnum.ENDIF) {
                conditionNode.setUniqueKey(ConditionEnum.ENDIF.getName());
                return;
            }
            if (ConditionEnum.END_WHILE == conditionEnum) {
                conditionNode.setUniqueKey(ConditionEnum.END_WHILE.getName());
                return;
            }
        }
        List<Expression> expressions = this.transferExp(conditionExpression, formula);
        StringBuilder codeStr = new StringBuilder();
        boolean bl = conditionEnumEquals = ConditionEnum.ELSE == conditionEnum || ConditionEnum.THEN == conditionEnum;
        if (isRecursion && !conditionEnumEquals) {
            resultCode.append(';');
        }
        ConditionEnum preChildConditionEnum = preConditionEnum;
        for (Expression expression : expressions) {
            if (expression instanceof ConditionExpression) {
                this.getResultExpression(formula, item, codeStr, customCalItemMap, resultItemName, (ConditionExpression)expression, true, preChildConditionEnum);
                preChildConditionEnum = ((ConditionExpression)expression).getConditionEnum();
                continue;
            }
            this.getResultJavaCode(formula, item, customCalItemMap, resultItemName, conditionNode, conditionEnum, codeStr, expression);
        }
        this.replaceJAVACode(resultCode, preConditionEnum, conditionNode, conditionEnum, codeStr);
    }

    private void replaceJAVACode(StringBuilder resultCode, ConditionEnum preConditionEnum, OriginalNode conditionNode, ConditionEnum conditionEnum, StringBuilder codeStr) {
        if (null == conditionEnum && codeStr.length() > 0) {
            resultCode.append(String.format(Locale.ROOT, "\t    %s;\n", codeStr));
            return;
        }
        if (null == conditionNode) {
            return;
        }
        String semicolon = ";";
        if (codeStr.length() >= 2 && "}\n".equals(codeStr.substring(codeStr.length() - 2, codeStr.length()))) {
            semicolon = "";
        }
        if (conditionEnum == ConditionEnum.IF) {
            resultCode.append(String.format(Locale.ROOT, "\n    if(%s)", codeStr));
            conditionNode.setUniqueKey(ConditionEnum.IF.getName());
        } else if (ConditionEnum.WHILE == conditionEnum) {
            codeStr.append(" && while_index <= getLoopLimit()");
            resultCode.append(String.format(Locale.ROOT, "\n    while(%s)", codeStr));
            conditionNode.setUniqueKey(ConditionEnum.WHILE.getName());
        } else if (conditionEnum == ConditionEnum.ELSEIF) {
            this.deleteLastChar(';', resultCode);
            this.deleteLastChar('\n', resultCode);
            resultCode.append(String.format(Locale.ROOT, "    else if(%s)", codeStr));
            conditionNode.setUniqueKey(ConditionEnum.ELSEIF.getName());
        } else if (conditionEnum == ConditionEnum.ELSE) {
            this.deleteLastChar('\n', resultCode);
            resultCode.append(String.format(Locale.ROOT, "    else{\n\t    %s%s\n    }", codeStr, semicolon)).append('\n');
            conditionNode.setUniqueKey(ConditionEnum.ELSE.getName());
        } else if (conditionEnum == ConditionEnum.THEN) {
            String whileIndex = "";
            if (ConditionEnum.WHILE == preConditionEnum) {
                whileIndex = "while_index ++;\n\t";
            }
            resultCode.append(String.format(Locale.ROOT, "{\n\t    %s%s%s\n    }", whileIndex, codeStr, semicolon)).append('\n');
            if (ConditionEnum.WHILE == preConditionEnum) {
                resultCode.append("    if (isExit) {\n");
                resultCode.append("        break;\n");
                resultCode.append("    }\n");
            }
            conditionNode.setUniqueKey(ConditionEnum.THEN.getName());
        }
    }

    private void deleteLastChar(char ch, StringBuilder resultCode) {
        if (ch == resultCode.charAt(resultCode.length() - 1)) {
            resultCode.deleteCharAt(resultCode.length() - 1);
        }
    }

    private void getCustomItemCodeStr(FormulaInfo formula, StringBuilder returnCode) {
        Set<String> calCustomUniqueCodeSet = formula.getCalCustomUniqueCodeSet();
        if (calCustomUniqueCodeSet != null) {
            for (String calCustomUniqueCode : calCustomUniqueCodeSet) {
                CalItem calItem = formula.getCalCustomItemMap().get(calCustomUniqueCode);
                DataTypeEnum dataType = calItem.getDataType();
                returnCode.append(String.format(Locale.ROOT, this.getDefineType(dataType), calCustomUniqueCode)).append('\n');
                String expCode = String.format(Locale.ROOT, this.getCustomItemDefineCode(dataType), calCustomUniqueCode, calCustomUniqueCode, calCustomUniqueCode);
                returnCode.append(expCode).append('\n');
            }
        }
    }

    private void getCalItemCodeStr(FormulaInfo formula, StringBuilder defineCode, StringBuilder assCode) {
        ResultItem resultItem = formula.getResultItem();
        HashMap calItemMap = Maps.newHashMapWithExpectedSize((int)16);
        calItemMap.putAll(formula.getCalUniqueCodeKeyMap());
        calItemMap.putAll(formula.getCalForFuncUniqueCodeKeyMap());
        calItemMap.putAll(formula.getCalForDataGradeUniqueCodeKeyMap());
        if (!calItemMap.isEmpty()) {
            for (Map.Entry calItemEntry : calItemMap.entrySet()) {
                CalItem calItem = (CalItem)calItemEntry.getValue();
                String calUniqueCode = calItem.getUniqueCode();
                String itemUniqueCode = formula.isProrateItemFormula() ? formula.getId() : resultItem.getUniqueCode();
                DataTypeEnum dataType = calItem.getDataType();
                if (!calUniqueCode.equals(resultItem.getUniqueCode())) {
                    defineCode.append(String.format(Locale.ROOT, this.getDefineType(dataType), calUniqueCode)).append('\n');
                }
                String expCode = String.format(Locale.ROOT, this.getCalItemDefineCode(dataType), calUniqueCode, calUniqueCode, itemUniqueCode);
                assCode.append(expCode).append('\n');
            }
        }
    }

    private void setCalCustomValueGlobalEffect(StringBuilder resultCode, Map<String, CalItem> customCalMap) {
        for (Map.Entry<String, CalItem> itemMap : customCalMap.entrySet()) {
            CalItem customCalItem = itemMap.getValue();
            String uniqueCode = itemMap.getKey();
            if (!customCalItem.isGlobalEffect()) continue;
            resultCode.append(String.format("    addCustomCalItemValue(\"%s\",%s);\n", uniqueCode, uniqueCode));
        }
    }

    private void setCalItemValueChangeEffect(FormulaInfo formula, StringBuilder resultCode) {
        Map<String, CalItem> calItemValueChangeMap = formula.getCalItemValueChangeMap();
        String resultUniqueCode = formula.getResultItem().getUniqueCode();
        for (Map.Entry<String, CalItem> itemMap : calItemValueChangeMap.entrySet()) {
            CalItem calItem = itemMap.getValue();
            String uniqueCode = calItem.getUniqueCode();
            if (resultUniqueCode.equals(uniqueCode)) continue;
            String itemUniqueCode = formula.isProrateItemFormula() ? formula.getId() : resultUniqueCode;
            resultCode.append(String.format("    updateCalItemValue(\"%s\", %s, sectionKey, \"%s\");\n", uniqueCode, uniqueCode, itemUniqueCode));
        }
    }

    private void setOutputAddResultCalItem(FormulaInfo formula, StringBuilder resultCode) {
        Map<String, CalItem> outputCalItemMap = formula.getOutputCalItemMap();
        String resultUniqueCode = formula.getResultItem().getUniqueCode();
        for (Map.Entry<String, CalItem> itemMap : outputCalItemMap.entrySet()) {
            CalItem calItem = itemMap.getValue();
            String uniqueCode = calItem.getUniqueCode();
            if (resultUniqueCode.equals(uniqueCode)) continue;
            resultCode.append(String.format(Locale.ROOT, "        addResultValue(\"%s\",%s,sectionKey);\n", uniqueCode, uniqueCode));
        }
    }

    private void setOutputSumResultCalItem(FormulaInfo formula, StringBuilder resultCode) {
        Map<String, CalItem> outputCalItemMap = formula.getOutputCalItemMap();
        String resultUniqueCode = formula.getResultItem().getUniqueCode();
        for (Map.Entry<String, CalItem> itemMap : outputCalItemMap.entrySet()) {
            CalItem calItem = itemMap.getValue();
            String uniqueCode = calItem.getUniqueCode();
            if (resultUniqueCode.equals(uniqueCode)) continue;
            resultCode.append(String.format(Locale.ROOT, "    sumItemResultValue(\"%s\");\n", uniqueCode));
        }
    }

    private void setOutputCustomCalItem(FormulaInfo formula, StringBuilder resultCode) {
        Map<String, CalItem> outputCalItemMap = formula.getOutputCustomCalItemMap();
        for (Map.Entry<String, CalItem> itemMap : outputCalItemMap.entrySet()) {
            CalItem calItem = itemMap.getValue();
            String uniqueCode = calItem.getUniqueCode();
            resultCode.append(String.format(Locale.ROOT, "    addOutputCustomCalItemValue(\"%s\",%s);\n", uniqueCode, uniqueCode));
        }
    }

    private void getTempVariableCodeStr(FormulaInfo formula, StringBuilder returnCode) {
        Map<String, OriginalNode> tempVariableMap = formula.getTempVariableMap();
        if (tempVariableMap != null) {
            for (Map.Entry<String, OriginalNode> entry : tempVariableMap.entrySet()) {
                OriginalNode node = entry.getValue();
                DataTypeEnum dataType = node.getDataType();
                returnCode.append(String.format(Locale.ROOT, this.getDefineType(dataType), entry.getKey())).append('\n');
            }
        }
    }

    private void validatorResultExp(int resultCount) {
        if (resultCount < 1) {
            String errorMsg = ResManager.loadKDString((String)"\u516c\u5f0f\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u201c{0}\u201d\u8bed\u53e5\u3002", (String)"FormulaParseService_31", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, FormulaKeyEnum.RESULT.getAlias()));
        }
    }

    private void getResultJavaCode(FormulaInfo formula, ResultItem item, Map<String, CalItem> customCalItemMap, String resultItemName, OriginalNode conditionNode, ConditionEnum conditionEnum, StringBuilder codeStr, Expression expression) {
        boolean conditionEquals;
        ExpressionParseHelper calExpHelper = new ExpressionParseHelper(formula, expression, conditionNode);
        ResultExpression resultExp = calExpHelper.compile();
        if (conditionEnum == null || conditionEnum == ConditionEnum.ELSE || conditionEnum == ConditionEnum.THEN) {
            if (resultExp == null) {
                OperatorExpression opExp = (OperatorExpression)expression;
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7ed3\u679c\u8868\u8fbe\u8bed\u53e5\u4e2d\u201c{2} = {3}\u201d\u7ef4\u62a4\u4e0d\u6b63\u786e,\u201c{4} =\u201d\u540e\u9762\u4e0d\u80fd\u662f\u8fd0\u7b97\u7b26\u3002", (String)"FormulaParseService_32", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, opExp.getNode().getLineIndex() + 1, opExp.getNode().getStartColumnIndex() + 1, FormulaKeyEnum.RESULT.getAlias(), opExp.getNode().getNodeText(), FormulaKeyEnum.RESULT.getAlias()));
            }
            this.checkResultExpressionAndChangeType(formula, item, conditionNode, resultExp);
        } else {
            this.checkCommonExpression(item, conditionNode, resultExp);
        }
        if (resultExp.getType() == ExpressionNodeTypeEnum.ASS) {
            this.getCustomCalItemOrTempVariableMap(customCalItemMap, resultExp, formula);
            if (expression instanceof AssExpression) {
                return;
            }
        }
        if (resultExp.getType() == ExpressionNodeTypeEnum.EXPORT) {
            return;
        }
        if (codeStr.length() > 0 && !"}\n".equals(codeStr.substring(codeStr.length() - 2, codeStr.length()))) {
            codeStr.append(";\n    ");
        }
        boolean bl = conditionEquals = conditionEnum == ConditionEnum.IF || ConditionEnum.WHILE == conditionEnum || conditionEnum == ConditionEnum.ELSEIF;
        if (resultExp.getType() == ExpressionNodeTypeEnum.RESULT && !conditionEquals) {
            codeStr.append(String.format(Locale.ROOT, "\t    %s=", resultItemName));
            formula.addResultCount();
        }
        codeStr.append(resultExp.getCode());
    }

    private void checkCommonExpression(ResultItem item, OriginalNode conditionNode, ResultExpression resultExp) {
        if (resultExp.getDataType() != DataTypeEnum.BOOLEAN) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5173\u952e\u5b57[{2}]\u540e\u9762\u5fc5\u987b\u662f\u5224\u65ad\u8868\u8fbe\u5f0f\u3002", (String)"FormulaParseService_33", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, conditionNode.getLineIndex() + 1, conditionNode.getStartColumnIndex() + 1, conditionNode.getNodeText()));
        }
        if (resultExp.getType() == ExpressionNodeTypeEnum.ASS && item.getDataType() != resultExp.getDataType()) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u201c=\u201d\u4e24\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u4e00\u81f4\u3002", (String)"FormulaParseService_34", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, conditionNode.getLineIndex() + 1, conditionNode.getStartColumnIndex() + 1));
        }
    }

    private void checkResultExpressionAndChangeType(FormulaInfo formula, ResultItem item, OriginalNode conditionNode, ResultExpression resultExp) {
        if (resultExp.getType() != ExpressionNodeTypeEnum.ASS && resultExp.getType() != ExpressionNodeTypeEnum.EXPORT && resultExp.getType() != ExpressionNodeTypeEnum.EXIT && item.getDataType() != resultExp.getDataType()) {
            boolean itemTypeIsDateAndResultIsTimeOrObjEtc;
            OriginalNode node = resultExp.getNode();
            boolean itemTypeIsIntAndResultIsNumOrObjEtc = !(item.getDataType() != DataTypeEnum.INT && item.getDataType() != DataTypeEnum.OBJECT || resultExp.getDataType() != DataTypeEnum.NUM && resultExp.getDataType() != DataTypeEnum.MONEY && resultExp.getDataType() != DataTypeEnum.OBJECT);
            boolean itemTypeIsNumAndResultIsIntOrObjEtc = !(item.getDataType() != DataTypeEnum.NUM && item.getDataType() != DataTypeEnum.MONEY && item.getDataType() != DataTypeEnum.OBJECT || resultExp.getDataType() != DataTypeEnum.INT && resultExp.getDataType() != DataTypeEnum.MONEY && resultExp.getDataType() != DataTypeEnum.NUM && resultExp.getDataType() != DataTypeEnum.OBJECT);
            boolean bl = itemTypeIsDateAndResultIsTimeOrObjEtc = !(item.getDataType() != DataTypeEnum.DATETIME && item.getDataType() != DataTypeEnum.DATE && item.getDataType() != DataTypeEnum.OBJECT || resultExp.getDataType() != DataTypeEnum.DATE && resultExp.getDataType() != DataTypeEnum.DATETIME && resultExp.getDataType() != DataTypeEnum.OBJECT);
            if (itemTypeIsIntAndResultIsNumOrObjEtc) {
                resultExp.setCode(String.format(Locale.ROOT, "new Integer(new BigDecimal(String.valueOf(%s)).intValue())", resultExp.getCode()));
            } else if (itemTypeIsNumAndResultIsIntOrObjEtc) {
                resultExp.setCode(String.format(Locale.ROOT, "new BigDecimal(String.valueOf(%s))", resultExp.getCode()));
            } else if (itemTypeIsDateAndResultIsTimeOrObjEtc) {
                resultExp.setCode(String.format(Locale.ROOT, "new DateTime(%s).toDate()", resultExp.getCode()));
            } else if (resultExp.getDataType() == DataTypeEnum.OBJECT) {
                String tempCode;
                if (item.getDataType() == DataTypeEnum.TEXT) {
                    tempCode = String.format(Locale.ROOT, "String.valueOf(%s)", resultExp.getCode());
                } else if (item.getDataType() == DataTypeEnum.BOOLEAN) {
                    tempCode = String.format(Locale.ROOT, "Boolean.parseBoolean(String.valueOf(%s))", resultExp.getCode());
                } else if (item.getDataType() == DataTypeEnum.BASE) {
                    tempCode = String.format(Locale.ROOT, "((DynamicObject) %s)", resultExp.getCode());
                } else {
                    String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7ed3\u679c\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e0e{5}\u201c{2}\u201d\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c{5}\u7684\u6570\u636e\u7c7b\u578b\u4e3a{3}\uff0c\u800c\u7ed3\u679c\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{4}\u3002", (String)"FormulaParseService_58", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, item.getName(), item.getDataType().getAlias(), resultExp.getDataType().getAlias(), formula.getResultItemPropertyName()));
                }
                resultExp.setCode(tempCode);
            } else if (DataTypeEnum.NULL != resultExp.getDataType()) {
                if (node != null) {
                    String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7ed3\u679c\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e0e{5}\u201c{2}\u201d\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c{5}\u7684\u6570\u636e\u7c7b\u578b\u4e3a{3}\uff0c\u800c\u7ed3\u679c\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{4}\u3002", (String)"FormulaParseService_58", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, item.getName(), item.getDataType().getAlias(), resultExp.getDataType().getAlias(), formula.getResultItemPropertyName()));
                }
                String errorMsg = ResManager.loadKDString((String)"\u7ed3\u679c\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e0e{3}\u201c{0}\u201d\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c{3}\u7684\u6570\u636e\u7c7b\u578b\u4e3a{1}\uff0c\u800c\u7ed3\u679c\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{2}\u3002", (String)"FormulaParseService_36", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, item.getName(), item.getDataType().getAlias(), resultExp.getDataType().getAlias(), formula.getResultItemPropertyName()));
            }
        }
    }

    private void getCustomCalItemOrTempVariableMap(Map<String, CalItem> customCalMap, ResultExpression resultExp, FormulaInfo formula) {
        AssExpression exp = (AssExpression)resultExp.getOriginalExp();
        CalItem calItem = exp.getCalItem();
        if (Objects.nonNull(calItem)) {
            String uniqueCode = calItem.getUniqueCode();
            customCalMap.put(uniqueCode, calItem);
        } else {
            OriginalNode item = exp.getNode();
            formula.addTempVariable(item.getUniqueKey(), item);
        }
    }

    private String getCustomItemDefineCode(DataTypeEnum type) {
        String typeStr = type == DataTypeEnum.NUM || type == DataTypeEnum.MONEY ? "    %s=getCustomCalItemValue(\"%s\") == \"\"? BigDecimal.ZERO:new BigDecimal(getCustomCalItemValue(\"%s\"));" : (type == DataTypeEnum.INT ? "    %s=getCustomCalItemValue(\"%s\") == \"\"? Integer.valueOf(0) : Integer.valueOf(getCustomCalItemValue(\"%s\"));" : (type == DataTypeEnum.DATE ? "    %s=getCustomCalItemValue(\"%s\") == \"\"? null: parseDate(getCustomCalItemValue(\"%s\"));" : (type == DataTypeEnum.BOOLEAN ? "    %s=getCustomCalItemValue(\"%s\") == \"\"? Boolean.FALSE : Boolean.valueOf(getCustomCalItemValue(\"%s\"));" : (type == DataTypeEnum.BASE ? "    %s=getCustomCalItemValueAsDynamicObj(\"%s\") == null ? null : getCustomCalItemValueAsDynamicObj(\"%s\");" : "    %s=getCustomCalItemValue(\"%s\")==\"\"?\"\":getCustomCalItemValue(\"%s\");"))));
        return typeStr;
    }

    private String getCalItemDefineCode(DataTypeEnum type) {
        String itemCode = type == DataTypeEnum.NUM ? "    %s=getFieldValueAsBigDecimal(\"%s\",sectionKey,\"%s\");" : (type == DataTypeEnum.INT ? "    %s=getFieldValueAsInteger(\"%s\",sectionKey,\"%s\");" : (type == DataTypeEnum.BOOLEAN ? "    %s=getFieldValueAsBoolean(\"%s\",sectionKey,\"%s\");" : (type == DataTypeEnum.DATE || type == DataTypeEnum.DATETIME ? "    %s=getFieldValueAsDate(\"%s\",sectionKey,\"%s\");" : (type == DataTypeEnum.ARRAY_OBJECT ? "    %s=getFieldValueAsObjectArray(\"%s\",sectionKey,\"%s\");" : (type == DataTypeEnum.ARRAY_STRING ? "    %s=getFieldValueAsStringArray(\"%s\",sectionKey,\"%s\");" : (type == DataTypeEnum.ARRAY_NUM ? "    %s=getFieldValueAsBigDecimalArray(\"%s\",sectionKey,\"%s\");" : (type == DataTypeEnum.ARRAY_BOOLEAN ? "    %s=getFieldValueAsBooleanArray(\"%s\",sectionKey,\"%s\");" : (type == DataTypeEnum.ARRAY_INT ? "    %s=getFieldValueAsIntegerArray(\"%s\",sectionKey,\"%s\");" : (type == DataTypeEnum.ARRAY_DATE ? "    %s=getFieldValueAsDateArray(\"%s\",sectionKey,\"%s\");" : (DataTypeEnum.MONEY == type ? "    %s=getFieldValueAsBigDecimal(\"%s\",sectionKey,\"%s\");" : (DataTypeEnum.BASE == type ? "    %s=getFieldValueAsDynamicObject(\"%s\",sectionKey,\"%s\");" : (DataTypeEnum.OBJECT == type ? "    %s=getFieldValueAsObject(\"%s\",sectionKey,\"%s\");" : "    %s=getFieldValueAsString(\"%s\",sectionKey,\"%s\");"))))))))))));
        return itemCode;
    }

    private String getDefineType(DataTypeEnum type) {
        String typeStr = type == DataTypeEnum.NUM || type == DataTypeEnum.MONEY ? "    BigDecimal %s=null;" : (type == DataTypeEnum.INT ? "    Integer %s=null;" : (type == DataTypeEnum.BOOLEAN ? "    Boolean %s=null;" : (type == DataTypeEnum.DATE || type == DataTypeEnum.DATETIME ? "    Date %s=null;" : (DataTypeEnum.ARRAY_NUM == type ? "    BigDecimal[] %s=null;" : (DataTypeEnum.ARRAY_STRING == type ? "    String[] %s=null;" : (DataTypeEnum.ARRAY_BOOLEAN == type ? "    Boolean[] %s=null;" : (DataTypeEnum.ARRAY_INT == type ? "    Integer[] %s=null;" : (DataTypeEnum.ARRAY_DATE == type ? "    Date[] %s=null;" : (DataTypeEnum.ARRAY_OBJECT == type ? "    Object[] %s=null;" : (DataTypeEnum.BASE == type ? "    DynamicObject %s=null;" : (DataTypeEnum.OBJECT == type ? "    Object %s=null;" : "    String %s=null;")))))))))));
        return typeStr;
    }

    private void checkCondition(FormulaInfo formula, List<ConditionExpression> conditionExpList) throws KDBizException {
        int complex = 0;
        OriginalNode previousNode = null;
        OriginalNode firstConditionNode = null;
        for (int index = 0; index < conditionExpList.size(); ++index) {
            ConditionExpression conditionExp = conditionExpList.get(index);
            OriginalNode condition = conditionExp.getNode();
            List<OriginalNode> expressions = conditionExp.getExpressions();
            if (condition == null) {
                if (!this.checkFirstLine(formula, conditionExpList, index, expressions)) continue;
                return;
            }
            if (firstConditionNode == null) {
                firstConditionNode = condition;
                this.checkFirstConditionNode(firstConditionNode);
            }
            if (!CollectionUtils.isEmpty(conditionExp.getChildConditionExpressions())) {
                this.checkCondition(formula, conditionExp.getChildConditionExpressions());
            }
            previousNode = this.checkConditionIsMatch(previousNode, condition);
            this.checkLastComplexConditionNode(conditionExpList, index, condition);
            complex = this.handleComplex(complex, condition);
        }
        this.checkComplex(complex);
    }

    private void checkLastComplexConditionNode(List<ConditionExpression> conditionExpList, int index, OriginalNode condition) {
        boolean textEqualsEnd;
        boolean bl = textEqualsEnd = HRStringUtils.equals((String)condition.getNodeText(), (String)FormulaKeyEnum.ENDIF.getAlias()) || HRStringUtils.equals((String)condition.getNodeText(), (String)FormulaKeyEnum.ENDWHILE.getAlias());
        if (index == conditionExpList.size() - 1 || textEqualsEnd) {
            if (textEqualsEnd) {
                ConditionExpression beforeTwoCondition = null;
                int loopCount = 2;
                if (index >= loopCount) {
                    int reIndex = 1;
                    while (reIndex <= loopCount && index - reIndex >= 0) {
                        ConditionExpression conditionExpression = conditionExpList.get(index - reIndex);
                        if (conditionExpression.getConditionEnum() == null) continue;
                        if (reIndex == loopCount) {
                            beforeTwoCondition = conditionExpression;
                        }
                        ++reIndex;
                        if (conditionExpression.getConditionEnum() != ConditionEnum.ELSE) continue;
                        ++loopCount;
                    }
                }
                if (beforeTwoCondition != null) {
                    this.checkEndCondition(beforeTwoCondition, condition, true);
                }
            } else {
                List conditionExpressions = conditionExpList.stream().filter(exp -> Objects.nonNull(exp.getNode())).filter(exp -> ConditionEnum.IF == exp.getConditionEnum() || ConditionEnum.WHILE == exp.getConditionEnum()).collect(Collectors.toList());
                if (!conditionExpressions.isEmpty()) {
                    ConditionExpression LastConditionExp = (ConditionExpression)conditionExpressions.get(conditionExpressions.size() - 1);
                    this.checkEndCondition(LastConditionExp, condition, false);
                } else {
                    String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u4e0d\u80fd\u4ee5\u201c{2}\u201d\u4f5c\u4e3a\u5f53\u524d\u6761\u4ef6\u5224\u65ad\u5185\u5bb9\u7684\u6700\u540e\u4e00\u4e2a\u5173\u952e\u5b57\u3002", (String)"FormulaParseService_37", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, condition.getLineIndex() + 1, condition.getStartColumnIndex() + 1, condition.getNodeText()));
                }
            }
        }
    }

    private void checkEndCondition(ConditionExpression beforeCondition, OriginalNode currentCondition, boolean currentNodeTextEqualsEnd) {
        boolean beforeTextIsIfOrElseIf;
        boolean beforeNodeTextEqualsStart;
        OriginalNode beforeExpCondition = beforeCondition.getNode();
        boolean bl = beforeNodeTextEqualsStart = HRStringUtils.equals((String)beforeExpCondition.getNodeText(), (String)FormulaKeyEnum.IF.getAlias()) || HRStringUtils.equals((String)beforeExpCondition.getNodeText(), (String)FormulaKeyEnum.WHILE.getAlias()) || HRStringUtils.equals((String)beforeExpCondition.getNodeText(), (String)FormulaKeyEnum.ELSEIF.getAlias());
        if (currentNodeTextEqualsEnd && !beforeNodeTextEqualsStart) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fa\u73b0\u591a\u4f59\u7684\u5173\u952e\u8bcd\u201c{2}\u201d\u3002", (String)"FormulaParseService_60", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, currentCondition.getLineIndex() + 1, currentCondition.getStartColumnIndex() + 1, currentCondition.getNodeText()));
        }
        String endNodeText = null;
        boolean isError = false;
        boolean bl2 = beforeTextIsIfOrElseIf = HRStringUtils.equals((String)FormulaKeyEnum.IF.getAlias(), (String)beforeExpCondition.getNodeText()) || HRStringUtils.equals((String)FormulaKeyEnum.ELSEIF.getAlias(), (String)beforeExpCondition.getNodeText());
        if (HRStringUtils.equals((String)FormulaKeyEnum.WHILE.getAlias(), (String)beforeExpCondition.getNodeText()) && !HRStringUtils.equals((String)currentCondition.getNodeText(), (String)FormulaKeyEnum.ENDWHILE.getAlias())) {
            endNodeText = FormulaKeyEnum.ENDWHILE.getAlias();
            isError = true;
        } else if (beforeTextIsIfOrElseIf && !HRStringUtils.equals((String)currentCondition.getNodeText(), (String)FormulaKeyEnum.ENDIF.getAlias())) {
            endNodeText = FormulaKeyEnum.ENDIF.getAlias();
            isError = true;
        }
        if (isError) {
            if (currentNodeTextEqualsEnd) {
                String errorMsg = ResManager.loadKDString((String)"\u5d4c\u5957\u201c{0}\u201d\u8bed\u53e5\uff0c\u7b2c{1}\u884c\uff0c\u7b2c{2}\u5217\uff0c\u4e0e\u201c{0}\u201d\u5339\u914d\u7684\u662f\u201c{3}\u201d\uff0c\u800c\u4e0d\u662f\u7b2c{4}\u884c\uff0c\u7b2c{5}\u5217\u7684\u201c{6}\u201d\u3002", (String)"FormulaParseService_61", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, beforeExpCondition.getNodeText(), beforeExpCondition.getLineIndex() + 1, beforeExpCondition.getStartColumnIndex() + 1, endNodeText, currentCondition.getLineIndex() + 1, currentCondition.getStartColumnIndex() + 1, currentCondition.getNodeText()));
            }
            String errorMsg = ResManager.loadKDString((String)"\u5d4c\u5957\u201c{0}\u201d\u8bed\u53e5\uff0c\u7f3a\u5c11\u201c{1}\u201d\u8bed\u53e5\uff0c\u7b2c{2}\u884c\uff0c\u7b2c{3}\u5217\uff0c\u201c{0}\u201d\u7f3a\u5c11\u4e0e\u4e4b\u5339\u914d\u7684\u201c{1}\u201d\u3002", (String)"FormulaParseService_59", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, beforeExpCondition.getNodeText(), endNodeText, beforeExpCondition.getLineIndex() + 1, beforeExpCondition.getStartColumnIndex() + 1));
        }
    }

    private int handleComplex(int complex, OriginalNode condition) {
        if (HRStringUtils.equals((String)condition.getNodeText(), (String)FormulaKeyEnum.IF.getAlias()) || HRStringUtils.equals((String)condition.getNodeText(), (String)FormulaKeyEnum.WHILE.getAlias())) {
            ++complex;
        }
        if (HRStringUtils.equals((String)condition.getNodeText(), (String)FormulaKeyEnum.ENDIF.getAlias()) || HRStringUtils.equals((String)condition.getNodeText(), (String)FormulaKeyEnum.ENDWHILE.getAlias())) {
            --complex;
        }
        return complex;
    }

    private void checkFirstConditionNode(OriginalNode firstConditionNode) {
        boolean nodeTextEquals;
        if (firstConditionNode == null) {
            return;
        }
        boolean bl = nodeTextEquals = HRStringUtils.equals((String)firstConditionNode.getNodeText(), (String)FormulaKeyEnum.IF.getAlias()) || HRStringUtils.equals((String)firstConditionNode.getNodeText(), (String)FormulaKeyEnum.WHILE.getAlias());
        if (!nodeTextEquals) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u516c\u5f0f\u7684\u7b2c\u4e00\u4e2a\u6761\u4ef6\u8868\u8fbe\u5f0f\u5173\u952e\u8bcd\u53ea\u80fd\u4ee5\u201c{2}\u201d\u6216\u201c{3}\u201d\u5f00\u59cb\u3002", (String)"FormulaParseService_51", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, firstConditionNode.getLineIndex() + 1, firstConditionNode.getStartColumnIndex() + 1, FormulaKeyEnum.IF.getAlias(), FormulaKeyEnum.WHILE.getAlias()));
        }
    }

    private void checkComplex(int complex) {
        if (complex != 0) {
            String errorMsg = complex > 0 ? ResManager.loadKDString((String)"\u8be5\u516c\u5f0f\u7684\u7ed3\u675f\u5173\u952e\u5b57\u7f3a\u5c11\u4e86{0}\u4e2a,\u8bf7\u68c0\u67e5\u3002", (String)"FormulaParseService_38", (String)"hrmp-hbp-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8be5\u516c\u5f0f\u7684\u7ed3\u675f\u5173\u952e\u5b57\u591a\u4f59\u4e86{0}\u4e2a,\u8bf7\u68c0\u67e5\u3002", (String)"FormulaParseService_39", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, Math.abs(complex)));
        }
    }

    private boolean checkFirstLine(FormulaInfo formula, List<ConditionExpression> conditionExpList, int index, List<OriginalNode> expressions) {
        OriginalNode firstNode = expressions.get(0);
        String nodeText = firstNode.getNodeText();
        if (conditionExpList.size() == 1 && index == 0) {
            if (FormulaUtils.isCalItem(formula, nodeText) || FormulaUtils.isCalCustomItem(formula, nodeText) || this.isResultKey(nodeText) || this.isDataTypeKey(nodeText) || this.isExportKey(nodeText)) {
                return true;
            }
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u516c\u5f0f\u53ea\u80fd\u4ee5\u201c{2}\u201d\u3001\u201c{4}\u201d\u3001\u8ba1\u7b97\u9879\u76ee\u6216\u8005\u6570\u636e\u7c7b\u578b\u5173\u952e\u5b57\u5f00\u59cb,\u5f53\u524d\u4ee5\u201c{3}\u201d\u5f00\u59cb\u3002", (String)"FormulaParseService_40", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, 1, 1, FormulaKeyEnum.RESULT.getAlias(), nodeText, FormulaKeyEnum.EXPORT.getAlias()));
        }
        if (!(FormulaUtils.isCalItem(formula, nodeText) || FormulaUtils.isCalCustomItem(formula, nodeText) || this.isResultKey(nodeText) || this.isDataTypeKey(nodeText) || this.isExportKey(nodeText))) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6761\u4ef6\u8868\u8fbe\u5f0f\u540e\u9762\u53ea\u80fd\u4ee5\u201c{2}\u201d\u3001\u201c{4}\u201d\u3001\u8ba1\u7b97\u9879\u76ee\u6216\u8005\u6570\u636e\u7c7b\u578b\u5173\u952e\u5b57\u5f00\u59cb,\u5f53\u524d\u4ee5\u201c{3}\u201d\u5f00\u59cb\u3002", (String)"FormulaParseService_41", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, firstNode.getLineIndex() + 1, firstNode.getStartColumnIndex() + 1, FormulaKeyEnum.RESULT.getAlias(), nodeText, FormulaKeyEnum.EXPORT.getAlias()));
        }
        return false;
    }

    private OriginalNode checkConditionIsMatch(OriginalNode previousNode, OriginalNode condition) throws KDBizException {
        if (Objects.isNull(previousNode) || Objects.isNull(condition)) {
            return condition;
        }
        FormulaKeyEnum previousKeyEnum = FormulaKeyEnum.getByAlias(previousNode.getNodeText());
        FormulaKeyEnum currentKeyEnum = FormulaKeyEnum.getByAlias(condition.getNodeText());
        if (Objects.isNull((Object)previousKeyEnum) || Objects.isNull((Object)currentKeyEnum)) {
            return condition;
        }
        if (this.checkAroundConditionKey(previousKeyEnum, FormulaKeyEnum.IF, currentKeyEnum, true, FormulaKeyEnum.THEN)) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6b64\u5904\u4e0d\u80fd\u662f\u201c{2}\u201d\uff1b\u7b2c{3}\u884c\uff0c\u7b2c{4}\u5217\u7684\u201c{5}\u201d\u540e\u9762\u7684\u6761\u4ef6\u5173\u952e\u5b57\u5fc5\u987b\u662f\u201c{6}\u201d\u3002", (String)"FormulaParseService_42", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, condition.getLineIndex() + 1, condition.getStartColumnIndex() + 1, condition.getNodeText(), previousNode.getLineIndex() + 1, previousNode.getStartColumnIndex() + 1, previousNode.getNodeText(), FormulaKeyEnum.THEN.getAlias()));
        }
        if (this.checkAroundConditionKey(previousKeyEnum, FormulaKeyEnum.THEN, currentKeyEnum, false, FormulaKeyEnum.THEN)) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6b64\u5904\u4e0d\u80fd\u662f\u201c{2}\u201d\uff1b\u7b2c{3}\u884c\uff0c\u7b2c{4}\u5217\u7684\u201c{5}\u201d\u540e\u9762\u7684\u6761\u4ef6\u5173\u952e\u5b57\u53ef\u4ee5\u662f\u201c{6}\u201d\u3001\u201c{7}\u201d\u3001\u201c{8}\u201d\u3001\u201c{9}\u201d\u3002", (String)"FormulaParseService_43", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, condition.getLineIndex() + 1, condition.getStartColumnIndex() + 1, condition.getNodeText(), previousNode.getLineIndex() + 1, previousNode.getStartColumnIndex() + 1, previousNode.getNodeText(), FormulaKeyEnum.ELSEIF.getAlias(), FormulaKeyEnum.ELSE.getAlias(), FormulaKeyEnum.ENDIF.getAlias(), FormulaKeyEnum.IF.getAlias()));
        }
        if (this.checkAroundConditionKey(previousKeyEnum, FormulaKeyEnum.ELSEIF, currentKeyEnum, true, FormulaKeyEnum.THEN)) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6b64\u5904\u4e0d\u80fd\u662f\u201c{2}\u201d\uff1b\u7b2c{3}\u884c\uff0c\u7b2c{4}\u5217\u7684\u201c{5}\u201d\u540e\u9762\u7684\u6761\u4ef6\u5173\u952e\u5b57\u5fc5\u987b\u662f\u201c{6}\u201d\u3002", (String)"FormulaParseService_42", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, condition.getLineIndex() + 1, condition.getStartColumnIndex() + 1, condition.getNodeText(), previousNode.getLineIndex() + 1, previousNode.getStartColumnIndex() + 1, previousNode.getNodeText(), FormulaKeyEnum.THEN.getAlias()));
        }
        if (this.checkAroundConditionKey(previousKeyEnum, FormulaKeyEnum.ENDIF, currentKeyEnum, true, FormulaKeyEnum.IF, FormulaKeyEnum.ENDIF, FormulaKeyEnum.WHILE, FormulaKeyEnum.ENDWHILE)) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6b64\u5904\u4e0d\u80fd\u662f\u201c{2}\u201d\uff1b\u7b2c{3}\u884c\uff0c\u7b2c{4}\u5217\u7684\u201c{5}\u201d\u540e\u9762\u7684\u6761\u4ef6\u5173\u952e\u5b57\u5fc5\u987b\u662f\u201c{6}\u201d\uff0c\u6216\u662f\u201c{7}\u201d\uff0c\u6216\u8005\u4e3a\u7a7a\u3002", (String)"FormulaParseService_44", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, condition.getLineIndex() + 1, condition.getStartColumnIndex() + 1, condition.getNodeText(), previousNode.getLineIndex() + 1, previousNode.getStartColumnIndex() + 1, previousNode.getNodeText(), FormulaKeyEnum.IF.getAlias(), FormulaKeyEnum.ENDIF.getAlias()));
        }
        if (this.checkAroundConditionKey(previousKeyEnum, FormulaKeyEnum.WHILE, currentKeyEnum, true, FormulaKeyEnum.THEN)) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6b64\u5904\u4e0d\u80fd\u662f\u201c{2}\u201d\uff1b\u7b2c{3}\u884c\uff0c\u7b2c{4}\u5217\u7684\u201c{5}\u201d\u540e\u9762\u7684\u6761\u4ef6\u5173\u952e\u5b57\u5fc5\u987b\u662f\u201c{6}\u201d\u3002", (String)"FormulaParseService_42", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, condition.getLineIndex() + 1, condition.getStartColumnIndex() + 1, condition.getNodeText(), previousNode.getLineIndex() + 1, previousNode.getStartColumnIndex() + 1, previousNode.getNodeText(), FormulaKeyEnum.THEN.getAlias()));
        }
        if (this.checkAroundConditionKey(previousKeyEnum, FormulaKeyEnum.ELSE, currentKeyEnum, true, FormulaKeyEnum.ENDIF, FormulaKeyEnum.IF, FormulaKeyEnum.WHILE)) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6b64\u5904\u4e0d\u80fd\u662f\u201c{2}\u201d\uff1b\u7b2c{3}\u884c\uff0c\u7b2c{4}\u5217\u7684\u201c{5}\u201d\u540e\u9762\u7684\u6761\u4ef6\u5173\u952e\u5b57\u53ef\u4ee5\u662f\u201c{6}\u201d\u3001\u201c{7}\u201d\u3002", (String)"FormulaParseService_52", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, condition.getLineIndex() + 1, condition.getStartColumnIndex() + 1, condition.getNodeText(), previousNode.getLineIndex(), previousNode.getStartColumnIndex() + 1, previousNode.getNodeText(), FormulaKeyEnum.ENDIF.getAlias(), FormulaKeyEnum.IF.getAlias()));
        }
        return condition;
    }

    private List<Expression> transferExp(ConditionExpression conditionExpression, FormulaInfo formula) throws KDBizException {
        OriginalNode conditionNode = conditionExpression.getNode();
        ConditionEnum conditionEnum = conditionExpression.getConditionEnum();
        List<OriginalNode> expressionList = conditionExpression.getExpressions();
        if (conditionEnum != null && expressionList.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6761\u4ef6\u8bed\u53e5\u201c{2}\u201d\u540e\u9762\u6ca1\u6709\u8868\u8fbe\u5f0f\u3002", (String)"FormulaParseService_45", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(msg, conditionNode.getLineIndex() + 1, conditionNode.getStartColumnIndex() + 1, conditionNode.getNodeText()));
        }
        boolean hasExit = FormulaUtils.isExit(expressionList.get(expressionList.size() - 1).getNodeText());
        if (expressionList.size() == 1 && !hasExit) {
            OriginalNode node = expressionList.get(0);
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8868\u8fbe\u5f0f\u201c{2}\u201d\u4e0d\u5b8c\u6574\u3002", (String)"FormulaParseService_47", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(msg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
        if (expressionList.size() == 2) {
            OriginalNode node1 = expressionList.get(0);
            OriginalNode node2 = expressionList.get(1);
            if (hasExit) {
                String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8868\u8fbe\u5f0f\u201c{2}\u201d\u4e0d\u5b8c\u6574\u3002", (String)"FormulaParseService_47", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(msg, node1.getLineIndex() + 1, node1.getStartColumnIndex() + 1, node1.getNodeText()));
            }
            if (FormulaUtils.isDataType(node1.getNodeText())) {
                this.isDataTypeKeyAndAddTempVariableIntoCache(expressionList, 0, node1, formula);
            } else if (!this.isExportKey(node1.getNodeText())) {
                String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8868\u8fbe\u5f0f\u201c{2} {3}\u201d\u4e0d\u5b8c\u6574\u3002", (String)"FormulaParseService_54", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(msg, node1.getLineIndex() + 1, node1.getStartColumnIndex() + 1, node1.getNodeText(), node2.getNodeText()));
            }
        } else if (conditionEnum == null || conditionEnum == ConditionEnum.ELSE || conditionEnum == ConditionEnum.THEN) {
            if (hasExit && expressionList.size() == 3) {
                OriginalNode node1 = expressionList.get(0);
                OriginalNode node2 = expressionList.get(1);
                String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8868\u8fbe\u5f0f\u201c{2} {3}\u201d\u4e0d\u5b8c\u6574\u3002", (String)"FormulaParseService_54", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(msg, node1.getLineIndex() + 1, node1.getStartColumnIndex() + 1, node1.getNodeText(), node2.getNodeText()));
            }
            ArrayList<List<OriginalNode>> originalNodeList = new ArrayList<List<OriginalNode>>(10);
            this.resealOriginalNodeList(formula, conditionNode, expressionList, originalNodeList);
            ArrayList<Expression> expList = new ArrayList<Expression>(10);
            for (List<OriginalNode> nodeList : originalNodeList) {
                OriginalNode node1 = (OriginalNode)nodeList.get(0);
                if (this.isResultKey(node1.getNodeText())) {
                    nodeList = this.getResultExpressionNodes(conditionExpression, formula, nodeList, node1);
                } else if (this.isDataTypeKey(node1.getNodeText())) {
                    this.checkAndSetTempVariableAssignmentNode(conditionExpression, nodeList, node1);
                } else if (FormulaUtils.isAssignmentMeaning(formula, nodeList, 0)) {
                    this.checkAndSetAssignmentNode(conditionExpression, nodeList, node1);
                } else if (FormulaUtils.isExit(node1.getNodeText())) {
                    this.checkExitNode(nodeList, node1);
                }
                expList.addAll(this.getExpression(conditionExpression, nodeList, formula));
            }
            return expList;
        }
        return this.getExpression(conditionExpression, expressionList, formula);
    }

    private void checkAndSetTempVariableAssignmentNode(ConditionExpression conditionExpression, List<OriginalNode> nodeList, OriginalNode keyNode) {
        if (nodeList.size() != 2 && nodeList.size() < 4) {
            DataTypeEnum typeEnum = DataTypeEnum.getByAlias(keyNode.getNodeText());
            String keyAlias = typeEnum.getAlias();
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u8bed\u53e5\u5fc5\u987b\u6ee1\u8db3\u683c\u5f0f\uff1a{2} \u201c\u53d8\u91cf = \u8868\u8fbe\u5f0f\u201d\u3002", (String)"FormulaParseService_46", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(msg, keyNode.getLineIndex() + 1, keyNode.getStartColumnIndex() + 1, keyAlias));
        }
        OriginalNode node2 = nodeList.get(1);
        conditionExpression.setIsResult(Boolean.FALSE);
        node2.setKeyType(ExpressionNodeTypeEnum.ASS);
        node2.setUniqueKey(node2.getNodeText());
    }

    private void checkAndSetAssignmentNode(ConditionExpression conditionExpression, List<OriginalNode> nodeList, OriginalNode keyNode) {
        if (nodeList.size() < 3) {
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8d4b\u503c\u8bed\u53e5\u5fc5\u987b\u6ee1\u8db3\u683c\u5f0f\uff1a\u201c\u8ba1\u7b97\u9879\u76ee = \u8868\u8fbe\u5f0f\u201d\u3002", (String)"FormulaParseService_53", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(msg, keyNode.getLineIndex() + 1, keyNode.getStartColumnIndex() + 1));
        }
        conditionExpression.setIsResult(Boolean.FALSE);
        keyNode.setKeyType(ExpressionNodeTypeEnum.ASS);
        keyNode.setUniqueKey(keyNode.getNodeText());
    }

    private void checkExitNode(List<OriginalNode> nodeList, OriginalNode keyNode) {
        if (nodeList.size() > 1) {
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{1}\u201d\u8868\u8fbe\u5f0f\u4ee3\u8868\u6240\u5728\u516c\u5f0f\u5757\u903b\u8f91\u5df2\u7ed3\u675f\uff0c\u540e\u9762\u4e0d\u80fd\u5b58\u5728\u5176\u4ed6\u8bed\u53e5\u3002", (String)"FormulaParseService_56", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(msg, keyNode.getLineIndex() + 1, keyNode.getStartColumnIndex() + 1));
        }
        keyNode.setKeyType(ExpressionNodeTypeEnum.EXIT);
        keyNode.setUniqueKey(keyNode.getNodeText());
    }

    @NotNull
    private List<OriginalNode> getResultExpressionNodes(ConditionExpression conditionExpression, FormulaInfo formula, List<OriginalNode> nodeList, OriginalNode resultKeyNode) {
        if (nodeList.size() < 2) {
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8868\u8fbe\u5f0f\u201c{2}\u201d\u4e0d\u5b8c\u6574\u3002", (String)"FormulaParseService_47", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(msg, resultKeyNode.getLineIndex() + 1, resultKeyNode.getStartColumnIndex() + 1, resultKeyNode.getNodeText()));
        }
        OriginalNode node2 = nodeList.get(1);
        if (!OperatorEnum.EQUAL.getAlias().equals(node2.getNodeText())) {
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7ed3\u679c\u8868\u8fbe\u8bed\u53e5\u201c{2} {3}\u201d\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u4e3a\u201c{4} =\u201d\u3002", (String)"FormulaParseService_48", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(msg, node2.getLineIndex() + 1, node2.getStartColumnIndex() + 1, resultKeyNode.getNodeText(), node2.getNodeText(), FormulaKeyEnum.RESULT.getAlias()));
        }
        nodeList = this.getNewExpressionList(nodeList);
        conditionExpression.setIsResult(Boolean.TRUE);
        resultKeyNode.setKeyType(ExpressionNodeTypeEnum.OPERATOR);
        resultKeyNode.setUniqueKey(OperatorEnum.RESULT.getName());
        formula.addOriginalKey(resultKeyNode);
        return nodeList;
    }

    private void resealOriginalNodeList(FormulaInfo formula, OriginalNode conditionNode, List<OriginalNode> expressionList, List<List<OriginalNode>> originalNodeList) {
        ArrayList<OriginalNode> newOriginalNodes = null;
        int index = 0;
        int len = expressionList.size();
        boolean isExport = false;
        while (index < len) {
            OriginalNode node = expressionList.get(index);
            this.isDataTypeKeyAndAddTempVariableIntoCache(expressionList, index, node, formula);
            if (this.isResultKey(node.getNodeText()) || this.isExportKey(node.getNodeText()) || this.isChildConditionKey(node.getNodeText()) || FormulaUtils.isNotNullDataType(node.getNodeText()) || FormulaUtils.isAssignmentMeaning(formula, expressionList, index) || FormulaUtils.isExit(node.getNodeText())) {
                OriginalNode preNode;
                if ((FormulaUtils.isCalItem(formula, node.getNodeText()) || FormulaUtils.isCalCustomItem(formula, node.getNodeText())) && isExport && index > 0 && (this.isExportKey((preNode = expressionList.get(index - 1)).getNodeText()) || ",".equals(preNode.getNodeText())) && newOriginalNodes != null) {
                    newOriginalNodes.add(node);
                    ++index;
                    continue;
                }
                newOriginalNodes = new ArrayList<OriginalNode>(10);
                originalNodeList.add(newOriginalNodes);
                isExport = this.isExportKey(node.getNodeText());
            }
            if (newOriginalNodes == null) {
                String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u540e\u9762\u5fc5\u987b\u662f\u8ba1\u7b97\u9879\u76ee\u8d4b\u503c\u8bed\u53e5\u6216\u201c{3}\u201d\u6216\u201c{4}\u201d\u8bed\u53e5\u6216\u6570\u636e\u7c7b\u578b\u5173\u952e\u5b57\u6216\u201c{5}\u201d\u8bed\u53e5\u6216\u201c{6}\u201d\u8bed\u53e5\u3002", (String)"FormulaParseService_49", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(msg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, conditionNode.getNodeText(), FormulaKeyEnum.RESULT.getAlias(), FormulaKeyEnum.IF.getAlias(), FormulaKeyEnum.NULL.getAlias(), FormulaKeyEnum.EXPORT.getAlias()));
            }
            newOriginalNodes.add(node);
            ++index;
        }
    }

    private boolean isAssignmentKey(String nodeText) {
        return FormulaKeyEnum.ASSIGN.getAlias().equals(nodeText);
    }

    private List<OriginalNode> getNewExpressionList(List<OriginalNode> expressionList) {
        ArrayList<OriginalNode> newExpressionList = new ArrayList<OriginalNode>(expressionList.size());
        int index = 0;
        for (OriginalNode node : expressionList) {
            if (index == 0 || index == 1) {
                ++index;
                continue;
            }
            newExpressionList.add(node);
        }
        return newExpressionList;
    }

    private boolean isResultKey(String nodeText) {
        return FormulaKeyEnum.RESULT.getAlias().equals(nodeText);
    }

    private boolean isExportKey(String nodeText) {
        return FormulaKeyEnum.EXPORT.getAlias().equals(nodeText);
    }

    private boolean isChildConditionKey(String nodeText) {
        return HRStringUtils.isNotEmpty((String)nodeText) && nodeText.contains(CONDITION_EXP_PLACEHOLDER);
    }

    private boolean isDataTypeKey(String nodeText) {
        return FormulaUtils.isDataType(nodeText);
    }

    private void isDataTypeKeyAndAddTempVariableIntoCache(List<OriginalNode> nodes, int index, OriginalNode isDataTypeKeyNode, FormulaInfo formula) {
        if (FormulaUtils.isNotNullDataType(isDataTypeKeyNode.getNodeText())) {
            if (index + 1 == nodes.size()) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u7c7b\u578b\u540e\u9762\u9700\u8981\u52a0\u5177\u4f53\u7684\u53d8\u91cf\u540d\u79f0\u548c\u503c\u3002", (String)"FormulaParseService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, isDataTypeKeyNode.getLineIndex() + 1, isDataTypeKeyNode.getStartColumnIndex() + 1, isDataTypeKeyNode.getNodeText()));
            }
            this.checkAssTempVariableDefineAndAddAssExpression(isDataTypeKeyNode, nodes.get(index + 1), formula);
        }
    }

    protected FormulaInfo getFormulaInfo() {
        return new FormulaInfo();
    }

    protected void childSetFormulaInfo(DynamicObject formula, FormulaInfo formulaInfo, IFormView view) {
    }

    private boolean checkAroundConditionKey(FormulaKeyEnum previousKeyEnum, FormulaKeyEnum previousCheckEnum, FormulaKeyEnum currentKeyEnum, boolean checkIsOrNot, FormulaKeyEnum ... currentCheckArray) {
        if (previousCheckEnum == previousKeyEnum) {
            boolean checkSuccess = false;
            for (FormulaKeyEnum currentCheckEnum : currentCheckArray) {
                if (currentCheckEnum != currentKeyEnum) continue;
                checkSuccess = true;
                break;
            }
            if (!checkIsOrNot) {
                checkSuccess = !checkSuccess;
            }
            return !checkSuccess;
        }
        return false;
    }

    protected void checkDetailNode(OriginalNode currentNode, List<OriginalNode> totalNodeList, List<Expression> expressions, FormulaInfo formulaInfo) {
    }

    private static class LoopIndex {
        int currIndex;
        int endIndex;
        int lPress = 0;
        int rPress = 0;
        int len;
        List<OriginalNode> nodes;
        boolean isDataGradeResult;
        String previousType;
        final List<Expression> subExpList;
        final List<OriginalNode> lParenthesesList = new ArrayList<OriginalNode>(10);
        String errorMsg;
        OriginalNode tempNode;

        public LoopIndex(List<OriginalNode> nodes, Integer index) {
            this.nodes = nodes;
            this.subExpList = new ArrayList<Expression>(nodes.size());
            this.len = nodes.size();
            if (Objects.nonNull(index)) {
                this.currIndex = index;
            }
        }

        public int getCurrIndex() {
            return this.currIndex;
        }

        public void setCurrIndex(int currIndex) {
            this.currIndex = currIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public void setEndIndex(int endIndex) {
            this.endIndex = endIndex;
        }

        public int getlPress() {
            return this.lPress;
        }

        public void setlPress(int lPress) {
            this.lPress = lPress;
        }

        public int getrPress() {
            return this.rPress;
        }

        public void setrPress(int rPress) {
            this.rPress = rPress;
        }

        public int getLen() {
            return this.len;
        }

        public List<OriginalNode> getNodes() {
            return this.nodes;
        }

        public boolean isDataGradeResult() {
            return this.isDataGradeResult;
        }

        public void setDataGradeResult(boolean dataGradeResult) {
            this.isDataGradeResult = dataGradeResult;
        }

        public String getPreviousType() {
            return this.previousType;
        }

        public void setPreviousType(String previousType) {
            this.previousType = previousType;
        }

        public List<Expression> getSubExpList() {
            return this.subExpList;
        }

        public List<OriginalNode> getlParenthesesList() {
            return this.lParenthesesList;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public OriginalNode getTempNode() {
            return this.tempNode;
        }

        public void setTempNode(OriginalNode tempNode) {
            this.tempNode = tempNode;
        }

        public OriginalNode getOriginalNode() {
            return this.nodes.get(this.currIndex);
        }

        public void addExpressionInSubList(Expression expression) {
            this.subExpList.add(expression);
        }

        public void addIntoLeftParenthesesList(OriginalNode node) {
            this.lParenthesesList.add(node);
        }

        public void addLeftParenthesesIndex() {
            ++this.lPress;
        }

        public void addRightParenthesesIndex() {
            ++this.rPress;
        }

        public void addCurrentIndex() {
            ++this.currIndex;
        }
    }
}

