/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.cal.template;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.formula.cal.enums.AddSumTypeEnum;
import kd.hr.hbp.business.service.formula.cal.template.ParentFormulaParse;
import kd.hr.hbp.business.service.formula.cal.vo.AddSumVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.service.formula.cal.vo.DataGradeVO;

public class FormulaParse
extends ParentFormulaParse {
    private static final Log log = LogFactory.getLog(FormulaParse.class);
    private String classNameKey;
    private Map<String, Map<String, Object>> sectionParamMap;
    private Map<String, Map<String, BigDecimal>> proportionMap = new HashMap<String, Map<String, BigDecimal>>(16);
    private Map<String, List<String>> itemSectionMap;
    private boolean isSection;
    private boolean isCalProportion;
    private Map<String, Map<String, Object>> sectionPriorResultMap = Maps.newHashMap();
    private Map<String, CalItemVO> uniqueCodeCalItemMap;
    private Map<String, Object> customCalItemMap;
    private Map<String, Object> outputCustomCalItemValueMap;
    private Map<String, LinkedHashMap<String, Object>> itemSectionResultMap;
    private static final List<String> DEFAULT_SECTIONLIST = Collections.singletonList("1@30");
    private Map<String, AddSumVO> addSumMap;
    private Map<String, List<AddSumVO>> itemToAddSumMap;
    private Map<String, Object> addSumValueMap;
    private Map<String, DataGradeVO> dataGradeMap;
    private String currentSectionKey;

    public FormulaParse() {
        this.params = new HashMap();
        this.resultMap = new HashMap();
        this.proportionMap = new HashMap<String, Map<String, BigDecimal>>();
        this.itemSectionMap = new HashMap<String, List<String>>();
        this.itemSectionResultMap = new HashMap<String, LinkedHashMap<String, Object>>();
        this.sectionParamMap = new HashMap<String, Map<String, Object>>();
        this.customCalItemMap = new HashMap<String, Object>();
        this.outputCustomCalItemValueMap = new HashMap<String, Object>();
    }

    public String getClassNameKey() {
        return this.classNameKey;
    }

    public void setClassNameKey(String classNameKey) {
        this.classNameKey = classNameKey;
    }

    public boolean isSection() {
        return this.isSection;
    }

    public void setSection(boolean isSection) {
        this.isSection = isSection;
    }

    public boolean isCalProportion() {
        return this.isCalProportion;
    }

    public void setCalProportion(boolean isCalProration) {
        this.isCalProportion = isCalProration;
    }

    public void setUniqueCodeCalItemMap(Map<String, CalItemVO> uniqueCodeCalItemMap) {
        this.uniqueCodeCalItemMap = uniqueCodeCalItemMap;
    }

    public Map<String, Map<String, Object>> getSectionParamMap() {
        return this.sectionParamMap;
    }

    public void setSectionParamMap(Map<String, Map<String, Object>> sectionParamMap) {
        if (null == sectionParamMap) {
            sectionParamMap = new HashMap<String, Map<String, Object>>();
        }
        this.sectionParamMap = sectionParamMap;
    }

    public void setSectionPriorResultMap(Map<String, Map<String, Object>> sectionPriorResultMap) {
        if (null == sectionPriorResultMap) {
            sectionPriorResultMap = new HashMap<String, Map<String, Object>>();
        }
        this.sectionPriorResultMap = sectionPriorResultMap;
    }

    public Map<String, Map<String, Object>> getSectionPriorResultMap() {
        return this.sectionPriorResultMap;
    }

    public Map<String, CalItemVO> getUniqueCodeCalItemMap() {
        return this.uniqueCodeCalItemMap;
    }

    public List<String> getItemSectionList(String uniqueCode) {
        if (null == this.itemSectionMap) {
            return DEFAULT_SECTIONLIST;
        }
        List<String> sectionList = this.itemSectionMap.get(uniqueCode);
        if (null == sectionList || sectionList.size() == 0) {
            return DEFAULT_SECTIONLIST;
        }
        return sectionList;
    }

    public Map<String, Map<String, BigDecimal>> getProportionMap() {
        return this.proportionMap;
    }

    public void setProportionMap(Map<String, Map<String, BigDecimal>> proportionMap) {
        this.proportionMap = proportionMap;
    }

    public Map<String, List<String>> getItemSectionMap() {
        return this.itemSectionMap;
    }

    public void setItemSectionMap(Map<String, List<String>> itemSectionMap) {
        if (null == itemSectionMap) {
            itemSectionMap = new HashMap<String, List<String>>();
        }
        this.itemSectionMap = itemSectionMap;
    }

    public Map<String, LinkedHashMap<String, Object>> getItemSectionResultMap() {
        return this.itemSectionResultMap;
    }

    public void setItemSectionResultMap(Map<String, LinkedHashMap<String, Object>> itemSectionResultMap) {
        this.itemSectionResultMap = itemSectionResultMap;
    }

    public Map<String, Object> getCustomCalItemMap() {
        return this.customCalItemMap;
    }

    public void setCustomCalItemMap(Map<String, Object> customCalItemMap) {
        if (null == customCalItemMap) {
            customCalItemMap = new HashMap<String, Object>();
        }
        this.customCalItemMap = customCalItemMap;
    }

    public Map<String, Object> getOutputCustomCalItemValueMap() {
        return this.outputCustomCalItemValueMap;
    }

    public void setOutputCustomCalItemValueMap(Map<String, Object> outputCustomCalItemValueMap) {
        if (null == outputCustomCalItemValueMap) {
            outputCustomCalItemValueMap = new HashMap<String, Object>();
        }
        this.outputCustomCalItemValueMap = outputCustomCalItemValueMap;
    }

    public void setAddSumMap(Map<String, AddSumVO> addSumMap) {
        if (addSumMap == null) {
            addSumMap = new HashMap<String, AddSumVO>();
        }
        this.addSumMap = addSumMap;
        this.addSumValueMap = new HashMap<String, Object>(this.addSumMap.size());
        this.itemToAddSumMap = new HashMap<String, List<AddSumVO>>();
        for (Map.Entry<String, AddSumVO> entry : addSumMap.entrySet()) {
            AddSumVO addSumVO = entry.getValue();
            if (addSumVO == null) continue;
            for (String itemUniqueCode : addSumVO.getAddSumItemUniqueCodeSet()) {
                this.itemToAddSumMap.computeIfAbsent(itemUniqueCode, k -> new ArrayList());
                this.itemToAddSumMap.computeIfPresent(itemUniqueCode, (k, v) -> {
                    v.add(addSumVO);
                    return v;
                });
            }
        }
    }

    public String getFieldValueAsString(String uniqueCode, String sectionKey, String calItemUniqueCode) {
        if (this.isSection && this.checkItemIsSection(calItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                return this.getFieldValueAsString(uniqueCode);
            }
            Object obj = sectionParamMap.get(uniqueCode);
            return obj == null ? null : obj.toString();
        }
        return this.getFieldValueAsString(uniqueCode);
    }

    public Object getFieldValueAsObject(String uniqueCode, String sectionKey, String calItemUniqueCode) {
        if (this.isSection && this.checkItemIsSection(calItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                return this.getFieldValueAsObject(uniqueCode);
            }
            return sectionParamMap.get(uniqueCode);
        }
        return this.getFieldValueAsObject(uniqueCode);
    }

    public BigDecimal getFieldValueAsBigDecimal(String uniqueCode, String sectionKey, String calItemUniqueCode) {
        if (this.isSection && this.checkItemIsSection(calItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                return this.getFieldValueAsBigDecimal(uniqueCode);
            }
            Object obj = sectionParamMap.get(uniqueCode);
            return obj == null ? null : new BigDecimal(obj.toString());
        }
        if (this.checkIsAddSum(uniqueCode)) {
            AddSumVO addSumVO = this.addSumMap.get(uniqueCode);
            if (AddSumTypeEnum.USE_SUM_UPDATE == addSumVO.getAddSumType()) {
                this.calAddSumValue(uniqueCode);
            }
            return this.getAddSumValueAsBigDecimal(uniqueCode);
        }
        return this.getFieldValueAsBigDecimal(uniqueCode);
    }

    public Integer getFieldValueAsInteger(String uniqueCode, String sectionKey, String calItemUniqueCode) {
        if (this.isSection && this.checkItemIsSection(calItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                return this.getFieldValueAsInteger(uniqueCode);
            }
            Object obj = sectionParamMap.get(uniqueCode);
            if (obj instanceof BigDecimal) {
                BigDecimal objvalue = (BigDecimal)obj;
                return objvalue.intValue();
            }
            return obj == null ? null : Integer.valueOf(Integer.parseInt(obj.toString()));
        }
        if (this.checkIsAddSum(uniqueCode)) {
            AddSumVO addSumVO = this.addSumMap.get(uniqueCode);
            if (AddSumTypeEnum.USE_SUM_UPDATE == addSumVO.getAddSumType()) {
                this.calAddSumValue(uniqueCode);
            }
            return this.getAddSumValueAsBigDecimal(uniqueCode).intValue();
        }
        return this.getFieldValueAsInteger(uniqueCode);
    }

    public Boolean getFieldValueAsBoolean(String uniqueCode, String sectionKey, String calItemUniqueCode) {
        if (this.isSection && this.checkItemIsSection(calItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                return this.getFieldValueAsBoolean(uniqueCode);
            }
            Object obj = sectionParamMap.get(uniqueCode);
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                if ("1".equals(obj.toString())) {
                    return Boolean.TRUE;
                }
                return Boolean.parseBoolean(String.valueOf(obj));
            }
            return Boolean.valueOf(obj.toString());
        }
        return this.getFieldValueAsBoolean(uniqueCode);
    }

    public Date getFieldValueAsDate(String uniqueCode, String sectionKey, String calItemUniqueCode) {
        if (this.isSection && this.checkItemIsSection(calItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                return this.getFieldValueAsDate(uniqueCode);
            }
            Object obj = sectionParamMap.get(uniqueCode);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Date) {
                return (Date)obj;
            }
            if (obj instanceof String) {
                return this.parseDate(String.valueOf(obj));
            }
            return null;
        }
        return this.getFieldValueAsDate(uniqueCode);
    }

    public DynamicObject getFieldValueAsDynamicObject(String uniqueCode, String sectionKey, String calItemUniqueCode) {
        if (this.isSection && this.checkItemIsSection(calItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                return this.getFieldValueAsDynamicObject(uniqueCode);
            }
            Object obj = sectionParamMap.get(uniqueCode);
            if (obj == null) {
                return null;
            }
            if (obj instanceof DynamicObject) {
                return (DynamicObject)obj;
            }
            return null;
        }
        return this.getFieldValueAsDynamicObject(uniqueCode);
    }

    public DynamicObject getDynamicObjectByEntityNumberAndId(String entityNumber, Object id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return new DynamicObject((DynamicObjectType)type, id);
    }

    private boolean checkItemIsSection(String uniqueCode) {
        if (null == this.itemSectionMap) {
            return false;
        }
        List<String> sectionKeyList = this.itemSectionMap.get(uniqueCode);
        return sectionKeyList != null && sectionKeyList.size() >= 2;
    }

    public void addResultValue(String uniqueCode, BigDecimal value, String sectionKey) {
        if (!this.isCalProportion) {
            value = this.convertItemValue(uniqueCode, value, sectionKey);
        }
        if (this.isSection && this.checkItemIsSection(uniqueCode) || this.isCalProportion) {
            LinkedHashMap itemResultMap = this.itemSectionResultMap.computeIfAbsent(uniqueCode, k -> new LinkedHashMap());
            value = this.dealItemDataScal(uniqueCode, value);
            itemResultMap.put(sectionKey, this.checkAndReturn(uniqueCode, sectionKey, value));
        } else {
            value = this.dealItemDataScal(uniqueCode, value);
            this.addResultValue(uniqueCode, value);
        }
    }

    public void addResultValue(String uniqueCode, BigDecimal value) {
        this.resultMap.put(uniqueCode, value);
        this.params.put(uniqueCode, value);
        this.addItemValueToSum(uniqueCode);
    }

    private BigDecimal convertItemValue(String uniqueCode, BigDecimal value, String sectionKey) {
        if (null == value) {
            return value;
        }
        Map<String, BigDecimal> proportionMap = this.proportionMap.get(uniqueCode);
        BigDecimal proportion = null;
        if (null == proportionMap) {
            proportion = BigDecimal.ONE;
        } else {
            proportion = proportionMap.get(sectionKey);
            if (null == proportion) {
                proportion = BigDecimal.ONE;
            }
        }
        return proportion.multiply(value);
    }

    private BigDecimal dealItemDataScal(String uniqueCode, BigDecimal value) {
        if (value == null || this.isCalProportion || this.uniqueCodeCalItemMap == null) {
            return value;
        }
        CalItemVO item = this.uniqueCodeCalItemMap.get(uniqueCode);
        if (item == null) {
            return value;
        }
        return value.setScale((int)item.getScale(), item.getRoundingMode());
    }

    public void addResultValue(String uniqueCode, Integer value, String sectionKey) {
        if (this.isSection && this.checkItemIsSection(uniqueCode) || this.isCalProportion) {
            LinkedHashMap itemResultMap = this.itemSectionResultMap.computeIfAbsent(uniqueCode, k -> new LinkedHashMap());
            itemResultMap.put(sectionKey, this.checkAndReturn(uniqueCode, sectionKey, value));
        } else {
            this.addResultValue(uniqueCode, value);
        }
    }

    public void addResultValue(String uniqueCode, Integer value) {
        this.resultMap.put(uniqueCode, value);
        this.params.put(uniqueCode, value);
        this.addItemValueToSum(uniqueCode);
    }

    public void addResultValue(String uniqueCode, Boolean value, String sectionKey) {
        if (this.isSection && this.checkItemIsSection(uniqueCode) || this.isCalProportion) {
            LinkedHashMap itemResultMap = this.itemSectionResultMap.computeIfAbsent(uniqueCode, k -> new LinkedHashMap());
            itemResultMap.put(sectionKey, this.checkAndReturn(uniqueCode, sectionKey, value));
        } else {
            this.addResultValue(uniqueCode, value);
        }
    }

    public void addResultValue(String uniqueCode, Boolean value) {
        this.resultMap.put(uniqueCode, value);
        this.params.put(uniqueCode, value);
    }

    public void addResultValue(String uniqueCode, Date value, String sectionKey) {
        if (this.isSection && this.checkItemIsSection(uniqueCode) || this.isCalProportion) {
            LinkedHashMap itemResultMap = this.itemSectionResultMap.computeIfAbsent(uniqueCode, k -> new LinkedHashMap());
            itemResultMap.put(sectionKey, this.checkAndReturn(uniqueCode, sectionKey, value));
        } else {
            this.addResultValue(uniqueCode, value);
        }
    }

    public void addResultValue(String uniqueCode, Date value) {
        this.resultMap.put(uniqueCode, value);
        this.params.put(uniqueCode, value);
    }

    public void addResultValue(String uniqueCode, String value, String sectionKey) {
        if (this.isSection && this.checkItemIsSection(uniqueCode) || this.isCalProportion) {
            LinkedHashMap itemResultMap = this.itemSectionResultMap.computeIfAbsent(uniqueCode, k -> new LinkedHashMap());
            itemResultMap.put(sectionKey, this.checkAndReturn(uniqueCode, sectionKey, value));
        } else {
            this.addResultValue(uniqueCode, value);
        }
    }

    public void addResultValue(String uniqueCode, String value) {
        this.resultMap.put(uniqueCode, value);
        this.params.put(uniqueCode, value);
    }

    public void addResultValue(String uniqueCode, DynamicObject value, String sectionKey) {
        if (this.isSection && this.checkItemIsSection(uniqueCode) || this.isCalProportion) {
            LinkedHashMap itemResultMap = this.itemSectionResultMap.computeIfAbsent(uniqueCode, k -> new LinkedHashMap());
            itemResultMap.put(sectionKey, this.checkAndReturn(uniqueCode, sectionKey, value));
        } else {
            this.addResultValue(uniqueCode, value);
        }
    }

    public void addResultValue(String uniqueCode, DynamicObject value) {
        this.resultMap.put(uniqueCode, value);
        this.params.put(uniqueCode, value);
    }

    public void addResultValue(String uniqueCode, Object value, String sectionKey) {
        if (this.isSection && this.checkItemIsSection(uniqueCode) || this.isCalProportion) {
            LinkedHashMap itemResultMap = this.itemSectionResultMap.computeIfAbsent(uniqueCode, k -> new LinkedHashMap());
            itemResultMap.put(sectionKey, this.checkAndReturn(uniqueCode, sectionKey, value));
        } else {
            this.addResultValue(uniqueCode, value);
        }
    }

    public void addResultValue(String uniqueCode, Object value) {
        this.resultMap.put(uniqueCode, value);
        this.params.put(uniqueCode, value);
    }

    public void sumItemResultValue(String uniqueCode) {
        if (!this.isSection || this.isCalProportion) {
            return;
        }
        LinkedHashMap<String, Object> itemResultMap = this.itemSectionResultMap.get(uniqueCode);
        if (itemResultMap == null || itemResultMap.size() == 0) {
            return;
        }
        BigDecimal result = BigDecimal.ZERO;
        Object otherResult = null;
        for (Map.Entry<String, Object> entry : itemResultMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof BigDecimal) {
                result = result.add((BigDecimal)value);
                continue;
            }
            otherResult = value;
        }
        if (otherResult != null) {
            this.resultMap.put(uniqueCode, otherResult);
            this.params.put(uniqueCode, otherResult);
        } else {
            this.resultMap.put(uniqueCode, result);
            this.params.put(uniqueCode, result);
        }
    }

    private Object checkAndReturn(String uniqueCode, String sectionKey, Object value) {
        Map<String, Object> priorSectionResultMap = this.sectionPriorResultMap.get(uniqueCode);
        if (priorSectionResultMap == null) {
            return value;
        }
        Object result = priorSectionResultMap.get(sectionKey);
        if (result == null) {
            return value;
        }
        return result;
    }

    protected void setCurrentSectionKey(String sectionKey) {
        this.currentSectionKey = sectionKey;
    }

    public String getCustomCalItemValue(String uniqueCode) {
        if (this.customCalItemMap != null) {
            log.error("customCalItemMap = " + this.customCalItemMap + ", uniqueCode=" + uniqueCode);
            Object obj = this.customCalItemMap.get(uniqueCode);
            return obj == null ? "" : obj.toString();
        }
        return "";
    }

    public DynamicObject getCustomCalItemValueAsDynamicObj(String uniqueCode) {
        if (this.customCalItemMap != null) {
            log.error("customCalItemMap = " + this.customCalItemMap + ", uniqueCode=" + uniqueCode);
            Object obj = this.customCalItemMap.get(uniqueCode);
            if (obj instanceof DynamicObject) {
                return (DynamicObject)obj;
            }
        }
        return null;
    }

    public void addCustomCalItemValue(String uniqueCode, Object value) {
        if (!this.customCalItemMap.containsKey(uniqueCode)) {
            return;
        }
        this.customCalItemMap.put(uniqueCode, value);
    }

    public void addOutputCustomCalItemValue(String uniqueCode, Object value) {
        this.outputCustomCalItemValueMap.put(uniqueCode, value);
    }

    public Object[] getFieldValueAsObjectArray(String uniqueCode, String sectionKey, String calItemUniqueCode) {
        if (this.isSection && this.checkItemIsSection(calItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                if (this.isCalProportion) {
                    return this.getFieldValueAsObjectArray(uniqueCode);
                }
                return null;
            }
            Object obj = sectionParamMap.get(uniqueCode);
            return obj instanceof String[] ? (String[])obj : null;
        }
        return this.getFieldValueAsObjectArray(uniqueCode);
    }

    public String[] getFieldValueAsStringArray(String uniqueCode, String sectionKey, String calItemUniqueCode) {
        if (this.isSection && this.checkItemIsSection(calItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                if (this.isCalProportion) {
                    return this.getFieldValueAsStringArray(uniqueCode);
                }
                return null;
            }
            Object obj = sectionParamMap.get(uniqueCode);
            return obj instanceof String[] ? (String[])obj : null;
        }
        return this.getFieldValueAsStringArray(uniqueCode);
    }

    public BigDecimal[] getFieldValueAsBigDecimalArray(String uniqueCode, String sectionKey, String calItemUniqueCode) {
        if (this.isSection && this.checkItemIsSection(calItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                if (this.isCalProportion) {
                    return this.getFieldValueAsBigDecimalArray(uniqueCode);
                }
                return null;
            }
            Object obj = sectionParamMap.get(uniqueCode);
            return obj instanceof BigDecimal[] ? (BigDecimal[])obj : null;
        }
        return this.getFieldValueAsBigDecimalArray(uniqueCode);
    }

    public Boolean[] getFieldValueAsBooleanArray(String uniqueCode, String sectionKey, String calItemUniqueCode) {
        if (this.isSection && this.checkItemIsSection(calItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                if (this.isCalProportion) {
                    return this.getFieldValueAsBooleanArray(uniqueCode);
                }
                return null;
            }
            Object obj = sectionParamMap.get(uniqueCode);
            return this.getBooleanArray(obj);
        }
        return this.getFieldValueAsBooleanArray(uniqueCode);
    }

    public Integer[] getFieldValueAsIntegerArray(String uniqueCode, String sectionKey, String calItemUniqueCode) {
        if (this.isSection && this.checkItemIsSection(calItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                if (this.isCalProportion) {
                    return this.getFieldValueAsIntegerArray(uniqueCode);
                }
                return null;
            }
            Object obj = sectionParamMap.get(uniqueCode);
            return this.getIntArray(obj);
        }
        return this.getFieldValueAsIntegerArray(uniqueCode);
    }

    public Date[] getFieldValueAsDateArray(String uniqueCode, String sectionKey, String calItemUniqueCode) {
        if (this.isSection && this.checkItemIsSection(calItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                if (this.isCalProportion) {
                    return this.getFieldValueAsDateArray(uniqueCode);
                }
                return null;
            }
            Object obj = sectionParamMap.get(uniqueCode);
            return this.getDateArray(obj);
        }
        return this.getFieldValueAsDateArray(uniqueCode);
    }

    public void calAddSumValueAfterAllCal() {
        if (this.addSumMap == null) {
            return;
        }
        for (Map.Entry<String, AddSumVO> entry : this.addSumMap.entrySet()) {
            if (AddSumTypeEnum.AFTER_CAL_SUM != entry.getValue().getAddSumType()) continue;
            this.calAddSumValue(entry.getKey());
        }
    }

    public Map<String, AddSumVO> getAddSumMap() {
        if (this.addSumMap == null) {
            return new HashMap<String, AddSumVO>();
        }
        for (Map.Entry<String, AddSumVO> entry : this.addSumMap.entrySet()) {
            Integer scale;
            BigDecimal sumAfterCal = BigDecimal.ZERO;
            AddSumVO addSumVO = entry.getValue();
            Object originalValue = this.originalParams.get(entry.getKey());
            Object afterCalValue = this.addSumValueMap.get(entry.getKey());
            if (originalValue instanceof BigDecimal) {
                sumAfterCal = sumAfterCal.add((BigDecimal)originalValue);
            } else if (originalValue instanceof Integer) {
                sumAfterCal = sumAfterCal.add(new BigDecimal((Integer)originalValue));
            }
            if (afterCalValue instanceof Integer) {
                afterCalValue = new BigDecimal((Integer)afterCalValue);
            }
            if (Objects.nonNull(scale = addSumVO.getScale()) && afterCalValue instanceof BigDecimal) {
                afterCalValue = ((BigDecimal)afterCalValue).setScale((int)scale, addSumVO.getRoundingMode());
            }
            if (afterCalValue instanceof BigDecimal) {
                sumAfterCal = sumAfterCal.add((BigDecimal)afterCalValue);
                if (Objects.nonNull(scale)) {
                    sumAfterCal = sumAfterCal.setScale((int)scale, addSumVO.getRoundingMode());
                }
            }
            addSumVO.setOriginalValue(originalValue);
            addSumVO.setCurrentCalValue(afterCalValue);
            addSumVO.setTotalValue(sumAfterCal);
        }
        return this.addSumMap;
    }

    private void calAddSumValue(String uniqueCode) {
        if (this.addSumMap == null) {
            return;
        }
        AddSumVO addSumVO = this.addSumMap.get(uniqueCode);
        if (Objects.nonNull(addSumVO)) {
            BigDecimal addSumValue = BigDecimal.ZERO;
            Set<String> addSumItemUniqueCodeSet = addSumVO.getAddSumItemUniqueCodeSet();
            for (String itemUniqueCode : addSumItemUniqueCodeSet) {
                Object itemValue = this.params.get(itemUniqueCode);
                BigDecimal proportion = BigDecimal.ONE;
                if (Objects.nonNull(addSumVO.getItemProportionMap().get(itemUniqueCode))) {
                    proportion = addSumVO.getItemProportionMap().get(itemUniqueCode);
                }
                if (itemValue instanceof String) {
                    itemValue = new BigDecimal(String.valueOf(itemValue));
                }
                Boolean isAdd = addSumVO.getItemIsAddMap().get(itemUniqueCode);
                if (itemValue instanceof BigDecimal) {
                    if (Objects.isNull(isAdd) || isAdd.booleanValue()) {
                        addSumValue = addSumValue.add(((BigDecimal)itemValue).multiply(proportion));
                        continue;
                    }
                    addSumValue = addSumValue.subtract(((BigDecimal)itemValue).multiply(proportion));
                    continue;
                }
                if (!(itemValue instanceof Integer)) continue;
                if (Objects.isNull(isAdd) || isAdd.booleanValue()) {
                    addSumValue = addSumValue.add(new BigDecimal((Integer)itemValue).multiply(proportion));
                    continue;
                }
                addSumValue = addSumValue.subtract(new BigDecimal((Integer)itemValue).multiply(proportion));
            }
            this.addSumValueMap.put(uniqueCode, addSumValue);
        }
    }

    private void addItemValueToSum(String itemUniqueCode) {
        if (this.itemToAddSumMap == null) {
            return;
        }
        List<AddSumVO> addSums = this.itemToAddSumMap.get(itemUniqueCode);
        if (addSums == null || addSums.isEmpty()) {
            return;
        }
        for (AddSumVO addSum : addSums) {
            if (AddSumTypeEnum.ITEM_UPDATE_SUM != addSum.getAddSumType()) continue;
            Object addSumValue = this.addSumValueMap.get(addSum.getUniqueCode());
            BigDecimal itemValue = this.getFieldValueAsBigDecimal(itemUniqueCode);
            BigDecimal proportion = BigDecimal.ONE;
            if (Objects.nonNull(addSum.getItemProportionMap().get(itemUniqueCode))) {
                proportion = addSum.getItemProportionMap().get(itemUniqueCode);
            }
            Boolean isAdd = addSum.getItemIsAddMap().get(itemUniqueCode);
            if (addSumValue == null) {
                addSumValue = BigDecimal.ZERO;
            }
            if (addSumValue instanceof BigDecimal) {
                addSumValue = Objects.isNull(isAdd) || isAdd.booleanValue() ? ((BigDecimal)addSumValue).add(itemValue.multiply(proportion)) : ((BigDecimal)addSumValue).subtract(itemValue.multiply(proportion));
            } else if (addSumValue instanceof Integer) {
                addSumValue = Objects.isNull(isAdd) || isAdd != false ? new BigDecimal((Integer)addSumValue).add(itemValue.multiply(proportion)) : new BigDecimal((Integer)addSumValue).subtract(itemValue.multiply(proportion));
            }
            this.addSumValueMap.put(addSum.getUniqueCode(), addSumValue);
        }
    }

    private boolean checkIsAddSum(String uniqueCode) {
        if (this.addSumMap == null) {
            return false;
        }
        AddSumVO addSumVO = this.addSumMap.get(uniqueCode);
        return addSumVO != null;
    }

    private BigDecimal getAddSumValueAsBigDecimal(String uniqueCode) {
        BigDecimal returnValue = BigDecimal.ZERO;
        if (this.originalParams == null) {
            return returnValue;
        }
        Object originalValue = this.originalParams.get(uniqueCode);
        if (originalValue == null) {
            originalValue = BigDecimal.ZERO;
        }
        if (originalValue instanceof BigDecimal) {
            returnValue = returnValue.add((BigDecimal)originalValue);
        } else if (originalValue instanceof Integer) {
            returnValue = returnValue.add(new BigDecimal((Integer)originalValue));
        }
        if (this.addSumValueMap == null) {
            return returnValue;
        }
        Object calculatingValue = this.addSumValueMap.get(uniqueCode);
        if (calculatingValue == null) {
            calculatingValue = BigDecimal.ZERO;
        }
        if (calculatingValue instanceof BigDecimal) {
            returnValue = returnValue.add((BigDecimal)calculatingValue);
        } else if (calculatingValue instanceof Integer) {
            returnValue = returnValue.add(new BigDecimal((Integer)calculatingValue));
        }
        return returnValue;
    }

    public Integer getDataGradeResultToInteger(String dataGradeUniqueCode, String resultKey, Object ... params) {
        DataGradeVO dataGradeVO = this.dataGradeMap.get(dataGradeUniqueCode);
        if (Objects.nonNull(dataGradeVO)) {
            Object result = dataGradeVO.getDataGradeResult(resultKey, params);
            return Objects.isNull(result) ? 0 : Integer.parseInt(result.toString());
        }
        return 0;
    }

    public BigDecimal getDataGradeResultToBigDecimal(String dataGradeUniqueCode, String resultKey, Object ... params) {
        DataGradeVO dataGradeVO = this.dataGradeMap.get(dataGradeUniqueCode);
        if (Objects.nonNull(dataGradeVO)) {
            Object result = dataGradeVO.getDataGradeResult(resultKey, params);
            return Objects.isNull(result) ? BigDecimal.ZERO : new BigDecimal(result.toString());
        }
        return BigDecimal.ZERO;
    }

    public String getDataGradeResultToString(String dataGradeUniqueCode, String resultKey, Object ... params) {
        DataGradeVO dataGradeVO = this.dataGradeMap.get(dataGradeUniqueCode);
        if (Objects.nonNull(dataGradeVO)) {
            Object result = dataGradeVO.getDataGradeResult(resultKey, params);
            return Objects.isNull(result) ? "" : result.toString();
        }
        return "";
    }

    public DynamicObject getDataGradeResultToDynamicObject(String dataGradeUniqueCode, String resultKey, Object ... params) {
        DataGradeVO dataGradeVO = this.dataGradeMap.get(dataGradeUniqueCode);
        if (Objects.nonNull(dataGradeVO)) {
            Object result = dataGradeVO.getDataGradeResult(resultKey, params);
            if (result instanceof DynamicObject) {
                return (DynamicObject)result;
            }
            return null;
        }
        return null;
    }

    public Date getDataGradeResultToDate(String dataGradeUniqueCode, String resultKey, Object ... params) {
        DataGradeVO dataGradeVO = this.dataGradeMap.get(dataGradeUniqueCode);
        if (Objects.nonNull(dataGradeVO)) {
            Object result = dataGradeVO.getDataGradeResult(resultKey, params);
            if (result instanceof Date) {
                return (Date)result;
            }
            if (result instanceof String) {
                return this.parseDate(String.valueOf(result));
            }
        }
        return null;
    }

    public void setDataGradeMap(Map<String, DataGradeVO> dataGradeMap) {
        this.dataGradeMap = dataGradeMap;
    }

    public void updateCalItemValue(String uniqueCode, Object value) {
        this.params.put(uniqueCode, value);
    }

    public void updateCalItemValue(String uniqueCode, Object value, String sectionKey, String calItemUniqueCode) {
        if (this.isSection && this.checkItemIsSection(calItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                return;
            }
            sectionParamMap.put(uniqueCode, value);
        } else {
            this.updateCalItemValue(uniqueCode, value);
        }
    }
}

