/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.entity.expression;

import java.util.Objects;
import kd.hr.hbp.business.service.formula.entity.expression.Expression;
import kd.hr.hbp.business.service.formula.entity.node.OriginalNode;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.service.formula.enums.ExpressionNodeTypeEnum;
import kd.hr.hbp.business.service.formula.enums.InvokeMethodEnum;

public class InvokeMethodExpression
extends Expression {
    private static final long serialVersionUID = -8831048438242831613L;
    private String code;
    private String afterBoxCode;
    private DataTypeEnum returnDataType;

    public InvokeMethodExpression(OriginalNode value, InvokeMethodEnum invokeMethodEnum) {
        this.setType(ExpressionNodeTypeEnum.INVOKE_METHOD);
        this.setNode(value);
        if (Objects.nonNull((Object)invokeMethodEnum)) {
            this.returnDataType = invokeMethodEnum.getReturnDataType();
            this.code = invokeMethodEnum.getCode();
            this.afterBoxCode = invokeMethodEnum.getAfterBoxCode();
        }
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public DataTypeEnum getReturnDataType() {
        return this.returnDataType;
    }

    public void setReturnDataType(DataTypeEnum returnDataType) {
        this.returnDataType = returnDataType;
    }

    public String boxCode(String code) {
        return String.format(this.afterBoxCode, code);
    }
}

