/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.entity.item;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.CalItemTypeEnum;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;

public class CalItem
extends TreeNodeItem {
    private static final long serialVersionUID = -555101180661151292L;
    protected boolean isCustomItem;
    protected boolean isGlobalEffect;
    protected DataTypeEnum dataType;
    protected CalItemTypeEnum itemType = CalItemTypeEnum.BASIC;
    protected String entityNumber;
    protected String propertyField;
    protected QFilter[] qFilters;
    protected String orders;
    private List<String> serializeQFilters;
    private boolean checkHourMinSec = false;
    private boolean isCanAssignment = true;

    public CalItem(String itemCategory, String id, String parentId, String name, String uniqueCode, DataTypeEnum dataType) {
        this(itemCategory, id, parentId, name, null, dataType, false, false);
        this.setUniqueCode(uniqueCode);
    }

    public CalItem(String itemCategory, String id, String parentId, String name, String uniqueCode, DataTypeEnum dataType, boolean isCustomItem) {
        this(itemCategory, id, parentId, name, null, dataType, isCustomItem, false);
        this.setUniqueCode(uniqueCode);
    }

    public CalItem(String itemCategory, String id, String parentId, String name, String uniqueCode, boolean isCustomItem, boolean isGlobalEffect, DataTypeEnum dataType) {
        this(itemCategory, id, parentId, name, null, dataType, isCustomItem, isGlobalEffect);
        this.setUniqueCode(uniqueCode);
    }

    public CalItem(String itemCategory, String id, String parentId, String name, String uniqueCode, DataTypeEnum dataType, boolean isCustomItem, boolean isGlobalEffect) {
        super(itemCategory, id, parentId, name, null);
        this.setUniqueCode(uniqueCode);
        this.dataType = dataType;
        this.isCustomItem = isCustomItem;
        this.isGlobalEffect = isGlobalEffect;
    }

    public CalItem() {
    }

    public DataTypeEnum getDataType() {
        return this.dataType;
    }

    public void setDataType(DataTypeEnum dataType) {
        this.dataType = dataType;
    }

    public boolean isCustomItem() {
        return this.isCustomItem;
    }

    public void setCustomItem(boolean customItem) {
        this.isCustomItem = customItem;
    }

    public boolean isGlobalEffect() {
        return this.isGlobalEffect;
    }

    public void setGlobalEffect(boolean globalEffect) {
        this.isGlobalEffect = globalEffect;
    }

    public CalItemTypeEnum getItemType() {
        return this.itemType;
    }

    public void setItemType(CalItemTypeEnum itemType) {
        this.itemType = itemType;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public String getPropertyField() {
        return this.propertyField;
    }

    public void setPropertyField(String propertyField) {
        this.propertyField = propertyField;
    }

    public QFilter[] getqFilters() {
        if (this.serializeQFilters != null && this.serializeQFilters.size() > 0) {
            return (QFilter[])this.serializeQFilters.stream().map(QFilter::fromSerializedString).toArray(QFilter[]::new);
        }
        return this.qFilters;
    }

    public void setqFilters(QFilter[] qFilters) {
        this.qFilters = qFilters;
        if (qFilters != null && qFilters.length > 0) {
            this.serializeQFilters = Lists.newArrayListWithExpectedSize((int)qFilters.length);
            for (QFilter filter : qFilters) {
                this.serializeQFilters.add(filter.toSerializedString());
            }
        }
    }

    public List<String> getSerializeQFilters() {
        return this.serializeQFilters;
    }

    public void setSerializeQFilters(List<String> serializeQFilters) {
        this.serializeQFilters = serializeQFilters;
    }

    public String getOrders() {
        return this.orders;
    }

    public void setOrders(String orders) {
        this.orders = orders;
    }

    public boolean isCheckHourMinSec() {
        return this.checkHourMinSec;
    }

    public void setCheckHourMinSec(boolean checkHourMinSec) {
        this.checkHourMinSec = checkHourMinSec;
    }

    public boolean isCanAssignment() {
        return this.isCanAssignment;
    }

    public void setCanAssignment(boolean canAssignment) {
        this.isCanAssignment = canAssignment;
    }

    @Override
    public final void setUniqueCode(String uniqueCode) {
        if (!this.checkCodeValidate(uniqueCode)) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"uniqueCode\u7684\u503c{0}\u4e0d\u89c4\u8303,uniqueCode\u53ea\u652f\u6301$_\u4ee5\u53ca\u82f1\u6587\u548c\u6570\u5b57\u3002", (String)"CalItem_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), uniqueCode));
        }
        this.uniqueCode = uniqueCode;
    }
}

