/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.entity.item;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.service.formula.cal.enums.DataGradeParamTypeEnum;
import kd.hr.hbp.business.service.formula.entity.item.ParamItem;
import kd.hr.hbp.business.service.formula.entity.item.ReturnItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.common.datagrade.DataGradeTableVO;
import kd.hr.hbp.common.datagrade.EntryVO;
import kd.hr.hbp.common.datagrade.ParamVO;
import kd.hr.hbp.common.util.HRJSONUtils;

public class DataGradeItem
extends TreeNodeItem {
    private static final long serialVersionUID = 4813255617663026450L;
    private Map<String, ReturnItem> returnDataMap;
    private String description;
    private String example;
    private List<ParamItem> dataGradeParams;

    public DataGradeItem() {
        this.setHasChild(true);
    }

    public DataGradeItem(String itemCategory, String id, String parentId, String name, String uniqueCode, Map<String, ReturnItem> returnDataMap, String description, String example, List<ParamItem> dataGradeParams) {
        super(itemCategory, id, parentId, name, uniqueCode);
        this.setHasChild(true);
        this.returnDataMap = returnDataMap;
        this.description = description;
        this.example = example;
        this.dataGradeParams = dataGradeParams;
    }

    public Map<String, ReturnItem> getReturnDataMap() {
        return this.returnDataMap;
    }

    public void setReturnDataMap(Map<String, ReturnItem> returnDataMap) {
        this.returnDataMap = returnDataMap;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public List<ParamItem> getDataGradeParams() {
        return this.dataGradeParams;
    }

    public void setDataGradeParams(List<ParamItem> dataGradeParams) {
        this.dataGradeParams = dataGradeParams;
    }

    public static DataGradeItem getDataGradeItem(DynamicObject dy) {
        return DataGradeItem.getDataGradeItem(dy, "DG", "DG");
    }

    public static DataGradeItem getDataGradeItem(DynamicObject dy, String parentId, String itemCategory) {
        DataGradeItem dataGradeItem = new DataGradeItem();
        dataGradeItem.setId(String.valueOf(dy.getPkValue()));
        dataGradeItem.setUniqueCode(dy.getString("uniquecode"));
        dataGradeItem.setName(dy.getString("name"));
        dataGradeItem.setParentId(parentId);
        dataGradeItem.setItemCategory(itemCategory);
        dataGradeItem.setDescription(dy.getString("description"));
        dataGradeItem.setExample(dy.getString("description"));
        try {
            DataGradeTableVO dataGradeParam = (DataGradeTableVO)HRJSONUtils.cast((String)dy.getString("datagradeparam"), DataGradeTableVO.class);
            ParamVO head = dataGradeParam.getHead();
            List condition = head.getCondition();
            ArrayList<ParamItem> paramItems = new ArrayList<ParamItem>(condition.size());
            for (EntryVO entryVO : condition) {
                DataGradeParamTypeEnum gradeParamTypeEnum = DataGradeParamTypeEnum.getTypeEnumByCode(entryVO.getPropsName());
                if (Objects.isNull((Object)gradeParamTypeEnum)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7\u53c2\u6570\u7c7b\u578b\u89e3\u6790\u5931\u8d25\u3002", (String)"DataGradeItem_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                }
                paramItems.add(new ParamItem(gradeParamTypeEnum.getCode(), entryVO.getName(), gradeParamTypeEnum.getAlias().loadKDString(), entryVO.getBasedatafield()));
            }
            dataGradeItem.setDataGradeParams(paramItems);
            List result = head.getResult();
            HashMap<String, ReturnItem> returnItemMap = new HashMap<String, ReturnItem>(result.size());
            for (EntryVO entryVO : result) {
                DataGradeParamTypeEnum gradeParamTypeEnum = DataGradeParamTypeEnum.getTypeEnumByCode(entryVO.getPropsName());
                if (Objects.isNull((Object)gradeParamTypeEnum)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7\u7ed3\u679c\u7c7b\u578b\u89e3\u6790\u5931\u8d25\u3002", (String)"DataGradeItem_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                }
                returnItemMap.put(entryVO.getName(), new ReturnItem(gradeParamTypeEnum.getCode(), entryVO.getName(), entryVO.getName(), entryVO.getName()));
            }
            dataGradeItem.setReturnDataMap(returnItemMap);
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7\u53c2\u6570\u89e3\u6790\u5931\u8d25\u3002", (String)"DataGradeItem_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        return dataGradeItem;
    }
}

