/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.entity.item;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.service.formula.entity.freemarker.FormulaDescFreemarkerVO;
import kd.hr.hbp.business.service.formula.entity.item.ParamItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.helper.FormulaDataServiceHelper;
import kd.hr.hbp.business.util.FreemarkerUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class FunctionItem
extends TreeNodeItem {
    private static final long serialVersionUID = 1921489792113949615L;
    private static final String TEMPLATE_NAME = "FormulaEditDesc";
    private String funkey;
    private String funcDataType;
    private String description;
    private String define;
    private String example;
    private boolean isCustomFunction;
    private List<ParamItem> params;
    private Set<String> importPackages;
    private String funcexp;
    protected List<FunctionItem> children;
    private String funcDescription;
    private String funcFullName;

    public String getFuncDescription() {
        return this.funcDescription;
    }

    public void setFuncDescription(String funcDescription) {
        this.funcDescription = funcDescription;
    }

    public String getFunkey() {
        return this.funkey;
    }

    public void setFunkey(String funkey) {
        this.funkey = funkey;
    }

    public String getFuncexp() {
        return this.funcexp;
    }

    public void setFuncexp(String funcexp) {
        this.funcexp = funcexp;
    }

    public Set<String> getImportPackages() {
        return this.importPackages;
    }

    public void setImportPackages(Set<String> importPackages) {
        this.importPackages = importPackages;
    }

    public List<FunctionItem> getChildren() {
        return this.children;
    }

    public void setChildren(List<FunctionItem> children) {
        this.children = children;
    }

    public FunctionItem() {
    }

    public String getFuncFullName() {
        return this.funcFullName;
    }

    public void setFuncFullName(String funcFullName) {
        this.funcFullName = funcFullName;
    }

    public FunctionItem(String itemCategory, String id, String parentId, String name, String uniqueCode, String funcDataType, String description, String define, String example, List<ParamItem> params) {
        this(itemCategory, id, parentId, name, uniqueCode, funcDataType, description, define, example, false, params);
    }

    public FunctionItem(String itemCategory, String id, String parentId, String name, String uniqueCode, String funcDataType, String description, String define, String example, boolean isCustomFunction, List<ParamItem> params) {
        super(itemCategory, id, parentId, name, uniqueCode);
        this.funcDataType = funcDataType;
        this.description = description;
        this.define = define;
        this.example = example;
        this.isCustomFunction = isCustomFunction;
        this.params = params;
    }

    public String getFuncDataType() {
        return this.funcDataType;
    }

    public void setFuncDataType(String funcDataType) {
        this.funcDataType = funcDataType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefine() {
        return this.define;
    }

    public void setDefine(String define) {
        this.define = define;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public List<ParamItem> getParams() {
        return this.params;
    }

    public void setParams(List<ParamItem> params) {
        this.params = params;
    }

    public boolean isCustomFunction() {
        return this.isCustomFunction;
    }

    public void setCustomFunction(boolean customFunction) {
        this.isCustomFunction = customFunction;
    }

    public static FunctionItem getFunctionItem(IDataModel model) {
        FunctionItem functionItem = new FunctionItem();
        functionItem.setItemCategory("FC");
        functionItem.setId(String.valueOf(model.getValue("id")));
        DynamicObject group = (DynamicObject)model.getValue("group");
        if (Objects.nonNull(group)) {
            functionItem.setParentId(group.getString("number"));
        }
        functionItem.setName(String.valueOf(model.getValue("name")));
        functionItem.setUniqueCode(String.valueOf(model.getValue("uniqueCode")));
        functionItem.setFuncDataType(String.valueOf(model.getValue("funcdatatype")));
        functionItem.setDescription(String.valueOf(model.getValue("description")));
        functionItem.setDefine(String.valueOf(model.getValue("define")));
        functionItem.setExample(String.valueOf(model.getValue("example")));
        functionItem.setParams(FormulaDataServiceHelper.getParamItems(model.getEntryEntity("params")));
        functionItem.setShow("1".equals(String.valueOf(model.getValue("enable"))) && "C".equals(String.valueOf(model.getValue("status"))));
        return functionItem;
    }

    public static FunctionItem getFunctionItem(DynamicObject dy) {
        FunctionItem functionItem = new FunctionItem();
        functionItem.setItemCategory("FC");
        functionItem.setId(String.valueOf(dy.getLong("id")));
        functionItem.setParentId("FC_" + dy.getString("group.number"));
        functionItem.setName(String.valueOf(dy.getString("name")));
        functionItem.setUniqueCode(String.valueOf(dy.getString("uniqueCode")));
        functionItem.setFuncDataType(String.valueOf(dy.getString("funcdatatype")));
        functionItem.setDescription(String.valueOf(dy.getString("description")));
        functionItem.setDefine(String.valueOf(dy.getString("define")));
        functionItem.setExample(String.valueOf(dy.getString("example")));
        functionItem.setParams(FormulaDataServiceHelper.getParamItems(dy.getDynamicObjectCollection("params")));
        functionItem.setShow("1".equals(dy.getString("enable")) && "C".equals(dy.getString("status")));
        return functionItem;
    }

    public static FunctionItem buildFunctionItem(DynamicObject dy) {
        DynamicObjectCollection importEntry;
        FunctionItem functionItem = new FunctionItem();
        functionItem.setParentId(dy.getString("group.number"));
        functionItem.setParentName(dy.getString("group.name"));
        functionItem.setId(String.valueOf(dy.getLong("id")));
        functionItem.setFunkey(dy.getString("funkey"));
        functionItem.setName(dy.getString("name"));
        functionItem.setUniqueCode(dy.getString("uniqueCode"));
        functionItem.setFuncDataType(dy.getString("funcdatatype"));
        functionItem.setDescription(dy.containsProperty("description") ? dy.getString("description") : "");
        functionItem.setDefine(dy.getString("define"));
        functionItem.setExample(dy.containsProperty("example") ? dy.getString("example") : "");
        functionItem.setParams(FormulaDataServiceHelper.getParamItems(dy.getDynamicObjectCollection("params")));
        DynamicObjectCollection dynamicObjectCollection = importEntry = dy.containsProperty("importentry") ? dy.getDynamicObjectCollection("importentry") : null;
        if (importEntry != null && importEntry.size() > 0) {
            HashSet<String> importPackages = new HashSet<String>(importEntry.size());
            for (DynamicObject entry : importEntry) {
                String packageName = entry.getString("importcode");
                if (!HRStringUtils.isNotEmpty((String)packageName)) continue;
                importPackages.add(packageName.trim());
            }
            functionItem.setImportPackages(importPackages);
        }
        functionItem.setFuncexp(dy.containsProperty("funcexp") ? dy.getString("funcexp") : "");
        try {
            functionItem.setFuncDescription(StringUtils.isNotEmpty((CharSequence)functionItem.getExample()) ? new FreemarkerUtil(FunctionItem.class, "/formula/template").process(new FormulaDescFreemarkerVO(functionItem), TEMPLATE_NAME) : "");
        }
        catch (Exception exception) {
            throw new KDBizException("freemarker_analysis_error:" + exception.getMessage());
        }
        StringBuilder value = new StringBuilder();
        value.append(functionItem.getFunkey());
        FunctionItem.appendParams(value, functionItem.getParams());
        value.append(')');
        functionItem.setFuncFullName(value.toString());
        return functionItem;
    }

    public static void appendParams(StringBuilder value, List<ParamItem> paramList) {
        value.append('(');
        if (paramList != null && paramList.size() > 0) {
            int size = paramList.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    value.append(',').append(paramList.get(i).getParamName());
                    continue;
                }
                value.append(paramList.get(i).getParamName());
            }
        }
    }
}

