/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.enums;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.LocaleString;
import kd.hr.hbp.business.service.formula.entity.HBPI18NParam;

public enum DataTypeEnum {
    OBJECT("OBJECT", new HBPI18NParam("OBJECT", "DataTypeEnum_14", "hrmp-hbp-business")),
    NUM("NUM", new HBPI18NParam("NUM", "DataTypeEnum_0", "hrmp-hbp-business")),
    TEXT("TEXT", new HBPI18NParam("TEXT", "DataTypeEnum_1", "hrmp-hbp-business")),
    BOOLEAN("BOOLEAN", new HBPI18NParam("BOOLEAN", "DataTypeEnum_2", "hrmp-hbp-business")),
    INT("INT", new HBPI18NParam("INT", "DataTypeEnum_3", "hrmp-hbp-business")),
    DATE("DATE", new HBPI18NParam("DATE", "DataTypeEnum_4", "hrmp-hbp-business")),
    MONEY("MONEY", new HBPI18NParam("MONEY", "DataTypeEnum_5", "hrmp-hbp-business")),
    ARRAY_NUM("ARR_NUM", new HBPI18NParam("ARR_NUM", "DataTypeEnum_6", "hrmp-hbp-business")),
    ARRAY_STRING("ARR_TEXT", new HBPI18NParam("ARR_TEXT", "DataTypeEnum_7", "hrmp-hbp-business")),
    ARRAY_BOOLEAN("ARR_BOOLEAN", new HBPI18NParam("ARR_BOOLEAN", "DataTypeEnum_8", "hrmp-hbp-business")),
    ARRAY_INT("ARR_INT", new HBPI18NParam("ARR_INT", "DataTypeEnum_9", "hrmp-hbp-business")),
    ARRAY_DATE("ARR_DATE", new HBPI18NParam("ARR_DATE", "DataTypeEnum_10", "hrmp-hbp-business")),
    ARRAY_OBJECT("ARR_OBJ", new HBPI18NParam("ARR_OBJ", "DataTypeEnum_13", "hrmp-hbp-business")),
    BASE("BASE", new HBPI18NParam("BASE", "DataTypeEnum_11", "hrmp-hbp-business")),
    NULL("NULL", new HBPI18NParam("NULL", "DataTypeEnum_12", "hrmp-hbp-business")),
    DATETIME("DATETIME", new HBPI18NParam("DATETIME", "DataTypeEnum_15", "hrmp-hbp-business"));

    private final String code;
    private final HBPI18NParam alias;
    private static final Map<String, DataTypeEnum> ALIAS_CACHE_MAP;
    private static long LAST_UPDATE_TIME;
    private static final long UPDATE_INTERVAL = 600000L;
    private static final Map<String, DataTypeEnum> ARRAY_TYPE;

    private DataTypeEnum(String code, HBPI18NParam alias) {
        this.code = code;
        this.alias = alias;
    }

    public String getCode() {
        return this.code;
    }

    public String getAlias() {
        return this.alias.loadKDString();
    }

    public static DataTypeEnum getDataType(String name) {
        DataTypeEnum dataType = null;
        if ("string".equalsIgnoreCase(name) || "text".equalsIgnoreCase(name)) {
            dataType = TEXT;
        } else if ("decimal".equalsIgnoreCase(name) || "numberic".equalsIgnoreCase(name) || "bigdecimal".equalsIgnoreCase(name) || "num".equalsIgnoreCase(name) || "number".equalsIgnoreCase(name)) {
            dataType = NUM;
        } else if ("boolean".equalsIgnoreCase(name) || "bool".equalsIgnoreCase(name)) {
            dataType = BOOLEAN;
        } else if ("integer".equalsIgnoreCase(name) || "int".equalsIgnoreCase(name)) {
            dataType = INT;
        } else if ("date".equalsIgnoreCase(name)) {
            dataType = DATE;
        } else if ("datetime".equalsIgnoreCase(name)) {
            dataType = DATETIME;
        } else if ("object".equalsIgnoreCase(name)) {
            dataType = OBJECT;
        } else if ("array_num".equalsIgnoreCase(name) || "BigDecimal[]".equalsIgnoreCase(name)) {
            dataType = ARRAY_NUM;
        } else if ("array_string".equalsIgnoreCase(name) || "array_text".equalsIgnoreCase(name) || "String[]".equalsIgnoreCase(name)) {
            dataType = ARRAY_STRING;
        } else if ("array_boolean".equalsIgnoreCase(name) || "Boolean[]".equalsIgnoreCase(name) || "boolean[]".equalsIgnoreCase(name)) {
            dataType = ARRAY_BOOLEAN;
        } else if ("array_int".equalsIgnoreCase(name) || "Integer[]".equalsIgnoreCase(name) || "int[]".equalsIgnoreCase(name)) {
            dataType = ARRAY_INT;
        } else if ("array_date".equalsIgnoreCase(name) || "Date[]".equalsIgnoreCase(name)) {
            dataType = ARRAY_DATE;
        } else if ("array_obj".equalsIgnoreCase(name) || "array_object".equalsIgnoreCase(name) || "Object[]".equalsIgnoreCase(name)) {
            dataType = ARRAY_OBJECT;
        } else if ("amount".equalsIgnoreCase(name) || "money".equalsIgnoreCase(name)) {
            dataType = MONEY;
        } else if ("base".equalsIgnoreCase(name)) {
            dataType = BASE;
        }
        return dataType;
    }

    public static DataTypeEnum changeArrayToSingleType(DataTypeEnum arrayType) {
        if (ARRAY_DATE == arrayType) {
            return DATE;
        }
        if (ARRAY_INT == arrayType) {
            return INT;
        }
        if (ARRAY_BOOLEAN == arrayType) {
            return BOOLEAN;
        }
        if (ARRAY_STRING == arrayType) {
            return TEXT;
        }
        if (ARRAY_NUM == arrayType) {
            return NUM;
        }
        if (ARRAY_OBJECT == arrayType) {
            return OBJECT;
        }
        return arrayType;
    }

    public static boolean isArrayType(DataTypeEnum type) {
        if (Objects.isNull((Object)type)) {
            return false;
        }
        return ARRAY_TYPE.containsKey(type.getCode());
    }

    public static Map<String, DataTypeEnum> getArrayType() {
        return ARRAY_TYPE;
    }

    public static boolean checkAndChangeIsNumType(DataTypeEnum dataType1, DataTypeEnum dataType2) {
        boolean type1IsNum = dataType1 == INT || dataType1 == NUM || dataType1 == MONEY;
        boolean type2IsNum = dataType2 == INT || dataType2 == NUM || dataType2 == MONEY;
        return type1IsNum && type2IsNum;
    }

    public static DataTypeEnum getByAlias(String alias) {
        return DataTypeEnum.getAliasCacheMap().get(alias);
    }

    public static Map<String, DataTypeEnum> getAliasCacheMap() {
        if (System.currentTimeMillis() - LAST_UPDATE_TIME >= 600000L) {
            LAST_UPDATE_TIME = System.currentTimeMillis();
            for (DataTypeEnum dataTypeEnum : DataTypeEnum.values()) {
                HBPI18NParam alias = dataTypeEnum.alias;
                LocaleString localeString = alias.getLocaleString();
                localeString.values().forEach(lang -> ALIAS_CACHE_MAP.put((String)lang, dataTypeEnum));
            }
        }
        return ALIAS_CACHE_MAP;
    }

    static {
        ALIAS_CACHE_MAP = Maps.newHashMapWithExpectedSize((int)16);
        LAST_UPDATE_TIME = 0L;
        ARRAY_TYPE = new HashMap<String, DataTypeEnum>();
        ARRAY_TYPE.put(ARRAY_NUM.getCode(), ARRAY_NUM);
        ARRAY_TYPE.put(ARRAY_STRING.getCode(), ARRAY_STRING);
        ARRAY_TYPE.put(ARRAY_BOOLEAN.getCode(), ARRAY_BOOLEAN);
        ARRAY_TYPE.put(ARRAY_INT.getCode(), ARRAY_INT);
        ARRAY_TYPE.put(ARRAY_DATE.getCode(), ARRAY_DATE);
        ARRAY_TYPE.put(ARRAY_OBJECT.getCode(), ARRAY_OBJECT);
    }
}

