/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.enums;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import kd.hr.hbp.business.service.formula.entity.HBPI18NParam;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public enum InvokeMethodEnum {
    LENGTH("LENGTH", DataTypeEnum.INT, new HBPI18NParam(".LENGTH", "InvokeMethodEnum_0", "hrmp-hbp-business"), ".length", new HashSet<DataTypeEnum>(DataTypeEnum.getArrayType().values()), "Integer.valueOf(%s)");

    private final String number;
    private final Set<DataTypeEnum> invokeDataType;
    private final DataTypeEnum returnDataType;
    private final HBPI18NParam alias;
    private final String code;
    private final String afterBoxCode;
    private static final Map<String, InvokeMethodEnum> CACHE_MAP;

    private InvokeMethodEnum(String number, DataTypeEnum returnDataType, HBPI18NParam alias, String code, Set<DataTypeEnum> invokeDataType, String afterBoxCode) {
        this.number = number;
        this.returnDataType = returnDataType;
        this.alias = alias;
        this.code = code;
        this.invokeDataType = invokeDataType;
        this.afterBoxCode = afterBoxCode;
    }

    public static InvokeMethodEnum getInvokeMethodEnum(String name) {
        return CACHE_MAP.get(name);
    }

    public String getNumber() {
        return this.number;
    }

    public String getAlias() {
        return this.alias.loadKDString();
    }

    public static Map<String, InvokeMethodEnum> getCacheMap() {
        return CACHE_MAP;
    }

    public DataTypeEnum getReturnDataType() {
        return this.returnDataType;
    }

    public String getCode() {
        return this.code;
    }

    public Set<DataTypeEnum> getInvokeDataType() {
        return Objects.nonNull(this.invokeDataType) ? this.invokeDataType : new HashSet<DataTypeEnum>();
    }

    public String getAfterBoxCode() {
        return this.afterBoxCode;
    }

    public static boolean isStartWithInvokeMethod(String text) {
        if (HRStringUtils.isNotEmpty((String)text)) {
            for (String aliasOrNumber : CACHE_MAP.keySet()) {
                if (!text.startsWith(aliasOrNumber)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        CACHE_MAP = new HashMap<String, InvokeMethodEnum>(InvokeMethodEnum.values().length);
        Stream.of(InvokeMethodEnum.values()).forEach(iv -> {
            CACHE_MAP.put(iv.getNumber(), (InvokeMethodEnum)((Object)iv));
            CACHE_MAP.put(iv.getAlias(), (InvokeMethodEnum)((Object)iv));
        });
    }
}

