/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.enums;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.hr.hbp.business.service.formula.entity.HBPI18NParam;
import kd.hr.hbp.business.service.formula.enums.FormulaKeyEnum;

public enum OperatorEnum {
    PLUS("PLUS", "+", "plus"),
    SUBTRACT("SUBTRACT", "-", "subtract"),
    MULTIPLY("MULTIPLY", "*", "multiply"),
    DIVIDE("DIVIDE", "/", "divide"),
    LPARENTHESES("LPARENTHESES", "(", ""),
    RPARENTHESES("RPARENTHESES", ")", ""),
    LBRACKET("LBRACKET", "[", ""),
    RBRACKET("RBRACKET", "]", ""),
    EQUAL("EQUAL", "=", "isEqual"),
    UNEQUAL("UNEQUAL", "!=", "unEqual"),
    GT("GT", ">", "gt"),
    LT("LT", "<", "lt"),
    GTOREQUAL("GTOREQUAL", ">=", "gtOrEqual"),
    LTOREQUAL("LTOREQUAL", "<=", "ltOrEqual"),
    QUOT("QUOT", "\"", ""),
    COMMA("COMMA", ",", ""),
    EMPTY("EMPTY", " ", ""),
    SPOT("SPOT", ".", ""),
    ASSIGNMENT("ASSIGN", FormulaKeyEnum.ASSIGN.getAlias(), ""),
    AND(FormulaKeyEnum.AND.getCode(), FormulaKeyEnum.AND.getAlias(), "&&"),
    OR(FormulaKeyEnum.OR.getCode(), FormulaKeyEnum.OR.getAlias(), "||"),
    RESULT(FormulaKeyEnum.RESULT.getCode(), FormulaKeyEnum.RESULT.getAlias(), "result"),
    CONTAIN(FormulaKeyEnum.LIKE.getCode(), FormulaKeyEnum.LIKE.getAlias(), "indexOf");

    private static final Map<String, OperatorEnum> ALIAS_CACHE_MAP;
    private static long LAST_UPDATE_TIME;
    private static final long UPDATE_INTERVAL = 600000L;
    private final String name;
    private final String alias;
    private final String code;

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getCode() {
        return this.code;
    }

    private OperatorEnum(String name, String alias, String code) {
        this.name = name;
        this.alias = alias;
        this.code = code;
    }

    public static Map<String, OperatorEnum> getAliasCacheMap() {
        if (System.currentTimeMillis() - LAST_UPDATE_TIME >= 600000L) {
            LAST_UPDATE_TIME = System.currentTimeMillis();
            Map<String, FormulaKeyEnum> formulaKeyCacheMap = FormulaKeyEnum.getCodeCacheMap();
            for (OperatorEnum operationEnum : OperatorEnum.values()) {
                FormulaKeyEnum formulaKeyEnum = formulaKeyCacheMap.get(operationEnum.getName());
                if (formulaKeyEnum != null) {
                    HBPI18NParam locateParam = formulaKeyEnum.getLocateParam();
                    LocaleString localeString = locateParam.getLocaleString();
                    localeString.values().forEach(lang -> ALIAS_CACHE_MAP.put((String)lang, operationEnum));
                    continue;
                }
                ALIAS_CACHE_MAP.put(operationEnum.getAlias(), operationEnum);
            }
        }
        return ALIAS_CACHE_MAP;
    }

    static {
        ALIAS_CACHE_MAP = Maps.newHashMapWithExpectedSize((int)16);
        LAST_UPDATE_TIME = 0L;
    }
}

