/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.helper;

import java.util.Date;
import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprParser;
import kd.bos.formula.excel.MapExecuteContext;
import kd.hr.hbp.business.function.helper.HRFunctionHelper;
import kd.hr.hbp.common.util.DateUtils;

public class ExprExecutor {
    private String funCode;
    private String formateString;

    public ExprExecutor(String funCode, String formateString) {
        this.funCode = funCode;
        this.formateString = formateString;
    }

    public Object execute() {
        Expr expr = ExprParser.parse((String)this.formateString);
        MapExecuteContext context = new MapExecuteContext();
        HRFunctionHelper.getMapFunc().values().forEach(arg_0 -> ((MapExecuteContext)context).addUDFunction(arg_0));
        return expr.execute((ExecuteContext)context);
    }

    public Object execute(Object ... args) {
        this.rebuildFormatString(args);
        String expression = this.getExpression(args);
        if (this.funCode.equalsIgnoreCase("IF")) {
            expression = expression.replace("\"" + args[0] + "\"", args[0].toString());
        }
        Expr expr = ExprParser.parse((String)expression);
        MapExecuteContext context = new MapExecuteContext();
        HRFunctionHelper.getMapFunc().values().forEach(arg_0 -> ((MapExecuteContext)context).addUDFunction(arg_0));
        return expr.execute((ExecuteContext)context);
    }

    private void rebuildFormatString(Object ... args) {
        StringBuilder params = new StringBuilder();
        for (int idx = 0; idx < args.length; ++idx) {
            params.append("%s");
            if (idx >= args.length - 1) continue;
            params.append(" , ");
        }
        this.formateString = this.formateString.replace(this.formateString.substring(this.formateString.indexOf("(") + 1, this.formateString.indexOf(")")), params.toString());
    }

    public String getExpression(Object ... args) {
        if (args != null && args.length > 0) {
            Object[] stringArgs = new String[args.length];
            for (int idx = 0; idx < args.length; ++idx) {
                stringArgs[idx] = args[idx] instanceof Date ? "DATE(\"" + DateUtils.getDate((Date)((Date)args[idx])) + "\")" : (args[idx] instanceof String ? "\"" + this.processString((String)args[idx]) + "\"" : String.valueOf(args[idx]));
            }
            return String.format(this.formateString, stringArgs);
        }
        return this.formateString;
    }

    public String getFunCode() {
        return this.funCode;
    }

    public void setFunCode(String funCode) {
        this.funCode = funCode;
    }

    private String processString(String str) {
        if (str != null) {
            return str.replace("\"", "\"&'\"'&\"");
        }
        return null;
    }
}

