/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.helper;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.formula.entity.freemarker.FormulaFreemarkerVOInterface;

public class FormulaFreemarkerHelper {
    private static final Log LOGGER = LogFactory.getLog(FormulaFreemarkerHelper.class);
    private static final Configuration FORMULA_TEMP_CFG = new Configuration(Configuration.VERSION_2_3_22);
    private static final String TEMPLATE_ROOT_DIR = "/formula/template";

    private static Template getTemplate(String templateName) throws IOException {
        return FORMULA_TEMP_CFG.getTemplate(templateName);
    }

    private static String analysisTemplate(Object paramValues, Template template) throws IOException, TemplateException {
        StringWriter writer = new StringWriter();
        template.process(paramValues, (Writer)writer);
        return ((Object)writer).toString();
    }

    public static String getFreemarkerString(FormulaFreemarkerVOInterface data, String templateName) {
        try {
            return FormulaFreemarkerHelper.analysisTemplate(data, FormulaFreemarkerHelper.getTemplate(templateName));
        }
        catch (TemplateException | IOException e) {
            LOGGER.error("freemarker_analysis_error:", e);
            throw new KDBizException("freemarker_analysis_error:" + e.getMessage());
        }
    }

    static {
        LOGGER.info("formula_temp_cfg init start...");
        FORMULA_TEMP_CFG.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(Configuration.VERSION_2_3_22));
        FORMULA_TEMP_CFG.setClassForTemplateLoading(FormulaFreemarkerHelper.class, TEMPLATE_ROOT_DIR);
    }
}

