/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.helper;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.formula.entity.FormulaInfo;
import kd.hr.hbp.business.service.formula.entity.floatcontrol.SelectItem;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.entity.item.Item;
import kd.hr.hbp.business.service.formula.entity.node.OriginalNode;
import kd.hr.hbp.business.service.formula.enums.FormulaKeyEnum;
import kd.hr.hbp.business.service.formula.utils.FormulaUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class FormulaReplaceHelper {
    private static final char NEWLINE = '\n';

    public static void replaceToUniqueKey(FormulaInfo formulaInfo) {
        Map<Integer, List<OriginalNode>> lineUniqueKeyNodes;
        String formulaText = formulaInfo.getOriginalCode();
        Object[] originalLines = formulaText.split("\\r?\\n");
        String uniqueKeyCode = formulaInfo.getOriginalCode();
        List<OriginalNode> originalKeys = formulaInfo.getOriginalKeys();
        if (Objects.nonNull(originalKeys) && !(lineUniqueKeyNodes = originalKeys.stream().sorted(Comparator.comparingInt(OriginalNode::getStartColumnIndex)).collect(Collectors.groupingBy(OriginalNode::getLineIndex))).isEmpty()) {
            for (int lineIndex = 0; lineIndex < originalLines.length; ++lineIndex) {
                List<OriginalNode> uniqueKeyNodes = lineUniqueKeyNodes.get(lineIndex);
                if (Objects.isNull(uniqueKeyNodes) || uniqueKeyNodes.isEmpty()) continue;
                StringBuilder newLineText = new StringBuilder();
                String currentLine = ((String)originalLines[lineIndex]).replace("\t", "    ");
                OriginalNode lastKeyNode = null;
                for (OriginalNode node : uniqueKeyNodes) {
                    int lastEndIndex = -1;
                    if (lastKeyNode != null) {
                        lastEndIndex = lastKeyNode.getEndColumnIndex();
                    }
                    lastKeyNode = node;
                    newLineText.append(currentLine, lastEndIndex + 1, node.getStartColumnIndex());
                    newLineText.append(node.getUniqueKey());
                }
                if (lastKeyNode != null && lastKeyNode.getEndColumnIndex() != currentLine.length()) {
                    newLineText.append(currentLine, lastKeyNode.getEndColumnIndex() + 1, currentLine.length());
                }
                originalLines[lineIndex] = newLineText.toString();
            }
            uniqueKeyCode = StringUtils.join((Object[])originalLines, (char)'\n');
        }
        formulaInfo.setUniqueKeyCode(uniqueKeyCode);
    }

    public static String transfer(List<OriginalNode> nodes, Map<String, String> uniqueCodeToNameMap) {
        StringBuilder transferString = new StringBuilder();
        int lastNodeEndIndex = 0;
        int lastLineIndex = 0;
        for (OriginalNode node : nodes) {
            if (lastLineIndex != node.getLineIndex()) {
                transferString.append('\n');
                lastLineIndex = node.getLineIndex();
            }
            int startColumnIndex = node.getStartColumnIndex();
            for (int index = 0; index < startColumnIndex - lastNodeEndIndex; ++index) {
                transferString.append(' ');
            }
            String showValue = uniqueCodeToNameMap.get(node.getNodeText());
            if (HRStringUtils.isNotEmpty((String)showValue)) {
                transferString.append(showValue);
            } else {
                transferString.append(node.getNodeText());
            }
            lastNodeEndIndex = node.getEndColumnIndex();
        }
        return transferString.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> getUniqueCodeToDisplayNameMap(DynamicObject formulaDy, Collection<? extends Item> functionItems, Collection<? extends Item> dataGradeItems, Collection<? extends Item> calItems) {
        String enumUniqueCodes;
        MainEntityType dataEntityType;
        HashMap uniqueCodeDisplayNameMap = Maps.newHashMapWithExpectedSize((int)16);
        if (formulaDy == null) {
            return uniqueCodeDisplayNameMap;
        }
        String baseDataUniqueCodes = formulaDy.getString("dependentbasedata");
        Map<String, CalItem> uniqueCodeToCalItemMap = null;
        if (calItems != null) {
            uniqueCodeToCalItemMap = calItems.stream().filter(calItem -> calItem instanceof CalItem).map(calItem -> (CalItem)calItem).collect(Collectors.toMap(Item::getUniqueCode, calItem -> calItem));
        }
        FormulaReplaceHelper.putIntoUniqueCodeDisplayNameMap(uniqueCodeDisplayNameMap, functionItems);
        FormulaReplaceHelper.putIntoUniqueCodeDisplayNameMap(uniqueCodeDisplayNameMap, dataGradeItems);
        FormulaReplaceHelper.putIntoUniqueCodeDisplayNameMap(uniqueCodeDisplayNameMap, calItems);
        if (HRStringUtils.isNotEmpty((String)baseDataUniqueCodes)) {
            String[] baseDataUniqueCodeArray = baseDataUniqueCodes.split(",");
            HashMap baseDataGroupMap = Maps.newHashMapWithExpectedSize((int)baseDataUniqueCodeArray.length);
            HashBasedTable baseDataUniqueCodeIdTable = HashBasedTable.create();
            for (String baseDataUniqueCode : baseDataUniqueCodeArray) {
                String[] splitValue = baseDataUniqueCode.substring(1, baseDataUniqueCode.length() - 1).split("\\.");
                baseDataGroupMap.putIfAbsent(splitValue[0], Lists.newArrayListWithExpectedSize((int)baseDataUniqueCodeArray.length));
                baseDataGroupMap.computeIfPresent(splitValue[0], (oldKey, list) -> {
                    try {
                        list.add(Long.parseLong(splitValue[2]));
                    }
                    catch (Exception e) {
                        list.add(splitValue[2]);
                    }
                    return list;
                });
                baseDataUniqueCodeIdTable.put((Object)splitValue[0], (Object)splitValue[2], (Object)baseDataUniqueCode);
            }
            for (Map.Entry entry2 : baseDataGroupMap.entrySet()) {
                String calItemUniqueCode = (String)entry2.getKey();
                if (uniqueCodeToCalItemMap == null) break;
                CalItem calItem2 = uniqueCodeToCalItemMap.get(calItemUniqueCode);
                if (calItem2 == null) continue;
                dataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)calItem2.getEntityNumber());
                String propertyFieldStr = calItem2.getPropertyField();
                HRBaseServiceHelper helper = new HRBaseServiceHelper(calItem2.getEntityNumber());
                ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
                QFilter idFilter = new QFilter(primaryKey.getName(), "in", entry2.getValue());
                DynamicObject[] baseDataArray = helper.queryOriginalArray(primaryKey.getName() + "," + propertyFieldStr, new QFilter[]{idFilter});
                Map row = baseDataUniqueCodeIdTable.row((Object)calItemUniqueCode);
                for (DynamicObject baseData : baseDataArray) {
                    String uniqueCode = (String)row.get(baseData.getString(primaryKey.getName()));
                    SelectItem selectItem = SelectItem.getSelectItemByBaseData(calItem2, baseData);
                    uniqueCodeDisplayNameMap.put(uniqueCode, selectItem.getShowKey());
                }
            }
        }
        if (HRStringUtils.isNotEmpty((String)(enumUniqueCodes = formulaDy.getString("dependentenum")))) {
            void var11_15;
            String[] enumUniqueCodeArray;
            String[] stringArray = enumUniqueCodeArray = enumUniqueCodes.split(",");
            int n = stringArray.length;
            boolean bl = false;
            while (var11_15 < n) {
                String enumUniqueCode = stringArray[var11_15];
                String[] splitValue = enumUniqueCode.substring(1, enumUniqueCode.length() - 1).split("\\.");
                dataEntityType = EntityMetadataCache.getDataEntityType((String)splitValue[0]);
                DynamicProperty property = dataEntityType.getProperty(splitValue[1]);
                if (property instanceof ComboProp) {
                    ComboProp comboProp = (ComboProp)property;
                    String itemByName = comboProp.getItemByName(splitValue[2]);
                    uniqueCodeDisplayNameMap.put(enumUniqueCode, SelectItem.getShowKey(itemByName));
                }
                ++var11_15;
            }
        }
        uniqueCodeDisplayNameMap.putAll(FormulaKeyEnum.getCodeCacheMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((FormulaKeyEnum)((Object)((Object)((Object)entry.getValue())))).getAlias())));
        return uniqueCodeDisplayNameMap;
    }

    private static void putIntoUniqueCodeDisplayNameMap(Map<String, String> uniqueCodeDisplayNameMap, Collection<? extends Item> items) {
        if (uniqueCodeDisplayNameMap == null) {
            return;
        }
        if (items != null) {
            for (Item item : items) {
                uniqueCodeDisplayNameMap.put(item.getUniqueCode(), FormulaUtils.getItemMapKey(item.getItemCategory(), item.getName()));
            }
        }
    }
}

