/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.entity.item.Item;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.ItemCategoryEnum;
import kd.hr.hbp.business.service.formula.utils.FormulaUtils;

public class FormulaTreeNodeUtils {
    private static final Log LOGGER = LogFactory.getLog(FormulaTreeNodeUtils.class);

    public static Optional<List<TreeNode>> loadTreeNodeItemList(List<TreeNodeItem> treeNodeItemList) {
        if (CollectionUtils.isEmpty(treeNodeItemList)) {
            LOGGER.warn("loadTreeNodeItemList_item_is_empty");
            return Optional.empty();
        }
        Set<String> notShowIds = treeNodeItemList.stream().filter(treeNodeItem -> !treeNodeItem.isShow()).map(Item::getId).collect(Collectors.toSet());
        Set allIds = treeNodeItemList.stream().map(Item::getId).collect(Collectors.toSet());
        treeNodeItemList = treeNodeItemList.stream().filter(node -> node.getUniqueCode() != null).filter(TreeNodeItem::isShow).filter(FormulaUtils.distinctByKey(Item::getUniqueCode)).collect(Collectors.toList());
        ArrayList treeNodes = Lists.newArrayListWithExpectedSize((int)treeNodeItemList.size());
        HashMap parentToChildNodeMap = new HashMap(16);
        for (TreeNodeItem item : treeNodeItemList) {
            FormulaTreeNodeUtils.convertObjToTreeNodeItem(item).ifPresent(nodeItem -> {
                ArrayList<TreeNode> childNodeList = (ArrayList<TreeNode>)parentToChildNodeMap.get(nodeItem.getParentId());
                if (Objects.isNull(childNodeList)) {
                    childNodeList = new ArrayList<TreeNode>(10);
                }
                TreeNode treeNode = new TreeNode(nodeItem.getParentId(), nodeItem.getId(), nodeItem.getName());
                treeNode.setIsOpened(nodeItem.isExpand());
                treeNode.setExpend(nodeItem.isExpand());
                childNodeList.add(treeNode);
                treeNodes.add(treeNode);
                parentToChildNodeMap.put(nodeItem.getParentId(), childNodeList);
            });
        }
        if (CollectionUtils.isEmpty((Collection)treeNodes)) {
            LOGGER.warn("loadTreeNodeItemList_treeNodes_is_empty");
            return Optional.empty();
        }
        for (TreeNode treeNode2 : treeNodes) {
            List childNodes = (List)parentToChildNodeMap.get(treeNode2.getId());
            if (CollectionUtils.isEmpty((Collection)childNodes)) continue;
            treeNode2.addChildren(childNodes);
        }
        LOGGER.info("loadTreeNodeItemList_treeNodes_size_is_{},nodeIdSet_size_is={}", (Object)treeNodes.size(), (Object)allIds.size());
        treeNodes.removeIf(treeNode -> allIds.contains(treeNode.getParentid()));
        LOGGER.info("loadTreeNodeItemList_afterRemove_treeNodes_size_is_{}", (Object)treeNodes.size());
        return Optional.of(FormulaTreeNodeUtils.removeNotShowTreeNodes(treeNodes, notShowIds));
    }

    private static Optional<TreeNodeItem> convertObjToTreeNodeItem(Object obj) {
        if (Objects.nonNull(obj)) {
            TreeNodeItem nodeItem = null;
            if (obj instanceof Map) {
                nodeItem = FormulaUtils.convertMapToObject((Map)obj, TreeNodeItem.class);
            }
            if (obj instanceof TreeNodeItem) {
                nodeItem = (TreeNodeItem)obj;
            }
            return Optional.ofNullable(nodeItem);
        }
        return Optional.empty();
    }

    public static List<TreeNodeItem> getAllParentTreeNodeItem(List<TreeNodeItem> childItems, List<TreeNodeItem> allItems) {
        Set parentIds = childItems.stream().map(TreeNodeItem::getParentId).collect(Collectors.toSet());
        List<TreeNodeItem> parentItems = allItems.stream().filter(treeNodeItem -> Objects.nonNull(treeNodeItem.getId()) && parentIds.contains(treeNodeItem.getId())).peek(treeNodeItem -> treeNodeItem.setExpand(true)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(parentItems)) {
            return parentItems;
        }
        parentItems.addAll(FormulaTreeNodeUtils.getAllParentTreeNodeItem(parentItems, allItems));
        return parentItems;
    }

    public static List<TreeNodeItem> getAllChildTreeNodeItem(List<TreeNodeItem> parentItems, List<TreeNodeItem> allItems) {
        Set parentIds = parentItems.stream().map(Item::getId).collect(Collectors.toSet());
        List<TreeNodeItem> childItems = allItems.stream().filter(treeNodeItem -> Objects.nonNull(treeNodeItem.getParentId()) && parentIds.contains(treeNodeItem.getParentId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(childItems)) {
            return childItems;
        }
        childItems.addAll(FormulaTreeNodeUtils.getAllParentTreeNodeItem(childItems, allItems));
        return childItems;
    }

    public static TreeNodeItem getFunctionRootItem() {
        TreeNodeItem rootItem = new TreeNodeItem("FC", "FC", "", ItemCategoryEnum.FUNCTION.getAlias());
        rootItem.setExpand(true);
        return rootItem;
    }

    public static TreeNodeItem getDataGradeRootItem() {
        TreeNodeItem rootItem = new TreeNodeItem("DG", "DG", "", ItemCategoryEnum.DATA_GRADE.getAlias());
        rootItem.setExpand(true);
        return rootItem;
    }

    public static List<TreeNode> removeNotShowTreeNodes(List<TreeNode> treeNodes, Set<String> notShowIds) {
        Iterator<TreeNode> iterator = treeNodes.iterator();
        while (iterator.hasNext()) {
            TreeNode next = iterator.next();
            if (notShowIds == null) continue;
            if (notShowIds.contains(next.getId()) || notShowIds.contains(next.getParentid())) {
                iterator.remove();
                continue;
            }
            if (next.getChildren() == null || next.getChildren().isEmpty()) continue;
            List<TreeNode> newChildren = FormulaTreeNodeUtils.removeNotShowTreeNodes(next.getChildren(), notShowIds);
            next.setChildren(newChildren);
        }
        return treeNodes;
    }
}

