/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.funcentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.hr.hbp.common.util.HRStringUtils;

class MergeMasterAppIdMapFunction
extends MapFunction {
    private static final long serialVersionUID = -5480919200625236069L;
    private final RowMeta oldMeta;
    private final Map<String, Integer> oldIndexMap;
    private final Map<String, Integer> newIndexMap;

    public MergeMasterAppIdMapFunction(RowMeta oldMeta) {
        int index;
        this.oldMeta = oldMeta;
        Field[] oldFields = oldMeta.getFields();
        this.oldIndexMap = Maps.newHashMapWithExpectedSize((int)oldFields.length);
        RowMeta newRowMeta = this.buildNewRowMeta();
        Field[] newFields = newRowMeta.getFields();
        this.newIndexMap = Maps.newHashMapWithExpectedSize((int)newFields.length);
        for (index = 0; index < oldFields.length; ++index) {
            this.oldIndexMap.put(oldFields[index].getAlias(), index);
        }
        for (index = 0; index < newFields.length; ++index) {
            this.newIndexMap.put(newFields[index].getAlias(), index);
        }
    }

    public Object[] map(Row row) {
        Field[] oldMetaFields;
        Object[] value = new Object[this.newIndexMap.size()];
        for (Field oldMetaField : oldMetaFields = this.oldMeta.getFields()) {
            String fieldAlias = oldMetaField.getAlias();
            if ("bizappid.masterid".equals(fieldAlias)) continue;
            value[this.newIndexMap.get((Object)fieldAlias).intValue()] = row.getString(this.oldIndexMap.get(fieldAlias).intValue());
        }
        String masterAppId = row.getString(this.oldIndexMap.get("bizappid.masterid").intValue());
        if (HRStringUtils.isNotEmpty((String)masterAppId)) {
            value[this.newIndexMap.get((Object)"bizappid").intValue()] = masterAppId;
        }
        return value;
    }

    public RowMeta getResultRowMeta() {
        return this.buildNewRowMeta();
    }

    private RowMeta buildNewRowMeta() {
        Field[] fields = this.oldMeta.getFields();
        ArrayList newFields = Lists.newArrayListWithExpectedSize((int)fields.length);
        for (Field field : fields) {
            if ("bizappid.masterid".equals(field.getAlias())) continue;
            newFields.add(field);
        }
        return new RowMeta(newFields.toArray(new Field[0]));
    }
}

