/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.function;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.formula.excel.BinaryExpr;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprList;
import kd.bos.formula.excel.FunCall;
import kd.bos.formula.excel.Operator;
import kd.bos.formula.excel.Paren;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.function.service.AbstractFunctionExecuteService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.HRStringUtils;

public class FunctionSubPageService {
    private static final Log LOGGER = LogFactory.getLog(FunctionSubPageService.class);
    private final Set<Character> specialChar = Stream.of(Character.valueOf('['), Character.valueOf(']'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('\"'), Character.valueOf(','), Character.valueOf(' '), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('<'), Character.valueOf('!'), Character.valueOf('\"')).collect(Collectors.toSet());
    private final Set<String> specialStr = Stream.of("true", "false", "and", "or", "null", "NULL").collect(Collectors.toSet());
    private static final Pattern numberPattern = Pattern.compile("^([-+])?\\d+(\\.\\d+)?$");
    private static final String FIELD_NAME = "fieldName";
    private static final String FIELD_NUMBER = "fieldNumber";
    private Map<String, List<String>> fileSourceEnumMap = null;

    public Map<String, Object> parseFunctionExpr(StringBuilder errorMsg, String expr, String fieldStr, Map<String, String> baseDataMap, Map<String, String> enumEntityNumMap) {
        return this.parseFunctionExpr(errorMsg, expr, fieldStr, baseDataMap, enumEntityNumMap, null);
    }

    public Map<String, Object> parseFunctionExpr(StringBuilder errorMsg, String expr, String fieldStr, Map<String, String> baseDataMap, Map<String, String> enumEntityNumMap, Map<String, List<String>> fileSourceEnumMap) {
        this.fileSourceEnumMap = fileSourceEnumMap;
        Map fieldMap = Collections.emptyMap();
        if (HRStringUtils.isNotEmpty((String)fieldStr)) {
            fieldMap = (Map)SerializationUtils.fromJsonString((String)fieldStr, Map.class);
        }
        Map<String, Object> resultMap = null;
        try {
            resultMap = this.transferExpr(expr, fieldMap, baseDataMap, enumEntityNumMap, false, errorMsg);
        }
        catch (Exception ex) {
            LOGGER.error("ReportFunctionSubPagePlugin parseFunctionExpr error:", (Throwable)ex);
            errorMsg.append(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u8bed\u6cd5\u3002", (String)"ReportFunctionSubPagePlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
        return resultMap;
    }

    public Map<String, Object> parseFunctionExpr(StringBuilder errorMsg, String expr, String fieldStr) {
        return this.parseFunctionExpr(errorMsg, expr, fieldStr, Maps.newHashMapWithExpectedSize((int)16), Maps.newHashMapWithExpectedSize((int)16));
    }

    public Object preExecuteExpr(String expr, Map<String, Object> paramMap, StringBuilder errorMsg, String functionExecuteServiceClassName) {
        Object result = null;
        try {
            Class<?> serviceClass = Class.forName(functionExecuteServiceClassName);
            AbstractFunctionExecuteService service = (AbstractFunctionExecuteService)serviceClass.newInstance();
            result = service.preExecute(expr, paramMap);
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            errorMsg.append(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u8bed\u6cd5\u3002", (String)"ReportFunctionSubPagePlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    public String replaceFieldName(String parsedExpr, List<Map<String, Object>> fields) {
        if (HRStringUtils.isEmpty((String)parsedExpr) || fields.isEmpty()) {
            return parsedExpr;
        }
        HashMap fieldsMap = Maps.newHashMapWithExpectedSize((int)fields.size());
        HashMap baseDataMap = Maps.newHashMapWithExpectedSize((int)fields.size());
        HashMap enumEntityNumMap = Maps.newHashMapWithExpectedSize((int)fields.size());
        for (Map<String, Object> field : fields) {
            String enumEntityNum;
            String name;
            Object nameObj = field.get(FIELD_NAME);
            if (nameObj instanceof String) {
                name = (String)nameObj;
            } else {
                LocaleString nameLocaleStr = (LocaleString)SerializationUtils.fromJsonString((String)JSONObject.toJSONString((Object)nameObj), LocaleString.class);
                name = nameLocaleStr.getLocaleValue();
            }
            String number = (String)field.get(FIELD_NUMBER);
            fieldsMap.put(number, "[" + name + "]");
            String baseDataNum = (String)field.get("baseDataNum");
            if ((number.endsWith(".name") || number.endsWith(".number")) && HRStringUtils.isNotEmpty((String)baseDataNum)) {
                baseDataMap.put("$" + number + "$", baseDataNum);
            }
            if (!HRStringUtils.isNotEmpty((String)(enumEntityNum = (String)field.get("enumEntityNum")))) continue;
            enumEntityNumMap.put("$" + number + "$", enumEntityNum);
        }
        Map<String, Object> resultMap = this.transferExpr(parsedExpr, fieldsMap, baseDataMap, enumEntityNumMap, true, new StringBuilder());
        if (resultMap == null) {
            return parsedExpr;
        }
        return (String)resultMap.get("viewExpr");
    }

    public Map<String, Object> transferExpr(String expr, Map<String, String> fieldMap, Map<String, String> baseDataMap, Map<String, String> enumEntityNumMap, boolean replaceName, StringBuilder errorMsg) {
        String fieldNum;
        char[] exprArr;
        HashMap baseDataNameOrNumMap = Maps.newHashMapWithExpectedSize((int)16);
        expr = expr.trim();
        expr = expr.replaceAll("\\s+", " ");
        expr = expr.replaceAll("\\s+(\\()", "$1");
        StringBuilder fieldSb = new StringBuilder();
        StringBuilder undefinedFieldNameSb = new StringBuilder();
        HashSet refFieldNums = Sets.newHashSetWithExpectedSize((int)16);
        boolean isUseFunction = false;
        int startIndex = 0;
        int currentIndex = 0;
        boolean isQuotation = false;
        boolean isField = false;
        String firstUnit = null;
        char split = ' ';
        HashMap varMap = Maps.newHashMapWithExpectedSize((int)16);
        int varCount = 1;
        for (char chr : exprArr = expr.toCharArray()) {
            if (this.specialChar.contains(Character.valueOf(chr))) {
                if (firstUnit != null && chr != ' ' && chr != '\"' && chr != '[' && chr != ']') {
                    split = chr;
                }
                if (isField && chr != ']') {
                    fieldSb.append(chr);
                }
                if (chr == '[') {
                    isField = true;
                }
                if (chr == '\"') {
                    if (!replaceName && isQuotation) {
                        firstUnit = this.validSplit(firstUnit, fieldSb.toString(), split);
                    }
                    boolean bl = isQuotation = !isQuotation;
                }
                if (fieldSb.length() > 0) {
                    if (!isField && chr == '(') {
                        isUseFunction = true;
                    }
                    if (!isField && (chr == '(' || isQuotation || this.specialStr.contains(fieldSb.toString()) || numberPattern.matcher(fieldSb.toString()).matches())) {
                        if (!replaceName && chr != '(') {
                            firstUnit = this.validSplit(firstUnit, fieldSb.toString(), split);
                        }
                        fieldSb = new StringBuilder();
                        startIndex = ++currentIndex;
                        continue;
                    }
                    if (chr == ']') {
                        String fieldNum2 = fieldMap.get(this.getFullFieldNum(fieldSb.toString()));
                        if (fieldNum2 == null) {
                            undefinedFieldNameSb.append((CharSequence)fieldSb).append(',');
                        } else {
                            String newFieldNum = "$" + fieldNum2 + "$";
                            varMap.put("var" + varCount++, newFieldNum);
                            if (fieldNum2.endsWith(".name")) {
                                baseDataNameOrNumMap.put(newFieldNum, "name");
                            } else if (fieldNum2.endsWith(".number")) {
                                baseDataNameOrNumMap.put(newFieldNum, "number");
                            }
                            expr = expr.substring(0, startIndex - 1) + newFieldNum + expr.substring(currentIndex + 1);
                            currentIndex = currentIndex + newFieldNum.length() - fieldSb.length() - 2;
                            refFieldNums.add(fieldNum2);
                        }
                        if (!replaceName) {
                            firstUnit = this.validSplit(firstUnit, fieldNum2, split);
                        }
                        fieldSb = new StringBuilder();
                        isField = false;
                    } else if (fieldSb.length() > 0 && chr == '[') {
                        undefinedFieldNameSb.append((CharSequence)fieldSb).append(',');
                        fieldSb = new StringBuilder();
                    } else {
                        ++currentIndex;
                        continue;
                    }
                }
                startIndex = ++currentIndex;
                continue;
            }
            if (replaceName && chr == '$' && fieldSb.length() > 0) {
                fieldSb.append(chr);
                String baseDataNum = baseDataMap.remove(fieldSb.toString());
                String enumEntityNum = enumEntityNumMap.remove(fieldSb.toString());
                fieldSb = new StringBuilder(fieldSb.substring(1, fieldSb.length() - 1));
                String fieldNum3 = fieldMap.get(fieldSb.toString());
                if (baseDataNum != null) {
                    baseDataMap.put(fieldNum3, baseDataNum);
                }
                if (enumEntityNum != null) {
                    enumEntityNumMap.put(fieldNum3, enumEntityNum);
                }
                varMap.put("var" + varCount++, fieldNum3);
                if (fieldSb.toString().endsWith(".name")) {
                    baseDataNameOrNumMap.put(fieldNum3, "name");
                } else if (fieldSb.toString().endsWith(".number")) {
                    baseDataNameOrNumMap.put(fieldNum3, "number");
                }
                expr = expr.substring(0, startIndex) + fieldNum3 + expr.substring(currentIndex + 1);
                currentIndex = currentIndex + fieldNum3.length() - fieldSb.length();
                refFieldNums.add(fieldNum3);
                currentIndex -= 2;
                fieldSb = new StringBuilder();
            } else if (!isQuotation) {
                fieldSb.append(chr);
            }
            ++currentIndex;
        }
        if (fieldSb.length() > 0 && (isField || !isQuotation && !this.specialStr.contains(fieldSb.toString()) && !numberPattern.matcher(fieldSb.toString()).matches()) && (fieldNum = fieldMap.get(this.getFullFieldNum(fieldSb.toString()))) == null) {
            undefinedFieldNameSb.append((CharSequence)fieldSb).append(',');
        }
        if (undefinedFieldNameSb.length() > 0) {
            errorMsg.append(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e2d\u51fa\u73b0\u4e86\u672a\u5b9a\u4e49\u7684\u5b57\u6bb5\u540d\u6216\u7b26\u53f7\uff1a", (String)"ReportFunctionSubPagePlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])).append(undefinedFieldNameSb.substring(0, undefinedFieldNameSb.length() - 1));
            return null;
        }
        if (expr.contains("$$")) {
            errorMsg.append(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u8bed\u6cd5\u3002", (String)"ReportFunctionSubPagePlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            return null;
        }
        Map<String, String> fieldReversMap = fieldMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (k1, k2) -> k1));
        Map<String, Object> result = this.handleBaseDataAndEnum(expr, varMap, baseDataMap, replaceName, baseDataNameOrNumMap, enumEntityNumMap, refFieldNums, fieldReversMap, errorMsg);
        if (errorMsg.length() > 0) {
            return null;
        }
        result.put("expr", expr);
        result.put("refFieldNums", refFieldNums);
        result.put("isUseFunc", isUseFunction);
        return result;
    }

    private String getFullFieldNum(String fieldNum) {
        return "[" + fieldNum + "]";
    }

    private String validSplit(String firstUnit, String fieldNum, char split) {
        if (firstUnit != null && split == ' ') {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u8bed\u6cd5\u3002", (String)"FunctionSubPageService_4", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        return fieldNum;
    }

    public Map<String, Object> handleBaseDataAndEnum(String parsedExpr, Map<String, String> varMap, Map<String, String> baseDataMap, boolean replaceName, Map<String, String> baseDataNameOrNumMap, Map<String, String> enumEntityNumMap, Set<String> refFieldNums, Map<String, String> fieldReversMap, StringBuilder errorMsg) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        if (varMap.isEmpty() || baseDataMap.isEmpty() && enumEntityNumMap.isEmpty()) {
            result.put("viewExpr", parsedExpr);
            result.put("runExpr", parsedExpr);
            return result;
        }
        for (Map.Entry<String, String> varEntry : varMap.entrySet()) {
            String newVar = varEntry.getKey();
            String originVar = varEntry.getValue();
            parsedExpr = parsedExpr.replace(originVar, newVar);
        }
        Expr expr = AbstractFunctionExecuteService.getExpr(parsedExpr);
        StringBuilder viewExpr = new StringBuilder(expr.toString());
        StringBuilder runExpr = new StringBuilder(expr.toString());
        this.parseBaseDataAndEnum(expr, viewExpr, runExpr, varMap, baseDataMap, replaceName, baseDataNameOrNumMap, enumEntityNumMap, refFieldNums, fieldReversMap, errorMsg);
        String finalViewExpr = viewExpr.toString();
        String finalRunExpr = runExpr.toString();
        for (Map.Entry<String, String> varEntry : varMap.entrySet()) {
            String originVar = varEntry.getKey();
            String newVar = varEntry.getValue();
            finalViewExpr = finalViewExpr.replace(originVar, newVar);
            finalRunExpr = finalRunExpr.replace(originVar, newVar);
        }
        finalViewExpr = finalViewExpr.replace("'\"", "\"");
        finalViewExpr = finalViewExpr.replace("\"'", "\"");
        finalRunExpr = finalRunExpr.replace("'\"", "\"");
        finalRunExpr = finalRunExpr.replace("\"'", "\"");
        result.put("viewExpr", finalViewExpr);
        result.put("runExpr", finalRunExpr);
        return result;
    }

    private void parseBaseDataAndEnum(Expr expr, StringBuilder viewExpr, StringBuilder runExpr, Map<String, String> varMap, Map<String, String> baseDataMap, boolean replaceName, Map<String, String> baseDataNameOrNumMap, Map<String, String> enumEntityNumMap, Set<String> refFieldNums, Map<String, String> fieldReversMap, StringBuilder errorMsg) {
        Expr expr1;
        if (expr == null) {
            return;
        }
        if (expr instanceof BinaryExpr) {
            BinaryExpr binaryExpr = (BinaryExpr)expr;
            Operator operator = binaryExpr.getOperator();
            Expr left = binaryExpr.getLeft();
            Expr right = binaryExpr.getRight();
            if (HRStringUtils.equals((String)operator.getName(), (String)"=") || HRStringUtils.equals((String)operator.getName(), (String)"!=")) {
                String var = varMap.get(left.toString());
                String baseDataNum = baseDataMap.get(var);
                String enumEntityNum = enumEntityNumMap.get(var);
                String value = right.toString();
                if (HRStringUtils.isNotEmpty((String)value) && (value.startsWith("'") && value.endsWith("'") || replaceName)) {
                    if (HRStringUtils.isNotEmpty((String)baseDataNum)) {
                        this.parseBaseData(var, baseDataNum, value, left, viewExpr, runExpr, replaceName, baseDataNameOrNumMap, refFieldNums, operator.getName(), errorMsg);
                    }
                    if (HRStringUtils.isNotEmpty((String)enumEntityNum)) {
                        this.parseEnum(var, enumEntityNum, value, left, viewExpr, runExpr, replaceName, fieldReversMap, operator.getName(), errorMsg);
                    }
                }
            }
            this.parseBaseDataAndEnum(left, viewExpr, runExpr, varMap, baseDataMap, replaceName, baseDataNameOrNumMap, enumEntityNumMap, refFieldNums, fieldReversMap, errorMsg);
            this.parseBaseDataAndEnum(right, viewExpr, runExpr, varMap, baseDataMap, replaceName, baseDataNameOrNumMap, enumEntityNumMap, refFieldNums, fieldReversMap, errorMsg);
        } else if (expr instanceof ExprList) {
            ExprList exprList = (ExprList)expr;
            if (exprList.list != null) {
                for (Expr expr12 : exprList.list) {
                    this.parseBaseDataAndEnum(expr12, viewExpr, runExpr, varMap, baseDataMap, replaceName, baseDataNameOrNumMap, enumEntityNumMap, refFieldNums, fieldReversMap, errorMsg);
                }
            }
        } else if (expr instanceof FunCall) {
            FunCall funCall = (FunCall)expr;
            if (funCall.getParams() != null) {
                for (Expr expr13 : funCall.getParams()) {
                    this.parseBaseDataAndEnum(expr13, viewExpr, runExpr, varMap, baseDataMap, replaceName, baseDataNameOrNumMap, enumEntityNumMap, refFieldNums, fieldReversMap, errorMsg);
                }
            }
        } else if (expr instanceof Paren && (expr1 = ((Paren)expr).getExpr()) != null) {
            this.parseBaseDataAndEnum(expr1, viewExpr, runExpr, varMap, baseDataMap, replaceName, baseDataNameOrNumMap, enumEntityNumMap, refFieldNums, fieldReversMap, errorMsg);
        }
    }

    private void parseBaseData(String var, String baseDataNum, String value, Expr left, StringBuilder viewExpr, StringBuilder runExpr, boolean replaceName, Map<String, String> baseDataNameOrNumMap, Set<String> refFieldNums, String op, StringBuilder errorMsg) {
        Object baseDataId = null;
        String newVar = var;
        String nameOrNum = baseDataNameOrNumMap.get(var);
        boolean valueIsNull = HRStringUtils.equalsIgnoreCase((String)value, (String)"NULL");
        if (!valueIsNull) {
            if (HRStringUtils.equals((String)nameOrNum, (String)"number")) {
                baseDataId = this.queryBaseDataId(baseDataNum, "number", value, replaceName);
                newVar = var.replace(".number$", ".id$");
            } else if (HRStringUtils.equals((String)nameOrNum, (String)"name")) {
                baseDataId = this.queryBaseDataId(baseDataNum, "name", value, replaceName);
                newVar = var.replace(".name$", ".id$");
            }
        }
        if (baseDataId == null && !valueIsNull) {
            if (replaceName) {
                return;
            }
            value = value.replace("'", "");
            String baseDataName = EntityMetadataCache.getDataEntityType((String)baseDataNum).getDisplayName().getLocaleValue();
            if (HRStringUtils.equals((String)nameOrNum, (String)"name")) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a%1$s\u7684%2$s\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\u662f\u5426\u51c6\u786e\u3002", (String)"FunctionSubPageService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]), value, baseDataName));
            } else {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%1$s\u7684%2$s\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\u662f\u5426\u51c6\u786e\u3002", (String)"FunctionSubPageService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]), value, baseDataName));
            }
        } else {
            if (valueIsNull) {
                baseDataId = "NULL";
            }
            String origin = left.toString() + " " + op + " " + value;
            String viewExprStr = viewExpr.toString().replace(origin, var + " " + op + " " + baseDataId);
            viewExpr.replace(0, viewExpr.length(), viewExprStr);
            String runExprStr = runExpr.toString().replace(origin, newVar + " " + op + " " + baseDataId);
            runExpr.replace(0, runExpr.length(), runExprStr);
            if (!replaceName) {
                refFieldNums.add(newVar.replace("$", ""));
            }
        }
    }

    private void parseEnum(String var, String enumEntityNum, String value, Expr left, StringBuilder viewExpr, StringBuilder runExpr, boolean replaceName, Map<String, String> fieldReversMap, String op, StringBuilder errorMsg) {
        if (this.fileSourceEnumMap == null) {
            this.handleEntityEnum(var, enumEntityNum, value, left, viewExpr, runExpr, replaceName, fieldReversMap, op, errorMsg);
        }
    }

    private void handleEntityEnum(String var, String enumEntityNum, String value, Expr left, StringBuilder viewExpr, StringBuilder runExpr, boolean replaceName, Map<String, String> fieldReversMap, String op, StringBuilder errorMsg) {
        IDataEntityProperty property;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)enumEntityNum);
        String fieldNum = replaceName ? fieldReversMap.get(var) : var.replace("$", "");
        if (fieldNum.contains(".")) {
            fieldNum = fieldNum.substring(fieldNum.lastIndexOf(46) + 1);
        }
        if ((property = (IDataEntityProperty)entityType.getAllFields().get(fieldNum)) == null) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u5931\u8d25\uff0c\u5b9e\u4f53%1$s\u4e2d\u4e0d\u5b58\u5728%2$s\u5b57\u6bb5\u3002", (String)"FunctionSubPageService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), enumEntityNum, fieldNum));
            return;
        }
        if (property instanceof ComboProp) {
            String finalVal = value.replace("'", "");
            String finalValue = finalVal = finalVal.replace("\"", "");
            List comboItems = ((ComboProp)property).getComboItems();
            if (replaceName) {
                comboItems.stream().filter(item -> HRStringUtils.equals((String)item.getValue(), (String)finalValue)).findAny().ifPresent(item -> {
                    String itemNum = "\"" + item.getName().getLocaleValue() + "\"";
                    String leftVar = left.toString();
                    String origin = leftVar + " " + op + " " + value;
                    String viewExprStr = viewExpr.toString().replace(origin, leftVar + " " + op + " " + itemNum);
                    viewExpr.replace(0, viewExpr.length(), viewExprStr);
                });
            } else {
                Optional<ValueMapItem> comboItemOp = comboItems.stream().filter(item -> HRStringUtils.equals((String)item.getName().getLocaleValue(), (String)finalValue)).findAny();
                if (comboItemOp.isPresent()) {
                    String itemNum = "\"" + comboItemOp.get().getValue() + "\"";
                    String leftVar = left.toString();
                    String origin = leftVar + " " + op + " " + value;
                    String runExprStr = runExpr.toString().replace(origin, leftVar + " " + op + " " + itemNum);
                    runExpr.replace(0, runExpr.length(), runExprStr);
                    String viewExprStr = viewExpr.toString().replace(origin, leftVar + " " + op + " " + itemNum);
                    viewExpr.replace(0, viewExpr.length(), viewExprStr);
                }
            }
        }
    }

    private Object queryBaseDataId(String baseDataNum, String field, String var, boolean replaceName) {
        DynamicObject baseDataDy;
        boolean idTypeIsLong;
        HRBaseServiceHelper helper = new HRBaseServiceHelper(baseDataNum);
        Class propertyType = EntityMetadataCache.getDataEntityType((String)baseDataNum).getPrimaryKey().getPropertyType();
        boolean bl = idTypeIsLong = propertyType == Long.TYPE || propertyType == Long.class;
        if (replaceName) {
            Object value = var;
            try {
                if (idTypeIsLong) {
                    value = Long.valueOf(var);
                } else {
                    var = var.replace("'", "");
                    value = var.replace("\"", "");
                }
                DynamicObject baseDataDy2 = helper.queryOriginalOne(field, new QFilter[]{new QFilter("id", "=", value)});
                if (baseDataDy2 == null) {
                    return null;
                }
                return "\"" + baseDataDy2.get(field) + "\"";
            }
            catch (Exception exception) {
                return value;
            }
        }
        var = var.replace("'", "");
        var = var.replace("\"", "");
        if (HRStringUtils.equals((String)"hbjm_jobgradehr", (String)baseDataNum)) {
            QFilter jobGradQFilter = new QFilter(field, "=", (Object)var).and(new QFilter("jobgradescm.iscurrentversion", "=", (Object)Boolean.TRUE));
            baseDataDy = helper.queryOriginalOne("id", new QFilter[]{jobGradQFilter});
        } else {
            String entityType = HisCommonService.getInstance().entityInhRelation(baseDataNum);
            if (EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType) || EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(entityType)) {
                QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
                baseDataDy = helper.queryOriginalOne("id", new QFilter[]{hisFilter, new QFilter(field, "=", (Object)var)});
            } else {
                baseDataDy = helper.queryOriginalOne("id", new QFilter[]{new QFilter(field, "=", (Object)var)});
            }
        }
        if (baseDataDy == null) {
            return null;
        }
        if (idTypeIsLong) {
            return baseDataDy.get("id");
        }
        return "\"" + baseDataDy.getString("id") + "\"";
    }
}

