/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.labelandreport;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.ext.hr.metadata.prop.QueryProp;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AddressField;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.businessfield.UserField;
import kd.bos.metadata.entity.commonfield.AdminDivisionField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.metadata.entity.commonfield.MulComboField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.StepperField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.commonfield.TimeField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;

public class AnalyseObjectUtil {
    public static final char SEPARATOR_UNIONKEY_ALIAS_KEY_CHAR = '\u03b4';
    public static final String SEPARATOR_DRILLING_KEY = "\u03b6";

    public static String getOriginFieldAlias(String alias) {
        int fieldAliasSplitIndex = AnalyseObjectUtil.getFieldAliasSplitIndex(alias);
        if (fieldAliasSplitIndex == -1) {
            if (alias.contains(SEPARATOR_DRILLING_KEY)) {
                return alias.substring(0, alias.lastIndexOf(SEPARATOR_DRILLING_KEY));
            }
            return alias;
        }
        return alias.substring(0, fieldAliasSplitIndex);
    }

    public static int getFieldAliasSplitIndex(String alias) {
        int lastDotIdx = alias.lastIndexOf(".");
        int lastSplitIdx = alias.lastIndexOf(948);
        if (lastDotIdx == -1) {
            return lastSplitIdx;
        }
        if (lastSplitIdx < lastDotIdx) {
            return -1;
        }
        return lastSplitIdx;
    }

    public static String getFieldValueType(IDataEntityProperty property) {
        Class propertyType = property.getPropertyType();
        if (propertyType == null) {
            return DataTypeEnum.STRING.getDataTypeKey();
        }
        if (propertyType.equals(DynamicObject.class)) {
            if (property instanceof BasedataProp) {
                propertyType = ((BasedataProp)property).getComplexType().getPrimaryKey().getPropertyType();
            } else if (property instanceof RefBillProp) {
                propertyType = ((RefBillProp)property).getComplexType().getPrimaryKey().getPropertyType();
            }
        }
        if (propertyType.equals(Integer.class) || propertyType.equals(Integer.TYPE)) {
            return DataTypeEnum.INTEGER.getDataTypeKey();
        }
        if (propertyType.equals(Long.class) || propertyType.equals(Long.TYPE)) {
            return DataTypeEnum.LONG.getDataTypeKey();
        }
        if (propertyType.equals(BigDecimal.class)) {
            return DataTypeEnum.BIGDECIMAL.getDataTypeKey();
        }
        if (propertyType.equals(String.class)) {
            return DataTypeEnum.STRING.getDataTypeKey();
        }
        if (propertyType.equals(Date.class)) {
            return DataTypeEnum.DATETIME.getDataTypeKey();
        }
        if (propertyType.equals(Boolean.class) || propertyType.equals(Boolean.TYPE)) {
            return DataTypeEnum.BOOLEAN.getDataTypeKey();
        }
        if (propertyType.equals(ILocaleString.class)) {
            return DataTypeEnum.STRING.getDataTypeKey();
        }
        return DataTypeEnum.STRING.getDataTypeKey();
    }

    public static boolean isBaseDataType(String fieldComplexType) {
        return FieldComplexType.BASE_DATA.getValue().equals(fieldComplexType) || FieldComplexType.ADMIN_ORG.getValue().equals(fieldComplexType) || FieldComplexType.HIS_BASE_DATA.getValue().equals(fieldComplexType);
    }

    public static boolean isEnumType(String controlType) {
        return FieldControlType.COMBO.getValue().equals(controlType) || FieldControlType.MUL_COMBO.getValue().equals(controlType);
    }

    public static String getFieldComplexTypeForNormal(IDataEntityProperty property) {
        if (property instanceof BasedataProp) {
            return null;
        }
        if (property.getParent() instanceof RefEntityType) {
            return null;
        }
        return FieldComplexType.NORMAL.getValue();
    }

    public static String getFieldComplexType(IDataEntityProperty property, Map<String, String> baseDataMap) {
        if (property instanceof BasedataProp) {
            String baseEntityId = ((BasedataProp)property).getBaseEntityId();
            String complexType = baseDataMap.get(baseEntityId);
            if (HRStringUtils.isEmpty((String)complexType)) {
                complexType = AnalyseObjectUtil.getBaseDataType(baseEntityId);
                baseDataMap.put(baseEntityId, complexType);
            }
            return complexType;
        }
        if (property.getParent() instanceof RefEntityType) {
            String parentBaseDataId = property.getParent().getName();
            String complexType = baseDataMap.get(parentBaseDataId);
            if (HRStringUtils.isEmpty((String)complexType)) {
                complexType = AnalyseObjectUtil.getBaseDataType(parentBaseDataId);
                baseDataMap.put(parentBaseDataId, complexType);
            }
            return complexType;
        }
        return FieldComplexType.NORMAL.getValue();
    }

    public static String getBaseDataType(String baseDataNumber) {
        if (HRStringUtils.equals((String)baseDataNumber, (String)"haos_adminorghr")) {
            return FieldComplexType.ADMIN_ORG.getValue();
        }
        String entityType = HisCommonService.getInstance().entityInhRelation(baseDataNumber);
        if (EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType) || EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(entityType)) {
            return FieldComplexType.HIS_BASE_DATA.getValue();
        }
        return FieldComplexType.BASE_DATA.getValue();
    }

    public static String getFiledPath(String entityAlias, boolean isMainEntity, IDataEntityProperty property) {
        IDataEntityType parent;
        String fieldNum = property.getName();
        String fieldPath = "";
        if (!isMainEntity) {
            fieldPath = entityAlias + '.';
        }
        if ((parent = property.getParent()) instanceof SubEntryType) {
            String subEntryName = parent.getName();
            String entryName = parent.getParent().getName();
            fieldPath = fieldPath + entryName + '.' + subEntryName + '.' + fieldNum;
        } else if (parent instanceof EntryType) {
            String entryName = parent.getName();
            fieldPath = fieldPath + entryName + '.' + fieldNum;
        } else {
            fieldPath = fieldPath + fieldNum;
        }
        return fieldPath;
    }

    public static LocaleString getLocaleString(OrmLocaleValue value) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (String loId : value.keySet()) {
            map.put(loId, value.get((Object)loId));
        }
        return LocaleString.fromMap((Map)map);
    }

    public static void setFieldControlType(List<QueryFieldCommonBo> queryFieldBoList) {
        HashMap entityMetadataMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap metadataNumberToIdMap = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        for (QueryFieldCommonBo queryFieldBo : queryFieldBoList) {
            if (HRStringUtils.isNotEmpty((String)queryFieldBo.getControlType())) continue;
            String entityNumber = queryFieldBo.getEntityNumber();
            MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(entityNumber);
            AnalyseObjectUtil.getEntityMetadata(entityNumber, entityMetadataMap, metadataNumberToIdMap);
            String fieldControlType = AnalyseObjectUtil.getFieldControlType(mainEntityType, entityMetadataMap, metadataNumberToIdMap, queryFieldBo.getFieldAlias(), queryFieldBo.getComplexType(), mainEntityTypeUtil);
            queryFieldBo.setControlType(fieldControlType);
        }
    }

    public static String getFieldControlType(MainEntityType dataEntityType, Map<String, EntityMetadata> entityMetadataMap, Map<String, String> metadataNumberToIdMap, String fieldAlias, String fieldComplexType, MainEntityTypeUtil mainEntityTypeUtil) {
        Field<?> field;
        if (fieldAlias.endsWith(".id")) {
            return FieldControlType.BASE_DATA.getValue();
        }
        IDataEntityProperty property = null;
        String[] aliasArr = fieldAlias.split("\\.");
        String fieldName = aliasArr[aliasArr.length - 1];
        if (AnalyseObjectUtil.isBaseDataType(fieldComplexType)) {
            String parentFieldName = aliasArr[aliasArr.length - 2];
            if (aliasArr.length > 2) {
                String grandParentFieldName = aliasArr[aliasArr.length - 3];
                IDataEntityProperty grandParentProp = (IDataEntityProperty)dataEntityType.getAllFields().get(grandParentFieldName);
                if (grandParentProp instanceof BasedataProp) {
                    String grandParentEntityNum = ((BasedataProp)grandParentProp).getBaseEntityId();
                    MainEntityType grandParentBaseDataEntityType = mainEntityTypeUtil.getMainEntityType(grandParentEntityNum);
                    property = (IDataEntityProperty)grandParentBaseDataEntityType.getAllFields().get(parentFieldName);
                }
            }
            if (property == null) {
                property = (IDataEntityProperty)dataEntityType.getAllFields().get(parentFieldName);
            }
            String baseEntityId = ((BasedataProp)property).getBaseEntityId();
            EntityMetadata entityMetadata = AnalyseObjectUtil.getEntityMetadata(baseEntityId, entityMetadataMap, metadataNumberToIdMap);
            field = entityMetadata.getFieldByKey(fieldName);
            field = AnalyseObjectUtil.getDateRangeOrTimeRangeField(field, mainEntityTypeUtil.getMainEntityType(baseEntityId), fieldAlias);
        } else {
            EntityMetadata entityMetadata = AnalyseObjectUtil.getEntityMetadata(dataEntityType.getName(), entityMetadataMap, metadataNumberToIdMap);
            field = entityMetadata.getFieldByKey(fieldName);
            field = AnalyseObjectUtil.getDateRangeOrTimeRangeField(field, dataEntityType, fieldAlias);
        }
        return AnalyseObjectUtil.getControlType(field);
    }

    private static Field<?> getDateRangeOrTimeRangeField(Field<?> field, MainEntityType dataEntityType, String fieldAlias) {
        if (field != null || dataEntityType == null) {
            return field;
        }
        IDataEntityProperty fieldProp = (IDataEntityProperty)dataEntityType.getAllFields().get(fieldAlias);
        if (fieldProp == null) {
            return null;
        }
        if (fieldProp instanceof TimeProp) {
            return new TimeField();
        }
        if (fieldProp instanceof DateProp) {
            return new DateField();
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    public static IDataEntityProperty parseFieldAliasGetProperty(String entityNumber, String fieldAlias, MainEntityTypeUtil entityTypeUtil) {
        String[] aliasArr;
        MainEntityType dataEntityType = entityTypeUtil.getMainEntityType(entityNumber);
        if (fieldAlias.startsWith(entityNumber)) {
            fieldAlias = fieldAlias.substring(fieldAlias.indexOf(".") + 1);
        }
        if ((aliasArr = fieldAlias.split("\\.")).length == 1) {
            return (IDataEntityProperty)dataEntityType.getAllFields().get(fieldAlias);
        }
        String fieldName = aliasArr[aliasArr.length - 1];
        if (aliasArr.length > 2) {
            String lastThird = aliasArr[aliasArr.length - 3];
            String lastSecond = aliasArr[aliasArr.length - 2];
            IDataEntityProperty parentProp = (IDataEntityProperty)dataEntityType.getAllFields().get(lastThird);
            if (parentProp instanceof BasedataProp) {
                IDataEntityProperty lastSecondProp;
                Optional<IDataEntityProperty> anyRefProp = AnalyseObjectUtil.getBaseRefProp(parentProp, lastSecond, true);
                if (anyRefProp.isPresent() && (lastSecondProp = anyRefProp.get()) instanceof BasedataProp && (anyRefProp = AnalyseObjectUtil.getBaseRefProp(lastSecondProp, fieldName, false)).isPresent()) {
                    return anyRefProp.get();
                }
            } else {
                Optional<IDataEntityProperty> anyRefProp;
                IDataEntityProperty lastSecondProp = (IDataEntityProperty)dataEntityType.getAllFields().get(lastSecond);
                if (lastSecondProp instanceof BasedataProp && (anyRefProp = AnalyseObjectUtil.getBaseRefProp(parentProp = (IDataEntityProperty)dataEntityType.getAllFields().get(lastSecond), fieldName, false)).isPresent()) {
                    return anyRefProp.get();
                }
            }
        } else {
            IDataEntityProperty parentProp = (IDataEntityProperty)dataEntityType.getAllFields().get(aliasArr[0]);
            if (parentProp instanceof BasedataProp) {
                DataEntityPropertyCollection relProps = ((BasedataProp)parentProp).getComplexType().getProperties();
                String subBaseDataPropNum = aliasArr[1];
                Optional<IDataEntityProperty> anyRefProp = relProps.stream().filter(relProp -> subBaseDataPropNum.equals(relProp.getName())).findAny();
                if (anyRefProp.isPresent()) {
                    return anyRefProp.get();
                }
            }
        }
        return (IDataEntityProperty)dataEntityType.getAllFields().get(fieldName);
    }

    private static Optional<IDataEntityProperty> getBaseRefProp(IDataEntityProperty parentPop, String refPropField, boolean needBaseProp) {
        DataEntityPropertyCollection relProps = ((BasedataProp)parentPop).getComplexType().getProperties();
        return relProps.stream().filter(relProp -> {
            if (needBaseProp) {
                return refPropField.equals(relProp.getName()) && relProp instanceof BasedataProp;
            }
            return refPropField.equals(relProp.getName());
        }).findAny();
    }

    public static String parseFieldAliasGetBaseDataNum(String entityNumber, String fieldAlias, MainEntityTypeUtil entityTypeUtil) {
        Map<String, String> baseDataNumAndPkType = AnalyseObjectUtil.parseFieldAliasGetBaseDataNumAndPkType(entityNumber, fieldAlias, entityTypeUtil);
        return baseDataNumAndPkType.get("baseDataNum");
    }

    public static Map<String, String> parseFieldAliasGetBaseDataNumAndPkType(String entityNumber, String fieldAlias, MainEntityTypeUtil entityTypeUtil) {
        IDataEntityProperty property;
        String[] aliasArr;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)2);
        String baseDataNum = "";
        String pkType = "";
        MainEntityType dataEntityType = entityTypeUtil.getMainEntityType(entityNumber);
        if (fieldAlias.startsWith(entityNumber)) {
            fieldAlias = fieldAlias.substring(fieldAlias.indexOf(".") + 1);
        }
        if ((aliasArr = fieldAlias.split("\\.")).length == 1) {
            pkType = dataEntityType.getPrimaryKey().getPropertyType() == String.class ? "string" : "long";
            resultMap.put("pkType", pkType);
            resultMap.put("baseDataNum", entityNumber);
            return resultMap;
        }
        String fieldName = aliasArr[aliasArr.length - 2];
        if (aliasArr.length > 2) {
            String parentFieldName = aliasArr[aliasArr.length - 3];
            IDataEntityProperty parentProp = (IDataEntityProperty)dataEntityType.getAllFields().get(parentFieldName);
            if (parentProp instanceof BasedataProp) {
                baseDataNum = ((BasedataProp)parentProp).getBaseEntityId();
                pkType = parentProp.getPropertyType() == String.class ? "string" : "long";
                DataEntityPropertyCollection relProps = ((BasedataProp)parentProp).getComplexType().getProperties();
                String subBaseDataPropNum = aliasArr[aliasArr.length - 2];
                Optional<IDataEntityProperty> anyRefProp = relProps.stream().filter(relProp -> subBaseDataPropNum.equals(relProp.getName()) && relProp instanceof BasedataProp).findAny();
                if (anyRefProp.isPresent()) {
                    baseDataNum = ((BasedataProp)anyRefProp.get()).getBaseEntityId();
                    baseDataNum = AnalyseObjectUtil.resetHrpiBaseDataNum((BasedataProp)anyRefProp.get(), baseDataNum);
                    pkType = ((BasedataProp)anyRefProp.get()).getRefIdProp().getPropertyType() == String.class ? "string" : "long";
                } else {
                    baseDataNum = AnalyseObjectUtil.resetHrpiBaseDataNum((BasedataProp)parentProp, baseDataNum);
                }
                resultMap.put("pkType", pkType);
                resultMap.put("baseDataNum", baseDataNum);
                return resultMap;
            }
        }
        if ((property = (IDataEntityProperty)dataEntityType.getAllFields().get(fieldName)) instanceof BasedataProp) {
            baseDataNum = ((BasedataProp)property).getBaseEntityId();
            pkType = ((BasedataProp)property).getRefIdProp().getPropertyType() == String.class ? "string" : "long";
            resultMap.put("pkType", pkType);
            baseDataNum = AnalyseObjectUtil.resetHrpiBaseDataNum((BasedataProp)property, baseDataNum);
            resultMap.put("baseDataNum", baseDataNum);
        }
        return resultMap;
    }

    private static String resetHrpiBaseDataNum(BasedataProp property, String baseDataNum) {
        if (property instanceof QueryProp) {
            if (property.getBaseEntityId().contains("hrpi_personf7query")) {
                baseDataNum = "hrpi_person";
            } else if (property.getBaseEntityId().contains("hrpi_depempf7query")) {
                baseDataNum = "hrpi_depemp";
            } else if (property.getBaseEntityId().contains("hrpi_employeef7query")) {
                baseDataNum = "hrpi_employee";
            }
        }
        return baseDataNum;
    }

    private static EntityMetadata getEntityMetadata(String entityNum, Map<String, EntityMetadata> entityMetadataMap, Map<String, String> metadataNumberToIdMap) {
        EntityMetadata entityMetadata = entityMetadataMap.get(entityNum);
        if (entityMetadata == null) {
            String metadataId = metadataNumberToIdMap.get(entityNum);
            if (metadataId == null) {
                metadataId = MetadataDao.getIdByNumber((String)entityNum, (MetaCategory)MetaCategory.Entity);
                metadataNumberToIdMap.put(entityNum, metadataId);
            }
            entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)metadataId, (MetaCategory)MetaCategory.Entity);
            entityMetadataMap.put(entityNum, entityMetadata);
        }
        return entityMetadata;
    }

    public static String getControlType(Field<?> field) {
        String controlType = FieldControlType.TEXT.getValue();
        if (field instanceof MuliLangTextField) {
            controlType = FieldControlType.MUL_LANG_TEXT.getValue();
        } else if (field instanceof BigIntField) {
            controlType = FieldControlType.BIGINT.getValue();
        } else if (field instanceof IntegerField) {
            controlType = FieldControlType.INTEGER.getValue();
        } else if (field instanceof DateField) {
            controlType = FieldControlType.DATE.getValue();
        } else if (field instanceof DateTimeField) {
            controlType = FieldControlType.DATE_TIME.getValue();
        } else if (field instanceof DateRangeField) {
            controlType = FieldControlType.DATE_RANGE.getValue();
        } else if (field instanceof TimeField) {
            controlType = FieldControlType.TIME.getValue();
        } else if (field instanceof TimeRangeField) {
            controlType = FieldControlType.TIME_RANGE.getValue();
        } else if (field instanceof StepperField) {
            controlType = FieldControlType.STEPPER.getValue();
        } else if (field instanceof MulComboField) {
            controlType = FieldControlType.MUL_COMBO.getValue();
        } else if (field instanceof ComboField) {
            controlType = FieldControlType.COMBO.getValue();
        } else if (field instanceof AmountField) {
            controlType = FieldControlType.AMOUNT.getValue();
        } else if (field instanceof DecimalField) {
            controlType = FieldControlType.DECIMAL.getValue();
        } else if (field instanceof CheckBoxField) {
            controlType = FieldControlType.CHECKBOX.getValue();
        } else if (field instanceof LargeTextField) {
            controlType = FieldControlType.LARGE_TEXT.getValue();
        } else if (field instanceof AdminDivisionField) {
            controlType = FieldControlType.ADMIN_DIVISION.getValue();
        } else if (field instanceof AddressField) {
            controlType = FieldControlType.ADDRESS.getValue();
        } else if (field instanceof UserField) {
            controlType = FieldControlType.USER.getValue();
        } else if (field instanceof OrgField) {
            controlType = FieldControlType.ORG.getValue();
        } else if (field instanceof BasedataField) {
            controlType = FieldControlType.BASE_DATA.getValue();
        } else if (field instanceof TextField) {
            controlType = FieldControlType.TEXT.getValue();
        }
        return controlType;
    }
}

