/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.labelandreport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.hr.ruleengine.enums.ParamTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;

public class AnobjFilterUtil {
    private static final String ID = "id";
    private static final String TEXT = "text";
    private static final String CHILDREN = "children";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String TYPE = "type";
    private static final String TYPE_DETAIL = "typeDetail";
    private static final String DATE_FORMAT = "dateFormat";
    private static final String ENTITY_NUMBER = "entityNumber";
    private static final String ENUM_LIST = "enumList";
    private static final String PARAM_MULTIPLE = "multiple";
    private static final String MULTIPLE_TRUE = "1";
    private static final String ORG_FUNID = "orgFunId";
    private static final String ORG_VIEW_SCHEME_NUMBER = "orgViewSchemeNumber";
    private static final Map<String, String> typeMap = Maps.newHashMapWithExpectedSize((int)16);

    public static List<Map<String, String>> getParamList(List<QueryFieldCommonBo> queryFieldCommonBos) {
        return AnobjFilterUtil.getParamList(queryFieldCommonBos, Maps.newHashMapWithExpectedSize((int)16));
    }

    public static List<Map<String, String>> getParamList(List<QueryFieldCommonBo> queryFieldCommonBos, Map<String, List<String>> fileSourceEnumItemMap) {
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)queryFieldCommonBos.size());
        HashMap entityPropMap = Maps.newHashMapWithExpectedSize((int)2);
        for (QueryFieldCommonBo queryFieldCommonBo : queryFieldCommonBos) {
            List<ValueMapItem> mapItemList;
            if (queryFieldCommonBo.getHRFilterParam().endsWith(".id")) continue;
            String controlType = queryFieldCommonBo.getControlType();
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)5);
            paramMap.put(ID, queryFieldCommonBo.getHRFilterParam());
            paramMap.put(NUMBER, queryFieldCommonBo.getHRFilterParam());
            paramMap.put(TEXT, queryFieldCommonBo.getFieldName().getLocaleValue());
            paramMap.put(NAME, queryFieldCommonBo.getFieldName().getLocaleValue());
            String type = typeMap.get(controlType);
            if (StringUtils.isEmpty((CharSequence)type)) continue;
            if (AnobjFilterUtil.isBaseData(type, queryFieldCommonBo)) {
                paramMap.put(TYPE, ParamTypeEnum.DYNAMICOBJECT.getValue());
                paramMap.put(TYPE_DETAIL, ParamTypeEnum.DYNAMICOBJECT.getValue());
                if (StringUtils.isNotEmpty((CharSequence)queryFieldCommonBo.getBaseDataNum())) {
                    paramMap.put(ENTITY_NUMBER, queryFieldCommonBo.getBaseDataNum());
                }
            } else {
                paramMap.put(TYPE, type);
                paramMap.put(TYPE_DETAIL, type);
            }
            if (queryFieldCommonBo.isVirtualEntityField()) {
                paramMap.put(ENTITY_NUMBER, queryFieldCommonBo.getBaseDataNum());
            }
            List<String> fileSourceEnumItems = fileSourceEnumItemMap.get(queryFieldCommonBo.getFieldAlias());
            if (type.equals(ParamTypeEnum.ENUM.getValue())) {
                paramMap.put(TYPE, ParamTypeEnum.STRING.getValue());
                mapItemList = AnobjFilterUtil.getComboItems(queryFieldCommonBo, fileSourceEnumItems);
                paramMap.put(ENUM_LIST, SerializationUtils.toJsonString(mapItemList));
            } else if (type.equals(ParamTypeEnum.MUL_ENUM.getValue())) {
                paramMap.put(TYPE, ParamTypeEnum.STRING.getValue());
                paramMap.put(PARAM_MULTIPLE, MULTIPLE_TRUE);
                paramMap.put(TYPE_DETAIL, ParamTypeEnum.MUL_ENUM.getValue());
                mapItemList = AnobjFilterUtil.getComboItems(queryFieldCommonBo, fileSourceEnumItems);
                paramMap.put(ENUM_LIST, SerializationUtils.toJsonString(mapItemList));
            }
            List propList = entityPropMap.getOrDefault(queryFieldCommonBo.getEntityName(), Lists.newArrayListWithExpectedSize((int)10));
            propList.add(paramMap);
            entityPropMap.put(queryFieldCommonBo.getEntityName(), propList);
        }
        for (Map.Entry entry : entityPropMap.entrySet()) {
            HashMap rootMap = Maps.newHashMapWithExpectedSize((int)2);
            rootMap.put(TEXT, entry.getKey());
            rootMap.put(CHILDREN, SerializationUtils.toJsonString(entry.getValue()));
            paramList.add(rootMap);
        }
        return paramList;
    }

    private static boolean isBaseData(String type, QueryFieldCommonBo queryFieldBo) {
        return !(!queryFieldBo.getFieldPath().endsWith(".name") && !queryFieldBo.getFieldPath().endsWith(".number") || !ParamTypeEnum.STRING.getValue().equals(type) || !FieldComplexType.BASE_DATA.getValue().equals(queryFieldBo.getComplexType()) && !FieldComplexType.ADMIN_ORG.getValue().equals(queryFieldBo.getComplexType()) && !FieldComplexType.HIS_BASE_DATA.getValue().equals(queryFieldBo.getComplexType()));
    }

    private static List<ValueMapItem> getComboItems(QueryFieldCommonBo queryFieldBo, List<String> fileSourceEnumItems) {
        MainEntityType mainEntityType;
        if (fileSourceEnumItems != null) {
            return fileSourceEnumItems.stream().map(item -> new ValueMapItem(null, item, new LocaleString(item))).collect(Collectors.toList());
        }
        String entityNumber = queryFieldBo.getEntityNumber();
        String fieldAlias = queryFieldBo.getFieldAlias();
        if (queryFieldBo.isVirtualEntityField()) {
            entityNumber = queryFieldBo.getFieldPath().split("\\.")[0];
            fieldAlias = queryFieldBo.getFieldPath();
        }
        if ((mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber)) == null) {
            return null;
        }
        String[] props = fieldAlias.split("\\.");
        DynamicProperty property = mainEntityType.getProperty(props[0]);
        if (property == null) {
            property = mainEntityType.getProperty(props[1]);
            if (property != null) {
                return AnobjFilterUtil.getComboItems(mainEntityType, props, 1);
            }
        } else {
            return AnobjFilterUtil.getComboItems(mainEntityType, props, 0);
        }
        return null;
    }

    private static List<ValueMapItem> getComboItems(MainEntityType mainEntityType, String[] props, int index) {
        if (mainEntityType == null || index == props.length) {
            return null;
        }
        DynamicProperty comboProp = AnobjFilterUtil.getComboProp(mainEntityType.getProperty(props[index]), props, index);
        if (null != comboProp) {
            return ((ComboProp)comboProp).getComboItems();
        }
        return null;
    }

    public static DynamicProperty getComboProp(DynamicProperty property, String[] props, int index) {
        if (property instanceof ComboProp) {
            return property;
        }
        if (property instanceof BasedataProp) {
            MainEntityType mainEntityType2 = EntityMetadataCache.getDataEntityType((String)((BasedataProp)property).getBaseEntityId());
            return AnobjFilterUtil.getComboProp(mainEntityType2.getProperty(props[index + 1]), props, index + 1);
        }
        if (property instanceof EntryProp) {
            return AnobjFilterUtil.getComboProp(((EntryProp)property).getDynamicCollectionItemPropertyType().getProperty(props[index + 1]), props, index + 1);
        }
        return null;
    }

    static {
        typeMap.put(FieldControlType.TEXT.getValue(), ParamTypeEnum.STRING.getValue());
        typeMap.put(FieldControlType.MUL_LANG_TEXT.getValue(), ParamTypeEnum.STRING.getValue());
        typeMap.put(FieldControlType.LARGE_TEXT.getValue(), ParamTypeEnum.STRING.getValue());
        typeMap.put(FieldControlType.INTEGER.getValue(), ParamTypeEnum.NUMBER.getValue());
        typeMap.put(FieldControlType.BIGINT.getValue(), ParamTypeEnum.NUMBER.getValue());
        typeMap.put(FieldControlType.DECIMAL.getValue(), ParamTypeEnum.NUMBER.getValue());
        typeMap.put(FieldControlType.STEPPER.getValue(), ParamTypeEnum.NUMBER.getValue());
        typeMap.put(FieldControlType.DATE.getValue(), ParamTypeEnum.DATE.getValue());
        typeMap.put(FieldControlType.DATE_TIME.getValue(), ParamTypeEnum.DATE.getValue());
        typeMap.put(FieldControlType.COMBO.getValue(), ParamTypeEnum.ENUM.getValue());
        typeMap.put(FieldControlType.MUL_COMBO.getValue(), ParamTypeEnum.MUL_ENUM.getValue());
        typeMap.put(FieldControlType.BASE_DATA.getValue(), ParamTypeEnum.DYNAMICOBJECT.getValue());
        typeMap.put(FieldControlType.USER.getValue(), ParamTypeEnum.DYNAMICOBJECT.getValue());
        typeMap.put(FieldControlType.ORG.getValue(), ParamTypeEnum.DYNAMICOBJECT.getValue());
        typeMap.put(FieldControlType.CHECKBOX.getValue(), ParamTypeEnum.BOOLEAN.getValue());
    }
}

