/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.labelandreport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.enums.ParamTypeEnum;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.service.complexobj.ComplexConstant;
import kd.hr.hbp.business.service.labelandreport.RuleOperatorEnum;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class HRFilterUtil {
    private static final Map<String, String> operatorMap = Maps.newHashMapWithExpectedSize((int)16);
    private static final List<String> dateList = Lists.newArrayListWithCapacity((int)20);

    private static boolean isBaseData(String paramType) {
        return ParamTypeEnum.DYNAMICOBJECT.getValue().equals(paramType);
    }

    private static String removeBaseDataKey(String param) {
        return param.substring(0, param.lastIndexOf("."));
    }

    @ExcludeFromJacocoGeneratedReport
    private static QFilter condition2QFilter(ConditionInfo conditionInfo, List<QueryFieldCommonBo> queryFieldBos, List<String> dateParamList) {
        String param = conditionInfo.getParam();
        String opt = conditionInfo.getOperators();
        String value = conditionInfo.getValue();
        String paramType = conditionInfo.getParamType();
        if (ParamTypeEnum.BOOLEAN.getValue().equals(conditionInfo.getValueDataType()) && "true".equals(value)) {
            value = "1";
        }
        if (ParamTypeEnum.BOOLEAN.getValue().equals(conditionInfo.getValueDataType()) && "false".equals(value)) {
            value = "0";
        }
        for (QueryFieldCommonBo queryFieldCommonBo : queryFieldBos) {
            if (!queryFieldCommonBo.getHRFilterParam().equals(param)) continue;
            param = queryFieldCommonBo.getFieldAlias();
        }
        if (dateList.contains(opt)) {
            dateParamList.add(param);
            return HRFilterUtil.date2QFilter(param, opt);
        }
        if (RuleOperatorEnum.STARTS_WITH.getValue().equals(opt)) {
            return new QFilter(param, "like", (Object)(value + "%"));
        }
        if (RuleOperatorEnum.ENDS_WITH.getValue().equals(opt)) {
            return new QFilter(param, "like", (Object)("%" + value));
        }
        if (RuleOperatorEnum.IS_NULL.getValue().equals(opt)) {
            if (HRFilterUtil.isBaseData(paramType)) {
                return new QFilter(param, "=", (Object)QEmptyValue.value).or(new QFilter(HRFilterUtil.removeBaseDataKey(param) + ".id", "=", (Object)QEmptyValue.value));
            }
            return new QFilter(param, "=", (Object)QEmptyValue.value);
        }
        if (RuleOperatorEnum.IS_NOT_NULL.getValue().equals(opt)) {
            if (ParamTypeEnum.DATE.getValue().equals(paramType)) {
                return new QFilter(param, "is not null", null);
            }
            return new QFilter(param, "is not null", null).and(new QFilter(param, "!=", (Object)"")).and(new QFilter(param, "!=", (Object)" "));
        }
        if (RuleOperatorEnum.CONTAINS.getValue().equals(opt)) {
            return new QFilter(param, "like", (Object)("%" + value + "%"));
        }
        if (RuleOperatorEnum.NOT_CONTAINS.getValue().equals(opt)) {
            if (HRFilterUtil.isBaseData(paramType)) {
                return new QFilter(param, "not like", (Object)("%" + value + "%")).or(new QFilter(param, "=", (Object)QEmptyValue.value));
            }
            return new QFilter(param, "not like", (Object)("%" + value + "%"));
        }
        if (RuleOperatorEnum.IN.getValue().equals(opt)) {
            if (HRFilterUtil.isBaseData(paramType)) {
                param = HRFilterUtil.removeBaseDataKey(param) + ".id";
            }
            if (ParamTypeEnum.NUMBER.getValue().equals(conditionInfo.getValueDataType())) {
                return new QFilter(param, "in", Arrays.stream(value.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            }
            return new QFilter(param, "in", (Object)value.split(","));
        }
        if (RuleOperatorEnum.NOT_IN.getValue().equals(opt)) {
            if (HRFilterUtil.isBaseData(paramType)) {
                param = HRFilterUtil.removeBaseDataKey(param) + ".id";
            }
            if (ParamTypeEnum.NUMBER.getValue().equals(conditionInfo.getValueDataType())) {
                return new QFilter(param, "not in", Arrays.stream(value.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            }
            return new QFilter(param, "not in", (Object)value.split(","));
        }
        if (HRFilterUtil.isBaseData(paramType)) {
            param = HRFilterUtil.removeBaseDataKey(param) + ".id";
        }
        if (ParamTypeEnum.NUMBER.getValue().equals(conditionInfo.getValueDataType())) {
            return new QFilter(param, operatorMap.get(opt), (Object)new BigDecimal(value));
        }
        if (ParamTypeEnum.DATE.getValue().equals(conditionInfo.getValueDataType())) {
            try {
                dateParamList.add(param);
                return new QFilter(param, operatorMap.get(opt), (Object)HRDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd"));
            }
            catch (ParseException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\u3002", (String)"HRFilterUtil_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
        }
        return new QFilter(param, operatorMap.get(opt), (Object)value);
    }

    @ExcludeFromJacocoGeneratedReport
    private static LocalDate getQuarterFirstDay(int year, int quarter) {
        if (quarter == 0) {
            return LocalDate.of(year - 1, 10, 1);
        }
        if (quarter == 1) {
            return LocalDate.of(year, 1, 1);
        }
        if (quarter == 2) {
            return LocalDate.of(year, 4, 1);
        }
        if (quarter == 3) {
            return LocalDate.of(year, 7, 1);
        }
        if (quarter == 4) {
            return LocalDate.of(year, 10, 1);
        }
        if (quarter == 5) {
            return LocalDate.of(year + 1, 1, 1);
        }
        return LocalDate.of(year + 1, 4, 1);
    }

    private static Date getStartTime(LocalDate date) {
        return Date.from(date.atStartOfDay(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
    }

    private static Date getNextDayStartTime(LocalDate date) {
        return Date.from(date.plusDays(1L).atStartOfDay(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
    }

    @ExcludeFromJacocoGeneratedReport
    private static QFilter date2QFilter(String param, String opt) {
        LocalDate date = LocalDate.now();
        int dayOfWeek = date.getDayOfWeek().getValue();
        int year = date.getYear();
        int quarter = (int)Math.ceil((double)date.getMonthValue() / 3.0);
        Date startToDay = HRFilterUtil.getStartTime(date);
        Date nextDayStartTime = HRFilterUtil.getNextDayStartTime(date);
        switch (RuleOperatorEnum.getEnum(opt)) {
            case TODAY: {
                return new QFilter(param, ">=", (Object)startToDay).and(new QFilter(param, "<", (Object)nextDayStartTime));
            }
            case LESS_OR_EQUALS_TODAY: {
                return new QFilter(param, "<", (Object)nextDayStartTime);
            }
            case GREATER_OR_EQUALS_TODAY: {
                return new QFilter(param, ">=", (Object)startToDay);
            }
            case YESTERDAY: {
                return new QFilter(param, ">=", (Object)HRDateTimeUtils.addDay((Date)startToDay, (long)-1L)).and(new QFilter(param, "<", (Object)startToDay));
            }
            case TOMORROW: {
                return new QFilter(param, ">=", (Object)HRDateTimeUtils.addDay((Date)startToDay, (long)1L)).and(new QFilter(param, "<", (Object)HRDateTimeUtils.addDay((Date)nextDayStartTime, (long)1L)));
            }
            case THIS_WEEK: {
                return new QFilter(param, ">=", (Object)HRDateTimeUtils.addDay((Date)startToDay, (long)(1 - dayOfWeek))).and(new QFilter(param, "<", (Object)HRDateTimeUtils.addDay((Date)nextDayStartTime, (long)(7 - dayOfWeek))));
            }
            case LAST_WEEK: {
                return new QFilter(param, ">=", (Object)HRDateTimeUtils.addDay((Date)startToDay, (long)(-dayOfWeek - 6))).and(new QFilter(param, "<", (Object)HRDateTimeUtils.addDay((Date)nextDayStartTime, (long)(-dayOfWeek))));
            }
            case NEXT_WEEK: {
                return new QFilter(param, ">=", (Object)HRDateTimeUtils.addDay((Date)startToDay, (long)(-dayOfWeek + 8))).and(new QFilter(param, "<", (Object)HRDateTimeUtils.addDay((Date)nextDayStartTime, (long)(14 - dayOfWeek))));
            }
            case THIS_MONTH: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date.withDayOfMonth(1))).and(new QFilter(param, "<", (Object)HRFilterUtil.getStartTime(date.plusMonths(1L).withDayOfMonth(1))));
            }
            case LAST_MONTH: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date.minusMonths(1L).withDayOfMonth(1))).and(new QFilter(param, "<", (Object)HRFilterUtil.getStartTime(date.withDayOfMonth(1))));
            }
            case NEXT_MONTH: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date.plusMonths(1L).withDayOfMonth(1))).and(new QFilter(param, "<", (Object)HRFilterUtil.getStartTime(date.plusMonths(2L).withDayOfMonth(1))));
            }
            case LAST3MONTH: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date.minusMonths(3L))).and(new QFilter(param, "<", (Object)HRFilterUtil.getNextDayStartTime(date)));
            }
            case NEXT3MONTH: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date)).and(new QFilter(param, "<", (Object)HRFilterUtil.getNextDayStartTime(date.plusMonths(3L))));
            }
            case THIS_QUARTER: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(HRFilterUtil.getQuarterFirstDay(year, quarter))).and(new QFilter(param, "<", (Object)HRFilterUtil.getStartTime(HRFilterUtil.getQuarterFirstDay(year, quarter + 1))));
            }
            case LAST_QUARTER: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(HRFilterUtil.getQuarterFirstDay(year, quarter - 1))).and(new QFilter(param, "<", (Object)HRFilterUtil.getStartTime(HRFilterUtil.getQuarterFirstDay(year, quarter))));
            }
            case NEXT_QUARTER: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(HRFilterUtil.getQuarterFirstDay(year, quarter + 1))).and(new QFilter(param, "<", (Object)HRFilterUtil.getStartTime(HRFilterUtil.getQuarterFirstDay(year, quarter + 2))));
            }
            case THIS_YEAR: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date.withDayOfYear(1))).and(new QFilter(param, "<", (Object)HRFilterUtil.getStartTime(date.plusYears(1L).withDayOfYear(1))));
            }
            case LAST_YEAR: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date.plusYears(-1L).withDayOfYear(1))).and(new QFilter(param, "<", (Object)HRFilterUtil.getStartTime(date.withDayOfYear(1))));
            }
            case NEXT_YEAR: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date.plusYears(1L).withDayOfYear(1))).and(new QFilter(param, "<", (Object)HRFilterUtil.getStartTime(date.plusYears(2L).withDayOfYear(1))));
            }
            case LAST1MONTH: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date.minusMonths(1L))).and(new QFilter(param, "<", (Object)HRFilterUtil.getStartTime(date)));
            }
            case NEXT1MONTH: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date)).and(new QFilter(param, "<", (Object)HRFilterUtil.getStartTime(date.plusMonths(1L))));
            }
            case LESS_TODAY: {
                return new QFilter(param, "<", (Object)HRFilterUtil.getStartTime(date));
            }
            case GREATER_TODAY: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getNextDayStartTime(date));
            }
            case LAST3DAY: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date.plusDays(-3L))).and(new QFilter(param, "<", (Object)HRFilterUtil.getNextDayStartTime(date)));
            }
            case LAST7DAY: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date.plusDays(-7L))).and(new QFilter(param, "<", (Object)HRFilterUtil.getNextDayStartTime(date)));
            }
            case LAST15DAY: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date.plusDays(-15L))).and(new QFilter(param, "<", (Object)HRFilterUtil.getNextDayStartTime(date)));
            }
            case LAST60DAY: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date.plusDays(-60L))).and(new QFilter(param, "<", (Object)HRFilterUtil.getNextDayStartTime(date)));
            }
            case THIS_MONTH_TO_DAY: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date.withDayOfMonth(1))).and(new QFilter(param, "<", (Object)HRFilterUtil.getNextDayStartTime(date)));
            }
            case THIS_YEAR_TO_DAY: {
                return new QFilter(param, ">=", (Object)HRFilterUtil.getStartTime(date.withDayOfYear(1))).and(new QFilter(param, "<", (Object)HRFilterUtil.getNextDayStartTime(date)));
            }
        }
        return null;
    }

    public static QFilter condition2QFilter4HRReport(String conditionJson, String queryFieldBoJson) {
        RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditionJson, RuleConditionInfo.class);
        List conditionList = ruleConditionInfo.getConditionList();
        if (CollectionUtils.isEmpty((Collection)conditionList)) {
            return null;
        }
        ArrayList<String> dateParamList = new ArrayList<String>(conditionList.size());
        List queryFieldBos = SerializationUtils.fromJsonStringToList((String)queryFieldBoJson, QueryFieldCommonBo.class);
        String expressStr = ruleConditionInfo.getConditionExpressStr();
        for (int i = 0; i < conditionList.size(); ++i) {
            QFilter qFilter = HRFilterUtil.condition2QFilter((ConditionInfo)conditionList.get(i), queryFieldBos, dateParamList);
            HRFilterUtil.encodeQFilter(qFilter);
            String filterStr = qFilter.toString();
            String re = i < 9 ? "T0" + (i + 1) : "T" + (i + 1);
            expressStr = expressStr.replace(re, filterStr);
        }
        return HRFilterUtil.decodeQFilter(QFilter.of((String)expressStr, (Object[])new Object[0]), dateParamList);
    }

    public static QFilter condition2QFilter4IntelSearch(String conditionJson, String propKey) {
        RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditionJson, RuleConditionInfo.class);
        List conditionList = ruleConditionInfo.getConditionList();
        if (CollectionUtils.isEmpty((Collection)conditionList)) {
            return null;
        }
        conditionList.forEach(conditionInfo -> conditionInfo.setParam(propKey));
        ArrayList<String> dateParamList = new ArrayList<String>(conditionList.size());
        String expressStr = ruleConditionInfo.getConditionExpressStr();
        for (int i = 0; i < conditionList.size(); ++i) {
            QFilter qFilter = HRFilterUtil.condition2QFilter((ConditionInfo)conditionList.get(i), Collections.emptyList(), dateParamList);
            HRFilterUtil.encodeQFilter(qFilter);
            String filterStr = qFilter.toString();
            String re = i < 9 ? "T0" + (i + 1) : "T" + (i + 1);
            expressStr = expressStr.replace(re, filterStr);
        }
        return HRFilterUtil.decodeQFilter(QFilter.of((String)expressStr, (Object[])new Object[0]), dateParamList);
    }

    private static void encodeQFilter(QFilter qFilter) {
        List nestList;
        String value;
        String property = qFilter.getProperty();
        if (property.contains("_")) {
            property = property.replaceAll("_", "ENCODE_ENCODE");
        }
        if (property.contains("\u03b4")) {
            property = property.replaceAll("\u03b4", "__");
        }
        qFilter.__setProperty(property);
        if (qFilter.getValue() instanceof String && (value = qFilter.getValue().toString()).contains(QEmptyValue.value.toString())) {
            qFilter.__setValue((Object)value.replaceAll(QEmptyValue.value.toString(), ComplexConstant.ENCODE_EMPTY));
        }
        if (!CollectionUtils.isEmpty((Collection)(nestList = qFilter.getNests(false)))) {
            for (QFilter.QFilterNest qFilterNest : nestList) {
                HRFilterUtil.encodeQFilter(qFilterNest.getFilter());
            }
        }
    }

    private static QFilter decodeQFilter(QFilter qFilter, List<String> dateParamList) {
        List nestList;
        String property = qFilter.getProperty();
        if (property.contains("_")) {
            property = property.replaceAll("__", "\u03b4");
            property = property.replaceAll("ENCODE_ENCODE", "_");
        }
        qFilter.__setProperty(property);
        if (qFilter.getValue() instanceof String) {
            String value = qFilter.getValue().toString();
            if (value.equals(QEmptyValue.value.toString())) {
                qFilter.__setValue((Object)QEmptyValue.value);
            } else if (value.contains(ComplexConstant.ENCODE_EMPTY)) {
                qFilter.__setValue((Object)value.replaceAll(ComplexConstant.ENCODE_EMPTY, QEmptyValue.value.toString()));
            }
            if (dateParamList.contains(property)) {
                try {
                    qFilter.__setValue((Object)HRDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd"));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(nestList = qFilter.getNests(false)))) {
            for (QFilter.QFilterNest qFilterNest : nestList) {
                HRFilterUtil.decodeQFilter(qFilterNest.getFilter(), dateParamList);
            }
        }
        return qFilter;
    }

    static {
        operatorMap.put(RuleOperatorEnum.LESS_THAN.getValue(), "<");
        operatorMap.put(RuleOperatorEnum.GREATER_THAN.getValue(), ">");
        operatorMap.put(RuleOperatorEnum.LESS_OR_EQUAL.getValue(), "<=");
        operatorMap.put(RuleOperatorEnum.GREATER_OR_EQUAL.getValue(), ">=");
        operatorMap.put(RuleOperatorEnum.EQUAL.getValue(), "=");
        operatorMap.put(RuleOperatorEnum.NOT_EQUAL.getValue(), "!=");
        operatorMap.put(RuleOperatorEnum.IS_NULL.getValue(), "is null");
        operatorMap.put(RuleOperatorEnum.IS_NOT_NULL.getValue(), "is not null");
        operatorMap.put(RuleOperatorEnum.DEFAULT.getValue(), "=");
        dateList.add(RuleOperatorEnum.TODAY.getValue());
        dateList.add(RuleOperatorEnum.LESS_OR_EQUALS_TODAY.getValue());
        dateList.add(RuleOperatorEnum.GREATER_OR_EQUALS_TODAY.getValue());
        dateList.add(RuleOperatorEnum.YESTERDAY.getValue());
        dateList.add(RuleOperatorEnum.TOMORROW.getValue());
        dateList.add(RuleOperatorEnum.THIS_WEEK.getValue());
        dateList.add(RuleOperatorEnum.LAST_WEEK.getValue());
        dateList.add(RuleOperatorEnum.NEXT_WEEK.getValue());
        dateList.add(RuleOperatorEnum.THIS_MONTH.getValue());
        dateList.add(RuleOperatorEnum.LAST_MONTH.getValue());
        dateList.add(RuleOperatorEnum.NEXT_MONTH.getValue());
        dateList.add(RuleOperatorEnum.LAST3MONTH.getValue());
        dateList.add(RuleOperatorEnum.NEXT3MONTH.getValue());
        dateList.add(RuleOperatorEnum.THIS_QUARTER.getValue());
        dateList.add(RuleOperatorEnum.LAST_QUARTER.getValue());
        dateList.add(RuleOperatorEnum.NEXT_QUARTER.getValue());
        dateList.add(RuleOperatorEnum.THIS_YEAR.getValue());
        dateList.add(RuleOperatorEnum.LAST_YEAR.getValue());
        dateList.add(RuleOperatorEnum.NEXT_YEAR.getValue());
        dateList.add(RuleOperatorEnum.LAST1MONTH.getValue());
        dateList.add(RuleOperatorEnum.NEXT1MONTH.getValue());
        dateList.add(RuleOperatorEnum.LESS_TODAY.getValue());
        dateList.add(RuleOperatorEnum.GREATER_TODAY.getValue());
        dateList.add(RuleOperatorEnum.LAST3DAY.getValue());
        dateList.add(RuleOperatorEnum.LAST7DAY.getValue());
        dateList.add(RuleOperatorEnum.LAST15DAY.getValue());
        dateList.add(RuleOperatorEnum.LAST60DAY.getValue());
        dateList.add(RuleOperatorEnum.THIS_MONTH_TO_DAY.getValue());
        dateList.add(RuleOperatorEnum.THIS_YEAR_TO_DAY.getValue());
    }
}

