/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.message;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.message.HRMessageConsumer;
import kd.hr.hbp.business.service.message.MsgCenterResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRISVUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class HRMsgCenterConsumer
extends HRMessageConsumer {
    private static final Log logger = LogFactory.getLog(HRMsgCenterConsumer.class);

    @Override
    protected void consumeMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        super.consumeMessage(message, messageId, resend, acker);
        if (!(message instanceof Map)) {
            return;
        }
        this.bizConsumeMessage(message);
    }

    private void bizConsumeMessage(Object message) {
        Map tempMap = null;
        long msgCenterId = 0L;
        try {
            tempMap = (Map)message;
            Long result = HRMsgCenterConsumer.queryDuplicateMsgCenter(tempMap, "msgNumber", "actionId");
            msgCenterId = null != result ? result : HRMsgCenterConsumer.publishMsgToMsgCenter(tempMap);
            tempMap.put("msgCenterId", msgCenterId);
            logger.info("******* Accepted Msg , Msg Data:{} ", message);
        }
        catch (Exception ex) {
            logger.error("bizConsumeMessage_or_publishMsgToMsgCenter_error:{}", message, (Object)ex);
            return;
        }
        List subInfoList = (List)tempMap.get("subInfoList");
        HashMap subInvokeResult = Maps.newHashMapWithExpectedSize((int)16);
        for (Map subInfo : subInfoList) {
            this.invokeService(tempMap, msgCenterId, subInvokeResult, subInfo);
        }
        HRMServiceHelper.invokeBizService("hrmp", "hrcs", "IHRCSMsgService", "consumeMsgToMsgCenter", msgCenterId, subInvokeResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeService(Map<String, Object> tempMap, long msgCenterId, Map<Long, MsgCenterResult> subInvokeResult, Map<String, String> subInfo) {
        Long subscribeId = subInfo.containsKey("subscribeId") ? Long.parseLong(subInfo.get("subscribeId")) : Long.parseLong(subInfo.get("businessTypeId"));
        MsgCenterResult msgCenterResult = new MsgCenterResult();
        msgCenterResult.setRecStatus("A");
        try {
            this.checkGroupStrategy(tempMap, subscribeId);
            String consumerCloud = subInfo.get("consumerCloud").toLowerCase(Locale.ROOT);
            String consumerAPP = subInfo.get("consumerAPP");
            String consumerService = subInfo.get("consumerService");
            String consumerMethod = subInfo.get("consumerMethod");
            DynamicObject tplDy = HRProducerServiceHelper.buildMsgDyObj(tempMap, subInfo);
            logger.info("*******msgCenterId = {}, subscribeId = {}, Msg Send to CLOUD:{}, APP:{}, Service:{}, Method:{}", new Object[]{msgCenterId, subscribeId, consumerCloud, consumerAPP, consumerService, consumerMethod});
            Object result = null;
            result = !HRISVUtils.isKingdeeIsv((String)consumerAPP) || StringUtils.isNotEmpty((CharSequence)subInfo.get("isnonoriginal")) && Boolean.parseBoolean(subInfo.get("isnonoriginal")) ? HRMServiceHelper.invokeService(consumerCloud, consumerAPP, consumerService, consumerMethod, tplDy) : HRMServiceHelper.invokeBizService(consumerCloud, consumerAPP, consumerService, consumerMethod, tplDy);
            if (!(result instanceof HRMServiceResult)) {
                return;
            }
            HRMServiceResult hrmServiceResult = result;
            if (!"success".equalsIgnoreCase(hrmServiceResult.getReturnCode())) {
                throw new KDBizException(new ErrorCode(hrmServiceResult.getReturnCode(), hrmServiceResult.getMessage()), new Object[0]);
            }
            if (hrmServiceResult.getReturnData() instanceof MsgCenterResult) {
                MsgCenterResult returnData = (MsgCenterResult)hrmServiceResult.getReturnData();
                msgCenterResult.setHandleStatus(returnData.getHandleStatus());
                msgCenterResult.setConsumeMsg(returnData.getConsumeMsg());
            }
        }
        catch (Exception ex) {
            msgCenterResult.setRecStatus("B");
            msgCenterResult.setRecMessage(ex.getMessage());
            logger.error("bizConsumeMessage_invoke_biz_mservice_error,msgCenterId:{},subscribeId:{}", new Object[]{msgCenterId, subscribeId, ex});
        }
        finally {
            subInvokeResult.put(subscribeId, msgCenterResult);
        }
    }

    private void checkGroupStrategy(Map<String, Object> tempMap, long subscribeId) {
        if (ObjectUtils.isEmpty((Object)tempMap.get("groupNumber"))) {
            return;
        }
        if (((Boolean)HRMServiceHelper.invokeBizService("hrmp", "hrcs", "IHRCSMsgService", "checkGroupStrategy", tempMap.get("groupNumber"), new Date(), subscribeId)).booleanValue()) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8ba2\u9605\u65b9\u5206\u7ec4\u6d88\u606f%1$s\u5b58\u5728\u672a\u6d88\u8d39\u6210\u529f\u7684\u524d\u5e8f\u6d88\u606f\uff0c\u672c\u6d88\u606f\u4e0d\u53d1\u9001\u3002", (String)"HRMsgCenterConsumer_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), tempMap.get("groupNumber")));
        }
    }

    private static long publishMsgToMsgCenter(Map<String, Object> messageInfo) {
        String msgNumber = (String)messageInfo.get("msgNumber");
        String msgTitle = (String)messageInfo.get("msgTitle");
        String msgDesc = (String)messageInfo.get("msgDesc");
        Long msgPublisherId = (Long)messageInfo.get("msgPublisherId");
        Long actionId = (Long)messageInfo.get("actionId");
        String msgTag = (String)messageInfo.get("msgTag");
        Long senderId = (Long)messageInfo.get("senderId");
        Date sendTime = (Date)messageInfo.get("sendTime");
        String params = (String)messageInfo.get("params");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgcenter");
        DynamicObject msgCenterDy = serviceHelper.generateEmptyDynamicObject();
        msgCenterDy.set("number", (Object)msgNumber);
        msgCenterDy.set("msgtitle", (Object)msgTitle);
        msgCenterDy.set("msgdesc", (Object)msgDesc);
        msgCenterDy.set("msgpublisher", (Object)msgPublisherId);
        msgCenterDy.set("action", (Object)actionId);
        msgCenterDy.set("msgtag", (Object)msgTag);
        msgCenterDy.set("sender", (Object)senderId);
        if (ObjectUtils.isNotEmpty((Object)messageInfo.get("groupNumber"))) {
            msgCenterDy.set("groupnum", messageInfo.get("groupNumber"));
        }
        if (ObjectUtils.isNotEmpty((Object)messageInfo.get("groupSeq"))) {
            msgCenterDy.set("groupseq", messageInfo.get("groupSeq"));
        }
        if (ObjectUtils.isNotEmpty((Object)messageInfo.get("groupCount"))) {
            msgCenterDy.set("groupcount", messageInfo.get("groupCount"));
        }
        if (Objects.isNull(sendTime)) {
            sendTime = HRDateTimeUtils.curDate();
        }
        msgCenterDy.set("sendtime", (Object)sendTime);
        msgCenterDy.set("params", (Object)params);
        msgCenterDy.set("puber", messageInfo.get("pubEr"));
        HRBaseUtils.setSysField((DynamicObject)msgCenterDy);
        return (Long)HRMServiceHelper.invokeBizService("hrmp", "hrcs", "IHRCSMsgService", "sendMsgToMsgCenter", msgCenterDy);
    }

    private static Long queryDuplicateMsgCenter(Map<String, Object> actionInfo, String ... keys) {
        if (Objects.isNull(keys)) {
            return null;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(keys.length);
        for (String key : keys) {
            String dyKey;
            Object value = actionInfo.get(key);
            if (!Objects.nonNull(value) || !HRStringUtils.isNotEmpty((String)(dyKey = HRProducerServiceHelper.META_FIELD_MAPPING.get(key)))) continue;
            filters.add(new QFilter(dyKey, "=", value));
        }
        if (!filters.isEmpty()) {
            return (Long)HRMServiceHelper.invokeBizService("hrmp", "hrcs", "IHRCSMsgService", "queryMsgCenter", new Object[]{filters.toArray(new QFilter[0])});
        }
        return null;
    }
}

