/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.message.coordination;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public abstract class CoordinationTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(CoordinationTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> requestMap) {
        boolean isSuccess = true;
        DynamicObject[] tasksByBatchNo = this.getTasksByBatchNo((String)requestMap.get("batchNo"));
        requestMap.put("tasks", tasksByBatchNo);
        Object taskId = requestMap.get("taskId");
        this.validateParams(requestMap);
        try {
            if (!this.checkTaskStatus(requestMap)) {
                LOGGER.info("checkTaskStatus_fail!,taskId:{}", taskId);
                requestMap.put("errMsg", ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1\u4e3a\u975e\u6210\u529f\u72b6\u6001\uff0c\u5f53\u524d\u4efb\u52a1\u4e0d\u53ef\u6267\u884c\u3002", (String)"CoordinationTask_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                requestMap.put("prePass", false);
                return;
            }
            if (!this.validateBusiness(requestMap)) {
                LOGGER.info("validateBusiness_fail!,taskId:{}", taskId);
                return;
            }
            this.doBusiness(requestMap);
        }
        catch (Throwable ex) {
            LOGGER.error("CoordinationTask_execute_error,taskId:{},ex:{}", taskId, (Object)ex);
            isSuccess = false;
            requestMap.put("errMsg", ex.getMessage());
        }
        finally {
            requestMap.putIfAbsent("isSuccess", isSuccess);
            this.doBusinessCallback(requestMap);
        }
    }

    public void doBusinessCallback(Map<String, Object> requestMap) {
        LOGGER.info("doBusinessCallback_beginning,taskId:{}", requestMap.get("taskId"));
        Boolean prePass = (Boolean)requestMap.get("prePass");
        if (!Objects.equals(prePass, Boolean.FALSE)) {
            this.updateTaskStatus(requestMap);
            this.saveLog(requestMap);
            DynamicObject[] newTasksByBatchNo = this.getTasksByBatchNo((String)requestMap.get("batchNo"));
            requestMap.put("tasks", newTasksByBatchNo);
            if (this.isPassCallback(requestMap)) {
                Map<String, Object> callbackDataMap = this.getCallbackData(requestMap);
                this.callback(callbackDataMap);
            }
        }
    }

    protected void validateParams(Map<String, Object> requestMap) {
        Object taskId = requestMap.get("taskId");
        DynamicObject[] tasks = (DynamicObject[])requestMap.get("tasks");
        Object batchNo = requestMap.get("batchNo");
        if (taskId == null) {
            throw new KDBizException("Param taskId is Null!");
        }
        if (tasks == null || tasks.length == 0) {
            throw new KDBizException("Param tasks is Null or Empty!");
        }
        if (batchNo == null) {
            throw new KDBizException("Param batchNo is Null!");
        }
    }

    private boolean checkTaskStatus(Map<String, Object> requestMap) {
        DynamicObject[] tasks = (DynamicObject[])requestMap.get("tasks");
        Long id = (Long)requestMap.get("taskId");
        Map<Long, DynamicObject> taskMap = Arrays.stream(tasks).collect(Collectors.toMap(task -> task.getLong("id"), task -> task));
        DynamicObject curTask = taskMap.get(id);
        DynamicObjectCollection parTasks = curTask.getDynamicObjectCollection("parent");
        boolean isPass = true;
        if (!CollectionUtils.isEmpty((Collection)parTasks)) {
            for (DynamicObject parTask : parTasks) {
                long parId = ((DynamicObject)parTask.get("fbasedataid")).getLong("id");
                String status = taskMap.get(parId).getString("taskstatus");
                if (Objects.equals("E", status)) continue;
                isPass = false;
                break;
            }
        }
        return isPass;
    }

    protected abstract boolean validateBusiness(Map<String, Object> var1);

    protected abstract void updateTaskStatus(Map<String, Object> var1);

    protected abstract void doBusiness(Map<String, Object> var1);

    protected abstract DynamicObject[] getTasksByBatchNo(String var1);

    protected abstract void saveLog(Map<String, Object> var1);

    private boolean isPassCallback(Map<String, Object> requestMap) {
        DynamicObject[] tasks;
        Object taskId = requestMap.get("taskId");
        Boolean isDiyCallback = (Boolean)requestMap.get("diyCallback");
        if (isDiyCallback == null) {
            isDiyCallback = true;
        }
        boolean isCallback = true;
        for (DynamicObject task : tasks = (DynamicObject[])requestMap.get("tasks")) {
            String status = task.getString("taskstatus");
            Object id = task.get("id");
            if (!"B".equals(status) && (!"C".equals(status) || Objects.equals(taskId, id))) continue;
            isCallback = false;
            break;
        }
        LOGGER.info("isPassCallback_success:{}", (Object)isCallback);
        return isCallback && isDiyCallback != false;
    }

    private Map<String, Object> getCallbackData(Map<String, Object> requestMap) {
        DynamicObject[] tasks = (DynamicObject[])requestMap.get("tasks");
        int successCount = 0;
        for (DynamicObject task : tasks) {
            String status = task.getString("taskstatus");
            if (!"E".equals(status)) continue;
            ++successCount;
        }
        String status = successCount == tasks.length ? "1" : (successCount == 0 ? "3" : "2");
        HashMap callbackDataMap = Maps.newHashMapWithExpectedSize((int)16);
        callbackDataMap.put("msgCenterId", requestMap.get("msgCenterId"));
        callbackDataMap.put("msgSubNo", requestMap.get("msgSubNo"));
        callbackDataMap.put("businessTypeId", requestMap.get("businessTypeId"));
        callbackDataMap.put("consumeMsg", requestMap.get("consumeMsg"));
        callbackDataMap.put("handleStatus", status);
        return callbackDataMap;
    }

    private void callback(Map<String, Object> callbackDataMap) {
        HRMServiceHelper.invokeHRMPService("hrcs", "IHRCSMsgService", "updateConsumeMsgInfo", callbackDataMap);
    }
}

