/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.ksql.util.StringUtil;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.QueryBuilderFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRQueryExactMatchListDataProvider
extends ListDataProvider {
    public DynamicObjectCollection getData(int start, int limit) {
        List qFilterList = this.getQFilters();
        QueryBuilder thisQueryBuilder = QueryBuilderFactory.createQueryBuilder((IListDataProvider)this, (int)start, (int)limit, (boolean)false);
        if (this.containQuickSearch(qFilterList)) {
            this.ftlikeTransEq(qFilterList);
            this.setQFilters(qFilterList);
            QueryEntityType entityType = (QueryEntityType)thisQueryBuilder.getEntityType();
            HRQueryEntityHelper queryEntityHelper = HRQueryEntityHelper.getInstance();
            Map<String, Object> confMap = queryEntityHelper.queryEntityReleaseInfo(entityType.getName());
            String datasourcetype = (String)confMap.get("datasourcetype");
            if (HRStringUtils.isEmpty((String)datasourcetype) || "ALGO".equals(datasourcetype)) {
                return super.getData(start, limit);
            }
            DynamicObjectCollection dyoColl = queryEntityHelper.getQueryDyoColl(entityType, thisQueryBuilder.getReturnEntityType(), this.getListSelectFields(thisQueryBuilder), qFilterList.toArray(new QFilter[0]), thisQueryBuilder.getOrderBys(), true, start, limit);
            this.getQueryResult().setDataCount(dyoColl.size());
            this.getQueryResult().setBillDataCount(dyoColl.size());
            this.getQueryResult().setCollection(dyoColl);
            return dyoColl;
        }
        DynamicObjectCollection emptyDyoColl = new DynamicObjectCollection(thisQueryBuilder.getReturnEntityType(), null);
        this.getQueryResult().setDataCount(0);
        this.getQueryResult().setBillDataCount(0);
        this.getQueryResult().setCollection(emptyDyoColl);
        return emptyDyoColl;
    }

    private String getListSelectFields(QueryBuilder queryBuilder) {
        HashSet<String> selectFieldSet = new HashSet<String>(16);
        selectFieldSet.addAll(Arrays.asList(queryBuilder.getSelectFields().split(",")));
        String orderByStr = queryBuilder.getOrderBys();
        if (!StringUtil.isEmpty((String)orderByStr)) {
            String[] tempStrs;
            for (String temp : tempStrs = orderByStr.trim().split(",")) {
                selectFieldSet.add(temp.trim().split(" ")[0].toLowerCase());
            }
        }
        return Joiner.on((char)',').join(selectFieldSet);
    }

    private void ftlikeTransEq(List<QFilter> qFilterList) {
        QFilter qFilter;
        HashMap keyMatchMap = Maps.newHashMapWithExpectedSize((int)16);
        Iterator<QFilter> iterator = qFilterList.iterator();
        while (iterator.hasNext()) {
            qFilter = iterator.next();
            if (!this.isQuickSearch(qFilter)) continue;
            String[] properties = qFilter.getProperties();
            String value = qFilter.getValue().toString().split("#")[1].replaceAll("%", "");
            String[] split = value.split("\b");
            for (String property : properties) {
                List qfValues = (List)keyMatchMap.get(property);
                if (qfValues == null) {
                    qfValues = Lists.newArrayListWithExpectedSize((int)10);
                }
                qfValues.addAll(Arrays.asList(split));
                keyMatchMap.put(property, qfValues);
            }
            iterator.remove();
        }
        qFilter = null;
        for (Map.Entry entry : keyMatchMap.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            QFilter tempQFilter = value.size() == 1 ? new QFilter(key, "=", value.get(0)) : new QFilter(key, "in", (Object)value);
            if (qFilter == null) {
                qFilter = tempQFilter;
                continue;
            }
            qFilter.or(tempQFilter);
        }
        qFilterList.add(qFilter);
    }

    private boolean isQuickSearch(QFilter qFilter) {
        if (qFilter == null) {
            return false;
        }
        return "ftlike".equals(qFilter.getCP()) && qFilter.getValue().toString().contains("#");
    }

    private boolean containQuickSearch(List<QFilter> qFilterList) {
        for (QFilter qFilter : qFilterList) {
            if (!this.isQuickSearch(qFilter)) continue;
            return true;
        }
        return false;
    }
}

