/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.es;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.QueryBuilderFactory;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.business.service.query.es.storage.EsResultVo;
import kd.hr.hbp.business.service.query.es.storage.EsStorage;
import kd.hr.hbp.business.service.query.es.storage.EsStorageFactory;
import kd.hr.hbp.business.service.query.es.storage.SortField;
import kd.hr.hbp.business.service.query.util.ListProviderDynamicObjCollectionUtil;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.business.service.query.util.QueryEsFilterFieldTransfer;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.EsCommonUtils;
import kd.hr.hbp.common.util.QueryEntityTypeUtil;
import kd.hr.hbp.common.util.QueryEntityUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.ElasticsearchStatusException;

public class EsListDataProvider
extends ListDataProvider {
    private static final Log logger = LogFactory.getLog(EsListDataProvider.class);
    private static final int lIST_PAGE_DATA_COUNT = 100000;
    private static String ENTITYS_SEPARATOR = ".";
    private static String ES_PAGE_CACHECOUNT = "es_page_cachecount";
    private static String SEARCH_AFTER_SORTED_VALUES = "search_after_sorted_values";
    private static String SEARCH_AFTER_SORTED_KEYS = "search_after_sorted_keys";
    private EsStorage storage = null;
    private QueryEntityType queryEntity;
    private IHRAppCache appCache;

    public EsListDataProvider(String pageId) {
        this.appCache = HRAppCache.get((String)pageId);
        this.storage = EsStorageFactory.getStorage("hr");
    }

    public int getBillDataCount() {
        String dataCount = (String)this.appCache.get(ES_PAGE_CACHECOUNT, String.class);
        if (StringUtils.isNotBlank((CharSequence)dataCount) && dataCount.chars().allMatch(Character::isDigit)) {
            return Integer.parseInt(dataCount);
        }
        return 0;
    }

    public int getRealCount() {
        String dataCount = (String)this.appCache.get(ES_PAGE_CACHECOUNT, String.class);
        if (StringUtils.isNotBlank((CharSequence)dataCount) && dataCount.chars().allMatch(Character::isDigit)) {
            return Integer.parseInt(dataCount);
        }
        return 0;
    }

    public DynamicObjectCollection getData(int start, int limit) throws KDBizException {
        QueryBuilder thisQueryBuilder = QueryBuilderFactory.createQueryBuilder((IListDataProvider)this, (int)start, (int)limit, (boolean)false);
        long startTime = System.currentTimeMillis();
        DynamicObjectCollection result = this.queryEsCollection(thisQueryBuilder, start);
        this.optEndLog("queryEsCollection", startTime);
        return result;
    }

    private void optEndLog(String opt, long startTime) {
        long ms = System.currentTimeMillis() - startTime;
        String msg = "----optEndLog----" + opt + "------" + ms + "ms----\r\n";
        logger.info(msg);
    }

    public DynamicObjectCollection queryDynamicObjectCollection(QueryEntityType queryType, DynamicObjectType dynamicObjectType, String selectFields, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit) throws KDBizException {
        this.queryEntity = queryType;
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(dynamicObjectType, null);
        Object[] qFiltersCopy = new QFilter[qFilters.length];
        for (int i = 0; i < qFilters.length; ++i) {
            if (qFilters[i] == null) continue;
            qFiltersCopy[i] = qFilters[i].copy();
        }
        HashMap<Integer, List<QFilter>> unionFiltersMap = new HashMap<Integer, List<QFilter>>();
        Object[] flikeQFilters = QFilterUtilHR.rebuidFlikeQFilterEx(unionFiltersMap, (QFilter[])qFiltersCopy, Boolean.FALSE, queryType);
        QFilter[] newFilters = (QFilter[])ArrayUtils.addAll((Object[])flikeQFilters, (Object[])qFiltersCopy);
        newFilters = (QFilter[])Arrays.stream(newFilters).filter(Objects::nonNull).toArray(QFilter[]::new);
        this.transPrivacyQfilter(newFilters);
        QueryEsFilterFieldTransfer esFilterFieldTransfer = new QueryEsFilterFieldTransfer();
        List<EsFilterField> esFilterFields = esFilterFieldTransfer.transferQFilter(queryType, newFilters);
        HashSet<String> selectFieldList = new HashSet<String>();
        this.buildSelect(selectFields, selectFieldList);
        String[] selectFieldArr = selectFieldList.toArray(new String[selectFieldList.size()]);
        SortField[] sortFields = this.buildSortFields(orderBys);
        long startTime = System.currentTimeMillis();
        String preName = EsCommonUtils.getIndexNamePrefix((String)"hr");
        String queryEntityName = queryType.getName();
        String indexAliasName = preName + "_" + queryEntityName;
        EsResultVo esResultVo = this.getEsResult(queryEntityName, isLimitCount, start, limit, sortFields, selectFieldArr, esFilterFields);
        List<Map<String, Object>> result = esResultVo.getResultData();
        this.optEndLog("storage.query", startTime);
        int count = this.storage.getCount(indexAliasName, null, esFilterFields);
        super.getQueryResult().setBillDataCount(count);
        super.getQueryResult().setDataCount(count);
        this.appCache.put(ES_PAGE_CACHECOUNT, (Object)String.valueOf(count));
        List<Map<String, Object>> newResult = this.flattenDataList(result, queryType.getJoinRelations());
        ListProviderDynamicObjCollectionUtil dynamicObjColUtil = new ListProviderDynamicObjCollectionUtil(selectFields, queryType);
        DynamicObjectCollection dynamicObjectCollectionResult = dynamicObjColUtil.createDynamicObjectCollection(newResult, start, dynamicObjectCollection, dynamicObjectType);
        this.optEndLog("dynamicObjectCollectionResult", startTime);
        return dynamicObjectCollectionResult;
    }

    private void transPrivacyQfilter(QFilter[] newFilters) {
        for (QFilter newFilter : newFilters) {
            String mainEntityName;
            Boolean isMainEntity = false;
            String entityName = QFilterUtilHR.getSubEntityName(newFilter.getProperty(), this.queryEntity);
            if (entityName == null) {
                entityName = this.queryEntity.getEntityName();
                isMainEntity = true;
            }
            String propertyname = null;
            String[] nameKeys = newFilter.getProperty().split("\\.");
            propertyname = isMainEntity.booleanValue() ? (nameKeys[0].equalsIgnoreCase(mainEntityName = this.queryEntity.getEntityName()) ? nameKeys[1] : nameKeys[0]) : nameKeys[1];
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            DynamicProperty dynamicProperty = dataEntityType.getProperty(propertyname);
            if (dynamicProperty == null) {
                logger.info("entitynum:{}, propertyname:{}, qfilter:{}", new Object[]{this.queryEntity.getName(), propertyname, newFilter.toString()});
                throw new KDBizException(this.queryEntity.getName() + " not exists property:" + propertyname);
            }
            if (!ORMConfig.PRIVACY_ENABLE.getBoolean() || !PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)dynamicProperty)) continue;
            QFilterUtilHR.handlePrivacyProperty(dynamicProperty, newFilter, this.queryEntity, propertyname);
        }
    }

    private DynamicObjectCollection queryEsCollection(QueryBuilder queryBuilder, int start) throws KDBizException {
        this.queryEntity = (QueryEntityType)queryBuilder.getEntityType();
        QFilter[] qFilters = queryBuilder.getFilters();
        String listSelectFields = this.getListSelectFields();
        DynamicObjectType returnEntityType = queryBuilder.getReturnEntityType();
        QueryEntityTypeUtil queryEntityUtil = new QueryEntityTypeUtil(this.queryEntity, listSelectFields);
        queryEntityUtil.tryRegisterJoinPk(returnEntityType);
        DynamicObjectCollection collection = this.queryDynamicObjectCollection(this.queryEntity, returnEntityType, listSelectFields, qFilters, queryBuilder.getOrderBys(), true, start, queryBuilder.getLimit());
        this.getQueryResult().setCollection(collection);
        return collection;
    }

    private String getListSelectFields() {
        List listFields = this.getListFields();
        return listFields.stream().map(ListField::getFieldName).collect(Collectors.joining(","));
    }

    private EsResultVo getEsResult(String entityName, boolean isLimitCount, int start, int limit, SortField[] sortFields, String[] selectFieldArr, List<EsFilterField> esFilterFields) throws KDBizException {
        String preName = EsCommonUtils.getIndexNamePrefix((String)"hr");
        String indexAliasName = preName + "_" + entityName;
        boolean bNeedSaveSortedKeyValue = this.needSaveSortedKeyValue(entityName, start, limit, this.storage);
        EsResultVo esResultVo = null;
        boolean bSortedKeyChanged = this.isSortedKeyChanged(sortFields);
        if (!isLimitCount) {
            return this.queryAllEsResultVo(sortFields, selectFieldArr, esFilterFields, indexAliasName);
        }
        boolean bNeedSearchAfter = this.needSearchAfter(this.appCache, sortFields, entityName, start, limit);
        try {
            if (bNeedSearchAfter) {
                if (bSortedKeyChanged) {
                    QueryBuilder queryBuilder = this.getQueryBuilder();
                    if (queryBuilder != null) {
                        queryBuilder.setStart(limit);
                    }
                    esResultVo = this.storage.query(indexAliasName, null, selectFieldArr, esFilterFields, sortFields, true, start, limit);
                } else {
                    Object objSortValues = this.appCache.get(SEARCH_AFTER_SORTED_VALUES, Object.class);
                    List listSortValues = (List)objSortValues;
                    esResultVo = this.storage.searchAfter(indexAliasName, null, selectFieldArr, esFilterFields, sortFields, true, start, limit, listSortValues.toArray());
                }
            } else {
                esResultVo = this.storage.query(indexAliasName, null, selectFieldArr, esFilterFields, sortFields, true, start, limit);
            }
        }
        catch (ElasticsearchStatusException ex) {
            logger.error("ES\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u53ef\u80fd\u4e3aES\u53c2\u6570 index.max_result_window \u503c\u8bbe\u7f6e\u5c0f\u4e8e( " + String.valueOf(100000) + ")," + ex.getDetailedMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25,\u8bf7\u68c0\u67e5\u65e5\u5fd7\u6587\u4ef6\u3002", (String)"EsListDataProvider_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            logger.error("\u67e5\u8be2\u6570\u636e\u5931\u8d25!" + ex.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25,\u8bf7\u68c0\u67e5\u65e5\u5fd7\u6587\u4ef6\u3002", (String)"EsListDataProvider_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        if (bNeedSaveSortedKeyValue) {
            Object[] objectSortValues = esResultVo.getObjSortValues();
            this.appCache.put(SEARCH_AFTER_SORTED_KEYS, (Object)sortFields);
            this.appCache.put(SEARCH_AFTER_SORTED_VALUES, (Object)objectSortValues);
        } else {
            this.appCache.put(SEARCH_AFTER_SORTED_KEYS, null);
            this.appCache.put(SEARCH_AFTER_SORTED_VALUES, null);
        }
        return esResultVo;
    }

    private EsResultVo queryAllEsResultVo(SortField[] sortFields, String[] selectFieldArr, List<EsFilterField> esFilterFields, String indexAliasName) {
        int rsSize;
        EsResultVo esResultVo = null;
        int start = 0;
        int limit = 1000;
        Object[] objectSortValues = null;
        do {
            EsResultVo tempEsRst = this.storage.searchAfter(indexAliasName, null, selectFieldArr, esFilterFields, sortFields, true, start, limit, objectSortValues);
            start += limit;
            objectSortValues = tempEsRst.getObjSortValues();
            rsSize = tempEsRst.getResultData().size();
            if (esResultVo == null) {
                esResultVo = tempEsRst;
                continue;
            }
            esResultVo.getResultData().addAll(tempEsRst.getResultData());
            esResultVo.setObjSortValues(tempEsRst.getObjSortValues());
        } while (rsSize == limit);
        return esResultVo;
    }

    private boolean needSaveSortedKeyValue(String entityName, int start, int limit, EsStorage storage) {
        if (start == 0 || limit == 0) {
            return false;
        }
        int difference = 100000 - start - limit;
        return difference < limit;
    }

    private boolean needSearchAfter(IHRAppCache appCache, SortField[] sortFields, String entityName, int start, int limit) {
        List listSortValues;
        Object objSortValues = appCache.get(SEARCH_AFTER_SORTED_VALUES, Object.class);
        if (objSortValues instanceof List && CollectionUtils.isNotEmpty((Collection)(listSortValues = (List)objSortValues))) {
            if (start == 0 || limit == 0) {
                return false;
            }
            if (start + limit > 100000) {
                return true;
            }
        }
        return false;
    }

    private boolean isSortedKeyChanged(SortField[] sortFields) {
        Object objSortKeys = this.appCache.get(SEARCH_AFTER_SORTED_KEYS, Object.class);
        List listSortKeys = null;
        if (!(objSortKeys instanceof List)) {
            return false;
        }
        listSortKeys = (List)objSortKeys;
        if (CollectionUtils.isEmpty((Collection)listSortKeys) && (sortFields == null || sortFields.length == 0)) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)listSortKeys) || sortFields == null || sortFields.length == 0) {
            return true;
        }
        if (sortFields.length != listSortKeys.size()) {
            return true;
        }
        for (int i = 0; i < listSortKeys.size(); ++i) {
            Map mapKey = (Map)listSortKeys.get(i);
            if (mapKey == null) continue;
            String sortName = (String)mapKey.get("name");
            Boolean order = (Boolean)mapKey.get("asc");
            boolean matched = false;
            for (SortField sortField : sortFields) {
                if (sortField == null || !sortField.getName().equals(sortName) || sortField.isAsc() != order.booleanValue()) continue;
                matched = true;
            }
            if (matched) continue;
            return true;
        }
        return false;
    }

    private void buildSelect(String selectFields, Set<String> selectFieldSet) {
        String[] selectFieldArr;
        for (String fieldName : selectFieldArr = selectFields.split(",")) {
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            String entityName = null;
            boolean isMainEntity = false;
            entityName = QFilterUtilHR.getSubEntityName(fieldName, this.queryEntity);
            if (entityName == null) {
                entityName = this.queryEntity.getEntityName();
                isMainEntity = true;
            }
            MainEntityType relationEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            IDataEntityProperty property = QueryEntityUtil.findProperty((MainEntityType)relationEntityType, (String)fieldName);
            StringBuilder sb = new StringBuilder();
            if (property instanceof DynamicComplexProperty) {
                String[] nameKeys = fieldName.split("\\.");
                if (isMainEntity && nameKeys.length == 3) {
                    sb.append(nameKeys[0]).append(".id");
                } else if (nameKeys.length == 4) {
                    sb.append(nameKeys[0]).append(".").append(nameKeys[1]).append(".id");
                } else {
                    sb.append(fieldName.replace(fieldName.substring(fieldName.lastIndexOf(".") + 1), "id"));
                }
            } else if (property instanceof ILocaleProperty) {
                sb.append(fieldName).append("_l.").append(RequestContext.get().getLang().name());
                selectFieldSet.add(fieldName);
            } else {
                DynamicSimpleProperty dynamicSimpleProperty;
                boolean isEncrypt;
                if (property instanceof DynamicSimpleProperty && (isEncrypt = (dynamicSimpleProperty = (DynamicSimpleProperty)property).isEncrypt())) {
                    sb.append(fieldName).append("_enp");
                    selectFieldSet.add(sb.toString());
                    sb = new StringBuilder();
                }
                sb.append(fieldName);
            }
            selectFieldSet.add(sb.toString());
        }
    }

    private SortField[] buildSortFields(String orderBys) {
        SortField[] sortFields = null;
        if (StringUtils.isBlank((CharSequence)orderBys)) {
            sortFields = new SortField[]{new SortField("_id", null, false)};
            return sortFields;
        }
        String[] orderByArr = orderBys.split(",");
        sortFields = new SortField[orderByArr.length + 1];
        for (int i = 0; i < orderByArr.length; ++i) {
            String[] orderByArrSub = orderByArr[i].split(" ");
            String fieldName = orderByArrSub[0];
            boolean subEntityFlags = true;
            String entityName = QFilterUtilHR.getSubEntityName(fieldName, this.queryEntity);
            if (entityName == null) {
                entityName = this.queryEntity.getEntityName();
                subEntityFlags = false;
            }
            MainEntityType relationEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            IDataEntityProperty property = QueryEntityUtil.findProperty((MainEntityType)relationEntityType, (String)fieldName);
            StringBuilder sb = new StringBuilder();
            if (null != property && property instanceof DynamicComplexProperty) continue;
            if (property instanceof ILocaleProperty) {
                sb.append(fieldName).append("_l.").append(RequestContext.get().getLang().name()).append(".keyword");
            } else if (property instanceof TextProp) {
                sb.append(fieldName);
                sb.append(".keyword");
            } else {
                sb.append(fieldName);
            }
            SortField sortField = new SortField(sb.toString());
            if (subEntityFlags) {
                sortField.setPath(entityName);
            }
            if (orderByArrSub.length == 2) {
                if ("ASC".equalsIgnoreCase(orderByArrSub[1])) {
                    sortField.setAsc(true);
                } else {
                    sortField.setAsc(false);
                }
            } else if (orderByArrSub.length == 1) {
                sortField.setAsc(true);
            }
            sortFields[i] = sortField;
        }
        sortFields[orderByArr.length] = new SortField("_id", null, false);
        return sortFields;
    }

    private List<Map<String, Object>> flattenDataList(List<Map<String, Object>> list, List<QuerySourceJoinRelation> listRelation) {
        String langStr = "_l." + RequestContext.get().getLang().name();
        ArrayList newList = Lists.newArrayListWithCapacity((int)16);
        for (Map<String, Object> map : list) {
            HashMap newMap = Maps.newHashMapWithExpectedSize((int)16);
            HashSet encryptFildSet = Sets.newHashSetWithExpectedSize((int)16);
            HashSet mulFieldCache = Sets.newHashSetWithExpectedSize((int)16);
            block1: for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                String subEntityName = key + ENTITYS_SEPARATOR;
                Object objValue = entry.getValue();
                if (objValue instanceof List) {
                    List nestList = (List)objValue;
                    for (int i = 0; i < nestList.size(); ++i) {
                        Object objMap = nestList.get(i);
                        if (!(objMap instanceof Map)) continue;
                        Map mapNested = (Map)objMap;
                        for (Map.Entry mapNestedEntry : mapNested.entrySet()) {
                            String nestKey;
                            String nestFiledName = (String)mapNestedEntry.getKey();
                            if (nestFiledName == null) continue;
                            if (nestFiledName.endsWith(langStr)) {
                                nestFiledName = nestFiledName.substring(0, nestFiledName.length() - langStr.length());
                            }
                            if (encryptFildSet.contains(nestKey = subEntityName + nestFiledName)) continue;
                            if (nestKey.endsWith("_enp")) {
                                nestKey = nestKey.substring(0, nestKey.length() - "_enp".length());
                                encryptFildSet.add(nestKey);
                            }
                            newMap.put(nestKey, mapNestedEntry.getValue());
                        }
                        continue block1;
                    }
                    continue;
                }
                if (mulFieldCache.contains(key)) continue;
                if (key.endsWith(langStr)) {
                    key = key.substring(0, key.length() - langStr.length());
                    mulFieldCache.add(key);
                    if (objValue == null || StringUtils.isEmpty((CharSequence)objValue.toString())) {
                        objValue = newMap.get(key);
                    }
                }
                if (encryptFildSet.contains(key)) continue;
                if (key.endsWith("_enp")) {
                    key = key.substring(0, key.length() - "_enp".length());
                    encryptFildSet.add(key);
                }
                newMap.put(key, objValue);
            }
            newList.add(newMap);
        }
        return newList;
    }
}

