/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.es.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDException;
import kd.hr.hbp.business.service.query.es.EsDataType;
import kd.hr.hbp.business.service.query.es.EsMappingProperty;
import kd.hr.hbp.business.service.query.es.EsTokenizerType;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.common.model.query.BosEsErrorCode;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class BaseEsStorage {
    protected static final String ANDSTR = "and";
    protected static final String ORSTR = "or";
    protected static final String MUST_STR = "must";
    protected static final String SHOULD_STR = "should";
    protected Map<String, List<String>> likeHighLightMap = null;

    private static boolean isAllASCII(String input) {
        boolean isASCII = true;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c <= '\u007f') continue;
            isASCII = false;
            break;
        }
        return isASCII;
    }

    protected XContentBuilder getFieldsMapping(XContentBuilder jsonBuilder, String coreName, EsMappingProperty ... esMappingIndexs) throws IOException {
        jsonBuilder.startObject("properties");
        for (EsMappingProperty mappingProperty : esMappingIndexs) {
            jsonBuilder.startObject(mappingProperty.getPropertyName()).field("type", (Object)mappingProperty.getDataType());
            if (EsDataType.STRING == mappingProperty.getDataType() || EsDataType.TEXT == mappingProperty.getDataType()) {
                if (EsTokenizerType.STANDARD != mappingProperty.getTokenizerType()) {
                    jsonBuilder.field("analyzer", (Object)mappingProperty.getTokenizerType());
                }
                if (EsTokenizerType.STANDARD != mappingProperty.getSearchTokenizerType()) {
                    jsonBuilder.field("search_analyzer", (Object)mappingProperty.getSearchTokenizerType());
                }
                jsonBuilder.startObject("fields").startObject("keyword").field("type", "keyword").field("ignore_above", mappingProperty.getPropertySize()).endObject().endObject();
            } else if (EsDataType.DATE != mappingProperty.getDataType() && (EsDataType.NESTED == mappingProperty.getDataType() || EsDataType.OBJECT == mappingProperty.getDataType())) {
                this.getFieldsMapping(jsonBuilder, null, mappingProperty.nests.toArray(new EsMappingProperty[0]));
            }
            jsonBuilder.endObject();
        }
        jsonBuilder.endObject();
        return jsonBuilder;
    }

    public QueryBuilder buidQueryBuilder(List<EsFilterField> filters) {
        ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
        if (null == filters || filters.size() == 0) {
            return null;
        }
        for (EsFilterField filter : filters) {
            QueryBuilder queryBuilder = this.buidNestQueryBuilder(filter);
            if (null == queryBuilder) continue;
            queryBuilders.add(queryBuilder);
        }
        if (queryBuilders.size() == 0) {
            return null;
        }
        if (queryBuilders.size() == 1) {
            return (QueryBuilder)queryBuilders.get(0);
        }
        return this.mergeQueryBuilders(queryBuilders, ANDSTR);
    }

    public QueryBuilder buidNestQueryBuilder(EsFilterField filter) {
        List<EsFilterField.FilterFieldNest> nests;
        QueryBuilder queryBuilder = null;
        if (filter == null) {
            return queryBuilder;
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getName())) {
            queryBuilder = this.buidQueryBuilderBase(filter);
        }
        if (!(nests = filter.getNests()).isEmpty()) {
            for (EsFilterField.FilterFieldNest nest : nests) {
                EsFilterField filterNest = nest.getFilter();
                queryBuilder = this.mergeQueryBuilder(queryBuilder, this.buidNestQueryBuilder(filterNest), nest.getNestRw());
            }
        }
        return queryBuilder;
    }

    public QueryBuilder buidQueryBuilder2(List<EsFilterField> filters) {
        ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
        for (EsFilterField filter : filters) {
            QueryBuilder queryBuilder = this.buidNestQueryBuilder2(filter);
            if (null == queryBuilder) continue;
            queryBuilders.add(queryBuilder);
        }
        if (queryBuilders.size() <= 1) {
            return (QueryBuilder)queryBuilders.get(0);
        }
        return this.mergeQueryBuilders(queryBuilders, ANDSTR);
    }

    public QueryBuilder buidNestQueryBuilder2(EsFilterField filter) {
        List<EsFilterField.FilterFieldNest> nests;
        QueryBuilder queryBuilder = null;
        if (filter == null) {
            return queryBuilder;
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getName())) {
            queryBuilder = this.buidQueryBuilderBase(filter);
        }
        if (!(nests = filter.getNests()).isEmpty()) {
            for (EsFilterField.FilterFieldNest nest : nests) {
                EsFilterField filterNest = nest.getFilter();
                queryBuilder = this.mergeQueryBuilder(queryBuilder, this.buidNestQueryBuilder(filterNest), nest.getNestRw());
            }
        }
        return queryBuilder;
    }

    protected QueryBuilder mergeQueryBuilders(List<QueryBuilder> qbs, String rw) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        String mustOrshould = this.getMustOrShould(rw);
        for (QueryBuilder qb : qbs) {
            if (MUST_STR.equals(mustOrshould)) {
                if (null == qb) continue;
                queryBuilder.must(qb);
                continue;
            }
            if (!SHOULD_STR.equals(mustOrshould) || null == qb) continue;
            queryBuilder.should(qb);
        }
        return queryBuilder;
    }

    protected QueryBuilder mergeQueryBuilder(QueryBuilder qb1, QueryBuilder qb2, String rw) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        String mustOrshould = this.getMustOrShould(rw);
        if (MUST_STR.equals(mustOrshould)) {
            if (null != qb1) {
                queryBuilder.must(qb1);
            }
            if (null != qb2) {
                queryBuilder.must(qb2);
            }
        } else if (SHOULD_STR.equals(mustOrshould)) {
            if (null != qb1) {
                queryBuilder.should(qb1);
            }
            if (null != qb2) {
                queryBuilder.should(qb2);
            }
        }
        return queryBuilder;
    }

    protected QueryBuilder buidQueryBuilderBase(EsFilterField filter) {
        QueryBuilder queryBuilder = null;
        if (StringUtils.isBlank((CharSequence)filter.getName())) {
            return queryBuilder;
        }
        StringBuilder filedNameSb = new StringBuilder();
        filedNameSb.append(filter.getName());
        String cp = filter.getCp().toLowerCase();
        Object[] values = filter.getKeywords();
        String rw = filter.isKeywordsOr() ? ORSTR : ANDSTR;
        String mustOrShould = this.getMustOrShould(rw);
        switch (cp) {
            case "match": {
                queryBuilder = this.buildMatchBuilder(filter, filedNameSb, values, mustOrShould);
                break;
            }
            case "like": {
                queryBuilder = this.buildLikeQueryBuilder(filter, filedNameSb, values, mustOrShould);
                break;
            }
            case "not like": {
                queryBuilder = this.buildNotLikeQueryBuilder(filter, filedNameSb, values, mustOrShould);
                break;
            }
            case "ftlike": {
                queryBuilder = this.buildLikeQueryBuilder(filter, filedNameSb, values, mustOrShould);
                break;
            }
            case "=": {
                queryBuilder = this.buildEqQueryBuilder(filter, filedNameSb, values, mustOrShould);
                break;
            }
            case "!=": {
                queryBuilder = this.buildNotEqQueryBuilder(filter, filedNameSb, values, mustOrShould);
                break;
            }
            case "<>": {
                queryBuilder = this.buildNotEqQueryBuilder(filter, filedNameSb, values, mustOrShould);
                break;
            }
            case "in": {
                queryBuilder = this.buildInQueryBuilder(filter, filedNameSb, values);
                break;
            }
            case "not in": {
                queryBuilder = this.buildNotInQueryBuilder(filter, filedNameSb, values);
                break;
            }
            case ">": 
            case "<": 
            case ">=": 
            case "<=": {
                queryBuilder = this.buildRangeQueryBuilder(cp, filter, filedNameSb, values);
                break;
            }
            case "is not null": {
                queryBuilder = this.existsQuery(filter, filedNameSb, values);
                break;
            }
            case "is null": {
                queryBuilder = this.notExistsQuery(filter, filedNameSb, values);
            }
        }
        if (null == queryBuilder) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{"the operator (" + cp + ") does not support."});
        }
        return queryBuilder;
    }

    protected QueryBuilder buildRangeQueryBuilder(String cp, EsFilterField filter, StringBuilder filedNameSb, Object[] values) {
        NestedQueryBuilder queryBuilder = null;
        switch (cp) {
            case ">": {
                Object gtValue = values[0];
                queryBuilder = QueryBuilders.rangeQuery((String)filedNameSb.toString()).gt(gtValue).boost(filter.getBoost());
                break;
            }
            case "<": {
                Object ltValue = values[0];
                queryBuilder = QueryBuilders.rangeQuery((String)filedNameSb.toString()).lt(ltValue).boost(filter.getBoost());
                break;
            }
            case ">=": {
                Object gteValue = values[0];
                queryBuilder = QueryBuilders.rangeQuery((String)filedNameSb.toString()).gte(gteValue).boost(filter.getBoost());
                break;
            }
            case "<=": {
                Object lteValue = values[0];
                queryBuilder = QueryBuilders.rangeQuery((String)filedNameSb.toString()).lte(lteValue).boost(filter.getBoost());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getPath())) {
            queryBuilder = QueryBuilders.nestedQuery((String)filter.getPath(), queryBuilder, (ScoreMode)ScoreMode.Max);
        }
        return queryBuilder;
    }

    protected QueryBuilder buildInQueryBuilder(EsFilterField filter, StringBuilder filedNameSb, Object[] values) {
        AbstractQueryBuilder queryBuilder = QueryBuilders.termsQuery((String)filedNameSb.toString(), (Object[])values).boost(filter.getBoost());
        if (StringUtils.isNotBlank((CharSequence)filter.getPath()) && null != queryBuilder) {
            queryBuilder = QueryBuilders.nestedQuery((String)filter.getPath(), (QueryBuilder)queryBuilder, (ScoreMode)ScoreMode.Max);
        }
        return queryBuilder;
    }

    protected QueryBuilder existsQuery(EsFilterField filter, StringBuilder filedNameSb, Object[] values) {
        AbstractQueryBuilder queryBuilder = QueryBuilders.existsQuery((String)filedNameSb.toString()).boost(filter.getBoost());
        if (StringUtils.isNotBlank((CharSequence)filter.getPath()) && null != queryBuilder) {
            queryBuilder = QueryBuilders.nestedQuery((String)filter.getPath(), (QueryBuilder)queryBuilder, (ScoreMode)ScoreMode.Max);
        }
        return queryBuilder;
    }

    protected QueryBuilder notExistsQuery(EsFilterField filter, StringBuilder filedNameSb, Object[] values) {
        return QueryBuilders.boolQuery().mustNot(this.existsQuery(filter, filedNameSb, values));
    }

    protected QueryBuilder buildNotInQueryBuilder(EsFilterField filter, StringBuilder filedNameSb, Object[] values) {
        return QueryBuilders.boolQuery().mustNot(this.buildInQueryBuilder(filter, filedNameSb, values));
    }

    protected QueryBuilder buildNotEqQueryBuilder(EsFilterField filter, StringBuilder filedNameSb, Object[] values, String mustOrShould) {
        return QueryBuilders.boolQuery().mustNot(this.buildEqQueryBuilder(filter, filedNameSb, values, mustOrShould));
    }

    protected QueryBuilder buildEqQueryBuilder(EsFilterField filter, StringBuilder filedNameSb, Object[] values, String mustOrShould) {
        AbstractQueryBuilder queryBuilder = null;
        if (values.length == 1) {
            queryBuilder = QueryBuilders.termQuery((String)filedNameSb.toString(), (Object)values[0]).boost(filter.getBoost());
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getPath()) && null != queryBuilder) {
            queryBuilder = QueryBuilders.nestedQuery((String)filter.getPath(), (QueryBuilder)queryBuilder, (ScoreMode)ScoreMode.Max);
        }
        return queryBuilder;
    }

    protected QueryBuilder buildNotLikeQueryBuilder(EsFilterField filter, StringBuilder filedNameSb, Object[] values, String mustOrShould) {
        return QueryBuilders.boolQuery().mustNot(this.buildLikeQueryBuilder(filter, filedNameSb, values, mustOrShould));
    }

    protected QueryBuilder buildLikeQueryBuilder(EsFilterField filter, StringBuilder filedNameSb, Object[] values, String mustOrShould) {
        NestedQueryBuilder result = null;
        if (values.length == 1) {
            String valueStr = String.valueOf(values[0]);
            String[] valueArr = valueStr.split("%");
            if (valueArr.length == 1 && valueStr.endsWith("%")) {
                result = QueryBuilders.prefixQuery((String)filedNameSb.toString(), (String)valueArr[0]).boost(filter.getBoost());
            } else if (valueArr.length > 1) {
                result = QueryBuilders.wildcardQuery((String)filedNameSb.toString(), (String)valueStr.replace("%", "*")).boost(filter.getBoost());
            } else {
                StringBuilder queryStringSb = new StringBuilder();
                queryStringSb.append((CharSequence)filedNameSb);
                queryStringSb.append(':');
                queryStringSb.append(valueStr.replace("%", "*"));
                result = QueryBuilders.queryStringQuery((String)queryStringSb.toString()).boost(filter.getBoost());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getPath()) && null != result) {
            result = QueryBuilders.nestedQuery((String)filter.getPath(), result, (ScoreMode)ScoreMode.Max);
        }
        return result;
    }

    protected QueryBuilder buildMatchBuilder(EsFilterField filter, StringBuilder filedNameSb, Object[] values, String mustOrShould) {
        AbstractQueryBuilder queryBuilder = null;
        if (values.length == 1) {
            queryBuilder = QueryBuilders.matchQuery((String)filedNameSb.toString(), (Object)values[0]).boost(filter.getBoost());
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getPath()) && null != queryBuilder) {
            queryBuilder = QueryBuilders.nestedQuery((String)filter.getPath(), (QueryBuilder)queryBuilder, (ScoreMode)ScoreMode.Max);
        }
        return queryBuilder;
    }

    protected String getMustOrShould(String rw) {
        String filterRw = "";
        if (ANDSTR.equals(rw)) {
            filterRw = MUST_STR;
        } else if (ORSTR.equals(rw)) {
            filterRw = SHOULD_STR;
        } else {
            throw new KDException(BosEsErrorCode.esException, new Object[]{"the relation (" + rw + ") does not support."});
        }
        return filterRw;
    }

    protected String buildBulkFailureMessage(int batchSize, List<BulkItemResponse> failureRespList) {
        StringBuilder failureMsg = new StringBuilder();
        int failureSize = failureRespList.size();
        failureMsg.append("es bulk opt error,success:");
        failureMsg.append(batchSize - failureSize);
        failureMsg.append(",failure:");
        failureMsg.append(failureSize);
        failureMsg.append(",details:");
        int flag = 1000;
        for (BulkItemResponse response : failureRespList) {
            if (flag >= 0) {
                failureMsg.append('\n').append("id [").append(response.getId()).append("], message [").append(response.getFailureMessage()).append(']');
            }
            --flag;
        }
        return failureMsg.toString();
    }
}

