/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.ksql;

import java.util.Arrays;
import java.util.Map;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;

public class CriteriaBuilder {
    private QFilter[] filters;
    private boolean bTmpTable;
    private Map<String, PKTempTable> tmpTableMap;
    private DBRoute route;
    private int tmpTableThresh = 10000;

    public CriteriaBuilder(QFilter[] filters, DBRoute route) {
        this.filters = filters;
        this.route = route;
    }

    public CriteriaBuilder(QFilter[] filters, DBRoute route, boolean bTmpTable, Map<String, PKTempTable> tmpTableMap) {
        this.filters = filters;
        this.bTmpTable = bTmpTable;
        this.route = route;
        this.tmpTableMap = tmpTableMap;
    }

    public String qFilterToString() {
        StringBuilder whereSqlBuilder = new StringBuilder();
        for (QFilter filter : this.getFilters()) {
            if (filter == null) continue;
            String sqlStr = QFilterUtilHR.toQFilterString(filter, true, this.isbTmpTable(), this.getTmpTableMap(), this.getRoute(), this.getTmpTableThresh());
            whereSqlBuilder.append(" and ").append(sqlStr);
        }
        return whereSqlBuilder.toString();
    }

    public QFilter[] getFilters() {
        return this.filters;
    }

    public void setFilters(QFilter[] filters) {
        this.filters = filters;
    }

    public boolean isbTmpTable() {
        return this.bTmpTable;
    }

    public void setbTmpTable(boolean bTmpTable) {
        this.bTmpTable = bTmpTable;
    }

    public DBRoute getRoute() {
        return this.route;
    }

    public void setRoute(DBRoute route) {
        this.route = route;
    }

    public Map<String, PKTempTable> getTmpTableMap() {
        return this.tmpTableMap;
    }

    public void setTmpTableMap(Map<String, PKTempTable> tmpTableMap) {
        this.tmpTableMap = tmpTableMap;
    }

    public int getTmpTableThresh() {
        return this.tmpTableThresh;
    }

    public void setTmpTableThresh(int tmpTableThresh) {
        this.tmpTableThresh = tmpTableThresh;
    }

    public String toString() {
        return "CriteriaBuilder{filters=" + Arrays.toString(this.filters) + ", bTmpTable=" + this.bTmpTable + ", route=" + this.route + ", tmpTableMap=" + this.tmpTableMap + ", tmpTableThresh=" + this.tmpTableThresh + '}';
    }
}

