/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.ksql;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.query.ksql.EntitySelectField;
import kd.hr.hbp.business.service.query.ksql.QueryField;
import kd.hr.hbp.business.service.query.util.QueryJoinExprUtil;
import kd.hr.hbp.business.servicehelper.HREntityHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryEntityUtil;
import kd.hr.hbp.common.util.QueryKSqlUtil;

public class QueryEntityInfo {
    private String queryEntityNum;
    private QueryEntityType queryEntityType;
    private String editEntityNum;
    private String editEntityTable;
    private MainEntityType editEntityType;
    private EntitySelectField editEntitySelectField;
    private List<EntitySelectField> joinEntitySelectField;
    private Set<String> allEntityNames;
    private List<JoinEntity> joinEntitys;
    private List<QuerySourceJoinRelation> joinRelations;
    private List<QuerySelectField> selectFields;

    public Set<String> getAllEntityNames() {
        return this.allEntityNames;
    }

    public List<JoinEntity> getJoinEntitys() {
        return this.joinEntitys;
    }

    public List<JoinEntity> getQueryJoinEntitys() {
        return CollectionUtils.isNotEmpty(this.joinEntitys) ? this.joinEntitys : (this.queryEntityType != null ? new ArrayList(this.queryEntityType.getJoinEntitys()) : null);
    }

    public void setJoinEntitys(List<JoinEntity> joinEntitys) {
        this.joinEntitys = joinEntitys;
    }

    public List<QuerySourceJoinRelation> getQueryJoinRelations() {
        return CollectionUtils.isNotEmpty(this.joinRelations) ? this.joinRelations : (this.queryEntityType != null ? new ArrayList(this.queryEntityType.getJoinRelations()) : null);
    }

    public List<QuerySourceJoinRelation> getJoinRelations() {
        return this.joinRelations;
    }

    public void setJoinRelations(List<QuerySourceJoinRelation> joinRelations) {
        this.joinRelations = joinRelations;
    }

    public List<QuerySelectField> getQuerySelectFields() {
        return CollectionUtils.isNotEmpty(this.selectFields) ? this.selectFields : (this.queryEntityType != null ? new ArrayList(this.queryEntityType.getSelectFields()) : null);
    }

    public List<QuerySelectField> getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(List<QuerySelectField> selectFields) {
        this.selectFields = selectFields;
    }

    public QueryEntityInfo(String queryEntityNum) {
        this.queryEntityNum = queryEntityNum;
        this.queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)queryEntityNum);
        this.editEntityNum = this.queryEntityType.getEditEntityName();
        this.editEntityTable = HREntityHelper.getTableName(this.editEntityNum);
        this.editEntityType = EntityMetadataCache.getDataEntityType((String)this.editEntityNum);
        this.allEntityNames = new HashSet<String>(16);
        this.allEntityNames.add(this.queryEntityType.getEditEntityName());
        this.allEntityNames.addAll(this.queryEntityType.getJoinEntitys().stream().map(JoinEntity::getEntityName).collect(Collectors.toSet()));
    }

    public Set<String> getJoinConditionMap(String entityAlias) {
        HashSet<String> joinConditionSet = new HashSet<String>(16);
        for (QuerySourceJoinRelation joinRelation : this.getQueryJoinRelations()) {
            List condition = joinRelation.getCondition();
            for (QSConditionRow qsConditionRow : condition) {
                String leftItem = qsConditionRow.getLeftItem().toString();
                this.recordJoinField(leftItem, entityAlias, joinConditionSet);
                String rightItem = qsConditionRow.getRightItem().toString();
                this.recordJoinField(rightItem, entityAlias, joinConditionSet);
            }
        }
        return joinConditionSet;
    }

    private void recordJoinField(String exprStr, String queryEntityAlias, Set<String> joinConditionSet) {
        String entityAlias;
        boolean leftItemIsField = QueryJoinExprUtil.itemIsField(this.queryEntityType, exprStr);
        if (leftItemIsField && queryEntityAlias.equals(entityAlias = QueryEntityUtil.getFieldEntityAlias((String)exprStr, (QueryEntityType)this.queryEntityType))) {
            joinConditionSet.add(exprStr);
        }
    }

    private void initEditEntitySelectField() {
        EntitySelectField entitySelectField = new EntitySelectField();
        entitySelectField.setEntityNum(this.editEntityNum);
        entitySelectField.setEntityAlias(this.editEntityNum);
        entitySelectField.setTable(this.editEntityTable);
        List<QuerySelectField> selectFields = this.getQuerySelectFields();
        Set<String> joinFieldSet = this.getJoinConditionMap(this.editEntityNum);
        for (QuerySelectField selectField : selectFields) {
            String queryFieldAlias = selectField.getAlias();
            joinFieldSet.remove(queryFieldAlias);
            QueryField queryField = this.parseProp((DynamicObjectType)this.getEditEntityType(), queryFieldAlias, queryFieldAlias);
            entitySelectField.addQueryField(queryField);
        }
        for (String joinField : joinFieldSet) {
            QueryField queryField = this.parseProp((DynamicObjectType)this.getEditEntityType(), joinField, joinField);
            entitySelectField.addQueryField(queryField);
        }
        List<QuerySourceJoinRelation> joinRelations = this.getQueryJoinRelations();
        for (QuerySourceJoinRelation joinRelation : joinRelations) {
            List condition = joinRelation.getCondition();
            for (QSConditionRow qsConditionRow : condition) {
                String queryFieldAlias = qsConditionRow.getLeftItem().toString();
                DynamicProperty property = this.getEditEntityType().getProperty(queryFieldAlias);
                if (property == null || !HRStringUtils.isNotEmpty((String)property.getTableGroup())) continue;
                QueryField queryField = this.parseProp((DynamicObjectType)this.getEditEntityType(), queryFieldAlias, queryFieldAlias);
                entitySelectField.addQueryField(queryField);
            }
        }
        this.setEditEntitySelectField(entitySelectField);
    }

    private void initJoinEntitySelectField() {
        ArrayList joinEntitySelectField = Lists.newArrayListWithCapacity((int)16);
        List<QuerySelectField> selectFields = this.getQuerySelectFields();
        List<JoinEntity> joinEntitys = this.getQueryJoinEntitys();
        Map joinRelationMap = this.getQueryJoinRelations().stream().collect(Collectors.toMap(QuerySourceJoinRelation::getRelEntityNumber, Function.identity()));
        for (JoinEntity joinEntity : joinEntitys) {
            String entityName = joinEntity.getEntityName();
            EntitySelectField entitySelectField = new EntitySelectField();
            entitySelectField.setEntityNum(entityName);
            entitySelectField.setTable(HREntityHelper.getTableName(entityName));
            MainEntityType joinEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            String joinEntityAlias = joinEntity.getAlias();
            entitySelectField.setEntityAlias(joinEntityAlias);
            String joinFieldPrex = joinEntityAlias + ".";
            Set<String> joinFieldSet = this.getJoinConditionMap(joinEntityAlias);
            for (QuerySelectField selectField : selectFields) {
                String fieldAlias = selectField.getAlias();
                if (!fieldAlias.startsWith(joinFieldPrex)) continue;
                joinFieldSet.remove(fieldAlias);
                String realField = fieldAlias.replaceFirst(joinFieldPrex, "");
                QueryField queryField = this.parseProp((DynamicObjectType)joinEntityType, fieldAlias, realField);
                entitySelectField.addQueryField(queryField);
            }
            for (String joinField : joinFieldSet) {
                String realField = joinField.replaceFirst(joinFieldPrex, "");
                QueryField queryField = this.parseProp((DynamicObjectType)joinEntityType, joinField, realField);
                entitySelectField.addQueryField(queryField);
            }
            QuerySourceJoinRelation querySourceJoinRelation = (QuerySourceJoinRelation)joinRelationMap.get(joinEntityAlias);
            List condition = querySourceJoinRelation.getCondition();
            for (QSConditionRow qsConditionRow : condition) {
                String queryFieldAlias = qsConditionRow.getRightItem().toString();
                String realField = queryFieldAlias.replaceFirst(joinFieldPrex, "");
                DynamicProperty property = joinEntityType.getProperty(realField);
                if (property == null || !HRStringUtils.isNotEmpty((String)property.getTableGroup())) continue;
                QueryField queryField = this.parseProp((DynamicObjectType)joinEntityType, queryFieldAlias, realField);
                entitySelectField.addQueryField(queryField);
            }
            joinEntitySelectField.add(entitySelectField);
        }
        this.setJoinEntitySelectField(joinEntitySelectField);
    }

    private QueryField parseProp(DynamicObjectType dynamicObjectType, String fieldAlias, String originField) {
        String baseEntityId;
        String[] fieldAliasArr = originField.split("\\.");
        DynamicProperty property = dynamicObjectType.getProperty(originField);
        if (property == null) {
            property = dynamicObjectType.getProperty(fieldAliasArr[0]);
        }
        if (property == null) {
            return null;
        }
        String mainTable = dynamicObjectType.getAlias();
        String mainTablePk = dynamicObjectType.getPrimaryKey().getAlias();
        String convertFieldAlias = QueryKSqlUtil.convertFieldAlias((String)dynamicObjectType.getName(), (String)"", (String)originField);
        QueryField queryField = new QueryField(fieldAlias, originField, convertFieldAlias, property.getAlias());
        queryField.setTable(mainTable);
        queryField.setPkDbField(mainTablePk);
        this.setMulOrGroupProp(property, queryField, mainTable);
        if (property instanceof BasedataProp && this.allEntityNames.contains(baseEntityId = ((BasedataProp)property).getBaseEntityId()) && fieldAliasArr.length > 1) {
            DynamicProperty bdProp;
            MainEntityType bdEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            mainTable = bdEntityType.getAlias();
            mainTablePk = bdEntityType.getPrimaryKey().getAlias();
            if (Objects.nonNull(queryField)) {
                queryField.setTable(mainTable);
                queryField.setPkDbField(mainTablePk);
            }
            if ((bdProp = bdEntityType.getProperty(originField.replaceFirst(fieldAliasArr[0] + ".", ""))) == null) {
                return null;
            }
            this.setMulOrGroupProp(bdProp, queryField, mainTable);
        }
        return queryField;
    }

    private void setMulOrGroupProp(DynamicProperty property, QueryField queryField, String mainTable) {
        if (Objects.isNull(queryField)) {
            return;
        }
        if (property instanceof EntryProp) {
            queryField = null;
        } else if (property instanceof MuliLangTextProp) {
            queryField.setMultiLanguage(true);
            queryField.setTable(mainTable + "_L");
        } else {
            String tableGroup = property.getTableGroup();
            if (HRStringUtils.isNotEmpty((String)tableGroup)) {
                queryField.setSplitField(true);
                queryField.setTable(mainTable + "_" + tableGroup);
            }
        }
    }

    public String getQueryEntityNum() {
        return this.queryEntityNum;
    }

    public void setQueryEntityNum(String queryEntityNum) {
        this.queryEntityNum = queryEntityNum;
    }

    public QueryEntityType getQueryEntityType() {
        return this.queryEntityType;
    }

    public void setQueryEntityType(QueryEntityType queryEntityType) {
        this.queryEntityType = queryEntityType;
    }

    public String getEditEntityNum() {
        return this.editEntityNum;
    }

    public void setEditEntityNum(String editEntityNum) {
        this.editEntityNum = editEntityNum;
    }

    public String getEditEntityTable() {
        return this.editEntityTable;
    }

    public void setEditEntityTable(String editEntityTable) {
        this.editEntityTable = editEntityTable;
    }

    public MainEntityType getEditEntityType() {
        return this.editEntityType;
    }

    public void setEditEntityType(MainEntityType editEntityType) {
        this.editEntityType = editEntityType;
    }

    public EntitySelectField getEditEntitySelectField() {
        this.initEditEntitySelectField();
        return this.editEntitySelectField;
    }

    public void setEditEntitySelectField(EntitySelectField editEntitySelectField) {
        this.editEntitySelectField = editEntitySelectField;
    }

    public List<EntitySelectField> getJoinEntitySelectField() {
        this.initJoinEntitySelectField();
        return this.joinEntitySelectField;
    }

    public void setJoinEntitySelectField(List<EntitySelectField> joinEntitySelectField) {
        this.joinEntitySelectField = joinEntitySelectField;
    }
}

