/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.ksql;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.hr.hbp.business.service.complexobj.util.MapCacheUtil;
import kd.hr.hbp.business.service.query.ksql.QueryEntityInfo;
import kd.hr.hbp.business.service.query.ksql.QueryKSqlTableParse;
import kd.hr.hbp.business.servicehelper.HREntityHelper;
import kd.hr.hbp.common.enums.query.KsqlJoinHint;
import kd.hr.hbp.common.util.HRStringUtils;

public class QueryKSqlFromParse {
    public static String getTableFromSql(QueryEntityInfo queryEntityInfo, boolean ignoreSplitTb, boolean ignoreMultiLanguageTb, Set<String> mustLoadTb) {
        HashMap<String, Set<String>> loadRecordAliasMap = new HashMap<String, Set<String>>();
        Map<String, Map<String, String>> entityTableAliasMap = QueryKSqlTableParse.getTableAlias(queryEntityInfo);
        StringBuilder fromSqlSb = new StringBuilder();
        fromSqlSb.append(QueryKSqlFromParse.getMustTableFromSql(queryEntityInfo, entityTableAliasMap, loadRecordAliasMap));
        if (ignoreMultiLanguageTb) {
            QueryKSqlFromParse.genIgnoreTableRecord(QueryKSqlTableParse.getMLTables(queryEntityInfo), mustLoadTb, loadRecordAliasMap);
        }
        fromSqlSb.append(QueryKSqlFromParse.genMuliLangTableSql(queryEntityInfo, entityTableAliasMap, loadRecordAliasMap));
        if (ignoreSplitTb) {
            QueryKSqlFromParse.genIgnoreTableRecord(QueryKSqlTableParse.getSplitTables(queryEntityInfo), mustLoadTb, loadRecordAliasMap);
        }
        fromSqlSb.append(QueryKSqlFromParse.genTableGroupSql(queryEntityInfo, entityTableAliasMap, loadRecordAliasMap));
        return fromSqlSb.toString();
    }

    private static void genIgnoreTableRecord(Map<String, Set<String>> specialTableMap, Set<String> mustLoadTb, Map<String, Set<String>> loadRecordAliasMap) {
        specialTableMap.forEach((entityAlias, specialTables) -> {
            if (mustLoadTb != null) {
                specialTables.removeAll(mustLoadTb);
            }
            Set loadTables = MapCacheUtil.getMapSetVal(loadRecordAliasMap, entityAlias);
            loadTables.addAll(specialTables);
            loadRecordAliasMap.put((String)entityAlias, loadTables);
        });
    }

    private static String getMustTableFromSql(QueryEntityInfo queryEntityInfo, Map<String, Map<String, String>> entityTableAliasMap, Map<String, Set<String>> loadRecordAliasMap) {
        StringBuilder fromSqlSb = new StringBuilder(" FROM ");
        String editEntityTable = queryEntityInfo.getEditEntityTable();
        String editEntityTableAlias = entityTableAliasMap.get(queryEntityInfo.getEditEntityNum()).get(editEntityTable);
        fromSqlSb.append(QueryKSqlFromParse.composeSimpleFromSql(editEntityTable, "", editEntityTableAlias, ""));
        HashSet<String> mainTbSet = new HashSet<String>(5);
        mainTbSet.add(editEntityTable);
        loadRecordAliasMap.put(queryEntityInfo.getEditEntityNum(), mainTbSet);
        fromSqlSb.append(QueryKSqlFromParse.genJoinRelationSql(queryEntityInfo, entityTableAliasMap, loadRecordAliasMap));
        return fromSqlSb.toString();
    }

    private static String genJoinRelationSql(QueryEntityInfo queryEntityInfo, Map<String, Map<String, String>> entityTableAliasMap, Map<String, Set<String>> loadRecordAliasMap) {
        List<QuerySourceJoinRelation> joinRelations = queryEntityInfo.getQueryJoinRelations();
        Map<String, String> tablePkMap = QueryKSqlFromParse.getTablePk(queryEntityInfo);
        List<JoinEntity> joinEntityList = queryEntityInfo.getQueryJoinEntitys();
        StringBuilder joinRelSql = new StringBuilder();
        for (QuerySourceJoinRelation joinRelation : joinRelations) {
            String relEntityNumber;
            String relEntityTable;
            String relEntityAlias = joinRelation.getRelEntityNumber();
            Set<String> joinEntityTables = MapCacheUtil.getMapSetVal(loadRecordAliasMap, relEntityAlias);
            if (joinEntityTables.contains(relEntityTable = HREntityHelper.getTableName(relEntityNumber = QueryKSqlFromParse.getEntityNameByAlias(relEntityAlias, joinEntityList)))) continue;
            String entityNumber = joinRelation.getEntityNumber();
            String entityTable = HREntityHelper.getTableName(entityNumber);
            if (!MapCacheUtil.getMapSetVal(loadRecordAliasMap, entityNumber).contains(entityTable)) continue;
            String joinType = joinRelation.getJoinType();
            StringBuilder conditionSql = new StringBuilder(" ON ");
            List condition = joinRelation.getCondition();
            HashMap preLoadTableMap = Maps.newHashMapWithExpectedSize((int)16);
            for (int index = 0; index < condition.size(); ++index) {
                QSConditionRow qsConditionRow = (QSConditionRow)condition.get(index);
                String joinCondition = QueryKSqlFromParse.parseJoinCondition(queryEntityInfo, qsConditionRow, entityTableAliasMap, preLoadTableMap, relEntityAlias);
                if (joinCondition == null) continue;
                if (index > 0 && index < condition.size()) {
                    conditionSql.append(qsConditionRow.getLogicOp());
                }
                conditionSql.append(joinCondition);
            }
            if (!preLoadTableMap.isEmpty()) {
                for (Map.Entry entry : preLoadTableMap.entrySet()) {
                    Iterator preLoadTableItr = ((Set)entry.getValue()).iterator();
                    while (preLoadTableItr.hasNext()) {
                        String table = (String)preLoadTableItr.next();
                        String mainTb = table.substring(0, table.lastIndexOf("_"));
                        Set<String> mapSetVal = MapCacheUtil.getMapSetVal(loadRecordAliasMap, entry.getKey());
                        if (mapSetVal.contains(mainTb)) {
                            String pkField = tablePkMap.get(mainTb);
                            joinRelSql.append(QueryKSqlFromParse.composeSplitTableFromSql(table, mainTb, pkField, entityTableAliasMap.get(entry.getKey())));
                            mapSetVal.add(table);
                        }
                        loadRecordAliasMap.put((String)entry.getKey(), mapSetVal);
                        preLoadTableItr.remove();
                    }
                }
            }
            joinEntityTables.add(relEntityTable);
            loadRecordAliasMap.put(relEntityAlias, joinEntityTables);
            joinRelSql.append(QueryKSqlFromParse.composeSimpleFromSql(relEntityTable, joinType, entityTableAliasMap.get(relEntityAlias).get(relEntityTable), conditionSql.toString()));
        }
        return joinRelSql.toString();
    }

    private static String genMuliLangTableSql(QueryEntityInfo queryEntityInfo, Map<String, Map<String, String>> entityTableAliasMap, Map<String, Set<String>> loadRecordAliasMap) {
        StringBuilder mulTableSql = new StringBuilder();
        Map<String, String> tablePkMap = QueryKSqlFromParse.getTablePk(queryEntityInfo);
        entityTableAliasMap.forEach((entityAlias, entityTableAlias) -> {
            Set muliLangTableSet = entityTableAlias.keySet().stream().filter(tb -> tb.endsWith("_L") || tb.endsWith("_L".toLowerCase(Locale.ROOT))).collect(Collectors.toSet());
            Iterator iterator = muliLangTableSet.iterator();
            while (iterator.hasNext()) {
                String mulLangTable = (String)iterator.next();
                String mainTable = mulLangTable.substring(0, mulLangTable.length() - 2);
                if (entityTableAlias.containsKey(mainTable)) continue;
                iterator.remove();
            }
            Set loadTableSet = MapCacheUtil.getMapSetVal(loadRecordAliasMap, entityAlias);
            for (String muliLangTable : muliLangTableSet) {
                if (loadTableSet.contains(muliLangTable)) continue;
                String mainTable = muliLangTable.substring(0, muliLangTable.length() - 2);
                String pkField = (String)tablePkMap.get(mainTable);
                mulTableSql.append(QueryKSqlFromParse.composeMuliLangFromSql(muliLangTable, mainTable, pkField, entityTableAlias));
                loadTableSet.add(muliLangTable);
            }
            loadRecordAliasMap.put((String)entityAlias, loadTableSet);
        });
        return mulTableSql.toString();
    }

    private static String composeMuliLangFromSql(String muliLangTable, String mainTable, String pkField, Map<String, String> entityTableAlias) {
        String muliLangTbAlias = entityTableAlias.get(muliLangTable);
        String mainTbAlias = entityTableAlias.get(mainTable);
        return KsqlJoinHint.LEFTJOIN.getJoin() + " " + muliLangTable + " " + muliLangTbAlias + " ON (" + mainTbAlias + "." + pkField + " = " + muliLangTbAlias + "." + pkField + " AND " + muliLangTbAlias + "." + "FLOCALEID = ?) ";
    }

    private static String genTableGroupSql(QueryEntityInfo queryEntityInfo, Map<String, Map<String, String>> entityTableAliasMap, Map<String, Set<String>> loadRecordAliasMap) {
        Map<String, String> tablePkMap = QueryKSqlFromParse.getTablePk(queryEntityInfo);
        StringBuilder sql = new StringBuilder();
        entityTableAliasMap.forEach((entityAlias, entityTableAlias) -> {
            Set loadRecordTable = MapCacheUtil.getMapSetVal(loadRecordAliasMap, entityAlias);
            Set unLoadTable = entityTableAlias.keySet().stream().filter(s -> !loadRecordTable.contains(s)).collect(Collectors.toSet());
            for (String table : unLoadTable) {
                String mainTb;
                if (loadRecordTable.contains(table) || !loadRecordTable.contains(mainTb = table.substring(0, table.lastIndexOf("_")))) continue;
                String pkField = (String)tablePkMap.get(mainTb);
                sql.append(QueryKSqlFromParse.composeSplitTableFromSql(table, mainTb, pkField, entityTableAlias));
                loadRecordTable.add(table);
            }
            loadRecordAliasMap.put((String)entityAlias, loadRecordTable);
        });
        return sql.toString();
    }

    private static Map<String, String> getTablePk(QueryEntityInfo queryEntityInfo) {
        HashMap tablePkMap = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)queryEntityInfo.getEditEntityNum());
        tablePkMap.put(HREntityHelper.getTableName(queryEntityInfo.getEditEntityNum()), entityType.getPrimaryKey().getAlias());
        List<JoinEntity> joinEntitys = queryEntityInfo.getQueryJoinEntitys();
        for (JoinEntity joinEntity : joinEntitys) {
            MainEntityType joinEntityType = EntityMetadataCache.getDataEntityType((String)joinEntity.getEntityName());
            tablePkMap.put(HREntityHelper.getTableName(joinEntity.getEntityName()), joinEntityType.getPrimaryKey().getAlias());
        }
        return tablePkMap;
    }

    private static String composeSplitTableFromSql(String splittable, String mainTable, String pkField, Map<String, String> entityTableAlias) {
        String splitTbAlias = entityTableAlias.get(splittable);
        String mainTbAlias = entityTableAlias.get(mainTable);
        return KsqlJoinHint.LEFTJOIN.getJoin() + " " + splittable + " " + splitTbAlias + " ON " + mainTbAlias + "." + pkField + " = " + splitTbAlias + "." + pkField + " ";
    }

    public static String getEntityNameByAlias(String entityAlias, List<JoinEntity> joinEntityList) {
        String entityName = null;
        for (JoinEntity joinEntity : joinEntityList) {
            if (!entityAlias.equals(joinEntity.getAlias())) continue;
            entityName = joinEntity.getEntityName();
            break;
        }
        return entityName;
    }

    private static String parseJoinCondition(QueryEntityInfo queryEntityInfo, QSConditionRow row, Map<String, Map<String, String>> entityTableAliasMap, Map<String, Set<String>> preLoadTableMap, String relEntityAlias) {
        StringBuilder conditionSql = new StringBuilder();
        String leftItem = row.getLeftItem().toString();
        String rightItem = row.getRightItem().toString();
        if (HRStringUtils.isEmpty((String)rightItem) || HRStringUtils.isEmpty((String)leftItem)) {
            return null;
        }
        conditionSql.append(" ");
        Set<String> mainPreLoad = MapCacheUtil.getMapSetVal(preLoadTableMap, queryEntityInfo.getEditEntityNum());
        Map<String, String> tableAliasMap = entityTableAliasMap.get(queryEntityInfo.getEditEntityNum());
        String fieldEntityAlias = QueryKSqlFromParse.getFieldEntityAlias(queryEntityInfo, leftItem);
        if (HRStringUtils.isNotEmpty((String)fieldEntityAlias)) {
            tableAliasMap = entityTableAliasMap.get(fieldEntityAlias);
        }
        conditionSql.append(QueryKSqlFromParse.parseQSExpr(queryEntityInfo, leftItem, tableAliasMap, mainPreLoad));
        preLoadTableMap.put(queryEntityInfo.getEditEntityNum(), mainPreLoad);
        conditionSql.append(" ");
        conditionSql.append(row.getCompareOp());
        conditionSql.append(" ");
        Set<String> rightPreLoad = MapCacheUtil.getMapSetVal(preLoadTableMap, relEntityAlias);
        fieldEntityAlias = QueryKSqlFromParse.getFieldEntityAlias(queryEntityInfo, rightItem);
        tableAliasMap = entityTableAliasMap.get(relEntityAlias);
        if (HRStringUtils.isNotEmpty((String)fieldEntityAlias)) {
            tableAliasMap = entityTableAliasMap.get(fieldEntityAlias);
        }
        String expr = QueryKSqlFromParse.parseQSExpr(queryEntityInfo, rightItem, tableAliasMap, rightPreLoad);
        preLoadTableMap.put(relEntityAlias, rightPreLoad);
        if ("like".equals(row.getCompareOp()) || "not like".equals(row.getCompareOp())) {
            if (expr.endsWith("'")) {
                expr = expr.substring(0, expr.lastIndexOf("'"));
                expr = expr + "%'";
            }
            conditionSql.append(expr);
        } else if ("in".equals(row.getCompareOp()) || "not in".equals(row.getCompareOp())) {
            conditionSql.append("(");
            conditionSql.append(expr);
            conditionSql.append(")");
        } else {
            conditionSql.append(expr);
        }
        conditionSql.append(" ");
        return conditionSql.toString();
    }

    private static String getFieldEntityAlias(QueryEntityInfo queryEntityInfo, String fieldAlias) {
        String[] fieldAliasArr;
        String firstField;
        Set relEntityAlias = queryEntityInfo.getQueryEntityType().getJoinEntitys().stream().map(JoinEntity::getAlias).collect(Collectors.toSet());
        if (relEntityAlias.contains(firstField = (fieldAliasArr = fieldAlias.split("\\."))[0])) {
            return firstField;
        }
        return null;
    }

    private static String parseQSExpr(QueryEntityInfo queryEntityInfo, String exprStr, Map<String, String> entityTableAlias, Set<String> preLoadTable) {
        String exprSql = "";
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)queryEntityInfo.getEditEntityNum());
        String entityTable = HREntityHelper.getTableName(queryEntityInfo.getEditEntityNum());
        List<JoinEntity> joinEntitys = queryEntityInfo.getQueryJoinEntitys();
        Map joinEntityMap = joinEntitys.stream().collect(Collectors.toMap(JoinEntity::getAlias, Function.identity()));
        String[] exprArr = exprStr.split("\\.");
        if (exprArr.length == 1) {
            DynamicProperty prop = entityType.getProperty(exprStr);
            if (prop == null) {
                exprSql = exprStr;
            } else {
                String tableAlias = entityTableAlias.get(entityTable);
                String tableGroup = prop.getTableGroup();
                if (HRStringUtils.isNotEmpty((String)tableGroup)) {
                    String splitTable = entityTable + "_" + tableGroup;
                    tableAlias = entityTableAlias.get(splitTable);
                    preLoadTable.add(splitTable);
                }
                exprSql = tableAlias + "." + prop.getAlias();
            }
        } else if (exprArr.length == 2) {
            JoinEntity joinEntity = (JoinEntity)joinEntityMap.get(exprArr[0]);
            if (joinEntity != null) {
                MainEntityType joinEntityType = EntityMetadataCache.getDataEntityType((String)joinEntity.getEntityName());
                DynamicProperty firstProp = joinEntityType.getProperty(exprArr[1]);
                if (firstProp == null) {
                    exprSql = exprStr;
                } else {
                    String bdTableName = HREntityHelper.getTableName(joinEntity.getEntityName());
                    String tableAlias = entityTableAlias.get(bdTableName);
                    String tableGroup = firstProp.getTableGroup();
                    if (HRStringUtils.isNotEmpty((String)tableGroup)) {
                        String splitTable = bdTableName + "_" + tableGroup;
                        tableAlias = entityTableAlias.get(splitTable);
                        preLoadTable.add(splitTable);
                    }
                    exprSql = tableAlias + "." + firstProp.getAlias();
                }
            } else {
                DynamicProperty prop = queryEntityInfo.getQueryEntityType().getEntityAlias().equals(exprArr[0]) ? entityType.getProperty(exprArr[1]) : entityType.getProperty(exprArr[0]);
                if (prop == null) {
                    exprSql = exprStr;
                } else {
                    String tableAlias = entityTableAlias.get(entityTable);
                    String tableGroup = prop.getTableGroup();
                    if (HRStringUtils.isNotEmpty((String)tableGroup)) {
                        String splitTable = entityTable + "_" + tableGroup;
                        tableAlias = entityTableAlias.get(splitTable);
                        preLoadTable.add(splitTable);
                    }
                    exprSql = tableAlias + "." + prop.getAlias();
                }
            }
        }
        return exprSql;
    }

    private static String composeSimpleFromSql(String tableName, String joinType, String tableAlias, String conditionSql) {
        String join = KsqlJoinHint.of((String)joinType).getJoin();
        return join + " " + tableName + " " + tableAlias + " " + conditionSql + " ";
    }
}

