/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.ksql;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.BasedataProp;
import kd.hr.hbp.business.service.query.ksql.QueryEntityInfo;
import kd.hr.hbp.common.util.QueryKSqlUtil;

public class QueryKSqlSelectFieldParse {
    public static Map<String, Object> getPkFields(QueryEntityInfo queryEntityInfo) {
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityType editEntityType = EntityMetadataCache.getDataEntityType((String)queryEntityInfo.getEditEntityNum());
        String pkAlias = editEntityType.getPrimaryKey().getName();
        fieldMap.put(pkAlias, pkAlias);
        List<JoinEntity> joinEntitys = queryEntityInfo.getQueryJoinEntitys();
        for (JoinEntity joinEntity : joinEntitys) {
            String joinEntityName = joinEntity.getEntityName();
            MainEntityType joinEntityType = EntityMetadataCache.getDataEntityType((String)joinEntityName);
            String joinEntityPkAlias = QueryKSqlUtil.convertFieldAlias((String)joinEntityName, (String)joinEntity.getAlias(), (String)joinEntityType.getPrimaryKey().getName());
            fieldMap.put(joinEntityPkAlias, joinEntityPkAlias);
        }
        return fieldMap;
    }

    public static Map<String, Object> getAllFields(QueryEntityInfo queryEntityInfo) {
        Map<String, Object> fieldMap = QueryKSqlSelectFieldParse.getPkFields(queryEntityInfo);
        List<JoinEntity> joinEntitys = queryEntityInfo.getQueryJoinEntitys();
        Map joinEntityMap = joinEntitys.stream().collect(Collectors.toMap(JoinEntity::getAlias, Function.identity()));
        List<QuerySelectField> selectFields = queryEntityInfo.getQuerySelectFields();
        for (QuerySelectField selectField : selectFields) {
            String queryFieldAlias = selectField.getAlias();
            String[] fieldAliasArr = queryFieldAlias.split("\\.");
            String firstField = fieldAliasArr[0];
            String fieldAlias = null;
            JoinEntity joinEntity = (JoinEntity)joinEntityMap.get(firstField);
            if (joinEntity != null) {
                String realField = queryFieldAlias.replaceFirst(firstField + ".", "");
                fieldAlias = QueryKSqlUtil.convertFieldAlias((String)joinEntity.getEntityName(), (String)firstField, (String)realField);
            } else {
                fieldAlias = QueryKSqlUtil.convertFieldAlias((String)queryEntityInfo.getEditEntityNum(), (String)"", (String)queryFieldAlias);
            }
            fieldMap.put(fieldAlias, fieldAlias);
        }
        fieldMap.remove(null);
        return fieldMap;
    }

    private static String tryGetFieldIfExistsCurQuery(QueryEntityInfo queryEntityInfo, String fieldAlias, boolean containEntityName) {
        String[] fieldAliasArr = fieldAlias.split("\\.");
        DynamicProperty bdProp = null;
        if (fieldAliasArr.length == 2) {
            bdProp = queryEntityInfo.getEditEntityType().getProperty(fieldAliasArr[0]);
        }
        if (containEntityName && fieldAliasArr.length == 3) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)fieldAliasArr[0]);
            bdProp = dataEntityType.getProperty(fieldAliasArr[1]);
        }
        if (bdProp instanceof BasedataProp) {
            String baseEntityId = ((BasedataProp)bdProp).getBaseEntityId();
            if (queryEntityInfo.getAllEntityNames().contains(baseEntityId)) {
                return fieldAlias;
            }
        }
        return null;
    }
}

