/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.ksql;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.entity.list.JoinEntity;
import kd.hr.hbp.business.service.complexobj.util.MapCacheUtil;
import kd.hr.hbp.business.service.complexobj.util.MulTableAliasUtil;
import kd.hr.hbp.business.service.query.ksql.EntitySelectField;
import kd.hr.hbp.business.service.query.ksql.QueryEntityInfo;
import kd.hr.hbp.business.service.query.ksql.QueryField;
import kd.hr.hbp.business.servicehelper.HREntityHelper;

public class QueryKSqlTableParse {
    public static Map<String, Map<String, String>> getTableAlias(QueryEntityInfo queryEntityInfo) {
        return MulTableAliasUtil.genTableAlias(QueryKSqlTableParse.getAllTable(queryEntityInfo));
    }

    private static Map<String, Set<String>> getAllTable(QueryEntityInfo queryEntityInfo) {
        HashMap<String, Set<String>> aliasMap = new HashMap<String, Set<String>>(16);
        HashSet<String> mainEntityTable = new HashSet<String>(16);
        mainEntityTable.add(queryEntityInfo.getEditEntityTable());
        aliasMap.put(queryEntityInfo.getEditEntityNum(), mainEntityTable);
        QueryKSqlTableParse.mergeMap(aliasMap, QueryKSqlTableParse.getJoinTables(queryEntityInfo));
        QueryKSqlTableParse.mergeMap(aliasMap, QueryKSqlTableParse.getMLTables(queryEntityInfo));
        QueryKSqlTableParse.mergeMap(aliasMap, QueryKSqlTableParse.getSplitTables(queryEntityInfo));
        return aliasMap;
    }

    private static void mergeMap(Map<String, Set<String>> rstMap, Map<String, Set<String>> bMap) {
        for (Map.Entry<String, Set<String>> entry : bMap.entrySet()) {
            Set<String> set = rstMap.get(entry.getKey());
            if (set == null) {
                set = entry.getValue();
            } else {
                set.addAll((Collection<String>)entry.getValue());
            }
            rstMap.put(entry.getKey(), set);
        }
    }

    private static Map<String, Set<String>> getJoinTables(QueryEntityInfo queryEntityInfo) {
        HashMap<String, Set<String>> aliasMap = new HashMap<String, Set<String>>(16);
        List<JoinEntity> joinEntitys = queryEntityInfo.getQueryJoinEntitys();
        for (JoinEntity joinEntity : joinEntitys) {
            String tableName = HREntityHelper.getTableName(joinEntity.getEntityName());
            HashSet<String> tableSet = new HashSet<String>(16);
            tableSet.add(tableName);
            aliasMap.put(joinEntity.getAlias(), tableSet);
        }
        return aliasMap;
    }

    public static Map<String, Set<String>> getMLTables(QueryEntityInfo queryEntityInfo) {
        return QueryKSqlTableParse.getPredicateTables(queryEntityInfo, QueryField::isMultiLanguage);
    }

    public static Map<String, Set<String>> getSplitTables(QueryEntityInfo queryEntityInfo) {
        return QueryKSqlTableParse.getPredicateTables(queryEntityInfo, QueryField::isSplitField);
    }

    private static Map<String, Set<String>> getPredicateTables(QueryEntityInfo queryEntityInfo, Predicate<? super QueryField> predicate) {
        HashMap<String, Set<String>> aliasMap = new HashMap<String, Set<String>>(16);
        List<QueryField> editQueryFields = queryEntityInfo.getEditEntitySelectField().getQueryFields();
        if (editQueryFields != null) {
            Set editSpliTables = editQueryFields.stream().filter(predicate).map(QueryField::getTable).collect(Collectors.toSet());
            aliasMap.put(queryEntityInfo.getEditEntityNum(), editSpliTables);
        }
        List<EntitySelectField> joinEntitySelectField = queryEntityInfo.getJoinEntitySelectField();
        for (EntitySelectField entitySelectField : joinEntitySelectField) {
            List<QueryField> joinQueryFields = entitySelectField.getQueryFields();
            if (joinQueryFields == null) continue;
            String entityAlias = entitySelectField.getEntityAlias();
            Set<String> entityAliasTable = MapCacheUtil.getMapSetVal(aliasMap, entityAlias);
            entityAliasTable.addAll(joinQueryFields.stream().filter(predicate).map(QueryField::getTable).collect(Collectors.toSet()));
            aliasMap.put(entityAlias, entityAliasTable);
        }
        return aliasMap;
    }
}

