/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DataSetDataType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryEntityUtil;

public class DataSetUtil {
    private static RowMeta genRowMeta(Set<String> columns, List<DataType> dataTypes) {
        DataType[] dataTypeArr = dataTypes.toArray(new DataType[dataTypes.size()]);
        String[] columnArr = columns.toArray(new String[columns.size()]);
        return RowMetaFactory.createRowMeta((String[])columnArr, (DataType[])dataTypeArr);
    }

    private static void fillFieldDataType(QueryEntityType queryEntity, String queryFields, Set<String> columns, List<DataType> dataTypes) {
        String[] queryFieldArr = queryFields.split(",");
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        for (String fieldName : queryFieldArr) {
            IDataEntityProperty property;
            if (fieldName == null) continue;
            String entityName = QFilterUtilHR.getSubEntityName(fieldName, queryEntity);
            if (entityName == null) {
                String realFieldName = fieldName;
                String mainEntityPrex = queryEntity.getEditEntityAliasName() + ".";
                if (fieldName.startsWith(mainEntityPrex)) {
                    realFieldName = fieldName.replaceFirst(mainEntityPrex, "");
                }
                property = QueryEntityUtil.getSimpleProperty((DynamicObjectType)queryEntity.getMainEntityType(), (String)realFieldName);
            } else {
                MainEntityType entityType = mainEntityTypeUtil.getMainEntityType(entityName);
                String[] nameKeys = fieldName.split("\\.");
                property = QueryEntityUtil.getSimpleProperty((DynamicObjectType)entityType, (String)fieldName.replaceFirst(nameKeys[0] + ".", ""));
            }
            if (property == null || columns.contains(fieldName)) continue;
            DataType dt = DataSetDataType.getDataType((Class)property.getPropertyType());
            columns.add(fieldName);
            dataTypes.add(dt);
        }
    }

    public static DataSet convertToDataSet(QueryEntityType queryEntity, String queryFields, DynamicObjectCollection dynamicObjectCollection) {
        if (HRStringUtils.isEmpty((String)queryFields) || dynamicObjectCollection == null || queryEntity == null) {
            return null;
        }
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        DataSetUtil.fillFieldDataType(queryEntity, queryFields, columns, dataTypes);
        RowMeta rowMeta = DataSetUtil.genRowMeta(columns, dataTypes);
        HashMap<String, Boolean> propMap = new HashMap<String, Boolean>(16);
        HashMap<String, Boolean> propTypeMap = new HashMap<String, Boolean>(16);
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            ArrayList value = new ArrayList();
            for (String column : columns) {
                String[] columnArr;
                String mainEntityPrex;
                if (column.startsWith(mainEntityPrex = queryEntity.getEditEntityAliasName() + ".")) {
                    column = column.replaceFirst(mainEntityPrex, "");
                }
                if ((columnArr = column.split("\\.")).length > 3) {
                    String fieldName = columnArr[0] + "." + columnArr[1] + "." + columnArr[2];
                    Object valueObj = dynamicObject.get(fieldName);
                    if (DataSetUtil.isMulBaseDataProp(dynamicObject, fieldName, propTypeMap)) {
                        valueObj = DataSetUtil.getMulBaseDataDisplayString(dynamicObject, column, fieldName);
                        value.add(valueObj);
                        continue;
                    }
                    DynamicObject realDyo = dynamicObject.getDynamicObject(fieldName);
                    if (realDyo == null) {
                        value.add(realDyo);
                        continue;
                    }
                    valueObj = realDyo.get(columnArr[3]);
                    if (valueObj instanceof DynamicObject) {
                        DynamicObject dyo = (DynamicObject)valueObj;
                        valueObj = dyo.getPkValue();
                    }
                    value.add(valueObj);
                    continue;
                }
                Object valueObj = dynamicObject.get(column);
                if (DataSetUtil.isPropertyOfDataEntityType(dynamicObject, column, propMap)) {
                    if (DataSetUtil.isMulBaseDataProp(dynamicObject, column, propTypeMap)) {
                        valueObj = DataSetUtil.getMulBaseDataDisplayString(dynamicObject, column, column);
                        value.add(valueObj);
                        continue;
                    }
                    valueObj = dynamicObject.get(column);
                } else {
                    DynamicProperty property;
                    String[] subProps = column.split("\\.");
                    if (subProps.length == 2 && DataSetUtil.isPropertyOfDataEntityType(dynamicObject, subProps[0], propMap) && (property = ((MainEntityType)dynamicObject.getDataEntityType()).getProperty(subProps[0])) instanceof MulBasedataProp) {
                        valueObj = DataSetUtil.getMulBaseProStringOfMainEntity(propMap, dynamicObject, subProps);
                        value.add(valueObj);
                        continue;
                    }
                }
                if (valueObj instanceof DynamicObject) {
                    DynamicObject dyo = (DynamicObject)valueObj;
                    valueObj = dyo.getPkValue();
                }
                value.add(valueObj);
            }
            dataList.add(value.toArray());
        }
        String algoKey = "kd.hr.hbp.business.service.query.util.DataSetUtil_" + queryEntity.getName();
        DataSetBuilder dataSetBuilder = Algo.create((String)algoKey).createDataSetBuilder(rowMeta);
        for (Object[] objects : dataList) {
            dataSetBuilder.append(objects);
        }
        DataSet dataSet = dataSetBuilder.build();
        return dataSet;
    }

    private static Object getMulBaseProStringOfMainEntity(Map<String, Boolean> propMap, DynamicObject dynamicObject, String[] splitProps) {
        Object valueObj = null;
        MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)dynamicObject.get(splitProps[0]);
        if (HRQueryEntityHelper.getCurrentRequestParam().isMulBaseDataCollectionToString()) {
            ArrayList<String> displayValList = new ArrayList<String>();
            for (DynamicObject mulDynObj : mulBasedataDynamicObjectCollection) {
                DynamicObject baseDynObj = (DynamicObject)mulDynObj.get("fbasedataid");
                displayValList.add(baseDynObj.getString(splitProps[1]));
            }
            valueObj = String.join((CharSequence)";", displayValList);
        } else {
            valueObj = mulBasedataDynamicObjectCollection;
        }
        return valueObj;
    }

    private static Object getMulBaseDataDisplayString(DynamicObject dynamicObject, String column, String fieldName) {
        Object valueObj;
        MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)dynamicObject.get(fieldName);
        if (HRQueryEntityHelper.getCurrentRequestParam().isMulBaseDataCollectionToString()) {
            ArrayList<String> displayValList = new ArrayList<String>();
            for (DynamicObject mulDynObj : mulBasedataDynamicObjectCollection) {
                DynamicObject baseDynObj = (DynamicObject)mulDynObj.get("fbasedataid");
                String displayProp = column.substring(column.lastIndexOf(".") + 1, column.length());
                displayValList.add(baseDynObj.getString(displayProp));
            }
            valueObj = String.join((CharSequence)";", displayValList);
        } else {
            valueObj = mulBasedataDynamicObjectCollection;
        }
        return valueObj;
    }

    private static boolean isPropertyOfDataEntityType(DynamicObject dynamicObject, String column, Map<String, Boolean> propMap) {
        if (propMap.get(column) != null && propMap.get(column).booleanValue()) {
            return true;
        }
        DynamicProperty property = ((MainEntityType)dynamicObject.getDataEntityType()).getProperty(column);
        if (property != null) {
            propMap.put(column, Boolean.TRUE);
        } else {
            propMap.put(column, Boolean.FALSE);
        }
        return propMap.get(column);
    }

    private static boolean isMulBaseDataProp(DynamicObject dynamicObject, String column, Map<String, Boolean> propTypeMap) {
        if (propTypeMap.get(column) != null && propTypeMap.get(column).booleanValue()) {
            return true;
        }
        DynamicProperty property = ((MainEntityType)dynamicObject.getDataEntityType()).getProperty(column);
        if (property instanceof MulBasedataProp) {
            propTypeMap.put(column, true);
        } else {
            propTypeMap.put(column, false);
        }
        return propTypeMap.get(column);
    }
}

