/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kd.bos.entity.QueryEntityType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.business.service.query.util.QFilterESTransFunction;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import org.apache.commons.collections.CollectionUtils;

public abstract class EsFilterFieldTransfer {
    public List<EsFilterField> transferQFilter(QueryEntityType queryEntityType, QFilter[] filters) {
        int i;
        QFilterESTransFunction sqltf = new QFilterESTransFunction(queryEntityType);
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>();
        if (filters == null) {
            return esFilterFields;
        }
        int n = filters.length;
        for (i = 0; i < n; ++i) {
            if (filters[i] == null) continue;
            filters[i] = filters[i].trans((Function)sqltf);
        }
        n = filters.length;
        for (i = 0; i < n; ++i) {
            if (null == filters[i]) continue;
            EsFilterField esFilterField = this.qFilterToEsFilter(queryEntityType, filters[i]);
            esFilterFields.add(esFilterField);
        }
        return esFilterFields;
    }

    protected abstract String getEsPath(QueryEntityType var1, String var2);

    private EsFilterField qFilterToEsFilter(QueryEntityType queryEntityType, QFilter filter) {
        EsFilterField firstAnd;
        String path = this.getEsPath(queryEntityType, filter.getProperty());
        if (filter.getCP().equalsIgnoreCase(QFilterUtilHR.hrEmptyDecimal)) {
            firstAnd = new EsFilterField(path, filter.getProperty(), "is null", new Object[0]);
            firstAnd.or(new EsFilterField(path, filter.getProperty(), "=", 0));
        } else if (filter.getCP().equalsIgnoreCase(QFilterUtilHR.hrEmptyText)) {
            firstAnd = new EsFilterField(path, filter.getProperty(), "is null", new Object[0]);
            firstAnd.or(new EsFilterField(path, filter.getProperty(), "=", ""));
            firstAnd.or(new EsFilterField(path, filter.getProperty(), "=", " "));
        } else if (filter.getCP().equalsIgnoreCase(QFilterUtilHR.hrEmptyFieldText)) {
            String propStr = filter.getProperty() + ".keyword";
            firstAnd = new EsFilterField(path, propStr, "is null", new Object[0]);
            firstAnd.or(new EsFilterField(path, propStr, "=", ""));
            firstAnd.or(new EsFilterField(path, propStr, "=", " "));
        } else {
            firstAnd = this.buildSingleFilterField(path, filter);
        }
        List nests = filter.getNests(false);
        if (CollectionUtils.isEmpty((Collection)nests)) {
            return firstAnd;
        }
        for (QFilter.QFilterNest nest : nests) {
            if (nest.isAnd()) {
                firstAnd.and(this.qFilterToEsFilter(queryEntityType, nest.getFilter()));
                continue;
            }
            firstAnd.or(this.qFilterToEsFilter(queryEntityType, nest.getFilter()));
        }
        return firstAnd;
    }

    private EsFilterField buildSingleFilterField(String path, QFilter qFilter) {
        StringBuilder name = new StringBuilder();
        name.append(qFilter.getProperty());
        Object value = qFilter.getValue();
        if (value instanceof String) {
            name.append(".keyword");
        } else {
            if (value instanceof Object[]) {
                Object[] valueArr = (Object[])qFilter.getValue();
                return new EsFilterField(path, name.toString(), qFilter.getCP(), valueArr);
            }
            if (value instanceof List) {
                List valueList = (List)qFilter.getValue();
                Object[] valueListArr = valueList.toArray();
                return new EsFilterField(path, name.toString(), qFilter.getCP(), valueListArr);
            }
            if (value instanceof Set) {
                Set valueSet = (Set)qFilter.getValue();
                Object[] valueSetArr = valueSet.toArray();
                return new EsFilterField(path, name.toString(), qFilter.getCP(), valueSetArr);
            }
        }
        return new EsFilterField(path, name.toString(), qFilter.getCP(), value);
    }
}

