/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.service.query.model.mulbasedata.HRMulBaseData;
import kd.hr.hbp.business.service.query.model.mulbasedata.HRMulBaseDataQueryInfo;
import kd.hr.hbp.business.service.query.model.mulbasedata.HRMulBaseDataRow;
import kd.hr.hbp.business.service.query.util.HRMulBaseDataQuery;

class HRMulBaseDataMapper {
    protected static final String F_BASE_DATA_ID = "fbasedataid";
    protected static final String HR_MULTI_BASE_DATA_IN_Tag = "$hrMultiBaseDataInTag$";
    private final Map<MulBasedataProp, Map<Object, List<HRMulBaseData>>> mulBaseDataDataMap;
    private final MainEntityType mainEntityType;
    private final Map<MulBasedataProp, LinkedHashSet<Object>> mulBaseDataObjectTypeMap = new HashMap<MulBasedataProp, LinkedHashSet<Object>>(16);
    private final List<HRMulBaseDataRow> mulBaseDataRows = new ArrayList<HRMulBaseDataRow>(10);
    private final List<Object> pkList;
    private final MulBasedataProp mulBasedataProp;

    HRMulBaseDataMapper(MainEntityType mainEntityType, List<Object> pkList, MulBasedataProp mulBasedataProp) {
        this.mainEntityType = mainEntityType;
        this.pkList = pkList;
        this.mulBaseDataDataMap = new HashMap<MulBasedataProp, Map<Object, List<HRMulBaseData>>>();
        this.mulBasedataProp = mulBasedataProp;
    }

    void buildMulBaseDataDataMap(MulBasedataProp mulBasedataProp) {
        IDataEntityType complexType = mulBasedataProp.getComplexType();
        boolean isBaseDataPkLongType = complexType.getPrimaryKey() instanceof LongProp;
        boolean isPkLongType = this.mainEntityType.getPrimaryKey() instanceof LongProp;
        FilterField filterField = FilterField.create((MainEntityType)this.mainEntityType, (String)mulBasedataProp.getName());
        if (filterField == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.mainEntityType.getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"MulBaseDataMapper_0", (String)"bos-dao", (Object[])new Object[0]), mulBasedataProp.getName(), "FIELDNOTEXISTS000022")});
        }
        String dbRouteKey = this.mainEntityType.getDBRouteKey();
        String entryPKAlias = filterField.getFieldProp().getParent().getPrimaryKey().getAlias();
        HRMulBaseDataQueryInfo mulBaseDataQueryInfo = new HRMulBaseDataQueryInfo(dbRouteKey, mulBasedataProp.getItemType().getAlias(), entryPKAlias, isPkLongType, this.pkList, isBaseDataPkLongType);
        List<HRMulBaseData> mulBaseDataList = HRMulBaseDataQuery.getMulBaseData(mulBaseDataQueryInfo);
        HashMap<Object, ArrayList<HRMulBaseData>> billPkToMulBaseDataPkMap = new HashMap<Object, ArrayList<HRMulBaseData>>(16);
        for (HRMulBaseData mulBaseData2 : mulBaseDataList) {
            ArrayList<HRMulBaseData> list = (ArrayList<HRMulBaseData>)billPkToMulBaseDataPkMap.get(mulBaseData2.getFid());
            if (list == null) {
                list = new ArrayList<HRMulBaseData>();
            }
            list.add(mulBaseData2);
            billPkToMulBaseDataPkMap.put(mulBaseData2.getFid(), list);
        }
        this.mulBaseDataDataMap.put(mulBasedataProp, billPkToMulBaseDataPkMap);
    }

    private MulBasedataDynamicObjectCollection getMulBaseDataPropValue(MulBasedataProp mulBasedataProp, Map<Object, DynamicObject> refBaseDynObj, DynamicObject parent) {
        MulBasedataDynamicObjectCollection objs = new MulBasedataDynamicObjectCollection(mulBasedataProp.getDynamicCollectionItemPropertyType(), (Object)parent);
        for (Map.Entry<Object, DynamicObject> entry : refBaseDynObj.entrySet()) {
            DynamicObject bsdObj = entry.getValue();
            DynamicObject newObj = new DynamicObject(mulBasedataProp.getDynamicCollectionItemPropertyType());
            newObj.set(F_BASE_DATA_ID, (Object)bsdObj);
            newObj.set("fbasedataid_id", entry.getKey());
            objs.add(newObj);
        }
        return objs;
    }

    void addMulBaseDataRow(MulBasedataProp mulBasedataProp, Object pkValue, DynamicObject parent, MulBasedataProp originalMulProp) {
        Object[] baseDataPkList = this.getMulBaseDataPkList((IDataEntityProperty)mulBasedataProp, pkValue);
        if (baseDataPkList.length == 0) {
            return;
        }
        LinkedHashSet<Object> allBaseDataIdSet = this.mulBaseDataObjectTypeMap.get(mulBasedataProp);
        if (allBaseDataIdSet == null) {
            allBaseDataIdSet = new LinkedHashSet(10);
        }
        allBaseDataIdSet.addAll(Arrays.asList(baseDataPkList));
        this.mulBaseDataObjectTypeMap.put(mulBasedataProp, allBaseDataIdSet);
        this.mulBaseDataRows.add(new HRMulBaseDataRow(mulBasedataProp, baseDataPkList, parent, originalMulProp));
    }

    void loadAndFillMulBaseDataRows() {
        DynamicObjectType complexType = (DynamicObjectType)this.mulBasedataProp.getRefBaseProp().getComplexType();
        Map<Object, List<HRMulBaseData>> oneMulBaseDataMap = this.mulBaseDataDataMap.get(this.mulBasedataProp);
        ArrayList<Object> baseDataIdList = new ArrayList<Object>();
        for (Map.Entry<Object, List<HRMulBaseData>> entry : oneMulBaseDataMap.entrySet()) {
            List<HRMulBaseData> mulBaseDataList = entry.getValue();
            for (HRMulBaseData mulBaseData : mulBaseDataList) {
                baseDataIdList.add(mulBaseData.getFBaseDataId());
            }
        }
        Map refBaseDynObj = BusinessDataReader.loadFromCache((Object[])baseDataIdList.toArray(), (DynamicObjectType)complexType);
        for (HRMulBaseDataRow mulBaseDataRow : this.mulBaseDataRows) {
            if (!mulBaseDataRow.getMulBaseDataProp().equals((Object)this.mulBasedataProp)) continue;
            LinkedHashMap<Object, DynamicObject> rowRefBaseDynObj = new LinkedHashMap<Object, DynamicObject>(mulBaseDataRow.getPkList().length);
            for (Object o : mulBaseDataRow.getPkList()) {
                DynamicObject dynamicObject = (DynamicObject)refBaseDynObj.get(o);
                if (dynamicObject == null) continue;
                rowRefBaseDynObj.put(o, dynamicObject);
            }
            if (rowRefBaseDynObj.isEmpty()) continue;
            mulBaseDataRow.getOriginalMulProp().setValueFast((Object)mulBaseDataRow.getDynamicObject(), (Object)this.getMulBaseDataPropValue(mulBaseDataRow.getOriginalMulProp(), rowRefBaseDynObj, mulBaseDataRow.getDynamicObject()));
        }
    }

    private Object[] getMulBaseDataPkList(IDataEntityProperty dataEntityProperty, Object pkValue) {
        Map<Object, List<HRMulBaseData>> map = this.mulBaseDataDataMap.get(dataEntityProperty);
        if (map == null) {
            return new Object[0];
        }
        List<HRMulBaseData> mulBaseDataList = map.get(pkValue);
        if (mulBaseDataList == null) {
            return new Object[0];
        }
        Object[] baseDataIdList = new Object[mulBaseDataList.size()];
        int i = 0;
        for (HRMulBaseData mulBaseData : mulBaseDataList) {
            baseDataIdList[i++] = mulBaseData.getFBaseDataId();
        }
        return baseDataIdList;
    }
}

