/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.query.multi.FieldDecrypt;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.service.query.util.HRMulBaseDataMapper;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.business.service.query.util.QueryFieldInfo;
import kd.hr.hbp.business.service.query.util.QueryMultiLangFieldLoader;
import kd.hr.hbp.business.service.query.util.QueryPrivacyFiledLoader;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryEntityUtil;
import kd.hr.hbp.common.util.UserDateTimeUtil;
import org.apache.commons.lang3.StringUtils;

public class ListProviderDynamicObjCollectionUtil {
    private static final Log LOGGER = LogFactory.getLog(ListProviderDynamicObjCollectionUtil.class);
    private QueryEntityType queryEntity;
    private String selectFields;
    private boolean reloadDecryptField;
    private Set<String> queryDecryptFieldKeyCache;
    private boolean reloadMultiLangField;
    private List<QueryFieldInfo> queryMultiLangFieldInfos;
    private Set<String> queryMultiLangFieldKeyCache;
    private List<QueryFieldInfo> queryPrivacyFieldInfos;
    private Set<String> queryPrivacyFieldKeyCache;
    private Calendar calendar = Calendar.getInstance(KDDateUtils.getSysTimeZone());
    List<HRMulBaseDataMapper> mulBaseDataMappers = new ArrayList<HRMulBaseDataMapper>();
    Map<String, MainEntityType> mainEntityTypeMap = new HashMap<String, MainEntityType>(16);
    Map<String, MulBasedataProp> mulBaseDataPropMap = new HashMap<String, MulBasedataProp>(16);

    public boolean isReloadDecryptField() {
        return this.reloadDecryptField;
    }

    public boolean isReloadMultiLangField() {
        return this.reloadMultiLangField;
    }

    public void setReloadDecryptField(boolean reloadDecryptField) {
        this.reloadDecryptField = reloadDecryptField;
        this.queryDecryptFieldKeyCache = new HashSet<String>(16);
        this.queryPrivacyFieldInfos = new ArrayList<QueryFieldInfo>(16);
        this.queryPrivacyFieldKeyCache = new HashSet<String>(16);
    }

    public void setReloadMultiLangField(boolean reloadMultiLangField) {
        this.reloadMultiLangField = reloadMultiLangField;
        this.queryMultiLangFieldInfos = new ArrayList<QueryFieldInfo>(16);
        this.queryMultiLangFieldKeyCache = new HashSet<String>(16);
        this.queryPrivacyFieldInfos = new ArrayList<QueryFieldInfo>(16);
        this.queryPrivacyFieldKeyCache = new HashSet<String>(16);
    }

    public ListProviderDynamicObjCollectionUtil(String selectFields, QueryEntityType queryEntity) {
        this.selectFields = selectFields;
        this.queryEntity = queryEntity;
        this.queryPrivacyFieldInfos = new ArrayList<QueryFieldInfo>(16);
        this.queryPrivacyFieldKeyCache = new HashSet<String>(16);
    }

    public DynamicObjectCollection createDynamicObjectCollection(List<Map<String, Object>> list, int start, DynamicObjectCollection dynamicObjectCollection, DynamicObjectType dt) {
        HashMap<String, Set<Object>> baseDataIdMap = new HashMap<String, Set<Object>>();
        for (Map<String, Object> resultMap : list) {
            this.buildDaseDataId("", resultMap, baseDataIdMap);
        }
        HashMap entityMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, String> bdLoadPropMap = this.resolveBdprop();
        for (Map.Entry<String, Set<Object>> entry : baseDataIdMap.entrySet()) {
            String selectProperties;
            String[] nameKeys;
            HashMap baseSelectMap = Maps.newHashMapWithExpectedSize((int)((Set)entry.getValue()).size());
            String subEntityName = QFilterUtilHR.getSubEntityName((String)entry.getKey(), this.queryEntity);
            if (subEntityName != null && (nameKeys = ((String)entry.getKey()).split("\\.")).length == 2 && nameKeys[1].equalsIgnoreCase("id")) continue;
            String entityName = this.removeIdSuffix((String)entry.getKey());
            DynamicProperty property = this.queryEntity.getProperty(entityName);
            if (null == property) {
                String[] entityNameArr = entityName.split("\\.");
                DynamicProperty firstProp = this.queryEntity.getProperty(entityNameArr[0]);
                if (firstProp instanceof JoinProperty) {
                    JoinProperty joinProperty = (JoinProperty)firstProp;
                    DynamicObjectType dynamicComplexPropertyType = joinProperty.getDynamicComplexPropertyType();
                    property = dynamicComplexPropertyType.getProperty(entityNameArr[1]);
                } else {
                    MainEntityType dataEntityTypeNest = EntityMetadataCache.getDataEntityType((String)entityNameArr[0]);
                    property = dataEntityTypeNest.getProperty(entityNameArr[1]);
                }
            }
            if (!(property instanceof BasedataProp) && !(property instanceof MulBasedataProp)) continue;
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                DynamicObject[] subjoinEntityArray = null;
                String selectProperties2 = bdLoadPropMap.get(basedataProp.getBaseEntityId());
                if (HRStringUtils.isEmpty((String)selectProperties2)) continue;
                DynamicObjectType type = this.getSubEntityType(basedataProp.getBaseEntityId(), selectProperties2);
                subjoinEntityArray = BusinessDataServiceHelper.load((Object[])((Set)entry.getValue()).toArray(new Object[0]), (DynamicObjectType)type);
                this.convertArrayToMap(subjoinEntityArray, baseSelectMap);
                entityMap.put(entityName, baseSelectMap);
                this.addMulBaseDataPropOfBaseDataProp(entry, selectProperties2, type);
                continue;
            }
            if (!(property instanceof MulBasedataProp) || HRStringUtils.isEmpty((String)(selectProperties = bdLoadPropMap.get(((MulBasedataProp)property).getBaseEntityId())))) continue;
            MulBasedataProp mulBasedataProp = (MulBasedataProp)dt.getProperty(entityName);
            if (mulBasedataProp != null) {
                HRMulBaseDataMapper hrMulBaseDataMapper = new HRMulBaseDataMapper((MainEntityType)this.queryEntity, Arrays.asList(((Set)entry.getValue()).toArray(new Object[0])), mulBasedataProp);
                hrMulBaseDataMapper.buildMulBaseDataDataMap(mulBasedataProp);
                this.mulBaseDataMappers.add(hrMulBaseDataMapper);
                continue;
            }
            mulBasedataProp = (MulBasedataProp)property;
            MainEntityType dataEntityType = (MainEntityType)mulBasedataProp.getParent();
            HRMulBaseDataMapper hrMulBaseDataMapper = new HRMulBaseDataMapper(dataEntityType, Arrays.asList(((Set)entry.getValue()).toArray(new Object[0])), mulBasedataProp);
            hrMulBaseDataMapper.buildMulBaseDataDataMap(mulBasedataProp);
            this.mulBaseDataMappers.add(hrMulBaseDataMapper);
        }
        dynamicObjectCollection.beginInit();
        UserDateTimeUtil userDateTimeUtil = new UserDateTimeUtil();
        String[] stringArray = this.selectFields.split(",");
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> map = list.get(i);
            DynamicObject dyn = new DynamicObject(dt);
            for (int j = 0; j < stringArray.length; ++j) {
                String fieldName = stringArray[j];
                this.buildDynamicObject(dyn, fieldName, map, entityMap, i + start, userDateTimeUtil);
            }
            dynamicObjectCollection.add((Object)dyn);
        }
        for (HRMulBaseDataMapper mulBaseDataMapper : this.mulBaseDataMappers) {
            mulBaseDataMapper.loadAndFillMulBaseDataRows();
        }
        entityMap.clear();
        dynamicObjectCollection.endInit();
        BusinessDataReader.loadRefence((Object[])dynamicObjectCollection.toArray((Object[])new DynamicObject[dynamicObjectCollection.size()]), (IDataEntityType)dt);
        QueryMultiLangFieldLoader specialFielder = new QueryMultiLangFieldLoader(this.isReloadMultiLangField());
        specialFielder.reloadSpecialField(dynamicObjectCollection, this.queryMultiLangFieldInfos);
        QueryPrivacyFiledLoader privacyFielder = new QueryPrivacyFiledLoader(true);
        privacyFielder.reloadSpecialField(dynamicObjectCollection, this.queryPrivacyFieldInfos);
        return dynamicObjectCollection;
    }

    public String removeIdSuffix(String input) {
        if (input.endsWith(".id")) {
            return input.substring(0, input.length() - 3);
        }
        return input;
    }

    private Map<String, String> resolveBdprop() {
        String[] listFields = this.selectFields.split(",");
        HashMap bdLoadFieldsMap = Maps.newHashMapWithExpectedSize((int)16);
        for (String fieldName : listFields) {
            String entityName = QFilterUtilHR.getSubEntityName(fieldName, this.queryEntity);
            String[] split = fieldName.split("\\.");
            String firstField = split[0];
            if (entityName == null) {
                this.recordBdField(this.queryEntity.getEditEntityName(), fieldName, bdLoadFieldsMap);
                continue;
            }
            fieldName = fieldName.replaceFirst(firstField + "\\.", "");
            this.recordBdField(entityName, fieldName, bdLoadFieldsMap);
        }
        HashMap bdLoadPropMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry entry : bdLoadFieldsMap.entrySet()) {
            Set value = (Set)entry.getValue();
            bdLoadPropMap.put(entry.getKey(), StringUtils.join((Object[])value.toArray(new String[value.size()]), (char)','));
        }
        return bdLoadPropMap;
    }

    private void recordBdField(String entityName, String fieldName, Map<String, Set<String>> bdLoadFieldsMap) {
        String[] nameKeys = fieldName.split("\\.");
        if (nameKeys.length < 2) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicProperty property = dataEntityType.getProperty(nameKeys[0]);
        if (property instanceof DynamicComplexProperty) {
            BasedataProp basedataProp = (BasedataProp)property;
            String bdEntityId = basedataProp.getBaseEntityId();
            String bdField = fieldName.replaceFirst(nameKeys[0] + "\\.", "");
            HashSet bdFieldSet = bdLoadFieldsMap.get(bdEntityId);
            if (bdFieldSet == null) {
                bdFieldSet = Sets.newHashSetWithExpectedSize((int)16);
                bdFieldSet.add("id");
            }
            bdFieldSet.add(bdField);
            bdLoadFieldsMap.put(bdEntityId, bdFieldSet);
        } else if (property instanceof MulBasedataProp) {
            MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
            String bdEntityId = mulBasedataProp.getBaseEntityId();
            String bdField = fieldName.replaceFirst(nameKeys[0] + "\\." + nameKeys[1] + "\\.", "");
            HashSet bdFieldSet = bdLoadFieldsMap.get(bdEntityId);
            if (bdFieldSet == null) {
                bdFieldSet = Sets.newHashSetWithExpectedSize((int)16);
                bdFieldSet.add("id");
            }
            bdFieldSet.add(bdField);
            bdLoadFieldsMap.put(bdEntityId, bdFieldSet);
        }
    }

    private DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        return EntityMetadataCache.getSubDataEntityType((String)entityName, select);
    }

    private void convertArrayToMap(DynamicObject[] objects, Map<Object, DynamicObject> map) {
        for (DynamicObject object : objects) {
            Object id = object.get("id");
            map.put(id, object);
        }
    }

    private void buildDaseDataId(String preName, Map<String, Object> resultMap, Map<String, Set<Object>> baseDataIdMap) {
        for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
            if (baseDataIdMap.containsKey(preName + entry.getKey())) {
                Set<Object> objectSet = baseDataIdMap.get(preName + entry.getKey());
                this.addId(objectSet, entry);
                continue;
            }
            if (entry.getKey().endsWith(".id")) {
                HashSet<Object> idSet = new HashSet<Object>();
                this.addId(idSet, entry);
                baseDataIdMap.put(preName + entry.getKey(), idSet);
                continue;
            }
            if (!(entry.getValue() instanceof Map)) continue;
            Map value = (Map)entry.getValue();
            this.buildDaseDataId(entry.getKey() + ".", value, baseDataIdMap);
        }
    }

    private void buildDynamicObject(DynamicObject data, String fieldName, Map<String, Object> map, Map<String, Map<Object, DynamicObject>> entityMap, int i, UserDateTimeUtil userDateTimeUtil) {
        try {
            if (fieldName == null) {
                return;
            }
            DynamicObjectType dt = data.getDynamicObjectType();
            DynamicProperty property = dt.getProperty(fieldName);
            String entityName = QFilterUtilHR.getSubEntityName(fieldName, this.queryEntity);
            if (entityName == null) {
                this.buildMainEntityDynamicObject(data, fieldName, map, i, userDateTimeUtil);
            } else {
                this.buildSubEntityDynamicObject(data, fieldName, map, entityMap, userDateTimeUtil);
            }
        }
        catch (Exception exception) {
            LOGGER.error("buildDynamicObject error:fieldName{}, index{}, data{}", new Object[]{fieldName, i, map});
            throw exception;
        }
    }

    private void buildMainEntityDynamicObject(DynamicObject data, String fieldName, Map<String, Object> map, int i, UserDateTimeUtil userDateTimeUtil) {
        DynamicObjectType dt = data.getDynamicObjectType();
        DynamicProperty property = dt.getProperty(fieldName);
        if (property == null) {
            String[] nameKeys = fieldName.split("\\.");
            DynamicProperty property2 = dt.getProperty(nameKeys[0]);
            if (property2 instanceof DynamicComplexProperty) {
                DynamicProperty subProperty;
                if (nameKeys.length > 1 && (subProperty = ((DynamicComplexProperty)property2).getDynamicComplexPropertyType().getProperty(nameKeys[1])) instanceof MulBasedataProp) {
                    MulBasedataProp mulBasedataProp = this.getMulBasePropByPropString(fieldName);
                    this.addMulBaseDataRow(data, map, fieldName, mulBasedataProp, (MulBasedataProp)subProperty);
                    return;
                }
                Object idObject = map.get(nameKeys[0] + ".id");
                if (null == idObject) {
                    data.set(nameKeys[0], null);
                    return;
                }
                property = ((BasedataProp)property2).getRefIdProp();
                DynamicProperty dtProperty = dt.getProperty(property.getName());
                if (dtProperty == null) {
                    return;
                }
                if (this.isNumber(idObject)) {
                    dtProperty.setValueFast((Object)data, (Object)Long.parseLong(idObject.toString()));
                } else {
                    dtProperty.setValueFast((Object)data, idObject);
                }
            } else if (property2 instanceof MulBasedataProp) {
                MulBasedataProp mulBasedataProp = (MulBasedataProp)property2;
                Object idObject = map.get(nameKeys[0] + ".id");
                if (null == idObject) {
                    data.set(nameKeys[0], null);
                    return;
                }
                if (this.isNumber(idObject)) {
                    idObject = Long.parseLong(idObject.toString());
                }
                for (HRMulBaseDataMapper mulBaseDataMapper : this.mulBaseDataMappers) {
                    mulBaseDataMapper.addMulBaseDataRow(mulBasedataProp, idObject, data, mulBasedataProp);
                }
            }
        } else {
            if (fieldName.contains("listcolumnap")) {
                data.set(fieldName, (Object)(i + 1));
                return;
            }
            Object propValue = map.get(fieldName);
            propValue = this.tryDecryptField((MainEntityType)this.queryEntity, this.queryEntity.getEditEntityName(), this.queryEntity.getEditEntityName(), fieldName, propValue);
            Date userDateTime = this.transUserDateTime((MainEntityType)this.queryEntity, this.queryEntity.getEditEntityName(), userDateTimeUtil, fieldName, propValue);
            this.parseMultiLangProp((MainEntityType)this.queryEntity, this.queryEntity.getEditEntityName(), this.queryEntity.getEditEntityName(), fieldName);
            this.parsePrivacyProp((MainEntityType)this.queryEntity, this.queryEntity.getEditEntityName(), this.queryEntity.getEditEntityName(), fieldName);
            if (null != propValue) {
                this.setValueFast(data, (IDataEntityProperty)property, fieldName, propValue, userDateTime);
            }
        }
    }

    private void buildSubEntityDynamicObject(DynamicObject data, String fieldName, Map<String, Object> map, Map<String, Map<Object, DynamicObject>> entityMap, UserDateTimeUtil userDateTimeUtil) {
        String[] nameKeys = fieldName.split("\\.");
        DynamicObjectType dt = data.getDynamicObjectType();
        DynamicProperty property = dt.getProperty(fieldName);
        if (nameKeys.length == 3) {
            DynamicObject dy;
            if (property instanceof MulBasedataProp) {
                MulBasedataProp mulBasedataProp = null;
                mulBasedataProp = this.getMulBasePropByPropMap(fieldName);
                if (mulBasedataProp != null) {
                    String propertyName = new StringBuffer(nameKeys[0]).append(".").append(nameKeys[1]).append(".").append(nameKeys[2]).toString();
                    MulBasedataProp property2 = (MulBasedataProp)dt.getProperty(propertyName);
                    this.addMulBaseDataRow(data, map, fieldName, mulBasedataProp, property2);
                    return;
                }
            }
            if ((dy = this.getSubBasicDynamicObject(fieldName, map, entityMap)) != null) {
                this.setValueFast(data, (IDataEntityProperty)property, fieldName, dy.get(nameKeys[2]), null);
            } else {
                this.setValueFast(data, (IDataEntityProperty)property, fieldName, null, null);
            }
        } else if (nameKeys.length == 4) {
            DynamicObject dy;
            String propertyName = new StringBuffer(nameKeys[0]).append(".").append(nameKeys[1]).toString();
            DynamicProperty property2 = dt.getProperty(propertyName);
            if (property2 instanceof MulBasedataProp) {
                this.addMulBaseDataRow(data, map, propertyName, (MulBasedataProp)property2, (MulBasedataProp)property2);
                return;
            }
            if (property2 == null && (property2 = dt.getProperty(propertyName = new StringBuffer(nameKeys[0]).append(".").append(nameKeys[1]).append(".").append(nameKeys[2]).toString())) instanceof MulBasedataProp) {
                MulBasedataProp mulBasedataProp = this.getMulBasePropByPropMap(fieldName);
                if (mulBasedataProp != null) {
                    propertyName = new StringBuffer(nameKeys[0]).append(".").append(nameKeys[1]).append(".").append(nameKeys[2]).toString();
                    property2 = (MulBasedataProp)dt.getProperty(propertyName);
                    this.addMulBaseDataRow(data, map, fieldName, mulBasedataProp, (MulBasedataProp)property2);
                    return;
                }
                return;
            }
            propertyName = new StringBuffer(nameKeys[0]).append(".").append(nameKeys[1]).append(".").append(nameKeys[2]).toString();
            property2 = dt.getProperty(propertyName);
            if (property2 instanceof MulBasedataProp) {
                this.addMulBaseDataRow(data, map, propertyName, (MulBasedataProp)property2, (MulBasedataProp)property2);
                return;
            }
            if (property2 != null) {
                property = ((BasedataProp)property2).getRefIdProp();
            }
            if ((dy = this.getSubBasicDynamicObject(fieldName, map, entityMap)) != null) {
                this.setValueFastOt(data, (IDataEntityProperty)property, propertyName, dy);
            } else {
                this.setValueFastOt(data, (IDataEntityProperty)property, propertyName, null);
            }
        } else {
            Object propValue = map.get(fieldName);
            String relEntityName = QueryEntityUtil.getEntityNameByAlias((String)nameKeys[0], (QueryEntityType)this.queryEntity);
            propValue = this.tryDecryptField(null, relEntityName, nameKeys[0], nameKeys[1], propValue);
            Date userDateTime = this.transUserDateTime(null, relEntityName, userDateTimeUtil, nameKeys[1], propValue);
            this.parseMultiLangProp(null, relEntityName, nameKeys[0], nameKeys[1]);
            this.parsePrivacyProp(null, relEntityName, nameKeys[0], nameKeys[1]);
            if (null != propValue) {
                this.setValueFast(data, (IDataEntityProperty)property, fieldName, propValue, userDateTime);
            } else {
                this.setValueFast(data, (IDataEntityProperty)property, fieldName, null, null);
            }
        }
    }

    private void parsePrivacyProp(MainEntityType mainEntityType, String entityName, String entityAlias, String fieldName) {
        DynamicProperty prop;
        if (!ORMConfig.PRIVACY_ENABLE.getBoolean()) {
            return;
        }
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(entityName);
        cacheKey.append("_");
        cacheKey.append(fieldName);
        if (this.queryPrivacyFieldKeyCache.contains(cacheKey.toString())) {
            return;
        }
        this.queryPrivacyFieldKeyCache.add(cacheKey.toString());
        if (mainEntityType == null) {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        }
        if ((prop = mainEntityType.getProperty(fieldName)) instanceof ISimpleProperty && PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)prop)) {
            IDataEntityType parentEntity = prop.getParent();
            entityName = parentEntity.getName();
            String entityAlas = parentEntity.getAlias();
            ISimpleProperty primaryKey = parentEntity.getPrimaryKey();
            boolean mainEntityField = false;
            if (parentEntity instanceof QueryEntityType) {
                QueryEntityType parentQueryEntity = (QueryEntityType)parentEntity;
                entityName = parentQueryEntity.getEntityName();
                mainEntityField = true;
            }
            QueryFieldInfo queryFieldInfo = new QueryFieldInfo(entityName, entityAlas, prop.getTableGroup(), primaryKey.getName(), primaryKey.getAlias(), prop.getAlias(), prop.getName());
            queryFieldInfo.setMainEntityField(mainEntityField);
            queryFieldInfo.setEntityAlias(entityAlias);
            if (prop instanceof MuliLangTextProp) {
                queryFieldInfo.setMulField(true);
            }
            this.queryPrivacyFieldInfos.add(queryFieldInfo);
        }
    }

    private void parseMultiLangProp(MainEntityType mainEntityType, String entityName, String entityAlias, String fieldName) {
        DynamicProperty prop;
        if (!this.isReloadMultiLangField()) {
            return;
        }
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(entityName);
        cacheKey.append("_");
        cacheKey.append(fieldName);
        if (this.queryMultiLangFieldKeyCache.contains(cacheKey.toString())) {
            return;
        }
        this.queryMultiLangFieldKeyCache.add(cacheKey.toString());
        if (mainEntityType == null) {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        }
        if ((prop = mainEntityType.getProperty(fieldName)) instanceof MuliLangTextProp) {
            MuliLangTextProp muliLangTextProp = (MuliLangTextProp)prop;
            IDataEntityType parentEntity = muliLangTextProp.getParent();
            entityName = parentEntity.getName();
            String entityAlas = parentEntity.getAlias();
            ISimpleProperty primaryKey = parentEntity.getPrimaryKey();
            boolean mainEntityField = false;
            if (parentEntity instanceof QueryEntityType) {
                QueryEntityType parentQueryEntity = (QueryEntityType)parentEntity;
                entityName = parentQueryEntity.getEntityName();
                mainEntityField = true;
            }
            QueryFieldInfo queryFieldInfo = new QueryFieldInfo(entityName, entityAlas, "L", primaryKey.getName(), primaryKey.getAlias(), muliLangTextProp.getAlias(), muliLangTextProp.getName());
            queryFieldInfo.setEntityAlias(entityAlias);
            queryFieldInfo.setMainEntityField(mainEntityField);
            this.queryMultiLangFieldInfos.add(queryFieldInfo);
        }
    }

    private Date transUserDateTime(MainEntityType mainEntityType, String entityName, UserDateTimeUtil dateTimeUtil, String fieldName, Object propValue) {
        DynamicProperty prop;
        if (propValue == null) {
            return null;
        }
        if (mainEntityType == null) {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        }
        if ((prop = mainEntityType.getProperty(fieldName)) instanceof DateTimeProp && propValue instanceof Date) {
            Date dateVal = (Date)propValue;
            DateTimeProp dateTimeProp = (DateTimeProp)prop;
            int timeZoneTransType = dateTimeProp.getTimeZoneTransType();
            if (timeZoneTransType == 1) {
                try {
                    LOGGER.info("transferUserDateTimeFormat fieldName:{}", (Object)fieldName);
                    return dateTimeUtil.transferUserDateTimeFormat(dateVal);
                }
                catch (ParseException parseException) {
                    LOGGER.error(dateVal + "transferUserDateTimeFormat exception :", (Throwable)parseException);
                }
            }
        }
        return null;
    }

    private Object tryDecryptField(MainEntityType mainEntityType, String entityName, String entityAlias, String fieldName, Object propValue) {
        DynamicProperty prop;
        if (mainEntityType == null) {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        }
        if ((prop = mainEntityType.getProperty(fieldName)) instanceof ISimpleProperty && ((ISimpleProperty)prop).isEncrypt()) {
            if (this.isReloadDecryptField()) {
                StringBuilder cacheKey = new StringBuilder();
                cacheKey.append(entityName);
                cacheKey.append("_");
                cacheKey.append(fieldName);
                if (this.queryDecryptFieldKeyCache.contains(cacheKey.toString())) {
                    return null;
                }
                this.queryDecryptFieldKeyCache.add(cacheKey.toString());
                IDataEntityType parentEntity = prop.getParent();
                entityName = parentEntity.getName();
                String entityAlas = parentEntity.getAlias();
                ISimpleProperty primaryKey = parentEntity.getPrimaryKey();
                boolean mainEntityField = false;
                if (parentEntity instanceof QueryEntityType) {
                    QueryEntityType parentQueryEntity = (QueryEntityType)parentEntity;
                    entityName = parentQueryEntity.getEntityName();
                    mainEntityField = true;
                }
                String decFieldALias = prop.getAlias() + "_enp";
                QueryFieldInfo queryFieldInfo = new QueryFieldInfo(entityName, entityAlas, prop.getTableGroup(), primaryKey.getName(), primaryKey.getAlias(), decFieldALias, prop.getName());
                queryFieldInfo.setMainEntityField(mainEntityField);
                queryFieldInfo.setEntityAlias(entityAlias);
                return null;
            }
            if (HRObjectUtils.isEmpty((Object)propValue)) {
                return propValue;
            }
            propValue = FieldDecrypt.get((ISimpleProperty)((ISimpleProperty)prop)).convert(propValue);
        }
        return propValue;
    }

    private DynamicObject getSubBasicDynamicObject(String fieldName, Map<String, Object> map, Map<String, Map<Object, DynamicObject>> entityMap) {
        String[] nameKeys = fieldName.split("\\.");
        if (nameKeys.length == 3) {
            DynamicObject dynamicObject;
            String firstProp = fieldName.substring(0, fieldName.lastIndexOf("."));
            Object idObject = map.get(firstProp + ".id");
            if (null == idObject) {
                return null;
            }
            Map<Object, DynamicObject> idDynamicMap = entityMap.get(firstProp);
            if (idDynamicMap != null && (dynamicObject = idDynamicMap.get(Long.parseLong(idObject.toString()))) != null) {
                return dynamicObject;
            }
        } else {
            if (nameKeys.length == 4) {
                StringBuilder builder = new StringBuilder();
                builder.append(nameKeys[0]).append(".").append(nameKeys[1]);
                String firstProp = builder.toString();
                Object idObject = map.get(firstProp + ".id");
                if (null == idObject) {
                    return null;
                }
                Map<Object, DynamicObject> idDynamicMap = entityMap.get(firstProp);
                if (idDynamicMap == null) {
                    return null;
                }
                DynamicObject dynamicObject = idDynamicMap.get(Long.parseLong(idObject.toString()));
                if (dynamicObject != null) {
                    String subBDName = nameKeys[2];
                    DynamicObject subDynamicObj = (DynamicObject)dynamicObject.get(subBDName);
                    return subDynamicObj;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private void setValueFastOt(DynamicObject data, IDataEntityProperty property, String fieldName, Object propValue) {
        if (property == null) {
            data.set(fieldName, propValue);
        }
        if (property != null && Date.class.equals((Object)property.getPropertyType())) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            try {
                Date date = null;
                if (null != propValue) {
                    date = format.parse(propValue.toString());
                }
                data.set(fieldName, date);
            }
            catch (ParseException e) {
                LOGGER.error((Throwable)e);
            }
        } else {
            data.set(fieldName, propValue);
        }
    }

    private void setValueFast(DynamicObject data, IDataEntityProperty property, String fieldName, Object propValue, Date userDateTime) {
        if (userDateTime == null && property != null && Date.class.equals((Object)property.getPropertyType())) {
            try {
                Date date = null;
                if (propValue instanceof Timestamp) {
                    this.calendar.setTimeInMillis(((Timestamp)propValue).getTime());
                    date = this.calendar.getTime();
                } else if (propValue != null) {
                    date = this.parseDate(propValue.toString());
                }
                data.set(fieldName, date);
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
        } else {
            data.set(fieldName, propValue);
        }
    }

    private Date parseDate(String time) throws ParseException {
        try {
            return HRDateTimeUtils.parseDate((String)time, (String)"yyyy-MM-dd'T'HH:mm:ss");
        }
        catch (ParseException parseException) {
            return HRDateTimeUtils.parseDate((String)time);
        }
    }

    private boolean isNumber(Object value) {
        boolean isNumber = false;
        if (value != null) {
            isNumber = StringUtils.isNumeric((CharSequence)value.toString());
        }
        return isNumber;
    }

    private void addId(Set<Object> idSet, Map.Entry<String, Object> entry) {
        Object value = entry.getValue();
        if (value == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)value.toString())) {
            LOGGER.warn("proppk : {}, is empty", (Object)entry.getKey());
            return;
        }
        if (this.isNumber(value)) {
            idSet.add(Long.parseLong(value.toString()));
        } else {
            idSet.add(value);
        }
    }

    private void addMulBaseDataRow(DynamicObject data, Map<String, Object> map, String propertyName, MulBasedataProp mulBasedataProp, MulBasedataProp originalMulProp) {
        String mulBaseDataString;
        Object idObject = map.get(propertyName + ".id");
        if (idObject == null && (idObject = map.get((mulBaseDataString = propertyName.substring(0, propertyName.lastIndexOf("."))) + ".id")) == null) {
            if (mulBaseDataString.indexOf(".") > 0) {
                mulBaseDataString = mulBaseDataString.substring(0, mulBaseDataString.lastIndexOf("."));
            }
            if ((idObject = map.get(mulBaseDataString + ".id")) == null) {
                return;
            }
        }
        if (this.isNumber(idObject)) {
            idObject = Long.parseLong(idObject.toString());
        }
        for (HRMulBaseDataMapper mulBaseDataMapper : this.mulBaseDataMappers) {
            mulBaseDataMapper.addMulBaseDataRow(mulBasedataProp, idObject, data, originalMulProp);
        }
    }

    private void addMulBaseDataPropOfBaseDataProp(Map.Entry<String, Set<Object>> baseMap, String selectProperties, DynamicObjectType type) {
        String[] props;
        for (String fullPropName : props = selectProperties.split(",")) {
            String[] subProp = fullPropName.split("\\.");
            String firstPropName = subProp[0];
            if (!(type.getProperty(firstPropName) instanceof MulBasedataProp)) continue;
            MulBasedataProp mulBasedataProp = (MulBasedataProp)type.getProperty(firstPropName);
            String mulSelectProperties = firstPropName;
            if (subProp.length > 1) {
                mulSelectProperties = fullPropName.substring(firstPropName.length() + 1);
            }
            if (HRStringUtils.isEmpty((String)mulSelectProperties)) continue;
            MainEntityType dataEntityType = (MainEntityType)mulBasedataProp.getParent();
            DynamicProperty firstProperty = (dataEntityType = this.getMainEntityType(dataEntityType.getName())).getProperty(firstPropName);
            if (!(firstProperty instanceof MulBasedataProp)) continue;
            mulBasedataProp = (MulBasedataProp)firstProperty;
            HRMulBaseDataMapper hrMulBaseDataMapper = new HRMulBaseDataMapper(dataEntityType, Arrays.asList(baseMap.getValue().toArray(new Object[0])), mulBasedataProp);
            hrMulBaseDataMapper.buildMulBaseDataDataMap(mulBasedataProp);
            this.mulBaseDataMappers.add(hrMulBaseDataMapper);
        }
    }

    private MulBasedataProp getMulBasePropByPropMap(String selectFieldProp) {
        if (this.mulBaseDataPropMap.get(selectFieldProp) != null) {
            return this.mulBaseDataPropMap.get(selectFieldProp);
        }
        MulBasedataProp mulBasedataProp = this.getMulBasePropByPropString(selectFieldProp);
        this.mulBaseDataPropMap.put(selectFieldProp, mulBasedataProp);
        return mulBasedataProp;
    }

    private MulBasedataProp getMulBasePropByPropString(String selectFieldProp) {
        String[] props = selectFieldProp.split(",");
        DynamicProperty property = null;
        for (String prop : props) {
            String baseEntityId;
            DynamicProperty subProperty;
            MainEntityType dataEntityTypeNest;
            String[] oneProps = prop.split("\\.");
            DynamicProperty firstProp = this.queryEntity.getProperty(oneProps[0]);
            if (firstProp instanceof JoinProperty) {
                JoinProperty joinProperty = (JoinProperty)firstProp;
                DynamicObjectType dynamicComplexPropertyType = joinProperty.getDynamicComplexPropertyType();
                property = dynamicComplexPropertyType.getProperty(oneProps[1]);
            } else {
                if (firstProp instanceof MulBasedataProp) {
                    return (MulBasedataProp)firstProp;
                }
                if (firstProp instanceof DynamicComplexProperty) {
                    String entityName = ((DynamicComplexProperty)firstProp).getComplexType().getName();
                    dataEntityTypeNest = this.getMainEntityType(entityName);
                    property = dataEntityTypeNest.getProperty(oneProps[1]);
                }
            }
            if (property instanceof MulBasedataProp) {
                return (MulBasedataProp)property;
            }
            if (!(property instanceof BasedataProp) || !((subProperty = (dataEntityTypeNest = this.getMainEntityType(baseEntityId = ((BasedataProp)property).getBaseEntityId())).getProperty(oneProps[2])) instanceof MulBasedataProp)) continue;
            return (MulBasedataProp)subProperty;
        }
        return null;
    }

    private MainEntityType getMainEntityType(String entityName) {
        if (this.mainEntityTypeMap.get(entityName) != null) {
            return this.mainEntityTypeMap.get(entityName);
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        this.mainEntityTypeMap.put(entityName, mainEntityType);
        return mainEntityType;
    }
}

