/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.function.Function;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.service.query.ksql.IKsqlConfig;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.query.vo.NestedBasicDataPropertyVO;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryEntityUtil;

public class QFilterKSQLTransFunction
implements Function<QFilter, QFilter> {
    private static Log logger = LogFactory.getLog(QFilterKSQLTransFunction.class);
    private QueryEntityType queryEntity;
    private IKsqlConfig ksqlConfig;

    public QFilterKSQLTransFunction(QueryEntityType queryEntity, IKsqlConfig ksqlConfig) {
        this.queryEntity = queryEntity;
        this.ksqlConfig = ksqlConfig;
    }

    @Override
    public QFilter apply(QFilter filter) {
        NestedBasicDataPropertyVO vo;
        if ("ftlike".equals(filter.getCP())) {
            filter.__setCP("like");
        }
        if (filter.toString().equalsIgnoreCase("1 != 1")) {
            return filter;
        }
        if (filter.getProperty().equals("1") && "1".equals(filter.getValue().toString())) {
            return filter;
        }
        QFilterUtilHR.convertPermQFilterEx(filter, this.queryEntity);
        String entityName = null;
        Boolean isMainEntity = false;
        entityName = QFilterUtilHR.getSubEntityName(filter.getProperty(), this.queryEntity);
        if (entityName == null) {
            entityName = this.queryEntity.getEntityName();
            isMainEntity = true;
        }
        if ((vo = QFilterUtilHR.changeSecondLvBDToFirstLvBDByFilterEx(filter.getProperty(), filter, this.queryEntity)) == null) {
            vo = this.getNestedBasicDataPropertyVO(filter, entityName, isMainEntity);
        }
        StringBuilder whereSql = new StringBuilder();
        String tableName = vo.mainEntityType.getAlias();
        if (vo.mutileLang.booleanValue()) {
            tableName = tableName + "_L";
        } else {
            String tableGroup = vo.dataEntityProperty.getTableGroup();
            if (HRStringUtils.isNotEmpty((String)tableGroup)) {
                tableName = tableName + "_" + tableGroup;
            }
        }
        String entityAlias = QueryEntityUtil.getFieldEntityAlias((String)filter.getProperty(), (QueryEntityType)this.queryEntity);
        this.ksqlConfig.addUnIgnoreTable(tableName);
        String aliasName = this.ksqlConfig.getTableAliasMap(this.queryEntity.getName()).get(entityAlias).get(tableName);
        whereSql.append(aliasName);
        if (vo.dataEntityProperty instanceof MulBasedataProp) {
            MainEntityType dataEntityType = null;
            dataEntityType = HRStringUtils.isEmpty((String)vo.getEntityName()) ? vo.getMainEntityType() : EntityMetadataCache.getDataEntityType((String)vo.getEntityName());
            FilterField filterField = FilterField.create((MainEntityType)dataEntityType, (String)vo.dataEntityProperty.getName());
            String entryPKAlias = filterField.getFieldProp().getParent().getPrimaryKey().getAlias();
            whereSql.append(".").append(entryPKAlias);
        } else {
            whereSql.append(".").append(vo.dataEntityProperty.getAlias());
        }
        try {
            this.processSpecialFilter(vo.filter, vo.dataEntityProperty);
        }
        catch (Exception er) {
            logger.error((Throwable)er);
        }
        vo.filter.__setProperty(whereSql.toString());
        return vo.filter;
    }

    @ExcludeFromJacocoGeneratedReport
    private NestedBasicDataPropertyVO getNestedBasicDataPropertyVO(QFilter filter, String entityName, Boolean isMainEntity) {
        MainEntityType dataEntityType;
        NestedBasicDataPropertyVO vo = new NestedBasicDataPropertyVO();
        vo.mainEntityType = dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        String propertyname = null;
        String[] nameKeys = filter.getProperty().split("\\.");
        if (isMainEntity.booleanValue()) {
            String mainEntityName = this.queryEntity.getEntityName();
            propertyname = nameKeys[0].equalsIgnoreCase(mainEntityName) ? nameKeys[1] : nameKeys[0];
        } else if (nameKeys.length < 2 && filter.getCP().equals("=") && filter.getValue() instanceof QEmptyValue) {
            propertyname = "id";
            filter.__setProperty(filter.getProperty() + ".id");
        } else {
            if (nameKeys.length < 2) {
                logger.error("QFilterKSQLTransFunction ERROR:{},", (Object)filter);
            }
            propertyname = nameKeys[1];
        }
        DynamicProperty dynamicProperty = dataEntityType.getProperty(propertyname);
        if (dynamicProperty == null) {
            logger.info("QFilterKSQLTransFunction.apply entitynum:{}, propertyname:{}, qfilter:{}", new Object[]{this.queryEntity.getName(), propertyname, filter.toString()});
            throw new KDBizException(this.queryEntity.getName() + " not exists property:" + propertyname);
        }
        if (dynamicProperty instanceof ILocaleProperty) {
            vo.mutileLang = true;
        }
        if (ORMConfig.PRIVACY_ENABLE.getBoolean() && PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)dynamicProperty)) {
            QFilterUtilHR.handlePrivacyProperty(dynamicProperty, filter, this.queryEntity, propertyname);
            return this.getNestedBasicDataPropertyVO(filter, entityName, isMainEntity);
        }
        vo.dataEntityProperty = dynamicProperty;
        vo.filter = filter;
        return vo;
    }

    @ExcludeFromJacocoGeneratedReport
    private void processSpecialFilter(QFilter filter, IDataEntityProperty property) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Collection cl;
        if (filter.getCP().equalsIgnoreCase("not exists") && filter.getValue().toString().equalsIgnoreCase("1 = 1")) {
            filter.__setCP("=");
            filter.__setValue((Object)0L);
            return;
        }
        String[] nameKeys = filter.getProperty().split("\\.");
        if (nameKeys[nameKeys.length - 1].equalsIgnoreCase("id")) {
            if (null != filter.getValue() && filter.getValue() instanceof QEmptyValue) {
                if (property instanceof BasedataProp) {
                    IDataEntityProperty refIdProp = ((BasedataProp)property).getRefIdProp();
                    if (refIdProp instanceof LongProp) {
                        this.resetDecimalFilter(filter);
                    } else if (refIdProp instanceof VarcharProp) {
                        this.resetVarcharFilter(filter);
                    } else {
                        filter.__setCP("is null");
                    }
                } else {
                    filter.__setCP("is null");
                }
            }
        } else if (filter.getCP().equals("=") && filter.getValue() instanceof QEmptyValue) {
            if (property instanceof DecimalProp) {
                this.resetDecimalFilter(filter);
            } else if (property instanceof TextProp) {
                this.resetVarcharFilter(filter);
            } else {
                filter.__setCP("is null");
            }
        }
        if (filter.getCP().equalsIgnoreCase("in") && filter.getValue() == null) {
            filter.__setCP("is null");
        }
        if (filter.getValue() != null && filter.getValue() instanceof Collection && (cl = (Collection)filter.getValue()).isEmpty()) {
            filter.__setCP("is null");
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void resetVarcharFilter(QFilter filter) throws NoSuchFieldException, IllegalAccessException {
        Field field = filter.getClass().getDeclaredField("cp");
        field.setAccessible(true);
        field.set(filter, QFilterUtilHR.hrEmptyText);
    }

    @ExcludeFromJacocoGeneratedReport
    private void resetDecimalFilter(QFilter filter) throws NoSuchFieldException, IllegalAccessException {
        Field field = filter.getClass().getDeclaredField("cp");
        field.setAccessible(true);
        field.set(filter, QFilterUtilHR.hrEmptyDecimal);
    }
}

