/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.service.complexobj.util.FieldFullPathParseUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.query.ksql.QueryField;
import kd.hr.hbp.business.service.query.model.QueryJoinConditionRowDetail;
import kd.hr.hbp.business.service.query.model.QueryJoinEntityRelation;
import kd.hr.hbp.business.service.query.model.QueryJoinFieldDetail;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;

public class QueryJoinExprUtil {
    public static QueryJoinEntityRelation conditionTrans(QueryEntityType queryEntityType, QuerySourceJoinRelation joinRelation, Map<String, String> relEntityMap, List<QueryField> queryFields) {
        Map<String, QueryField> queryFieldMap = queryFields.stream().collect(Collectors.toMap(QueryField::getAlias, Function.identity()));
        QueryJoinEntityRelation joinEntityRelation = new QueryJoinEntityRelation(joinRelation);
        List conditions = joinRelation.getCondition();
        ArrayList<QueryJoinConditionRowDetail> joinRowList = new ArrayList<QueryJoinConditionRowDetail>(conditions.size());
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        for (QSConditionRow condition : conditions) {
            QueryJoinConditionRowDetail joinConditionRowDetail = new QueryJoinConditionRowDetail(condition);
            MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(joinRelation.getEntityNumber());
            QueryJoinFieldDetail leftJoinFieldDetail = QueryJoinExprUtil.parseJoinItem(condition.getLeftItem().toString(), relEntityMap, mainEntityType, mainEntityTypeUtil, queryFieldMap);
            joinConditionRowDetail.setLeftField(leftJoinFieldDetail);
            String rightItem = condition.getRightItem().toString();
            if (QueryJoinExprUtil.itemIsField(queryEntityType, rightItem)) {
                QueryJoinFieldDetail rightJoinFieldDetail = QueryJoinExprUtil.parseJoinItem(rightItem, relEntityMap, mainEntityType, mainEntityTypeUtil, queryFieldMap);
                joinConditionRowDetail.setRightField(rightJoinFieldDetail);
                if (leftJoinFieldDetail.getFieldRealTable().equals(leftJoinFieldDetail.getMainTable()) && rightJoinFieldDetail.getFieldRealTable().equals(rightJoinFieldDetail.getMainTable())) {
                    joinConditionRowDetail.setCanJoin(true);
                }
                if (HRStringUtils.isNotEmpty((String)leftJoinFieldDetail.getSplitTable()) || HRStringUtils.isNotEmpty((String)rightJoinFieldDetail.getSplitTable())) {
                    joinConditionRowDetail.setJoinNum(4);
                } else if (HRStringUtils.isNotEmpty((String)leftJoinFieldDetail.getSubEntryTable()) || HRStringUtils.isNotEmpty((String)rightJoinFieldDetail.getSubEntryTable())) {
                    joinConditionRowDetail.setJoinNum(3);
                } else if (HRStringUtils.isNotEmpty((String)leftJoinFieldDetail.getEntryTable()) || HRStringUtils.isNotEmpty((String)rightJoinFieldDetail.getEntryTable())) {
                    joinConditionRowDetail.setJoinNum(2);
                } else if (HRStringUtils.isNotEmpty((String)leftJoinFieldDetail.getMainTable()) || HRStringUtils.isNotEmpty((String)rightJoinFieldDetail.getMainTable())) {
                    joinConditionRowDetail.setJoinNum(1);
                }
            } else {
                joinConditionRowDetail.setJoinNum(9);
            }
            joinRowList.add(joinConditionRowDetail);
        }
        joinEntityRelation.setJoinRowList(joinRowList);
        boolean canJoin = false;
        for (QueryJoinConditionRowDetail detail : joinEntityRelation.getJoinRowList()) {
            if (!detail.isCanJoin()) continue;
            canJoin = true;
            break;
        }
        joinEntityRelation.setJoinAble(canJoin);
        QueryJoinExprUtil.checkJoinRel(queryEntityType, joinEntityRelation);
        return joinEntityRelation;
    }

    private static void checkJoinRel(QueryEntityType queryEntityType, QueryJoinEntityRelation joinEntityRelation) {
        List<QueryJoinConditionRowDetail> joinRowList = joinEntityRelation.getJoinRowList();
        for (QueryJoinConditionRowDetail conditionRowDetail : joinRowList) {
            QSConditionRow conditionRow = conditionRowDetail.getConditionRow();
            if (!QueryJoinExprUtil.itemIsField(queryEntityType, conditionRow.getRightItem().toString())) continue;
            QueryJoinFieldDetail rightField = conditionRowDetail.getRightField();
            QueryJoinFieldDetail leftField = conditionRowDetail.getLeftField();
            if (leftField.isMainEntityField() != rightField.isMainEntityField()) continue;
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b9e\u4f53\u5173\u8054\u5173\u7cfb\u8bbe\u7f6e\u9519\u8bef%s\u3002", (String)"QueryJoinExprUtil_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), conditionRow.getLeftItem().toString() + '=' + conditionRow.getRightItem().toString()));
        }
    }

    public static boolean itemIsField(QueryEntityType queryEntityType, String exprStr) {
        if (HRStringUtils.isEmpty((String)exprStr)) {
            return false;
        }
        if (exprStr.startsWith("'") && exprStr.endsWith("'")) {
            return false;
        }
        String[] exprArr = exprStr.split("\\.");
        String firstStr = exprArr[0];
        for (JoinEntity joinEntity : queryEntityType.getJoinEntitys()) {
            if (!joinEntity.getAlias().equals(firstStr)) continue;
            return true;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)queryEntityType.getEditEntityName());
        DynamicProperty property = mainEntityType.getProperty(firstStr);
        return property != null;
    }

    private static QueryJoinFieldDetail parseJoinItem(String exprStr, Map<String, String> relEntityMap, MainEntityType mainEntityType, MainEntityTypeUtil mainEntityTypeUtil, Map<String, QueryField> queryFieldMap) {
        QueryJoinFieldDetail joinFieldDetail;
        String relEntityNumber = FieldFullPathParseUtil.getFieldEntityNumber(relEntityMap, exprStr);
        if (HRStringUtils.isEmpty((String)relEntityNumber)) {
            joinFieldDetail = QueryJoinExprUtil.genJoinFieldDetail(null, (DynamicObjectType)mainEntityType, exprStr, "");
            joinFieldDetail.setMainEntityField(true);
        } else {
            MainEntityType joinEntityType = mainEntityTypeUtil.getMainEntityType(relEntityNumber);
            String[] fieldAliasArr = exprStr.split("\\.");
            String relEntityAlias = fieldAliasArr[0];
            String fieldPrex = relEntityAlias + ".";
            String realField = exprStr.replaceFirst(relEntityAlias + "\\.", "");
            joinFieldDetail = QueryJoinExprUtil.genJoinFieldDetail(null, (DynamicObjectType)joinEntityType, realField, fieldPrex);
            joinFieldDetail.setMainEntityField(false);
        }
        QueryField queryField = queryFieldMap.get(exprStr);
        joinFieldDetail.setFieldInfo(queryField);
        return joinFieldDetail;
    }

    @ExcludeFromJacocoGeneratedReport
    private static QueryJoinFieldDetail genJoinFieldDetail(QueryJoinFieldDetail joinFieldDetail, DynamicObjectType dynamicObjectType, String originField, String fieldPrex) {
        String[] fieldAliasArr = originField.split("\\.");
        DynamicProperty property = dynamicObjectType.getProperty(originField);
        if (property == null) {
            property = dynamicObjectType.getProperty(fieldAliasArr[0]);
        }
        if (property == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u65e0\u6cd5\u89e3\u6790\u3002", (String)"JoinExprUtil_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), originField));
        }
        String mainTable = dynamicObjectType.getAlias();
        String mainTablePk = dynamicObjectType.getPrimaryKey().getAlias();
        if (joinFieldDetail == null) {
            joinFieldDetail = new QueryJoinFieldDetail();
            joinFieldDetail.setMainTable(mainTable);
            joinFieldDetail.setMainTablePk(mainTablePk);
        }
        joinFieldDetail.setFieldRealTable(mainTable);
        if (property instanceof ISimpleProperty && PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)property)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u5173\u8054\u4e0d\u53ef\u4f7f\u7528\u9690\u79c1\u4e2d\u5fc3\u5b57\u6bb5\uff1a%s\u3002", (String)"JoinExprUtil_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), originField));
        }
        return QueryJoinExprUtil.setMulOrGroupProp(property, originField, joinFieldDetail, mainTable, fieldPrex);
    }

    @ExcludeFromJacocoGeneratedReport
    private static QueryJoinFieldDetail setMulOrGroupProp(DynamicProperty property, String originField, QueryJoinFieldDetail joinFieldDetail, String mainTable, String fieldPrex) {
        if (property instanceof EntryProp) {
            DynamicProperty tempProp;
            String[] split = originField.split("\\.");
            DynamicObjectType entryProp = ((EntryProp)property).getDynamicCollectionItemPropertyType();
            originField = originField.replaceFirst(split[0] + "\\.", "");
            joinFieldDetail.setEntryTable(entryProp.getAlias());
            joinFieldDetail.setEntryTablePk(entryProp.getPrimaryKey().getAlias());
            joinFieldDetail.setFieldRealTable(entryProp.getAlias());
            if (split.length >= 2 && (tempProp = entryProp.getProperty(split[1])) instanceof SubEntryProp) {
                entryProp = ((SubEntryProp)tempProp).getDynamicCollectionItemPropertyType();
                originField = originField.replaceFirst(split[1] + "\\.", "");
                joinFieldDetail.setSubEntryTable(entryProp.getAlias());
                joinFieldDetail.setSubEntryTablePk(entryProp.getPrimaryKey().getAlias());
                joinFieldDetail.setFieldRealTable(entryProp.getAlias());
            }
            return QueryJoinExprUtil.genJoinFieldDetail(joinFieldDetail, entryProp, originField, fieldPrex);
        }
        if (property instanceof MuliLangTextProp) {
            joinFieldDetail.setMulangField(true);
            joinFieldDetail.setSplitTable(mainTable + "_L");
            joinFieldDetail.setFieldRealTable(mainTable + "_L");
        } else {
            String tableGroup = property.getTableGroup();
            if (HRStringUtils.isNotEmpty((String)tableGroup)) {
                String splitTable = mainTable + "_" + tableGroup;
                joinFieldDetail.setSplitTable(splitTable);
                joinFieldDetail.setFieldRealTable(splitTable);
            }
        }
        return joinFieldDetail;
    }
}

