/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.rp;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormMetadataCache;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.service.rp.RelatePageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import org.jetbrains.annotations.NotNull;

public class HRRelatePanelSetFactory {
    private static String APPID_HBP = "hbp";
    private static String RELATEPAGE_PRE = "relatePage_";
    private static final Log logger = LogFactory.getLog(HRRelatePanelSetFactory.class);

    public static List<RelatePageInfo> getRelatePageInfoList(String relateEntityTypeId) {
        return HRRelatePanelSetFactory.getRelatePageInfosNoPerm(relateEntityTypeId, true);
    }

    @NotNull
    private static List<RelatePageInfo> getRelatePageInfosNoPerm(String relateEntityTypeId, boolean isPerm) {
        String lang = RequestContext.get().getLang().name();
        String cacheKey = RELATEPAGE_PRE + relateEntityTypeId + lang;
        String jsonString = "";
        try {
            jsonString = (String)HRAppCache.get((String)APPID_HBP).get(cacheKey, String.class);
        }
        catch (Exception ex) {
            logger.error("Cache Data Failed\uff1a" + ex);
        }
        List<RelatePageInfo> relatePageList = new ArrayList<RelatePageInfo>();
        if (HRStringUtils.isEmpty((String)jsonString) || HRStringUtils.equalsIgnoreCase((String)jsonString, (String)"[]")) {
            HRRelatePanelSetFactory.initPageSetMapByEntityType(relateEntityTypeId);
            jsonString = (String)HRAppCache.get((String)APPID_HBP).get(cacheKey, String.class);
        }
        if (HRStringUtils.isEmpty((String)jsonString)) {
            return relatePageList;
        }
        relatePageList = SerializationUtils.fromJsonStringToList((String)jsonString, RelatePageInfo.class);
        if (isPerm) {
            return HRRelatePanelSetFactory.dealPermission(relatePageList);
        }
        return relatePageList;
    }

    private static List<RelatePageInfo> dealPermission(List<RelatePageInfo> pageInfoList) {
        ArrayList newRelateList = Lists.newArrayListWithCapacity((int)pageInfoList.size());
        List numberList = pageInfoList.stream().map(relatePageInfo -> relatePageInfo.getNumber()).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_relatepanelset");
        DynamicObject[] relatePanels = serviceHelper.query("appid,pageinfo,number", new QFilter[]{new QFilter("number", "in", numberList)});
        block0: for (RelatePageInfo relatePageInfo2 : pageInfoList) {
            for (DynamicObject relatePanel : relatePanels) {
                boolean harelatePageInfoshPerm;
                if (!HRStringUtils.equals((String)relatePageInfo2.getNumber(), (String)relatePanel.getString("number"))) continue;
                String appId = relatePanel.getString("appid.id");
                String entitytypNumber = FormMetadataCache.getFormConfig((String)relatePageInfo2.getPageNumber()).getEntityTypeId();
                if (logger.isInfoEnabled()) {
                    logger.info("appId:" + appId + "entitytypNumber:" + entitytypNumber);
                }
                if (appId == null || entitytypNumber == null || !(harelatePageInfoshPerm = PermissionServiceHelper.hasViewPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)entitytypNumber))) continue block0;
                newRelateList.add(relatePageInfo2);
                continue block0;
            }
        }
        return newRelateList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPageSetMapByEntityType(String relateEntityTypeId) {
        Class<HRRelatePanelSetFactory> clazz = HRRelatePanelSetFactory.class;
        synchronized (HRRelatePanelSetFactory.class) {
            Map<String, List<RelatePageInfo>> pageMap = HRRelatePanelSetFactory.queryRelatePageInfoList(relateEntityTypeId);
            pageMap.entrySet().stream().forEach(entry -> HRAppCache.get((String)APPID_HBP).put((String)entry.getKey(), (Object)SerializationUtils.toJsonString(entry.getValue())));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void clearHRRelatePanelSetMap(String relateEntityTypeId) {
        IHRAppCache appCache = HRAppCache.get((String)APPID_HBP);
        Lang[] langs = Lang.values();
        String cachePre = RELATEPAGE_PRE + relateEntityTypeId;
        for (int i = 0; i < langs.length; ++i) {
            Lang tempLang = langs[i];
            String cacheKey = cachePre + tempLang;
            String relatePageJson = (String)appCache.get(cacheKey, String.class);
            if (!HRStringUtils.isNotEmpty((String)relatePageJson)) continue;
            appCache.remove(cacheKey);
        }
    }

    public static Map<String, List<RelatePageInfo>> queryRelatePageInfoList(String relateEntityTypeId) {
        String selectFields = "number,entitytype.id,pageinfo,name,pagetype,mainPropName,filterCondition,enable,status";
        Long relateEntityTypeLongId = Long.valueOf(relateEntityTypeId);
        QFilter typeFilter = new QFilter("entitytype.id", "=", (Object)relateEntityTypeLongId);
        typeFilter.and("enable", "=", (Object)"1");
        typeFilter.and("status", "=", (Object)"C");
        QFilter[] filterArray = new QFilter[]{typeFilter};
        String order = "index,number";
        DynamicObject[] pageSetColl = BusinessDataServiceHelper.load((String)"hbss_relatepanelset", (String)selectFields, (QFilter[])filterArray, (String)order);
        Lang[] langs = Lang.values();
        HashMap<String, List<RelatePageInfo>> pageMap = new HashMap<String, List<RelatePageInfo>>(16);
        String cachePre = RELATEPAGE_PRE + relateEntityTypeId;
        for (int i = 0; i < langs.length; ++i) {
            ArrayList<RelatePageInfo> pageList = new ArrayList<RelatePageInfo>();
            String tempLang = langs[i].toString();
            String cacheKey = cachePre + tempLang;
            for (int j = 0; j < pageSetColl.length; ++j) {
                DynamicObject pageDynObj = pageSetColl[j];
                LocaleDynamicObjectCollection localeColl = (LocaleDynamicObjectCollection)pageDynObj.get("multilanguagetext");
                HRRelatePanelSetFactory.addPageList(pageList, tempLang, pageDynObj, localeColl);
            }
            if (pageList.size() == 0) {
                for (DynamicObject pageDynObj : pageSetColl) {
                    HRRelatePanelSetFactory.addPageListByMul(pageList, pageDynObj);
                }
            }
            pageMap.put(cacheKey, pageList);
        }
        return pageMap;
    }

    private static void addPageListByMul(List<RelatePageInfo> pageList, DynamicObject pageDynObj) {
        RelatePageInfo relatePageInfo = new RelatePageInfo(pageDynObj.getString("number").toUpperCase(Locale.ROOT), pageDynObj.getString("pageinfo_id"), pageDynObj.getString("name"), pageDynObj.getString("pagetype"), pageDynObj.getString("mainPropName"), pageDynObj.getString("filterCondition"));
        pageList.add(relatePageInfo);
    }

    private static void addPageList(List<RelatePageInfo> pageList, String tempLang, DynamicObject pageDynObj, LocaleDynamicObjectCollection localeColl) {
        for (DynamicObject dynamicObject : localeColl) {
            if (!HRStringUtils.equals((String)tempLang, (String)dynamicObject.getString("localeid"))) continue;
            RelatePageInfo relatePageInfo = new RelatePageInfo(pageDynObj.getString("number").toUpperCase(Locale.ROOT), pageDynObj.getString("pageinfo_id"), dynamicObject.getString("name"), pageDynObj.getString("pagetype"), pageDynObj.getString("mainPropName"), pageDynObj.getString("filterCondition"));
            pageList.add(relatePageInfo);
            break;
        }
    }

    public static RelatePageInfo getRelatePageInfo(String relateEntityTypeId, String pageNumber) {
        RelatePageInfo relatePageInfo = null;
        List<RelatePageInfo> pageList = HRRelatePanelSetFactory.getRelatePageInfosNoPerm(relateEntityTypeId, false);
        int size = pageList.size();
        for (int i = 0; i < size; ++i) {
            if (!pageNumber.equals(pageList.get(i).getNumber())) continue;
            relatePageInfo = pageList.get(i);
            break;
        }
        return relatePageInfo;
    }
}

