/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.ruleengine;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class RuleEngineRespDyObjService {
    private RuleEngineRespDyObjService() {
    }

    public static void generateDynamicObjectInResp(Map<String, Object> responseMap) {
        List policyResultList = (List)responseMap.get("policyResults");
        if (policyResultList == null || policyResultList.isEmpty()) {
            return;
        }
        policyResultList.forEach(policyResult -> {
            List rosterResultList;
            List defaultResultList;
            List ruleResultList = (List)policyResult.get("ruleResults");
            if (ruleResultList != null && !ruleResultList.isEmpty()) {
                ruleResultList.forEach(ruleResult -> {
                    List matchResultList = (List)ruleResult.get("matchResults");
                    ruleResult.put("matchResults", RuleEngineRespDyObjService.processResultList(matchResultList));
                });
            }
            if ((defaultResultList = (List)policyResult.get("defaultResults")) != null && !defaultResultList.isEmpty()) {
                policyResult.put("defaultResults", RuleEngineRespDyObjService.processResultList(defaultResultList));
            }
            if ((rosterResultList = (List)policyResult.get("rosterResults")) != null && !rosterResultList.isEmpty()) {
                policyResult.put("rosterResults", RuleEngineRespDyObjService.processResultList(rosterResultList));
            }
        });
    }

    private static Map<String, Object> processResultList(List<Map<String, Object>> resultList) {
        if (resultList == null || resultList.isEmpty()) {
            return null;
        }
        HashMap resultObjectMap = Maps.newHashMapWithExpectedSize((int)16);
        resultList.forEach(singleResultOriginMap -> RuleEngineRespDyObjService.buildReturnObject(singleResultOriginMap, resultObjectMap));
        return resultObjectMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void buildReturnObject(Map<String, Object> singleResultOriginMap, Map<String, Object> resultObjectMap) {
        String field = (String)singleResultOriginMap.get("field");
        String entityType = (String)singleResultOriginMap.get("entityType");
        String fieldType = (String)singleResultOriginMap.get("fieldType");
        String originValue = (String)singleResultOriginMap.get("value");
        if (HRStringUtils.isEmpty((String)entityType)) {
            resultObjectMap.put(field, originValue);
            return;
        }
        if (field.endsWith(".id")) {
            field = field.substring(0, field.lastIndexOf(".id"));
        }
        if (!field.contains(".")) {
            if (originValue == null) {
                resultObjectMap.put(field, null);
                return;
            } else if (originValue.contains(",")) {
                DynamicObjectCollection collection = (DynamicObjectCollection)resultObjectMap.getOrDefault(field, new DynamicObjectCollection());
                for (String id : originValue.split(",")) {
                    DynamicObject entityObj = RuleEngineRespDyObjService.generateDynamicObject(entityType);
                    entityObj.set("id", (Object)id);
                    collection.add((Object)entityObj);
                }
                resultObjectMap.put(field, collection);
                return;
            } else {
                DynamicObject entityObj = (DynamicObject)resultObjectMap.getOrDefault(field, RuleEngineRespDyObjService.generateDynamicObject(entityType));
                entityObj.set("id", (Object)originValue);
                resultObjectMap.put(field, entityObj);
            }
            return;
        }
        String dynamicObjectName = field.substring(0, field.indexOf(46));
        String fieldProperty = field.substring(field.indexOf(46) + 1);
        DynamicObject entityObj = (DynamicObject)resultObjectMap.getOrDefault(dynamicObjectName, RuleEngineRespDyObjService.generateDynamicObject(entityType));
        if ("dynamicObject".equals(fieldType)) {
            DynamicProperty prop = ((MainEntityType)entityObj.getDataEntityType()).getProperty(fieldProperty);
            if (prop instanceof BasedataProp) {
                String entityNumber = ((BasedataProp)prop).getBaseEntityId();
                HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
                DynamicObject dyObject = helper.generateEmptyDynamicObject();
                dyObject.set("id", (Object)originValue);
                entityObj.set(fieldProperty, (Object)dyObject);
            } else {
                if (!(prop instanceof MulBasedataProp)) throw new KDBizException("prop type error:" + prop.getClass().getName());
                String entityNumber = ((MulBasedataProp)prop).getBaseEntityId();
                DynamicObjectCollection collection = new DynamicObjectCollection();
                HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
                for (String id : originValue.split(",")) {
                    DynamicObject dyObject = helper.generateEmptyDynamicObject();
                    dyObject.set("id", (Object)id);
                    collection.add((Object)dyObject);
                }
                entityObj.set(fieldProperty, (Object)collection);
            }
        } else if ("date".equals(fieldType)) {
            try {
                Date date = HRDateTimeUtils.parseDate((String)originValue, (String)"yyyy-MM-dd");
                entityObj.set(fieldProperty, (Object)date);
            }
            catch (ParseException e) {
                entityObj.set(fieldProperty, null);
            }
        } else {
            entityObj.set(fieldProperty, (Object)originValue);
        }
        resultObjectMap.put(dynamicObjectName, entityObj);
    }

    private static DynamicObject generateDynamicObject(String entityType) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityType);
        return helper.generateEmptyDynamicObject();
    }
}

