/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.smartsearch;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.hr.hbp.business.service.query.es.storage.SortField;
import kd.hr.hbp.business.service.query.es.storage.highlevel.EsAccess;
import kd.hr.hbp.business.service.smartsearch.EsQueryService;
import kd.hr.hbp.common.util.EsCommonUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;

public class EsQueryServiceImpl
implements EsQueryService {
    static Map<String, RestHighLevelClient> clientCacheMap = new ConcurrentHashMap<String, RestHighLevelClient>(8);
    private RestHighLevelClient client = null;

    public EsQueryServiceImpl(String region) {
        this.client = this.getClient(region);
    }

    private RestHighLevelClient getClient(String region) {
        Map configMap = EsCommonUtils.getServerConfig((String)region);
        String port = (String)configMap.get("port");
        String ip = (String)configMap.get("ip");
        return clientCacheMap.computeIfAbsent(ip + port, i -> EsAccess.createRestHighLevelClient(configMap));
    }

    @Override
    public SearchResponse query(String indexName, String typeName, String[] selectFileds, QueryBuilder queryBuilder, SortField[] sortFields, String preTag, String postTag, int start, int size) {
        return EsAccess.queryWithHighLight(this.client, indexName, typeName, selectFileds, queryBuilder, sortFields, false, preTag, postTag, start, size);
    }

    @Override
    public List<Map<String, Object>> getHighLightResult(String[] selectFileds, SearchResponse searchResponse) {
        return EsAccess.getHighLightResult(selectFileds, searchResponse);
    }
}

