/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.smartsearch;

import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.constants.smartsearch.HRSmartSearchConstants;
import kd.hr.hbp.common.enums.smartsearch.SearchRespCodeEnum;
import kd.hr.hbp.common.model.smartsearch.search.SearchParam;
import kd.hr.hbp.common.model.smartsearch.search.SmartSearchResp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic(scriptName="HR\u667a\u80fd\u641c\u7d22\u6570\u636e\u641c\u7d22\u670d\u52a1\u7c7b")
public class HRSmartSearchService {
    private static final Log LOGGER = LogFactory.getLog(HRSmartSearchService.class);
    private static final String DEF_PRETAG = "<em>";
    private static final String DEF_POSTTAG = "</em>";

    public static HrApiResponse<SmartSearchResp> search(SearchParam searchParam) {
        return HRSmartSearchService.search(searchParam, null, null);
    }

    public static HrApiResponse<SmartSearchResp> search(SearchParam searchParam, List<String> searchField, QFilter[] qFilters) {
        return HRSmartSearchService.search(searchParam, searchField, qFilters, 0, 10000);
    }

    public static HrApiResponse<SmartSearchResp> search(SearchParam searchParam, List<String> searchField, QFilter[] qFilters, int start, int limit) {
        return HRSmartSearchService.search(searchParam, searchField, qFilters, DEF_PRETAG, DEF_POSTTAG, start, limit);
    }

    public static HrApiResponse<SmartSearchResp> search(SearchParam searchParam, List<String> searchField, QFilter[] qFilters, String highLightPreTag, String highLightPostTag, int start, int limit) {
        HrApiResponse response;
        LOGGER.info("search param[searchParam:{},searchField:{},start:{},limit:{},qFilters:{}]", new Object[]{searchParam, searchField, start, limit, qFilters});
        try {
            SmartSearchResp smartSearchResp = (SmartSearchResp)HRMServiceHelper.invokeBizService("hrmp", "hrss", "IHRSSSearchService", "search", searchParam, searchField, qFilters, highLightPreTag, highLightPostTag, start, limit);
            response = smartSearchResp == null ? HrApiResponse.fail((String)SearchRespCodeEnum.NOT_FOUND.getCode(), (String)SearchRespCodeEnum.NOT_FOUND.getLocalMsg()) : HrApiResponse.success((Object)smartSearchResp);
        }
        catch (Exception exp) {
            LOGGER.error((Throwable)exp);
            response = HRSmartSearchService.exceptionResp(exp);
        }
        LOGGER.info("search result:{}", (Object)SerializationUtils.toJsonString(response));
        return response;
    }

    public static HrApiResponse<SmartSearchResp> searchAfter(SearchParam searchParam, List<String> searchField, QFilter[] qFilters, String highLightPreTag, String highLightPostTag, Object[] objSortValues, int limit) {
        HrApiResponse response;
        LOGGER.info("search param[searchParam:{},searchField:{},start:{},limit:{},qFilters:{}]", new Object[]{searchParam, searchField, objSortValues, limit, qFilters});
        try {
            SmartSearchResp smartSearchResp = (SmartSearchResp)HRMServiceHelper.invokeBizService("hrmp", "hrss", "IHRSSSearchService", "searchAfter", searchParam, searchField, qFilters, highLightPreTag, highLightPostTag, objSortValues, limit);
            response = HrApiResponse.success((Object)smartSearchResp);
        }
        catch (Exception exp) {
            LOGGER.error((Throwable)exp);
            response = HRSmartSearchService.exceptionResp(exp);
        }
        LOGGER.info("search result:{}", (Object)SerializationUtils.toJsonString(response));
        return response;
    }

    private static HrApiResponse<SmartSearchResp> exceptionResp(Exception exp) {
        HrApiResponse response = null;
        if (exp instanceof KDBizException) {
            KDBizException kdBizException = (KDBizException)((Object)exp);
            if (BosErrorCode.paramError.getCode().equals(kdBizException.getErrorCode().getCode())) {
                response = HrApiResponse.fail((String)SearchRespCodeEnum.PARAM_ERROR.getCode(), (String)exp.getMessage());
            } else if (HRSmartSearchConstants.SCENE_CONFIG_MODIFY.getCode().equals(kdBizException.getErrorCode().getCode())) {
                response = HrApiResponse.fail((String)SearchRespCodeEnum.SCENE_CONFIG_MODIFY.getCode(), (String)SearchRespCodeEnum.SCENE_CONFIG_MODIFY.getLocalMsg());
            }
        }
        if (response == null) {
            response = HrApiResponse.fail((String)SearchRespCodeEnum.FAIL.getCode(), (String)exp.getMessage());
        }
        return response;
    }
}

