/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.smartsearch;

import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.enums.smartsearch.SearchRespCodeEnum;
import kd.hr.hbp.common.model.smartsearch.search.LabelValCompParam;
import kd.hr.hbp.common.model.smartsearch.search.LabelValCompResp;

public class LabelValCompletionService {
    private static final Log LOGGER = LogFactory.getLog(LabelValCompletionService.class);

    public static HrApiResponse<List<LabelValCompResp>> completion(LabelValCompParam compParam) {
        HrApiResponse response;
        block4: {
            LOGGER.info("completion param[compParam:{}]", (Object)compParam);
            response = null;
            try {
                List compRespList = (List)HRMServiceHelper.invokeBizService("hrmp", "hrss", "IHRSSLabelCompService", "completion", compParam);
                response = compRespList == null ? HrApiResponse.fail((String)SearchRespCodeEnum.NOT_FOUND.getCode(), (String)SearchRespCodeEnum.NOT_FOUND.getLocalMsg()) : HrApiResponse.success((Object)compRespList);
            }
            catch (Exception exp) {
                LOGGER.error((Throwable)exp);
                if (exp instanceof KDBizException) {
                    KDBizException kdBizException = (KDBizException)((Object)exp);
                    if (BosErrorCode.paramError.getCode().equals(kdBizException.getErrorCode().getCode())) {
                        response = HrApiResponse.fail((String)SearchRespCodeEnum.PARAM_ERROR.getCode(), (String)exp.getMessage());
                    }
                }
                if (response != null) break block4;
                return HrApiResponse.fail((String)SearchRespCodeEnum.NOT_FOUND.getCode(), (String)SearchRespCodeEnum.NOT_FOUND.getLocalMsg());
            }
        }
        LOGGER.info("completion result:{}", (Object)SerializationUtils.toJsonString(response));
        return response;
    }
}

